/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.component.camel.deploy.support;

import javax.inject.Named;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.junit.Assert;

/**
 *  Java DSL route builder perform try-catch.
 */
@Named("doCatchRouteBuilder")
public class DoCatchRouteBuilder extends RouteBuilder {

    public void configure() {
        from("switchyard://DoCatchService")
        .doTry()
            .log(">>>>> doTry")
            .to("switchyard://ExceptionService")
        .doCatch(Exception.class)
            .log(">>>>> doCatch")
            .process(new Processor() {
                public void process(Exchange ex) throws Exception {
                    Exception e = ex.getProperty(org.apache.camel.Exchange.EXCEPTION_CAUGHT, Exception.class);
                    Assert.assertTrue(e.getMessage(), e.getMessage().contains("throwing from ExceptionService"));
                    ex.setProperty("doCatchEntered", true);
                }
            })
        .doFinally()
            .log(">>>>> doFinally")
            .process(new Processor() {
                public void process(Exchange ex) {
                    Assert.assertNotNull(ex.getProperty("doCatchEntered"));
                }
            })
        .end();
    }

}
