/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.ejb;

import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;

public class StrictlyPooledMDB
implements MessageDrivenBean,
MessageListener {
    private static Logger log = Logger.getLogger(StrictlyPooledMDB.class);
    private static int maxActiveCount = 5;
    private static int activeCount;
    private MessageDrivenContext ctx = null;
    private QueueConnection queConn;
    private QueueSession session;
    private QueueSender sender;

    private static synchronized int incActiveCount() {
        return activeCount++;
    }

    private static synchronized int decActiveCount() {
        return activeCount--;
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        this.ctx = ctx;
        try {
            InitialContext iniCtx = new InitialContext();
            Integer i = (Integer)iniCtx.lookup("java:comp/env/maxActiveCount");
            maxActiveCount = i;
            QueueConnectionFactory factory = (QueueConnectionFactory)iniCtx.lookup("java:/ConnectionFactory");
            this.queConn = factory.createQueueConnection();
            this.session = this.queConn.createQueueSession(false, 1);
            Queue queue = (Queue)iniCtx.lookup("queue/B");
            this.sender = this.session.createSender(queue);
        }
        catch (Exception e) {
            log.error((Object)"Setup failure", (Throwable)e);
            throw new EJBException("Setup failure", e);
        }
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.queConn != null) {
                this.queConn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to close JMS resources", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        int count = StrictlyPooledMDB.incActiveCount();
        log.debug((Object)("Begin onMessage, activeCount=" + count + ", ctx=" + this.ctx));
        try {
            try {
                TextMessage reply = null;
                if (count > maxActiveCount) {
                    String msg = "IllegalState, activeCount > maxActiveCount, " + count + " > " + maxActiveCount;
                    IllegalStateException e = new IllegalStateException(msg);
                    reply = this.session.createObjectMessage((Serializable)e);
                } else {
                    TextMessage tm = (TextMessage)message;
                    reply = this.session.createTextMessage("Recevied msg=" + tm.getText());
                }
                Thread.currentThread();
                Thread.sleep(1000L);
                this.sender.send((Message)reply);
            }
            catch (JMSException e) {
                log.error((Object)"Failed to send error message", (Throwable)e);
                Object var7_10 = null;
                count = StrictlyPooledMDB.decActiveCount();
                log.debug((Object)("End onMessage, activeCount=" + count + ", ctx=" + this.ctx));
                return;
            }
            catch (InterruptedException interruptedException) {
                Object var7_11 = null;
                count = StrictlyPooledMDB.decActiveCount();
                log.debug((Object)("End onMessage, activeCount=" + count + ", ctx=" + this.ctx));
                return;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            count = StrictlyPooledMDB.decActiveCount();
            log.debug((Object)("End onMessage, activeCount=" + count + ", ctx=" + this.ctx));
            throw throwable;
        }
        count = StrictlyPooledMDB.decActiveCount();
        log.debug((Object)("End onMessage, activeCount=" + count + ", ctx=" + this.ctx));
    }
}

