/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;

public class MsgSender {
    Logger log = Logger.getLogger(this.getClass());
    public static final String JMS_FACTORY = "ConnectionFactory";
    public static final String QUEUE = "queue/testQueue";
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueSender qsender;
    private TextMessage msg;
    private Queue queue;

    public void init(Context ctx, String queueName) throws NamingException, JMSException {
        this.qconFactory = (QueueConnectionFactory)ctx.lookup(JMS_FACTORY);
        this.qcon = this.qconFactory.createQueueConnection();
        this.qsession = this.qcon.createQueueSession(false, 1);
        try {
            this.queue = (Queue)ctx.lookup(queueName);
        }
        catch (NamingException ne) {
            this.queue = this.qsession.createQueue(queueName);
            ctx.bind(queueName, (Object)this.queue);
        }
        this.qcon.start();
    }

    public void close() throws JMSException {
        if (this.qcon != null) {
            this.qsender.close();
            this.qsession.close();
            this.qcon.close();
            this.qcon = null;
        }
    }

    public void sendMsg(String message) {
        try {
            this.init(new InitialContext(), QUEUE);
            this.log.debug((Object)"Sending a message..");
            this.qsender = this.qsession.createSender(this.queue);
            this.msg = this.qsession.createTextMessage();
            this.msg.setText(message);
            this.qsender.send((Message)this.msg);
            this.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static InitialContext getInitialContext(String url) throws NamingException {
        return new InitialContext();
    }
}

