package jboss.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.ejb.Remote;
import javax.ejb.Stateful;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.notifications.event.NodeVisitedEvent;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ha.framework.server.CacheManagerLocator;

@Stateful
@Remote(TestCache.class)
@RemoteBinding(jndiBinding = "TestCacheBean/remote")
public class TestCacheBean implements TestCache, Serializable {

	private transient MyListener listener;
	private Set<String> cacheNames;
	private List<Cache> caches;

	public void create() {
		getCacheNames();
		caches = new ArrayList<Cache>();
		for (String cacheName : cacheNames) {
			getCaches(cacheName);
		}
	}

	public void remove(Cache cache) {
		if (cache != null && listener != null) {
			cache.removeCacheListener(listener);
			cache.removeNode("/");
		}
	}

	public void testCache(Cache cache) {
		try {
			Node<Object, Object> rootNode = cache.getRoot();

			addToNode(rootNode, "/", 3);

			Fqn<String> fqn = Fqn.fromString("/temp/node");

			for (int t = 0; t < 30; t++) {
				cache.get(fqn, "1");
			}

			for (int i = 0; i < 2; i++) {
				for (int t = 0; t < 10; t++) {
					{
						Node tempNode = rootNode.getChild(String.valueOf(i));
						for (Object name : tempNode.getKeys()) {
							{
								Object tempObj = tempNode.get(name);
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void addToNode(Node<Object, Object> node, String name, int level) {
		if (level == 0)
			return;

		for (int a = 0; a < 3; a++) {
			String tempName = String.valueOf(a);
			Fqn<String> tempFqn = Fqn.fromString(tempName);
			Node<Object, Object> tempNode = node.addChild(tempFqn);

			for (int i = 0; i < 10; i++) {
				tempNode.put(String.valueOf(i), String.valueOf(i));
			}
			addToNode(tempNode, tempName, level - 1);
		}
	}

	private void getCacheNames() {
		CacheManager cm = CacheManagerLocator.getCacheManagerLocator()
				.getCacheManager(null);
		Set<String> names = cm.getCacheNames();

		cacheNames = names;
	}

	public void getCaches(String cacheName) {
		Cache cache = null;
		try {
			if (cacheName != null) {
				CacheManager cm = CacheManagerLocator.getCacheManagerLocator()
						.getCacheManager(null);

				cache = cm.getCache(cacheName, true);

				listener = new MyListener();
				cache.addCacheListener(listener);

				cache.start();
			}

			caches.add(cache);
			System.out.println(cacheName);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@CacheListener
	public class MyListener {
		HashSet<String> visited = new HashSet<String>();

		public void clear() {
			visited.clear();
		}

		@NodeVisited
		public void nodeVisited(NodeVisitedEvent event) {
			if (!event.isPre()) {
				Fqn fqn = event.getFqn();
				String name = fqn.toString();
				String token = ".clusteredentity.";
				int index = name.indexOf(token);
				if (index > -1) {
					index += token.length();
					name = name.substring(index);
				}
			}
		}

		@CacheStarted
		public void onStart(CacheStartedEvent event) {
			System.out.println("Cache STARTED.");
		}

		@CacheStopped
		public void onStop(CacheStoppedEvent event) {
			System.out.println("Cache STOPED.");
		}
	}

	public void remove() {
		for (Cache cache : caches) {
			remove(cache);
		}
	}

	public void test() {
		for (Cache cache : caches) {
			testCache(cache);
		}
	}
}
