/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.util.ejb;

import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.test.util.ejb.EJBTestCase;
import org.jboss.test.util.ejb.RemoteTestException;
import org.jboss.tm.TransactionManagerLocator;

public class EJBTestRunnerBean
implements SessionBean {
    private static final Logger log = Logger.getLogger(EJBTestRunnerBean.class);
    private transient SessionContext ctx;
    private String runnerJndiName;

    public void run(String className, String methodName) throws RemoteTestException {
        Properties props = new Properties();
        try {
            InitialContext ctx = new InitialContext();
            NamingEnumeration<Binding> bindings = ctx.listBindings("java:comp/env");
            while (bindings.hasMore()) {
                Binding binding = bindings.next();
                String name = binding.getName();
                String value = binding.getObject().toString();
                props.setProperty(name, value);
            }
        }
        catch (NamingException e) {
            throw new RemoteTestException(e);
        }
        this.run(className, methodName, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(String className, String methodName, Properties props) throws RemoteTestException {
        block14: {
            RemoteTestException exception;
            EJBTestCase testCase;
            block11: {
                testCase = this.getTestInstance(className, methodName);
                this.setUpEJB(testCase, props);
                exception = null;
                this.runTestCase(testCase);
                Object var8_6 = null;
                try {
                    this.tearDownEJB(testCase, props);
                }
                catch (RemoteTestException e2) {
                    if (exception == null) break block11;
                    exception = e2;
                }
            }
            if (exception != null) {
                throw exception;
            }
            break block14;
            {
                catch (RemoteTestException e) {
                    block12: {
                        exception = e;
                        Object var8_7 = null;
                        try {
                            this.tearDownEJB(testCase, props);
                        }
                        catch (RemoteTestException e2) {
                            if (exception == null) break block12;
                            exception = e2;
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
            }
            catch (Throwable throwable) {
                block13: {
                    Object var8_8 = null;
                    try {
                        this.tearDownEJB(testCase, props);
                    }
                    catch (RemoteTestException e2) {
                        if (exception == null) break block13;
                        exception = e2;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
        }
    }

    private static boolean wantUserTransaction(Properties props) {
        return props == null || props.get("NO_USER_TRANSACTION") == null;
    }

    private void setUpEJB(EJBTestCase testCase, Properties props) throws RemoteTestException {
        boolean wantUserTransaction = EJBTestRunnerBean.wantUserTransaction(props);
        try {
            if (wantUserTransaction) {
                this.ctx.getUserTransaction().begin();
            }
            try {
                testCase.setUpEJB(props);
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
            if (wantUserTransaction && this.ctx.getUserTransaction().getStatus() == 0) {
                this.ctx.getUserTransaction().commit();
            }
        }
        catch (Throwable e) {
            try {
                if (wantUserTransaction) {
                    this.ctx.getUserTransaction().rollback();
                }
            }
            catch (SystemException unused) {
                // empty catch block
            }
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)e;
            }
            throw new RemoteTestException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestCase(EJBTestCase testCase) throws RemoteTestException {
        block18: {
            Transaction tx2;
            try {
                boolean wantUserTransaction = EJBTestRunnerBean.wantUserTransaction(testCase.getProps());
                try {
                    if (wantUserTransaction) {
                        this.ctx.getUserTransaction().begin();
                    }
                    try {
                        testCase.runBare();
                    }
                    catch (Throwable e) {
                        throw new RemoteTestException(e);
                    }
                    if (wantUserTransaction && this.ctx.getUserTransaction().getStatus() == 0) {
                        this.ctx.getUserTransaction().commit();
                    }
                }
                catch (Throwable e) {
                    try {
                        if (wantUserTransaction) {
                            this.ctx.getUserTransaction().rollback();
                        }
                    }
                    catch (SystemException unused) {
                        // empty catch block
                    }
                    if (e instanceof RemoteTestException) {
                        throw (RemoteTestException)e;
                    }
                    throw new RemoteTestException(e);
                }
                Object var6_6 = null;
                tx2 = null;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var6_7 = null;
                    Transaction tx2 = null;
                    TransactionManager tm = TransactionManagerLocator.getInstance().locate();
                    try {
                        tx2 = tm.getTransaction();
                        if (tx2 == null) break block19;
                        try {
                            tx2.rollback();
                            Object var10_14 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var10_15 = null;
                            tm.suspend();
                            throw throwable2;
                        }
                        tm.suspend();
                        {
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error rolling back incomplete transaction: " + tx2), (Throwable)e);
                    }
                }
                throw throwable;
            }
            TransactionManager tm = TransactionManagerLocator.getInstance().locate();
            try {
                tx2 = tm.getTransaction();
                if (tx2 == null) break block18;
                try {
                    tx2.rollback();
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    tm.suspend();
                    throw throwable;
                }
                tm.suspend();
                {
                }
            }
            catch (Exception e) {
                log.error((Object)("Error rolling back incomplete transaction: " + tx2), (Throwable)e);
            }
        }
    }

    private void tearDownEJB(EJBTestCase testCase, Properties props) throws RemoteTestException {
        boolean wantUserTransaction = EJBTestRunnerBean.wantUserTransaction(props);
        try {
            if (wantUserTransaction) {
                this.ctx.getUserTransaction().begin();
            }
            try {
                testCase.tearDownEJB(props);
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
            if (wantUserTransaction && this.ctx.getUserTransaction().getStatus() == 0) {
                this.ctx.getUserTransaction().commit();
            }
        }
        catch (Throwable e) {
            try {
                if (wantUserTransaction) {
                    this.ctx.getUserTransaction().rollback();
                }
            }
            catch (SystemException unused) {
                // empty catch block
            }
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)e;
            }
            throw new RemoteTestException(e);
        }
    }

    private EJBTestCase getTestInstance(String className, String methodName) {
        Class<?> testClass = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            testClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException("Test class not found : " + className);
        }
        Constructor<?> constructor = null;
        try {
            constructor = testClass.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new EJBException("Test class does not have a constructor which has a single String argument.", e);
        }
        try {
            EJBTestCase testCase = (EJBTestCase)constructor.newInstance(methodName);
            testCase.setServerSide(true);
            return testCase;
        }
        catch (Exception e) {
            throw new EJBException("Cannot instantiate test class: " + testClass.getName(), e);
        }
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext ctx) {
        this.ctx = ctx;
    }
}

