/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content.sync;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.DistributionDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionFileDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSource;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.SyncException;
import org.rhq.enterprise.server.plugin.pc.content.SyncTracker;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionSourceSynchronizer {
    private final Log log = LogFactory.getLog(this.getClass());
    private RepoManagerLocal repoManager;
    private ContentSourceManagerLocal contentSourceManager;
    private SubjectManagerLocal subjectManager;
    private Repo repo;
    private ContentSource source;
    private ContentProvider provider;

    public DistributionSourceSynchronizer(Repo repo, ContentSource source, ContentProvider provider) {
        this.repo = repo;
        this.source = source;
        this.provider = provider;
        this.repoManager = LookupUtil.getRepoManagerLocal();
        this.contentSourceManager = LookupUtil.getContentSourceManager();
        this.subjectManager = LookupUtil.getSubjectManager();
    }

    public SyncTracker synchronizeDistributionMetadata(SyncTracker tracker) throws SyncException, InterruptedException {
        if (!(this.provider instanceof DistributionSource)) {
            return tracker;
        }
        DistributionSource distributionSource = (DistributionSource)((Object)this.provider);
        String msg = "Synchronize Distributions: [" + this.source.getName() + "]: syncing repo [" + this.repo.getName() + "]";
        this.log.info((Object)msg);
        tracker.getRepoSyncResults().appendResults(msg);
        long start = System.currentTimeMillis();
        PageControl pc = PageControl.getUnlimitedInstance();
        Subject overlord = this.subjectManager.getOverlord();
        PageList<Distribution> dists = this.repoManager.findAssociatedDistributions(overlord, this.repo.getId(), pc);
        this.log.debug((Object)("Found " + dists.size() + " distributions for repo " + this.repo.getId()));
        DistributionSyncReport distReport = new DistributionSyncReport(this.repo.getId());
        ArrayList<DistributionDetails> distDetails = new ArrayList<DistributionDetails>(dists.size());
        this.translateDomainToDto((List<Distribution>)dists, (List<DistributionDetails>)distDetails);
        this.log.info((Object)("Synchronize Distributions: [" + this.repo.getName() + "]: loaded existing list of size=[" + dists.size() + "] (" + (System.currentTimeMillis() - start) + ")ms"));
        start = System.currentTimeMillis();
        distributionSource.synchronizeDistribution(this.repo.getName(), distReport, distDetails);
        this.log.info((Object)("Synchronize Distributions: [" + this.repo.getName() + "]: got sync report from adapter=[" + distReport + "] (" + (System.currentTimeMillis() - start) + ")ms"));
        RepoSyncResults syncResults = this.contentSourceManager.mergeDistributionSyncReport(this.source, distReport, tracker.getRepoSyncResults());
        tracker.setRepoSyncResults(syncResults);
        tracker.getProgressWatcher().finishWork(this.provider.getSyncProgressWeight().getDistribtutionBitsWeight());
        return tracker;
    }

    public SyncTracker synchronizeDistributionBits(SyncTracker tracker) throws SyncException, InterruptedException {
        if (!(this.provider instanceof DistributionSource)) {
            return tracker;
        }
        Subject overlord = this.subjectManager.getOverlord();
        tracker.getRepoSyncResults().appendResults("Synchronize Distributions: [" + this.repo.getName() + " Starting Distribution bits download.");
        tracker.setRepoSyncResults(this.repoManager.mergeRepoSyncResults(tracker.getRepoSyncResults()));
        this.contentSourceManager.downloadDistributionBits(overlord, this.source);
        tracker.getRepoSyncResults().appendResults("Synchronize Distributions: [" + this.repo.getName() + " finished bits download.");
        tracker.getProgressWatcher().finishWork(this.provider.getSyncProgressWeight().getDistribtutionBitsWeight());
        return tracker;
    }

    private void translateDomainToDto(List<Distribution> dists, List<DistributionDetails> distDetails) {
        DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
        for (Distribution d : dists) {
            DistributionDetails detail = new DistributionDetails(d.getLabel(), d.getDistributionType().getName());
            detail.setLabel(d.getLabel());
            detail.setDistributionPath(d.getBasePath());
            detail.setDescription(d.getDistributionType().getDescription());
            List<DistributionFile> files = distManager.getDistributionFilesByDistId(d.getId());
            for (DistributionFile f : files) {
                DistributionFileDetails dfd = new DistributionFileDetails(f.getRelativeFilename(), f.getLastModified(), f.getMd5sum());
                detail.addFile(dfd);
            }
            distDetails.add(detail);
        }
    }
}

