/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;

public class Delta {
    private String relativePath = null;
    private long size;

    public Delta(String relativePath, long size) {
        this.relativePath = relativePath;
        this.size = size;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getName() {
        return this.relativePath.substring(this.relativePath.lastIndexOf(File.separator) + 1);
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Delta)) {
            return false;
        }
        return this.getRelativePath().equals(((Delta)other).getRelativePath());
    }

    public String getAbstractPath() {
        if (this.relativePath.matches("/?server/.*?/.*")) {
            return "#{jbossServerHomeDir}/" + this.relativePath.replaceAll("/?server/[^/]*/", "");
        }
        if (this.relativePath.matches("/?jboss-as/server/.*?/.*")) {
            return "#{jbossServerHomeDir}/" + this.relativePath.replaceAll("/?jboss-as/server/[^/]*/", "");
        }
        if (this.relativePath.matches("/?client/.*")) {
            return "#{jbossClientDir}/" + this.relativePath.replaceAll("/?client/", "");
        }
        if (this.relativePath.matches("/?jboss-as/client/.*")) {
            return "#{jbossClientDir}/" + this.relativePath.replaceAll("/?jboss-as/client/", "");
        }
        if (this.relativePath.matches("/?seam/.*")) {
            return "#{jbossHomeDir}/" + this.relativePath.replaceAll("/?seam/", "../seam/");
        }
        if (this.relativePath.matches("/?jboss-as/.*")) {
            return "#{jbossHomeDir}/" + this.relativePath.replaceAll("/?jboss-as/", "");
        }
        return "#{jbossHomeDir}/" + this.relativePath.replaceAll("^/", "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.relativePath == null ? 0 : this.relativePath.hashCode());
        return result;
    }

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = this.getClass().getSimpleName() + " ( " + super.toString() + "    " + "relativePath = " + this.relativePath + "    " + " )";
        return retValue;
    }
}

