/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidFrameBorder;
import com.birosoft.liquid.LiquidInternalFrameBorder;
import com.birosoft.liquid.borders.LiquidFocusCellHighlightBorder;
import com.birosoft.liquid.borders.LiquidListBorder;
import com.birosoft.liquid.borders.LiquidPopupMenuBorder;
import com.birosoft.liquid.borders.LiquidTextFieldBorder;
import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jvnet.lafplugin.ComponentPluginManager;

public class LiquidLookAndFeel
extends BasicLookAndFeel {
    public static final String PLUGIN_XML = "META-INF/liquid-plugin.xml";
    protected static ComponentPluginManager pluginManager = new ComponentPluginManager("META-INF/liquid-plugin.xml");
    protected static UIDefaults uiDefaults;
    protected static boolean defaultRowBackgroundMode;
    protected static boolean showTableGrids;
    protected static boolean panelTransparency;
    protected static boolean winDecoPanther;
    protected static boolean toolbarButtonsFocusable;
    protected static boolean toolbarFlattedButtons;
    protected static boolean toolbarFlattedButtonsRollover;
    private static boolean bgStipples;
    private static boolean isInstalled;
    protected static String fontName;
    protected Toolkit awtToolkit = Toolkit.getDefaultToolkit();
    private HashMap colorMap = new HashMap();
    Border focusCellHighlightBorder = new LiquidFocusCellHighlightBorder(new Color(86, 46, 0));
    Border listBorder = new LiquidListBorder();
    Border zeroEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    Object fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
    Object multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
    Object formattedInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
    private boolean windowslfforfilechooser = false;

    static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.indexOf("Windows") != -1;
    }

    static boolean isPreTiger() {
        Integer version;
        String jre = System.getProperty("java.version", "");
        String versionString = jre.substring(2, 3);
        Integer n = version = versionString != null ? Integer.valueOf(versionString) : null;
        return version != null && version < 5;
    }

    public LiquidLookAndFeel() {
        if (!isInstalled) {
            isInstalled = true;
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("LiquidLookAndFeel", "com.birosoft.liquid.LiquidLookAndFeel"));
            this.loadConfProperties();
            this.loadSystemProperties();
        }
    }

    public String getID() {
        return "Liquid";
    }

    public String getName() {
        return "Liquid";
    }

    public static ColorUIResource getControl() {
        return (ColorUIResource)uiDefaults.get("control");
    }

    public String getDescription() {
        return "The Liquid Look and Feel version 2.9.1. Published under the GNU Lesser General Public License.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    private void loadConfProperties() {
        Properties liquidProps = new Properties();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            liquidProps.load(classLoader.getResourceAsStream("liquidlnf.conf"));
            boolean boolValue = false;
            String stringValue = null;
            stringValue = liquidProps.getProperty("panelTransparency", null);
            if (stringValue != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setPanelTransparency(boolValue);
            }
            if ((stringValue = liquidProps.getProperty("showTableGrids", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setShowTableGrids(boolValue);
            }
            if ((stringValue = liquidProps.getProperty("stipples", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setStipples(boolValue);
            }
            if ((stringValue = liquidProps.getProperty("alternateBackground", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setDefaultRowBackgroundMode(boolValue);
            }
            if ((stringValue = liquidProps.getProperty("windowDecoration", null)) != null) {
                LiquidLookAndFeel.setLiquidDecorations(stringValue != null && stringValue.length() > 0, stringValue);
            }
            if ((stringValue = liquidProps.getProperty("toolbarFlattedButtons", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setToolbarFlattedButtons(boolValue);
            }
            if ((stringValue = liquidProps.getProperty("toolbarFlattedButtonsRollover", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setToolbarFlattedButtonsRollover(boolValue);
            }
            if ((stringValue = liquidProps.getProperty("toolbarButtonsFocusable", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setToolbarButtonsFocusable(boolValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadSystemProperties() {
        try {
            boolean boolValue = false;
            String stringValue = null;
            stringValue = System.getProperty("liquidlnf.panelTransparency", null);
            if (stringValue != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setPanelTransparency(boolValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.showTableGrids", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setShowTableGrids(boolValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.stipples", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setStipples(boolValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.alternateBackground", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setDefaultRowBackgroundMode(boolValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.windowDecoration", null)) != null) {
                LiquidLookAndFeel.setLiquidDecorations(stringValue != null && stringValue.length() > 0, stringValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.toolbarFlattedButtons", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setToolbarFlattedButtons(boolValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.toolbarFlattedButtonsRollover", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setToolbarFlattedButtonsRollover(boolValue);
            }
            if ((stringValue = System.getProperty("liquidlnf.toolbarButtonsFocusable", null)) != null) {
                boolValue = Boolean.valueOf(stringValue);
                LiquidLookAndFeel.setToolbarButtonsFocusable(boolValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initClassDefaults(UIDefaults table) {
        uiDefaults = table;
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "com.birosoft.liquid.LiquidButtonUI", "CheckBoxUI", "com.birosoft.liquid.LiquidCheckBoxUI", "TextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "FormattedTextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "PasswordTextFieldUI", "com.birosoft.liquid.LiquidPasswordFieldUI", "PasswordFieldUI", "com.birosoft.liquid.LiquidPasswordFieldUI", "SliderUI", "com.birosoft.liquid.LiquidSliderUI", "SpinnerUI", "com.birosoft.liquid.LiquidSpinnerUI", "ToolBarUI", "com.birosoft.liquid.LiquidToolBarUI", "MenuBarUI", "com.birosoft.liquid.LiquidMenuBarUI", "MenuUI", "com.birosoft.liquid.LiquidMenuUI", "PanelUI", "com.birosoft.liquid.LiquidPanelUI", "MenuItemUI", "com.birosoft.liquid.LiquidMenuItemUI", "CheckBoxMenuItemUI", "com.birosoft.liquid.LiquidCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.birosoft.liquid.LiquidRadioButtonMenuItemUI", "TableUI", "com.birosoft.liquid.LiquidTableUI", "TableHeaderUI", "com.birosoft.liquid.LiquidTableHeaderUI", "ScrollBarUI", "com.birosoft.liquid.LiquidScrollBarUI", "TabbedPaneUI", "com.birosoft.liquid.LiquidTabbedPaneUI", "ToggleButtonUI", "com.birosoft.liquid.LiquidToggleButtonUI", "ScrollPaneUI", "com.birosoft.liquid.LiquidScrollPaneUI", "ProgressBarUI", "com.birosoft.liquid.LiquidProgressBarUI", "InternalFrameUI", "com.birosoft.liquid.LiquidInternalFrameUI", "DesktopIconUI", "com.birosoft.liquid.LiquidDesktopIconUI", "RadioButtonUI", "com.birosoft.liquid.LiquidRadioButtonUI", "ComboBoxUI", "com.birosoft.liquid.LiquidComboBoxUI", "ListUI", "com.birosoft.liquid.LiquidListUI", "SeparatorUI", "com.birosoft.liquid.LiquidSeparatorUI", "PopupMenuSeparatorUI", "com.birosoft.liquid.LiquidPopupMenuSeparatorUI", "SplitPaneUI", "com.birosoft.liquid.LiquidSplitPaneUI", "FileChooserUI", "com.birosoft.liquid.FileChooserBasicUI", "RootPaneUI", "com.birosoft.liquid.LiquidRootPaneUI", "OptionPaneUI", "com.birosoft.liquid.LiquidOptionPaneUI"});
        pluginManager.processAllDefaultsEntries(table, null);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        this.colorMap.put("activeBackground", "#3E91EB");
        this.colorMap.put("activeBlend", "#3E91EB");
        this.colorMap.put("activeForeground", "#FFFFFF");
        this.colorMap.put("activeTitleBtnBg", "#AFD6FF");
        this.colorMap.put("alternateBackground", "#EEF6FF");
        this.colorMap.put("background", "#F6F5F4");
        this.colorMap.put("buttonBackground", "#D7E7F9");
        this.colorMap.put("buttonForeground", "#000000");
        this.colorMap.put("foreground", "#000000");
        this.colorMap.put("inactiveBackground", "#AFD6FF");
        this.colorMap.put("inactiveBlend", "#AFD6FF");
        this.colorMap.put("inactiveForeground", "#232323");
        this.colorMap.put("inactiveTitleBtnBg", "#DAEEFF");
        this.colorMap.put("linkColor", "#0000C0");
        this.colorMap.put("selectBackground", "#A9D1FF");
        this.colorMap.put("selectForeground", "#030303");
        this.colorMap.put("visitedLinkColor", "#800080");
        this.colorMap.put("windowBackground", "#FFFFFF");
        this.colorMap.put("windowForeground", "#000000");
        String[] defaultSystemColors = new String[]{"desktop", (String)this.colorMap.get("alternateBackground"), "activeCaption", (String)this.colorMap.get("activeBackground"), "activeCaptionText", (String)this.colorMap.get("activeForeground"), "activeCaptionBorder", (String)this.colorMap.get("activeBackground"), "inactiveCaption", (String)this.colorMap.get("inactiveBackground"), "inactiveCaptionText", (String)this.colorMap.get("inactiveForeground"), "inactiveCaptionBorder", (String)this.colorMap.get("inactiveBackground"), "window", (String)this.colorMap.get("background"), "windowBorder", (String)this.colorMap.get("windowBackground"), "windowText", (String)this.colorMap.get("windowForeground"), "menu", (String)this.colorMap.get("background"), "menuText", (String)this.colorMap.get("foreground"), "text", (String)this.colorMap.get("windowBackground"), "textText", (String)this.colorMap.get("windowForeground"), "textHighlight", (String)this.colorMap.get("selectBackground"), "textHighlightText", (String)this.colorMap.get("selectForeground"), "textInactiveText", "#A7A5A3", "control", (String)this.colorMap.get("background"), "controlText", (String)this.colorMap.get("buttonForeground"), "controlHighlight", (String)this.colorMap.get("buttonBackground"), "controlLtHighlight", (String)this.colorMap.get("selectBackground"), "controlShadow", "#BBBBBB", "controlLightShadow", "#000000", "controlDkShadow", "#000000", "scrollbar", "#000000", "info", (String)this.colorMap.get("foreground"), "infoText", (String)this.colorMap.get("foreground")};
        this.loadSystemColors(table, defaultSystemColors, false);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.margin", this.getButtonMargin());
        table.put("Button.border", new BasicBorders.MarginBorder());
        table.put("ToggleButton.margin", this.getButtonMargin());
        table.put("ToggleButton.border", new BasicBorders.MarginBorder());
        table.put("ToggleButton.background", table.get("window"));
        table.put("TextField.border", new LiquidTextFieldBorder());
        table.put("PasswordField.border", new LiquidTextFieldBorder());
        table.put("Spinner.border", new LiquidTextFieldBorder(new Insets(2, 2, 2, 2)));
        table.put("ToolBar.background", table.get("window"));
        table.put("MenuBar.background", table.get("window"));
        border = new EmptyBorder(2, 2, 2, 2);
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", new LiquidInternalFrameBorder());
        border = new EmptyBorder(3, 1, 3, 1);
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("CheckBoxMenuItem.checkIcon", LiquidLookAndFeel.loadIcon("menucheck.png", this));
        table.put("CheckBoxMenuItem.checkedIcon", LiquidLookAndFeel.loadIcon("menuchecked.png", this));
        table.put("RadioButtonMenuItem.checkIcon", LiquidLookAndFeel.loadIcon("menuradio.png", this));
        table.put("RadioButtonMenuItem.checkedIcon", LiquidLookAndFeel.loadIcon("menuradio_down.png", this));
        table.put("MenuItem.arrowIcon", LiquidLookAndFeel.loadIcon("menuarrow.png", this));
        table.put("MenuItem.selArrowIcon", LiquidLookAndFeel.loadIcon("menuarrowsel.png", this));
        table.put("Menu.submenuPopupOffsetX", new Integer(-3));
        table.put("Menu.submenuPopupOffsetY", new Integer(4));
        border = new LiquidPopupMenuBorder();
        table.put("PopupMenu.border", border);
        table.put("SplitPane.dividerSize", new Integer(7));
        table.put("InternalFrame.paletteTitleHeight", new Integer(18));
        table.put("InternalFrame.frameTitleHeight", new Integer(24));
        table.put("InternalFrame.paletteTitleFont", this.getFont(0, 12));
        table.put("InternalFrame.titleFont", this.getFont(1, 13));
        table.put("InternalFrame.pantherTitleFont", this.getFont(1, 13));
        table.put("Panel.background", table.get("window"));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(1, 1, 1, 1));
        table.put("TabbedPane.tabAreaInsets", new Insets(4, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(5, 0, 0, 0));
        table.put("TabbedPane.unselected", table.get("shadow"));
        table.put("TabbedPane.tabsOverlapBorder", Boolean.TRUE);
        table.put("Checkbox.select", table.get("shadow"));
        table.put("PopupMenu.background", table.get("window"));
        table.put("PopupMenu.foreground", Color.black);
        table.put("TextField.selectionForeground", table.get("textHighlightText"));
        table.put("TextField.selectionBackground", table.get("textHighlight"));
        table.put("TextField.background", table.get("text"));
        table.put("TextField.disabledBackground", table.get("window"));
        table.put("TextField.focusInputMap", this.fieldInputMap);
        table.put("PasswordField.focusInputMap", this.fieldInputMap);
        table.put("TextArea.focusInputMap", this.multilineInputMap);
        table.put("TextPane.focusInputMap", this.multilineInputMap);
        table.put("TextPane.background", table.get("text"));
        table.put("EditorPane.focusInputMap", this.multilineInputMap);
        table.put("FormattedTextField.focusInputMap", this.formattedInputMap);
        table.put("List.background", table.get("text"));
        table.put("List.border", this.zeroEmptyBorder);
        table.put("List.selectionForeground", table.get("textHighlightText"));
        table.put("List.selectionBackground", table.get("textHighlight"));
        table.put("List.focusCellHighlightBorder", this.focusCellHighlightBorder);
        table.put("ScrollPane.border", this.listBorder);
        table.put("ComboBox.border", new EmptyBorder(1, 1, 1, 1));
        table.put("ComboBox.foreground", table.get("textHighlightText"));
        table.put("ComboBox.background", table.get("text"));
        table.put("ComboBox.selectionForeground", table.get("textHighlightText"));
        table.put("ComboBox.selectionBackground", table.get("textHighlight"));
        table.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}));
        table.put("InternalFrame.paletteCloseIcon", LiquidLookAndFeel.loadIcon("closebutton.png", this));
        table.put("InternalFrame.closeIcon", LiquidLookAndFeel.loadWinButtonIcon("close.png", this));
        table.put("InternalFrame.maximizeIcon", LiquidLookAndFeel.loadWinButtonIcon("maximize.png", this));
        table.put("InternalFrame.iconifyIcon", LiquidLookAndFeel.loadWinButtonIcon("minimize.png", this));
        table.put("InternalFrame.minimizeIcon", LiquidLookAndFeel.loadWinButtonIcon("restore.png", this));
        table.put("InternalFrame.icon", LiquidLookAndFeel.loadIcon("internalframeicon.png", this));
        table.put("InternalFrame.pantherFrameIcon", (Object)null);
        table.put("InternalFrame.pantherIcon", (Object)null);
        table.put("InternalFrame.pantherIconInactive", (Object)null);
        table.put("Table.background", table.get("text"));
        table.put("Table.foreground", table.get("controlText"));
        table.put("Table.selectionBackground", table.get("textHighlight"));
        table.put("Table.selectionForeground", table.get("textHighlightText"));
        table.put("Table.focusCellBackground", table.get("textHighlight"));
        table.put("Table.focusCellForeground", table.get("textHighlightText"));
        table.put("Table.focusCellHighlightBorder", this.focusCellHighlightBorder);
        table.put("Table.scrollPaneBorder", this.listBorder);
        table.put("TableHeader.font", this.getFont(0, 12));
        table.put("TableHeader.foreground", table.get("textText"));
        table.put("TableHeader.background", table.get("window"));
        table.put("TableHeader.cellBorder", this.zeroEmptyBorder);
        table.put("ToolTip.background", new Color(255, 255, 225));
        table.put("ToolTip.foreground", new Color(0, 0, 0));
        table.put("ToolTip.font", this.getFont(0, 12));
        table.put("ToolTip.border", new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
        table.put("Tree.font", this.getFont(0, 12));
        table.put("Tree.selectionForeground", table.get("textHighlightText"));
        table.put("Tree.selectionBackground", table.get("textHighlight"));
        table.put("Tree.foreground", table.get("textText"));
        table.put("Tree.background", table.get("text"));
        table.put("Tree.hash", table.get("text"));
        table.put("Tree.expandedIcon", LiquidLookAndFeel.loadIcon("treeminus.png", this));
        table.put("Tree.collapsedIcon", LiquidLookAndFeel.loadIcon("treeplus.png", this));
        table.put("Tree.openIcon", LiquidLookAndFeel.loadIcon("treefolderopened.png", this));
        table.put("Tree.closedIcon", LiquidLookAndFeel.loadIcon("treefolderclosed.png", this));
        table.put("Tree.leafIcon", LiquidLookAndFeel.loadIcon("treeleaf.png", this));
        table.put("Tree.rowHeight", new Integer(18));
        table.put("Tree.selectionBorderColor", new Color(86, 46, 0));
        table.put("SplitPane.background", table.get("text"));
        table.put("SplitPane.border", this.listBorder);
        table.put("SplitPaneDivider.border", this.zeroEmptyBorder);
        table.put("FileView.directoryIcon", LiquidLookAndFeel.loadIcon("treefolderclosed.png", this));
        table.put("FileView.computerIcon", LiquidLookAndFeel.loadIcon("computericon.png", this));
        table.put("FileView.fileIcon", LiquidLookAndFeel.loadIcon("document.png", this));
        table.put("FileView.floppyDriveIcon", LiquidLookAndFeel.loadIcon("floppy.png", this));
        table.put("FileView.hardDriveIcon", LiquidLookAndFeel.loadIcon("harddisk.png", this));
        table.put("FileChooser.detailsViewIcon", LiquidLookAndFeel.loadIcon("filedetails.png", this));
        table.put("FileChooser.homeFolderIcon", LiquidLookAndFeel.loadIcon("desktopicon.png", this));
        table.put("FileChooser.listViewIcon", LiquidLookAndFeel.loadIcon("filelist.png", this));
        table.put("FileChooser.newFolderIcon", LiquidLookAndFeel.loadIcon("newfolder.png", this));
        table.put("FileChooser.upFolderIcon", LiquidLookAndFeel.loadIcon("parentdirectory.png", this));
        table.put("FileChooser.upFolderIcon", LiquidLookAndFeel.loadIcon("parentdirectory.png", this));
        table.put("OptionPane.errorIcon", LiquidLookAndFeel.loadIcon("error.png", this));
        table.put("OptionPane.informationIcon", LiquidLookAndFeel.loadIcon("information.png", this));
        table.put("OptionPane.warningIcon", LiquidLookAndFeel.loadIcon("warning.png", this));
        table.put("OptionPane.questionIcon", LiquidLookAndFeel.loadIcon("question.png", this));
        table.put("RootPane.colorChooserDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.frameBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", LiquidFrameBorder.getInstance());
        table.put("ProgressBar.horizontalSize", new Dimension(146, 14));
        table.put("ProgressBar.verticalSize", new Dimension(14, 146));
        table.put("ProgressBar.font", this.getFont(0, 12));
    }

    public static ImageIcon loadIcon(String file, Object invoker) {
        return LiquidLookAndFeel.loadIconImmediately(file, invoker);
    }

    public static ImageIcon loadWinButtonIcon(String file, Object invoker) {
        if (winDecoPanther) {
            file = "panther-" + file;
        }
        return LiquidLookAndFeel.loadIconImmediately(file, invoker);
    }

    public static ImageIcon loadIconImmediately(String file, Object invoker) {
        try {
            Image img = SkinImageCache.getInstance().getImage(file);
            ImageIcon icon = new ImageIcon(img);
            if (icon.getIconWidth() <= 0) {
                System.out.println("******************** File " + file + " not found. Exiting");
                System.exit(1);
            }
            return icon;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting resource " + file);
            return null;
        }
    }

    protected Font getFont(int type, int size) {
        return new Font(fontName, type, size);
    }

    private InsetsUIResource getButtonMargin() {
        return new InsetsUIResource(4, 16, 4, 16);
    }

    public static Color getLightControl() {
        return (Color)uiDefaults.get("control");
    }

    public static Color getDarkControl() {
        return new Color(127, 127, 127);
    }

    public static Color getBackgroundColor() {
        return (Color)uiDefaults.get("window");
    }

    public static Color getDesktopColor() {
        return (Color)uiDefaults.get("desktop");
    }

    protected static Color getWindowTitleInactiveForeground() {
        return (Color)uiDefaults.get("inactiveCaptionText");
    }

    public static Color getWindowBackground() {
        return (Color)uiDefaults.get("window");
    }

    public static Color getButtonBackground() {
        return (Color)uiDefaults.get("controlHighlight");
    }

    public static void setDefaultTableBackgroundMode(boolean b) {
        LiquidLookAndFeel.setDefaultRowBackgroundMode(b);
    }

    public static void setDefaultRowBackgroundMode(boolean b) {
        defaultRowBackgroundMode = b;
        if (!b) {
            showTableGrids = true;
        }
    }

    public static void setLiquidDecorations(boolean useWinDeco) {
        LiquidLookAndFeel.setLiquidDecorations(useWinDeco, "liquid");
    }

    public static void setLiquidDecorations(boolean useWinDeco, String internalFrameType) {
        JFrame.setDefaultLookAndFeelDecorated(useWinDeco);
        JDialog.setDefaultLookAndFeelDecorated(useWinDeco);
        if (internalFrameType.equalsIgnoreCase("panther") || internalFrameType.equalsIgnoreCase("mac")) {
            winDecoPanther = true;
        } else if (internalFrameType.equalsIgnoreCase("liquid")) {
            winDecoPanther = false;
        }
        UIManager.put("InternalFrame.closeIcon", LiquidLookAndFeel.loadWinButtonIcon("close.png", null));
        UIManager.put("InternalFrame.maximizeIcon", LiquidLookAndFeel.loadWinButtonIcon("maximize.png", null));
        UIManager.put("InternalFrame.iconifyIcon", LiquidLookAndFeel.loadWinButtonIcon("minimize.png", null));
        UIManager.put("InternalFrame.minimizeIcon", LiquidLookAndFeel.loadWinButtonIcon("restore.png", null));
    }

    protected static boolean areStipplesUsed() {
        return bgStipples;
    }

    public static void setStipples(boolean b) {
        bgStipples = b;
    }

    public static void setShowTableGrids(boolean showTableGrids) {
        LiquidLookAndFeel.showTableGrids = showTableGrids;
    }

    public static void setPanelTransparency(boolean autoTransparency) {
        panelTransparency = autoTransparency;
    }

    public static void setToolbarButtonsFocusable(boolean focusableButtons) {
        toolbarButtonsFocusable = focusableButtons;
    }

    public static void setToolbarFlattedButtons(boolean flatedButtons) {
        toolbarFlattedButtons = flatedButtons;
    }

    public static void setToolbarFlattedButtons(boolean flatedButtons, boolean paintRollover) {
        LiquidLookAndFeel.setToolbarFlattedButtons(flatedButtons);
        LiquidLookAndFeel.setToolbarFlattedButtonsRollover(paintRollover);
    }

    public static void setToolbarFlattedButtonsRollover(boolean paintRollover) {
        toolbarFlattedButtonsRollover = paintRollover;
    }

    public void initialize() {
        super.initialize();
        pluginManager.initializeAll();
    }

    public void uninitialize() {
        super.uninitialize();
        pluginManager.uninitializeAll();
    }

    static {
        defaultRowBackgroundMode = true;
        showTableGrids = false;
        panelTransparency = true;
        winDecoPanther = false;
        toolbarButtonsFocusable = false;
        toolbarFlattedButtons = true;
        toolbarFlattedButtonsRollover = true;
        bgStipples = true;
        isInstalled = false;
        fontName = "Helvetica";
    }
}

