package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.driver.CSVDataSetDefDriver;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.CSVDataSetDefEditor;
import org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.validations.dataset.CSVDataSetDefValidator;
import org.dashbuilder.validations.dataset.DataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.uberfire.mocks.EventSourceMock;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.*;

@RunWith(GwtMockitoTestRunner.class)
public class CSVDataSetEditWorkflowTest {

    @Mock SyncBeanManager beanManager;
    @Mock DataSetDefValidator dataSetDefValidator;
    @Mock EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock DataSetClientServices clientServices;
    @Mock DataSet dataSet;
    @Mock DataSetEditorWorkflow.View view;
    @Mock SimpleBeanEditorDriver<CSVDataSetDef, CSVDataSetDefEditor> driver;
    @Mock org.dashbuilder.client.widgets.dataset.editor.csv.CSVDataSetEditor csvEditor;
    @Mock CSVDataSetDefValidator csvDataSetDefValidator;
    @Mock CSVDataSetDef dataSetDef;
    @Mock DataSetDefRefreshAttributesEditor refreshEditor;
    
    private CSVDataSetEditWorkflow presenter;
    
    @Before
    public void setup() throws Exception {

        presenter = new CSVDataSetEditWorkflow(clientServices, dataSetDefValidator, beanManager,
                saveRequestEvent, testDataSetEvent, cancelRequestEvent, view);
        when(dataSetDef.getProvider()).thenReturn(DataSetProviderType.CSV);
        when(dataSetDefValidator.validatorFor(any(DataSetProviderType.class))).thenReturn(csvDataSetDefValidator);
        when(csvEditor.refreshEditor()).thenReturn(refreshEditor);
        when(refreshEditor.isRefreshEnabled()).thenReturn(true);
    }

    @Test
    public void testGetDriverClass() {
        assertEquals(CSVDataSetDefDriver.class, presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        assertEquals(org.dashbuilder.client.widgets.dataset.editor.csv.CSVDataSetEditor.class, presenter.getEditorClass());
    }
    
    @Test
    public void testValidateUsingFilePath() {
        presenter._setDataSetDef(dataSetDef);
        presenter.driver = driver;
        presenter.editor = csvEditor;
        when(csvEditor.isUsingFilePath()).thenReturn(true);
        presenter.validate(true, true, true);
        verify(csvDataSetDefValidator, times(1)).validate(dataSetDef, true, true, true, true);
        verify(csvDataSetDefValidator, times(0)).validateAttributes(dataSetDef, true);
    }

    @Test
    public void testValidateUsingFileUrl() {
        presenter._setDataSetDef(dataSetDef);
        presenter.driver = driver;
        presenter.editor = csvEditor;

        when(csvEditor.isUsingFilePath()).thenReturn(false);
        presenter.validate(true, true, true);
        verify(csvDataSetDefValidator, times(1)).validate(dataSetDef, true, true, true, false);
        verify(csvDataSetDefValidator, times(0)).validateAttributes(dataSetDef, false);
    }

    @Test
    public void testFlushDriverUsingFileUrl() throws Exception {
        presenter._setDataSetDef(dataSetDef);
        presenter.driver = driver;
        presenter.editor = csvEditor;
        when(csvEditor.isUsingFilePath()).thenReturn(false);
        presenter.afterFlush();
        verify(dataSetDef, times(1)).setFilePath(null);
        verify(dataSetDef, times(0)).setFileURL(null);
    }

    @Test
    public void testFlushUsingFilePath() throws Exception {
        presenter._setDataSetDef(dataSetDef);
        presenter.driver = driver;
        presenter.editor = csvEditor;
        when(csvEditor.isUsingFilePath()).thenReturn(true);
        presenter.afterFlush();
        verify(dataSetDef, times(1)).setFileURL(null);
        verify(dataSetDef, times(0)).setFilePath(null);
    }
    
}
