/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.GlassBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ShadeColorScheme;
import org.jvnet.substance.color.ShiftColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.painter.GlassGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceCharcoalTheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstancePlanktonWatermark;

public class MagmaSkin
extends SubstanceAbstractSkin {
    public static final String NAME = "Magma";

    public MagmaSkin() {
        ShiftColorScheme shiftRed = new ShiftColorScheme(new SunsetColorScheme(), Color.red, 0.3);
        final SubstanceCharcoalTheme defaultTheme = new SubstanceCharcoalTheme();
        SubstanceTheme activeTheme = new SubstanceTheme(shiftRed, "Red sunset", SubstanceTheme.ThemeKind.BRIGHT){

            public SubstanceTheme getBorderTheme() {
                return defaultTheme;
            }
        }.saturate(0.4);
        ShadeColorScheme disabledScheme = new ShadeColorScheme(defaultTheme.getColorScheme(), 0.5){
            Color foreColor;
            {
                this.foreColor = new Color(104, 93, 90);
            }

            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme, "Disabled Magma", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme activeTitleTheme = defaultTheme.saturate(0.2);
        SubstanceTheme watermarkTheme = defaultTheme.saturate(0.4);
        SubstanceComplexTheme complexTheme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme, activeTitleTheme, watermarkTheme);
        complexTheme.registerComponentStateTheme(disabledTheme, 0.7f, false, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        complexTheme.registerComponentHighlightStateTheme(activeTheme.saturate(-0.2), 0.7f, ComponentState.ROLLOVER_UNSELECTED);
        complexTheme.registerComponentHighlightStateTheme(activeTheme, 0.7f, ComponentState.SELECTED);
        complexTheme.registerComponentHighlightStateTheme(activeTheme, 0.9f, ComponentState.ROLLOVER_SELECTED);
        complexTheme.registerComponentHighlightStateTheme(activeTheme.saturate(-0.2), 0.7f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        this.theme = complexTheme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstancePlanktonWatermark();
        this.gradientPainter = new GlassGradientPainter();
        this.titlePainter = new ArcHeaderPainter();
        this.borderPainter = new GlassBorderPainter();
    }

    public String getDisplayName() {
        return NAME;
    }
}

