/*
 * Copyright 2010 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.core.reteoo;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.spi.PropagationContext;

public class QueryRiaFixerNodeLeftTuple extends BaseLeftTuple {
    private static final long  serialVersionUID = 540l;

    public QueryRiaFixerNodeLeftTuple() {
        // constructor needed for serialisation
    }

    // ------------------------------------------------------------
    // Constructors
    // ------------------------------------------------------------
    public QueryRiaFixerNodeLeftTuple(final InternalFactHandle factHandle,
                                      final Sink sink,
                                      final boolean leftTupleMemoryEnabled) {
        super( factHandle, 
               sink, 
               leftTupleMemoryEnabled );
    }

    public QueryRiaFixerNodeLeftTuple(final LeftTuple leftTuple,
                                      final Sink sink,
                                      final PropagationContext pctx,
                                      final boolean leftTupleMemoryEnabled) {
        super( leftTuple, 
               sink,
               pctx,
               leftTupleMemoryEnabled );
    }

    public QueryRiaFixerNodeLeftTuple(final LeftTuple leftTuple,
                                      final RightTuple rightTuple,
                                      final Sink sink) {
        super( leftTuple, 
               rightTuple, 
               sink );
    }

    public QueryRiaFixerNodeLeftTuple(final LeftTuple leftTuple,
                                      final RightTuple rightTuple,
                                      final Sink sink,
                                      final boolean leftTupleMemoryEnabled) {
        this( leftTuple,
              rightTuple,
              null,
              null,
              sink,
              leftTupleMemoryEnabled );
    }

    public QueryRiaFixerNodeLeftTuple(final LeftTuple leftTuple,
                                      final RightTuple rightTuple,
                                      final LeftTuple currentLeftChild,
                                      final LeftTuple currentRightChild,
                                      final Sink sink,
                                      final boolean leftTupleMemoryEnabled) {
        super( leftTuple, 
               rightTuple, 
               currentLeftChild, 
               currentRightChild, 
               sink, 
               leftTupleMemoryEnabled );
    }
    
}
