package com.redhat.installer.tests.installation.validator;

import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.framework.testers.DataValidatorTester;
import com.redhat.installer.installation.validator.BinaryInPathValidator;
import com.redhat.installer.installation.validator.GitInPathValidator;
import com.redhat.installer.installation.validator.JarInPathValidator;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

public class BinaryInPathValidatorTest extends DataValidatorTester {

    @Before
    public void setup() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "cluster.demo.no.jar", "no.git.in.path.warning", "fake");
    }
    @Test
    public void testExistingGitBinary() {
        dv = new GitInPathValidator();
        assertStatusOk();
    }

    @Test
    public void testExistingJarBinary() {
        dv = new JarInPathValidator();
        assertStatusOk();
    }

    @Test
    public void testNonexistentBinaryError() {
        dv = new TestFakeBinaryError();
        assertStatusError();
    }

    @Test
    public void testNonexistentBinaryWarning(){
        dv = new TestFakeBinaryWarning();
        assertStatusWarning();
    }

    private class TestFakeBinaryError extends BinaryInPathValidator {
        @Override
        protected String getWarningId() {
            return "fake";
        }

        @Override
        protected String getBinaryName() {
            return "some-super-fake-binary-name";
        }

        @Override
        protected Status getFailureStatus() {
            return Status.ERROR;
        }
    }

    private class TestFakeBinaryWarning extends BinaryInPathValidator {
        @Override
        protected String getWarningId() {
            return "fake";
        }

        @Override
        protected String getBinaryName() {
            return "some-super-fake-binary-name";
        }

        @Override
        protected Status getFailureStatus() {
            return Status.WARNING;
        }
    }

}
