/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static boolean isBrowserRootStoreLoaded = false;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;

    public static synchronized void reset() {
        rootStore = RootCertStore.getCertStore();
        permanentStore = DeploySigningCertStore.getCertStore();
        sessionStore = new SessionCertStore();
        deniedStore = new DeniedCertStore();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserRootStore = service.getBrowserSigningRootCertStore();
            browserTrustedStore = service.getBrowserTrustedCertStore();
            isBrowserRootStoreLoaded = false;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string;
                    crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
                    if (crlCheck && (string = Config.getProperty("deployment.security.validation.crl.url")) != null && string.length() > 0) {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                        URL uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoInput(true);
                        uRLConnection.setUseCaches(false);
                        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                        crl509 = (X509CRL)certificateFactory.generateCRL(dataInputStream);
                        dataInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp");
                    if (ocspCheck) {
                        ocspSigner = Config.getProperty("deployment.security.validation.ocsp.signer");
                        ocspURL = Config.getProperty("deployment.security.validation.ocsp.url");
                        if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                            ocspValidConfig = true;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, new AppInfo());
    }

    public static synchronized boolean isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        int n;
        Certificate[] certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        deniedStore.load();
        if (browserRootStore != null && !isBrowserRootStoreLoaded) {
            browserRootStore.load();
            isBrowserRootStoreLoaded = true;
        }
        if (browserTrustedStore != null) {
            browserTrustedStore.load();
        }
        ArrayList arrayList = new ArrayList();
        while (n3 < certificateArray.length) {
            ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
            int n5 = n2;
            while (n5 + 1 < certificateArray.length && certificateArray[n5] instanceof X509Certificate && certificateArray[n5 + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n5], (X509Certificate)certificateArray[n5 + 1])) {
                ++n5;
            }
            n3 = n5 + 1;
            for (n = n2; n < n3; ++n) {
                arrayList2.add(certificateArray[n]);
            }
            arrayList.add(arrayList2);
            n2 = n3;
            ++n4;
        }
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
            if (clazz == null) {
                bl = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
            bl = false;
        }
        if (Config.isJavaVersionAtLeast16() && bl) {
            Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
            boolean bl2 = false;
            n = 0;
            boolean bl3 = false;
            int n6 = 0;
            LinkedHashSet<X509Certificate> linkedHashSet = new LinkedHashSet<X509Certificate>();
            linkedHashSet.addAll(rootStore.getCertificates());
            if (browserRootStore != null) {
                linkedHashSet.addAll(browserRootStore.getCertificates());
            }
            Iterator iterator = arrayList.iterator();
            n4 = 0;
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                X500Principal x500Principal;
                int n7;
                List list = (List)iterator.next();
                Certificate[] certificateArray2 = list.toArray(new X509Certificate[0]);
                if (!Config.getBooleanProperty("deployment.security.askgrantdialog.show")) {
                    string = ResourceManager.getMessage("trustdecider.user.cannot.grant.any");
                    throw new CertificateException(string);
                }
                CertificateExpiredException certificateExpiredException = null;
                CertificateNotYetValidException certificateNotYetValidException = null;
                for (n7 = 0; n7 < certificateArray2.length; ++n7) {
                    try {
                        certificateArray2[n7].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException != null) continue;
                        certificateExpiredException = certificateExpiredException2;
                        n6 = -1;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) continue;
                        certificateNotYetValidException = certificateNotYetValidException2;
                        n6 = 1;
                    }
                }
                n7 = certificateArray2.length;
                X509Certificate x509Certificate = certificateArray2[n7 - 1];
                X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                if (((Object)x500Principal2).equals(x500Principal = x509Certificate.getSubjectX500Principal()) && !linkedHashSet.contains(x509Certificate)) {
                    if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                        string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                        throw new CertificateException(string);
                    }
                    bl2 = true;
                    linkedHashSet.add(x509Certificate);
                }
                boolean bl4 = false;
                boolean bl5 = false;
                try {
                    int n8;
                    object4 = Validator.getInstance("PKIX", "plugin code signing", linkedHashSet);
                    object3 = (PKIXValidator)object4;
                    object2 = object3.getParameters();
                    ((PKIXParameters)object2).addCertPathChecker(new DeployCertPathChecker((PKIXValidator)object3));
                    if (crlCheck) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
                        if (crl509 != null) {
                            bl4 = true;
                        } else {
                            for (n8 = 0; n8 < certificateArray2.length; ++n8) {
                                if (!CertUtils.getCertCRLExtension(certificateArray2[n8])) continue;
                                bl4 = true;
                            }
                        }
                        object2 = TrustDecider.doCRLValidation((PKIXParameters)object2, bl4);
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
                    }
                    if (ocspCheck) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
                        if (ocspValidConfig) {
                            bl5 = true;
                        } else {
                            for (n8 = 0; n8 < certificateArray2.length; ++n8) {
                                if (!CertUtils.getCertAIAExtension(certificateArray2[n8])) continue;
                                bl5 = true;
                            }
                        }
                        TrustDecider.doOCSPValidation((PKIXParameters)object2, linkedHashSet, (X509Certificate[])certificateArray2, bl5);
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
                    }
                    object = new X509Certificate[n7];
                    for (int i = 0; i < n7; ++i) {
                        object[i] = new X509CertificateWrapper(certificateArray2[i]);
                    }
                    ((Validator)object4).validate((X509Certificate[])object);
                    if (crlCheck && bl4) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.crl.succeed");
                    }
                    if (ocspCheck && bl5) {
                        Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.succeed");
                    }
                }
                catch (CertificateException certificateException) {
                    if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                        string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                        throw new CertificateException(string);
                    }
                    if (certificateException instanceof ValidatorException) {
                        object3 = (ValidatorException)certificateException;
                        if (ValidatorException.T_NO_TRUST_ANCHOR.equals(object3.getErrorType())) {
                            bl2 = true;
                        }
                        String string2 = "Certificate has been revoked";
                        if (crlCheck && bl4 || ocspCheck && bl5) {
                            object = object3.getMessage();
                            if (((String)object).contains(string2)) {
                                Trace.msgSecurityPrintln("trustdecider.check.validation.revoked");
                            } else {
                                Trace.msgSecurityPrintln((String)object);
                            }
                            throw object3;
                        }
                        throw object3;
                    }
                    throw certificateException;
                }
                catch (IOException iOException) {
                    Trace.msgSecurityPrintln(iOException.getMessage());
                    throw iOException;
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    Trace.msgSecurityPrintln(invalidAlgorithmParameterException.getMessage());
                    throw invalidAlgorithmParameterException;
                }
                catch (CRLException cRLException) {
                    Trace.msgSecurityPrintln(cRLException.getMessage());
                    throw cRLException;
                }
                if (bl2) {
                    linkedHashSet.remove(x509Certificate);
                }
                if (certificateExpiredException != null) {
                    n = 1;
                    n6 = -1;
                }
                if (certificateNotYetValidException != null) {
                    n = 1;
                    n6 = 1;
                }
                object4 = null;
                try {
                    object3 = codeSource.getCodeSigners();
                    object2 = object3[n4].getTimestamp();
                    if (object2 != null) {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                        object4 = ((Timestamp)object2).getTimestamp();
                        object = ((Timestamp)object2).getSignerCertPath();
                        if (n != 0) {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                            Date date = certificateArray2[n7 - 1].getNotAfter();
                            Date date2 = certificateArray2[n7 - 1].getNotBefore();
                            if (((Date)object4).before(date) && ((Date)object4).after(date2)) {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                                boolean bl6 = TrustDecider.checkTSAPath((CertPath)object, linkedHashSet);
                                if (bl6) {
                                    n = 0;
                                    n6 = 0;
                                } else {
                                    object4 = null;
                                }
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
                        }
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
                }
                int n9 = 0;
                if (deniedStore.contains(certificateArray2[0])) {
                    n9 = deniedStore.contains(certificateArray2[0], true) ? 1 : n;
                }
                if (n9 == 0) {
                    if (permanentStore.contains(certificateArray2[0]) && (n == 0 || !permanentStore.contains(certificateArray2[0], true))) {
                        return true;
                    }
                    if (sessionStore.contains(certificateArray2[0]) && (n == 0 || !sessionStore.contains(certificateArray2[0], true))) {
                        return true;
                    }
                    if (browserTrustedStore != null && browserTrustedStore.contains(certificateArray2[0])) {
                        return true;
                    }
                    int n10 = X509Util.showSecurityDialog(certificateArray2, codeSource.getLocation(), 0, n7, bl2, n6, (Date)object4, appInfo);
                    if (n10 == 0) {
                        Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                        sessionStore.add(certificateArray2[0], n == 0);
                        sessionStore.save();
                        bl3 = true;
                    } else if (n10 == 2) {
                        Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                        object = DeploySigningCertStore.getUserCertStore();
                        object.load(true);
                        if (object.add(certificateArray2[0], n == 0)) {
                            object.save();
                        }
                        bl3 = true;
                    } else {
                        Trace.msgSecurityPrintln("trustdecider.user.deny");
                        deniedStore.add(certificateArray2[0], n == 0);
                        deniedStore.save();
                    }
                    if (bl3) {
                        return true;
                    }
                }
                ++n4;
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
            return CertValidator.validate(codeSource, appInfo, certificateArray, n4, rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore);
        }
        return false;
    }

    private static boolean checkTSAPath(CertPath certPath, LinkedHashSet linkedHashSet) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        Validator validator = Validator.getInstance("PKIX", "tsa server", linkedHashSet);
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[0]);
        try {
            x509CertificateArray = validator.validate(x509CertificateArray);
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln(certificateException.getMessage());
            return false;
        }
        return true;
    }

    private static PKIXParameters doCRLValidation(PKIXParameters pKIXParameters, boolean bl) throws IOException, InvalidAlgorithmParameterException, CRLException, NoSuchAlgorithmException {
        if (crl509 != null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.on");
            System.clearProperty("com.sun.security.enableCRLDP");
            pKIXParameters.setRevocationEnabled(true);
            pKIXParameters.addCertStore(java.security.cert.CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl509))));
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.off");
            pKIXParameters.setRevocationEnabled(bl);
            System.setProperty("com.sun.security.enableCRLDP", Boolean.toString(bl));
        }
        return pKIXParameters;
    }

    private static void doOCSPValidation(PKIXParameters pKIXParameters, LinkedHashSet linkedHashSet, X509Certificate[] x509CertificateArray, boolean bl) throws IOException {
        X509Certificate x509Certificate = null;
        Security.setProperty("ocsp.enable", Boolean.toString(bl));
        if (ocspValidConfig) {
            Security.setProperty("ocsp.responderURL", ocspURL);
        }
        pKIXParameters.setRevocationEnabled(bl);
        if (ocspValidConfig) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.on");
            String string = null;
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext() && !ocspSigner.equals(string = CertUtils.extractSubjectAliasName(x509Certificate = (X509Certificate)iterator.next()))) {
            }
            if (x509Certificate != null) {
                Security.setProperty("ocsp.responderCertSubjectName", x509Certificate.getSubjectX500Principal().getName());
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.off");
        }
        if (!crlCheck && bl) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
    }

    static {
        TrustDecider.reset();
    }
}

