#!/bin/bash

# the script takes binutils* and creates the cross-* packages

for arch in hppa mips arm i386 x86_64 s390 s390x ppc ppc64 ia64 sparc avr alpha; do 

   echo -n "Building package for $arch --> cross-$arch-binutils ..."

   ln -f binutils.changes cross-$arch-binutils.changes
   sed -e "s/^Name:.*binutils\$/Name:         cross-$arch-binutils/" \
       -e "s/^%changelog -n binutils\$/%changelog -n cross-$arch-binutils/" \
       < binutils.spec > cross-$arch-binutils.spec

   echo " done."
done
