%{
//////////////////////////////////////////////////////////////////////////////
// diag-parser.y

TERMS* newTERMS(const char*, const char*, const char* = 0);
static unsigned intConvert(char *S)
{        
   char *err;
   unsigned i=strtoul(S,&err,10);
   assert(*err==0);
   return i;
}

void setAtomIDB(ATOM& a)
    {
    if( ! a.refineType(PREDICATE_NAMES::typeIDB) )
        {
        // This predicate previously was known as EDB, so now
        // we have to move over all instances to the IDB...
        ATOMSET::FIND_RESULT f;
        EDB.find(a, f);
 
        for( ; ! f.atEnd(); f++)
            {
            DISJUNCTION d;
            d.add(*f);
            RULE r(&d,0);
 
            IDB.push_back(r);
 
            if( PTraceLevel >= 1 )
                cdebug << "Moving " << *f
                       << " from EDB to IDB as "
                       << r
                       << endl;
            }
                                                                                
        EDB.erasePred(a);
        }
    }
%}

//////////////////////////////////////////////////////////////////////////////

%union {
    char*        string;
    TERMS*       terms;
    TERM*        term;
    ATOM*        atom;
    LITERAL*     literal;
    }

%token <string>   ID NUM
%type  <string>   ident
%type  <term>     term
%type  <terms>    terms 
%type  <atom>     atom propositional_atom
%type  <literal>  literal

%token ERROR

%token COMMA DOT

%token PARAM_OPEN PARAM_CLOSE
%token NOT
%token BRACKET_OPEN BRACKET_CLOSE


%start input
%%

PARAM_SEPARATOR : COMMA;



input     :
          | input literal DOT { 
#ifdef BISON_DEBUG
                                diagyydebug=1;
#endif
                                if( diagParseLiterals ) 
                                    diagO.push_back(*($2));
                                else
                                    { 
                                    if ( FDiag == FRONTEND_DIAG_WEIGHTED )
                                        { 
                                        diagyyerror("-FDmincost selected but unweighted hypothesis "
                                                    "encountered."); 
                                        exit(0);
                                        }
                                    WEIGHTEDATOM wAtom(*($2),0); 
                                    diagH.push_back(wAtom);
                                    }
                                delete $2;
                              }
          | input literal DOT BRACKET_OPEN NUM BRACKET_CLOSE 
                              {
#ifdef BISON_DEBUG
                                diagyydebug=1;
#endif
                                if( diagParseLiterals )
                                    diagyyerror("Weights are not allowed in observations");
                                else 
                                    { 
                                    if ( FDiag != FRONTEND_DIAG_WEIGHTED ) 
                                        {
                                        diagyyerror("-FD selected but weighted hypothesis " 
                                                    "encountered. ");
                                        exit(0);
                                        }
                                    unsigned weight= intConvert($5);
                                    delete $5;
                                    WEIGHTEDATOM wAtom(*($2),weight); 
                                    diagH.push_back(wAtom);
                                    }
                                delete $2;
                              }
          ;

literal   : atom              {
                                $$=new LITERAL(false,*($1));
                                delete $1;
                              }
          | NOT atom          { 
                                $$=new LITERAL(true,*($2));
                                delete $2;
                              }
          ;

atom      : propositional_atom {
                                $$=$1;
                              }
          | ident PARAM_OPEN terms PARAM_CLOSE
                              {
                                $$ = new ATOM($1,$3,PREDICATE_NAMES::typeUndef); 
                                setAtomIDB(*$$);
                                delete $3;
                              }
          ;

propositional_atom  : ident   {
                                $$ = new ATOM($1,0,PREDICATE_NAMES::typeUndef); 
                                setAtomIDB(*$$);
                              }
          ;

terms    : term               {
                                $$=new TERMS;
                                $$->push_back(*$1);
                                delete $1;
                              }
          | terms PARAM_SEPARATOR term
                              {
                                $$=$1;
                                $$->push_back(*$3); 
                                delete $3;
                              }
          ;


ident      : ID               { 
                                $$=$1;
                              }
          ;

term     : ID                 {
                                $$=new TERM($1);
                              }
          | NUM               {
                                unsigned i= intConvert($1);
                                delete $1;
                                
                                $$=new TERM(i,0);

                                if( static_cast<int>(i) > MaxIntegerSeen )
                                    MaxIntegerSeen=i;

                              }
          ;

%%
