//////////////////////////////////////////////////////////////////////////////
// Intelligent Grounding

#define WITH_DEPGRAPH
#define WITH_GLOBAL_VARIABLES

#include <cmath>
#include "dl.h"
#include "stats.h"
#include "grounding.h"
//#include "grounding-body.h"

/** Create a ground instance of a given CONJUNCTION. Fills an empty 
 * GCONJUNCTION, with ground literals obtained replacing variables 
 * in CONJUNCTION by their bindings in the given map. 
 * Unnecessary predicates (according to the given databases) are left out.
 * Requires a previous construction of an empty GCONJUNCTION and
 * a previous call of negativeBodyIsFalse(conj,deltaNF) because only
 * there we check if a negative literal is contained in EDB, I.positive or
 * deltaNF->positive
 * Uses globals: I, solved, done
 * @param body the GCONJUNCTION to fill.
 * @param conj the CONJUNCTION that will serve as template.
 * @param v2c the mapping of variables to bindings.
 * @param deltaNF the database to check in addition to I. It's NULL when
 * this function is called for constraints and weakConstraints.
 * @param component the current component in the dependency graph.
 * @param recursiveAggregates the vector of the recursive 
 * aggregates in the body. It's NULL when this function is called for 
 * constraints and weakConstraints.
 */  
void GROUNDING::fillGConjunction(
    GCONJUNCTION &body, 
    const CONJUNCTION &conj,
    const TERM v2c[],
    const INTERPRET *deltaNF,
    const unsigned component,
    vector<LITERAL> *recursiveAggregates )
    {
    assert( conj.begin() != conj.end() );
    for( CONJUNCTION::const_iterator i = conj.begin(); i != conj.end(); i++ )
        if( (*i).isAggregate() )
            {
            // Note that the code concerning recursive aggregates is not 
            // currently used.

            if( ! isRecursiveAggregate( (*i).getAggregate().getAuxAtom(), 
                                        component ) )
                {
                const AGGREGATEATOM &a = AGGREGATEATOM( (*i).getAggregate() );

                if( ! solved[a.getAuxAtom().getIndex()]
                    && ! a.isAssignment()
                    && ! a.isSatisfied(v2c)
                    && ! ( (*i).isNegative() && a.isViolated(v2c) ) )
                    {
                    GLITERAL l( (*i).isNegative(), GATOM(ATOM(*i,v2c)) );

                    l.getAggregate().moveToHashes();

                    body.addUnique(l);
                    }
                }
            else 
                {
                // Add the current recursive aggregate in the body.
                recursiveAggregates->push_back(*i);
                }
            }
        else if( (*i).isIDB() )
            {
            if( (*i).isPropositional() )
                {
                if( (*i).isNegative() )
                    {
                    if( done[(*i).getIndex()] )
                        {
                        if( ! solved[(*i).getIndex()] 
                            && (I.isUndefined((ATOM)*i) 
                            || (deltaNF && deltaNF->isUndefined((ATOM)*i))) )
                            body.addUnique( GLITERAL(true,GATOM(*i)) );
                        // else => !(I.isTrue(*i) || deltaNF->isTrue(*i))
                        // because negativeBodyIsFalse(conj,deltaNF) 
                        // was false
                        }
                    else
                        body.addUnique( GLITERAL(true,GATOM(*i)) );
                    }
                else
                    if( ! I.isTrue(*i) 
                        && ! (deltaNF && deltaNF->isTrue(*i)) )
                        body.addUnique( GATOM(*i) );
                }
            else
                {
                const LITERAL body_element(*i,v2c);

                if( (*i).isNegative() )
                    {
                    if( done[(*i).getIndex()] )
                        {
                        if( ! solved[(*i).getIndex()] 
                            && (I.isUndefined((ATOM)body_element) 
                            || (deltaNF && deltaNF
                                ->isUndefined((ATOM)body_element))) )
                            body.addUnique( GLITERAL(true,
                                            GATOM(body_element)) );
                        // else => !(I.isTrue((ATOM)body_element) ||
                        //           deltaNF->isTrue((ATOM)body_element))
                        // because negativeBodyIsFalse(conj,deltaNF) 
                        // was false
                        }
                    else
                        body.addUnique( GLITERAL(true,GATOM(body_element)) );
                    }
                else
                    if( ! I.isTrue(body_element) 
                        && ! (deltaNF && deltaNF->isTrue(body_element)) )
                        body.addUnique( GATOM(body_element) );
                }
            }
    }

