//////////////////////////////////////////////////////////////////////////////
// odbc.h

void odbcExport(const INTERPRET *, const GINTERPRET *);
void odbcAddImport( const char *, const char *, const char *,
                    const char *, const char *, const char *);
void odbcImport();

class ODBC_EXPORT
    {
    char *DBdns;
    char *DBuser;
    char *DBpass;
    char *DBtable;
    char *predicate;
    char *query;

public:
    void setVariables(
        const char *dns,
        const char *user,
        const char *pass,
        const char *table,
        const char *pred,
        const char *qry )
        {
        DBdns = new char[strlen(dns) + 1];
        DBuser = new char[strlen(user) + 1];
        DBpass = new char[strlen(pass) + 1];
        DBtable = new char[strlen(table) + 1];
        predicate = new char[strlen(pred) + 1];
        query = new char[strlen(qry) + 1];
        strcpy(DBdns, dns);
        strcpy(DBuser, user);
        strcpy(DBpass, pass);
        strcpy(DBtable, table);
        strcpy(predicate, pred);
        strcpy(query, qry);
        }

public:
    ODBC_EXPORT()
        : DBdns(0),
          DBuser(0),
          DBpass(0),
          DBtable(0),
          predicate(0),
          query(0)
        {
        }

    ODBC_EXPORT(const ODBC_EXPORT &o)
        {
        setVariables( o.getDBdns(), 
                      o.getDBuser(), 
                      o.getDBpass(),
                      o.getDBtable(), 
                      o.getPredicate(), 
                      o.getQuery() );
        }

    ODBC_EXPORT(
        const char *dns,
        const char *user,
        const char *pass,
        const char *table,
        const char *pred,
        const char *qry)
        {
        setVariables(dns, user, pass, table, pred, qry);
        }

    void operator=(const ODBC_EXPORT &)
        {
        assert( 0 );
        }

    const char *getDBdns() const
        {
        return DBdns;
        }

    const char *getDBuser() const
        {
        return DBuser;
        }

    const char *getDBpass() const
        {
        return DBpass;
        }

    const char *getQuery() const
        {
        return query;
        }

    const char *getPredicate() const
        {
        return predicate;
        }

    const char *getDBtable() const
        {
        return DBtable;
        }

    ~ODBC_EXPORT()
        {
        delete[] predicate;
        delete[] DBtable;
        delete[] DBuser;
        delete[] DBdns;
        delete[] query;
        delete[] DBpass;
        }

    void run(const INTERPRET *, const GINTERPRET *) const;
    };

class ODBC_IMPORT
    {
    char *DBdns;
    char *DBuser;
    char *DBpass;
    char *query;
    char *predicate;
    char *DBtype;

public:
    void setVariables(
        const char *dns,
        const char *user,
        const char *pass,
        const char *qry,
        const char *pred,
        const char *type )
        {
        DBdns = new char[strlen(dns) + 1];
        DBuser = new char[strlen(user) + 1];
        DBpass = new char[strlen(pass) + 1];
        query = new char[strlen(qry) + 1];
        predicate = new char[strlen(pred) + 1];
        DBtype = new char[strlen(type) + 1];
        strcpy(DBdns, dns);
        strcpy(DBuser, user);
        strcpy(DBpass, pass);
        strcpy(query, qry);
        strcpy(predicate, pred);
        strcpy(DBtype, type);
        }

    const char *getDBdns() const
        {
        return DBdns;
        }

    const char *getDBuser() const
        {
        return DBuser;
        }

    const char *getDBpass() const
        {
        return DBpass;
        }

    const char *getQuery() const
        {
        return query;
        }

    const char *getPredicate() const
        {
        return predicate;
        }

    const char *getDBtype() const
        {
        return DBtype;
        }

    void connect();

    bool import();

public:
    ODBC_IMPORT()
        : DBdns(0),
          DBuser(0),
          DBpass(0),
          query(0),
          predicate(0),
          DBtype(0)
        {
        assert(0);
        }

    ODBC_IMPORT(const ODBC_IMPORT &o)
        {
        setVariables(o.getDBdns(),
                     o.getDBuser(),
                     o.getDBpass(),
                     o.getQuery(),
                     o.getPredicate(),
                     o.getDBtype());
        }

    ODBC_IMPORT(
        const char *dns,
        const char *user,
        const char *pass,
        const char *qry,
        const char *pred,
        const char *type)
        {
        setVariables(dns, user, pass, qry, pred, type);
        }

    ODBC_IMPORT& operator=(const ODBC_IMPORT &o)
        {
        setVariables(o.getDBdns(),
                     o.getDBuser(),
                     o.getDBpass(),
                     o.getQuery(),
                     o.getPredicate(),
                     o.getDBtype());
        return *this;
        }

    ~ODBC_IMPORT()
        {
        delete[] predicate;
        delete[] DBtype;
        delete[] DBuser;
        delete[] DBdns;
        delete[] query;
        delete[] DBpass;
    }
    };
   
extern vector<ODBC_EXPORT> ODBC_Exports;
extern vector<ODBC_IMPORT> ODBC_Imports;


