/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID = 258,
     NUM = 259,
     ERROR = 260,
     NEWLINE = 261,
     COMMA = 262,
     DOT = 263,
     COLON = 264,
     SEMICOLON = 265,
     EXCLAMATION = 266,
     PLUS = 267,
     ASTERISK = 268,
     EQUALS = 269,
     VERTICAL_BAR = 270,
     ID_OR_VEL = 271,
     CONS = 272,
     WEAK_CONS = 273,
     ANON_VAR = 274,
     PARAM_OPEN = 275,
     PARAM_CLOSE = 276,
     BRACKET_OPEN = 277,
     BRACKET_CLOSE = 278,
     CURLY_OPEN = 279,
     CURLY_CLOSE = 280,
     PRED_EQUAL = 281,
     PRED_UNEQUAL = 282,
     PRED_LESS = 283,
     PRED_GREATER = 284,
     PRED_LESS_OR_EQ = 285,
     PRED_GREATER_OR_EQ = 286,
     PRED_INT = 287,
     PRED_SUCC = 288,
     PRED_ANY = 289,
     PRED_AVG = 290,
     PRED_COUNT = 291,
     PRED_MAX = 292,
     PRED_MIN = 293,
     PRED_SUM = 294,
     PRED_TIMES = 295,
     NOT = 296,
     TRUE_NOT = 297,
     MAXINTEGER = 298,
     BOOL_QUERY = 299,
     META_IMPORT = 300,
     META_EXPORT = 301,
     META_QUERY_EXPORT = 302
   };
#endif
#define ID 258
#define NUM 259
#define ERROR 260
#define NEWLINE 261
#define COMMA 262
#define DOT 263
#define COLON 264
#define SEMICOLON 265
#define EXCLAMATION 266
#define PLUS 267
#define ASTERISK 268
#define EQUALS 269
#define VERTICAL_BAR 270
#define ID_OR_VEL 271
#define CONS 272
#define WEAK_CONS 273
#define ANON_VAR 274
#define PARAM_OPEN 275
#define PARAM_CLOSE 276
#define BRACKET_OPEN 277
#define BRACKET_CLOSE 278
#define CURLY_OPEN 279
#define CURLY_CLOSE 280
#define PRED_EQUAL 281
#define PRED_UNEQUAL 282
#define PRED_LESS 283
#define PRED_GREATER 284
#define PRED_LESS_OR_EQ 285
#define PRED_GREATER_OR_EQ 286
#define PRED_INT 287
#define PRED_SUCC 288
#define PRED_ANY 289
#define PRED_AVG 290
#define PRED_COUNT 291
#define PRED_MAX 292
#define PRED_MIN 293
#define PRED_SUM 294
#define PRED_TIMES 295
#define NOT 296
#define TRUE_NOT 297
#define MAXINTEGER 298
#define BOOL_QUERY 299
#define META_IMPORT 300
#define META_EXPORT 301
#define META_QUERY_EXPORT 302




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

//////////////////////////////////////////////////////////////////////////////
// parser.y

#include "builtin.h"

#define STRINGIFY(X) STRINGIFY1(X)
#define STRINGIFY1(X) #X

LOCAL_VARIABLES LocalVariables;

NEG_ATOMS NegativeAtoms;

#define INVALID_GUARD "#invalid_guard#" 

//////////////////////////////////////////////////////////////////////////////

/** builds a new TERM with the given name.
 * A name starting with a capital letter means that this should be a variable.
 * It is generated as a constant otherwise.
 * @param id the name.
 * @return the new TERM.
 */
TERM *newTERM(const char* id)
    {
    if (isupper(id[0]))
	return new TERM(LocalVariables.record(id));
    else
	return new TERM(id);
    }

/** builds a new TERMS list with the given TERMs.
 * @param new1 the first member.
 * @param new2 (optional) the second member.
 * @param new3 (optional) the third member.
 * @return the new TERMS.
 */
TERMS* newTERMS(
    const TERM* new1,
    const TERM* new2,
    const TERM* new3 )
    {
    TERMS* x=new TERMS;

    x->push_back(*new1);
    if (new2)
        x->push_back(*new2);
    if (new3)
        x->push_back(*new3);

    return x;
    }

/** builds a new built-in ATOM.
 * @param type specifies exact built-in.
 * @param terms the list of parameters.
 * @return the new ATOM.
 */
ATOM* newBuiltin(BUILTIN type, const TERMS* terms)
    {
    return new ATOM(type,terms);
    }

/** builds a new negative ATOM with the given name.
 * @param name the ATOM's intended name.
 * @param terms the list of parameters.
 * @return the new ATOM.
 */
ATOM* newNegativeATOM(const char *name, const TERMS *terms)
    {
    char *negname=new char[strlen(name)+2];

    negname[0] = '-';
    strcpy(negname+1,name);

    ATOM *atom = new ATOM(negname,terms,PREDICATE_NAMES::typeUndef);

    delete[] negname;

    NegativeAtoms.insert(atom->getIndex());

    return atom;
    }

enum WCType { WCfree, WCnone, WClayer, WCweight, WCfull };

/** determines whether a given weak-constraint-type is compatible with
 * previous ones.
 *
 * An error is issued if the given type is incompatible.
 *
 * @param requested the type of the current constraint.
 * @return whether the check suceeded.
 */
static bool checkWC(WCType requested)
    {
    static WCType state=WCfree;

    if (state==WCfree)
	state=requested;
    else if (state!=requested)
	{
	yyerror("Weak constraint has different weight-format than others");
        parser_errors++;

        return false;
	}

    return true;
    }

static unsigned newObjectID(const char* id, OIDindices* oind)
    {
    ObjectIDs.push_back(OID(id,oind));
    CurrentOID = ObjectIDs.size() - 1;

    return ObjectIDs.size()-1;
    }

OIDindices* newOIDindex(OIDindices* oind, const char* id)
    {
    assert(oind);

    if( (TERM::Strings.find(NAMES_ITEM(id))).second )
        {
        OIDs::const_iterator i = ObjectIDs.begin();

        for( ; i != ObjectIDs.end() && (*i) != id; i++ )
            {
            }

        if( i != ObjectIDs.end() )
            {
            (*oind).push_back(i - ObjectIDs.begin());
            return oind;
            }
        }

    yyerror("Undefined object identifier");
    parser_errors++;
    return oind;
    }


class DefeasibilitySetter : public unary_function<ATOM&,void>
    {
    const unsigned oi;
    const ATOM &pred;
public:
    DefeasibilitySetter(const unsigned oi2, const ATOM &pred2)
        : oi(oi2), pred(pred2)
        {
        }

    void operator() (const ATOM &a) const
        {
        if( a == pred )
             {
             if( TraceLevel >= 3)
                 cdebug << "Defeasible atom: " << pred << " in "
                        << ObjectIDs[oi] << endl;
             ObjectIDs[oi].addDefeasible(pred);
             }
        }
    };

static void set_defeasible(const ATOM &pred, const OIDindices *oind)
    {
    if( ! oind )
        return;

    for( OIDindices::const_iterator i = oind->begin();
         i != oind->end();
         i++ )
        {
        if( ObjectIDs[*i].isDefeasible(pred) )
            {
            if( TraceLevel >= 3 )
                cdebug << pred << " is already defeasible in " 
                       << ObjectIDs[*i]
                       << ". Aborting defeasibility check." << endl;
            return;
            }

        // check rules in ObjectIDs[*i]
        ObjectIDs[*i].getEDB()->foreach( DefeasibilitySetter(*i,pred) );

        for( RULES::const_iterator j = (ObjectIDs[*i].getIDB())->begin();
             j != (ObjectIDs[*i].getIDB())->end();
             j++ )
            {
            for( DISJUNCTION::const_iterator k = j->getHead().begin();
                 k != j->getHead().end();
                 k++ )
                if( *k == pred )
                    {
                    if( TraceLevel >= 3 )
                        cdebug << "Defeasible atom: " << pred << " in " 
                               << ObjectIDs[*i] << endl;
                    ObjectIDs[*i].addDefeasible(pred);
                    }
            }

        set_defeasible(pred,ObjectIDs[*i].getParentOIDindices());
        }
    }

/////////////////////////////////////////////////////////////////////////////
/**Substitute v with the constant c when occurring in atom a as variable.
 */
static void substitute( ATOM &a,
    const TERM &c,
    const TERM &v )
    {
    assert( a.isRegularAtom() );
    assert( c.getType() == TERM::String 
            || c.getType() == TERM::Integer );
    assert( v.getType() == TERM::Variable );

    if( a.getParams() )
        replace( a.getParamsForModification()->begin(), 
                 a.getParamsForModification()->end(),
                 v, c );
    }

/////////////////////////////////////////////////////////////////////////////
/**Substitute v with c in each atom of disjunction d. 
 */
static void substitute( DISJUNCTION &d,
    const TERM &c,
    const TERM &v )
    {
    assert( c.getType() == TERM::String 
            || c.getType() == TERM::Integer );
    assert( v.getType() == TERM::Variable );

    for( DISJUNCTION::iterator i = d.begin();
         i != d.end();
         i++ )
        substitute( (*i),c,v );
    }

/////////////////////////////////////////////////////////////////////////////
/**Substitute in each positive literal appearing in c the occurrences of 
 * v with the constant c.
 */
static void substitute( CONJUNCTION &con,
    const TERM &c,
    const TERM &v )
    {
    assert( c.getType()==TERM::String 
            || c.getType() == TERM::Integer );
    assert( v.getType() == TERM::Variable );

    for( CONJUNCTION::iterator l = con.pos_begin();
         l != con.pos_end();
         l++ )
        {
        if( (*l).isAggregate() )
            {
            // Substitute v by c in the auxiliary atom.
            substitute( (*l).getAggregate()
                        .getAuxAtomForModification(),c,v );
            // If guards are equal to the var term substitute
            // them with the constant value. 
            if( (*l).getAggregate().getUpperGuardAsVar() == v )
                (*l).getAggregate().setUpperGuard(c);
            if( (*l).getAggregate().getLowerGuardAsVar() == v )
                (*l).getAggregate().setLowerGuard(c);
            }
        else
            substitute( (*l),c,v );
        }
    }

/////////////////////////////////////////////////////////////////////////////
/**Substitute in each atom occurring in c, and d all of the occurrences
 * of v with c.
 */
inline static void substitute( 
    DISJUNCTION       *dis,
    CONJUNCTION       &con,
    const TERM        &c,
    const TERM        &v )
    {
    if( dis )
        substitute(*dis,c,v);
    substitute(con,c,v);
    }

/////////////////////////////////////////////////////////////////////////////
/* For each equality builtin in conjunction c in which a constant is
 * assigned to a variable, substitute each occurrence of the variable 
 * by the constant in all the literals appearing in c, and all the
 * atoms appearing in d.
 */
static void bindTermOfBuiltinEquality( DISJUNCTION *d, CONJUNCTION &c )
    {
    for( CONJUNCTION::iterator l = c.begin();
         l != c.end();
         l++ )
        {
        // Check whether the literal is an equality builtin.
        if( (*l).isBuiltinEquality() )
            {
            // Note: don't nitialize t1, antd t2 as reference
            // because of side effects tested upon procedure
            // substitute(ATOM &, const TERM &, const TERM &).
            const TERM t1 = *( (*l).getParams()->begin() );
            const TERM t2 = *( (*l).getParams()->begin()+1 );

            // Check whether the first argument is a variable and 
            // the second argument is a constant.
            if( t1.getType() == TERM::Variable 
                && ( t2.getType() == TERM::String 
                     || t2.getType() == TERM::Integer ) )
                {
                substitute(d,c,t2,t1);
                }
            // Check whether the first argument is a constant and
            // the second argument is a variable.
            else if( ( t1.getType() == TERM::String
                       || t1.getType() == TERM::Integer )
                     && t2.getType() == TERM::Variable )
                {
                substitute(d,c,t1,t2);
                }
            }
        }
    }

static void newRule(const RULE &rule)
    {
    if( rule.getBody() )
        bindTermOfBuiltinEquality( &( rule.getHeadForModification() ),
                      *( rule.getBodyForModification() ) );

    if( ! rule.isSafe() )
        {
        yyerror("Rule is not safe");
        parser_errors++;
        }
    else if( LocalVariables.getNumber() > n_par )
        {
        yyerror("Rule contains too many variables");
        parser_errors++;
        }
    else 
        {
        assert( rule.hasHead() );

        const DISJUNCTION &head = rule.getHead();

        // Is this rule in fact a fact?
        if( ! rule.isDisjunctive()  &&  ! rule.getBody() )
            {
            const ATOM &a=*(head.begin());

            if( a.refineType(PREDICATE_NAMES::typeEDB) )
                {
                assert( CurrentOID < ObjectIDs.size() );
                ObjectIDs[CurrentOID].addEDBFact(a);

                OIDindices* oind = ObjectIDs[CurrentOID].getParentOIDindices();

                if(oind)
                    {
                    if( TraceLevel >= 3 )
                        cdebug << "Defeasibility checking " << a 
                               << " in " << ObjectIDs[CurrentOID] 
                               << "." << endl;

                    if( a.occursComplementary() )
                        {
                        ATOM complement(a);
                        a.getComplementary(a.getParams(),complement);
                        set_defeasible(complement, oind);
                        }
                    }
                }
            else
                {
                // Using an IDB predicate as EDB.
                a.refineType(PREDICATE_NAMES::typeIDB);
                IDB.push_back(rule);
                }
            }
        else
            // We are dealing with a "real" rule.
            {
            for( DISJUNCTION::const_iterator i=head.begin();
                 i != head.end();
                 i++ )
                {
                if( ! (*i).refineType(PREDICATE_NAMES::typeIDB) )
                    {
                    // This predicate previously was known as EDB, so now
                    // we have to move over all instances to the IDB...
                    ATOMSET::FIND_RESULT f; 
                    EDB.find(*i, f);

                    for( ; ! f.atEnd(); f++)
                        {
                        DISJUNCTION d;
                        d.add(*f);
                        RULE r(&d,0);

                        IDB.push_back(r);

                        if( PTraceLevel >= 1 )
                            cdebug << "Moving " << *f
                                   << " from EDB to IDB as "
                                   << r
                                   << endl;
                        }

                    EDB.erasePred(*i);
                    }
                }
                    
            if( LocalVariables.getNumber() )
                IsIDBGround=false;

            assert( CurrentOID < ObjectIDs.size() );
            ObjectIDs[CurrentOID].addIDBRule(rule);

            OIDindices *oind = ObjectIDs[CurrentOID].getParentOIDindices();

            if( oind )
                {
                for( DISJUNCTION::const_iterator i=head.begin();
                     i != head.end();
                     i++ )
                    {
                    if( TraceLevel >= 3 )
                        cdebug << "Defeasibility checking " << (*i)
                               << " in " << ObjectIDs[CurrentOID] 
                               << "." << endl;

                    if( (*i).occursComplementary() )
                        {
                        ATOM complement(*i);
                        (*i).getComplementary((*i).getParams(),complement);
                        set_defeasible(complement, oind);
                        }
                    }
                }
            }
        }
    LocalVariables.clear();
    }

static void newStrictRule(const RULE &rule)
    {
    unsigned CurrentOIDStacked = CurrentOID;
    // Strict rules simply go into the default object.
    CurrentOID = 0;
    newRule(rule);
    CurrentOID = CurrentOIDStacked;
    StrictRulesExist = true;
    }

static void newConstraint(CONJUNCTION &constraint)
    {
    bindTermOfBuiltinEquality(0,constraint);

    if ( ! constraint.isSafe())
        {
        yyerror("Constraint is not safe");
        parser_errors++;
        }
    else if ( LocalVariables.getNumber() > n_par )
        {
        yyerror("Constraint contains too many variables");
        parser_errors++;
        }
    else
        {
        if( LocalVariables.getNumber() )
            IsConstraintsGround=false;

        CONSTRAINT c(constraint,false);
        Constraints.push_back(c);
        }

    LocalVariables.clear();
    }

static void newWeakConstraint(
    CONJUNCTION   *wconstraint,
    const WEIGHTS *weights )
    {
    bindTermOfBuiltinEquality(0,*wconstraint);

    if (weights)
        {
        if ( ! ( wconstraint->isSafe() && safeWeights(*weights,*wconstraint)))
            {
            yyerror("Weak constraint is not safe");
            parser_errors++;
            }
        else if( LocalVariables.getNumber() > n_par )
            {
            yyerror("Weak constraint contains too many variables");
            parser_errors++;
            }
        else
            {
            if( LocalVariables.getNumber() )
                IsWConstraintsGround=false;

            if( ! (weights->first).isVar() && ! (weights->first).isInt() )
                {
                yyerror("A weight should be a number or a variable");
                parser_errors++;
                }
            else if( ! (weights->second).isVar() && ! (weights->second).isInt() )
                {
                yyerror("A level should be a number or a variable");
                parser_errors++;
                }
            else if( (weights->first).isInt() && (weights->first).getInt() < 0 )
                {
                yyerror("Weight must be a non-negative integer.");
                parser_errors++;
                }
            else if( (weights->second).isInt() && (weights->second).getInt() <= 0 )
                {
                yyerror("Level must be a positive integer.");
                parser_errors++;
                }
            else
                {
                WEAKCONSTRAINT c(*(wconstraint),(*weights).first,(*weights).second);
                WConstraints.push_back(c);
                }
            }
        }

    LocalVariables.clear();
    }

//////////////////////////////////////////////////////////////////////////////
// Parse and standardize the lower (upper) guard of an aggregate.
// Possible syntax errors are properly flagged, and a dummy guard
// is returned in order to allow to proceed in a safe and sound way.
//
// @param inclusive true if the guard is inclusive (>=), false
// else (>).
// @param isLower true if processing lower guard, false else.

static GUARD* standardizeGuard(
    TERM         *term,
    const bool    inclusive,
    const bool    isLower)
    {
    assert(term);

    bool guardOperator = true;

    // Proceed with a parsing check of the guard.
    if( ! ( term->isVar() || term->isInt() ) )
        {
        yyerror("A guard should be a number or a variable");
        parser_errors++;
        }
    else if( isLower && term->isInt() && ( term->getInt() < 0 ) )
        {
        yyerror("Lower guard should be greater-or-equal than 0");
        parser_errors++;
        }
    else if( !isLower && term->isInt() && ( term->getInt() < 0 ) )
        {
        yyerror("Upper guard should be greater-or-equal than 0");
        parser_errors++;
        }
    else if( !isLower && !inclusive && term->isInt() && 
        ( term->getInt() == 0 ) )
        {
        yyerror("Upper guard should be greater than 0");
        parser_errors++;
        }
    else if( isLower && !inclusive && term->isInt() && 
        ( term->getInt() == INT_MAX ) )
        {
        yyerror("Lower guard should be less than MAXINT");
        parser_errors++;
        }
    else
        {
        // Perform the standardization of the guard.
        assert( term );
        TERM ident;

        if( term->isInt() )
            {
            if(!inclusive)
                if( isLower ) 
                    {
                    assert( (term->getInt()) < INT_MAX );
                    ident = TERM( term->getInt() +1, 0);
                    }
                else
                    {
                    assert( term->getInt() > 0 );
                    ident = TERM( term->getInt() -1, 0);
                    }
            else
                ident = TERM(term->getInt(), 0);
            }
        else
            {
            assert( term->isVar() );
            ident = TERM(*term);
            guardOperator = inclusive;
            }

        return new GUARD( ident, guardOperator ); 
        }

    // Parse error(s) have been found, return a dummy guard.
    return new GUARD( TERM(INVALID_GUARD), guardOperator );
    }

//////////////////////////////////////////////////////////////////////////////
//
// Build an aggregate atom.
// Set the assignment flag iff the aggregate is of the form 
// X <= aggregate( Vars : Conjunction ) <= X.
// Note: to allow standardization of aggregate's conjunction
// w.r.t. the body under construction conj is processed when
// StandardizeBody is called.
// Side effects: aggrPred, lower, upper are freed upon return.
//
static ATOM* newAggregate(
    GUARD         *lower,
    GUARD         *upper,
    AGGREGATEPRED *aggrPred )
    {
    assert( lower && upper );
    assert( aggrPred );
 
    if( PTraceLevel >= 1 )
        cdebug << (*lower).first
               << ( (*lower).second ? " <= " : " < " )
               << (*aggrPred).getAggregateType().getName()
               << "( " << (*aggrPred).getVars() << " :"
               << (*aggrPred).getConjunction() << " )"
               << ( (*upper).second ? " <= " : " < " )
               << (*upper).first 
               << endl;
             
    // Build the aggregate to return.
    AGGREGATEATOM aggregate(*lower,*upper,*aggrPred);

    // Set the assignment flag if this is a assigning aggregate.
    if( lower->first.isVar() && lower->first == upper->first 
        && lower->second == upper->second )
        aggregate.setAssignment(true);

    // aggrPred,lower,upper are freed upon return.
    if(aggrPred) 
        delete aggrPred;

    assert( lower != upper );
    if(lower)
        delete lower;
    if(upper)
        delete upper;

    return new ATOM(aggregate);
    }        

/**Check whether all of the variables in vars
 * occur in any of the literals in conjunction. 
 */
static bool varsOccurInConjunction(
    const TERMS &vars,
    const CONJUNCTION &conjunction)
// @param vars is a vector of variables.
// @param conjunction is the aggregate conjunction.
    {
    assert(conjunction.size() > 0);
    assert(vars.size() > 0 );
 
    bool found = false;
    for( TERMS::const_iterator t = vars.begin();
        t != vars.end();
        t++)
        {
        for( CONJUNCTION::const_iterator lit = conjunction.begin();
            lit != conjunction.end() && !found;
            lit++)
            {
            assert( (*lit).isRegularAtom() );
            if( (*lit).getParams() && contains(*((*lit).getParams()),*t) )
                found=true;
            }
 
        if(!found)
            // Vars to be aggregated over should appear in Free.
            return false;
        }
 
    return true;
    } 

/**Return true if the variables to be aggregated over are free w.r.t.
 * the conjunction, in which the aggregate is contained, false else.
 * A variable is free if it appears in a literal of the aggregate
 * conjunction, and neither appears in any regular atom of the
 * conjunction in which the aggregate occurs, nor in any guard of an
 * aggregate atom in this conjunction.
 * Assumption: conj contains aggr.
 */
static bool freeVarsToBeAggregatedOver(
    const AGGREGATEATOM &aggr,
    const CONJUNCTION& conj )
// @param aggr is an aggregate atom.
// @param conj is the body aggr occurs in.
    {
    // Check sanity of the aggregate atom.
    assert( aggr.getFreeVars().size() > 0 );
    assert( aggr.getConjunction().size() > 0 );

    // We cannot check whether aggr is in conj, as the equality
    // operator for aggregate atoms is guaranteed to work only after
    // standardization.

    const TERMS &vars = aggr.getFreeVars();

    // First check whether all variables to be aggregated over occur
    // in the aggregate conjunction.
    if ( varsOccurInConjunction(vars,aggr.getConjunction()) )
        {
        // Now make sure that the variables to be aggregated over do
        // not occur in the rest of the conjunction in which the
        // aggregate occurs. For regular atoms, all variables are
        // considered, for aggregate atoms the guards. Note that aggr
        // is assumed to be in conj.
        for(CONJUNCTION::const_iterator lit = conj.begin();
            lit != conj.end();
            lit++)
            {
            // For each atom in conj:
            if( (*lit).isRegularAtom() )
                {
                // For a regular atom, check whether any of its variables
                // is among the variables to be aggregated over. If so,
                // we immediately return false.
                if( (*lit).getParams() )
                    {
                    for(TERMS::const_iterator var = vars.begin();
                        var != vars.end();
                        var++)
                        {
                        if( contains(*((*lit).getParams()),*var))
                            {
                            // A free variable occurs in the remainder of the body.
                            return false;
                            }
                        }
                    }
                }
            else
                {
                // For aggregate atoms, make sure that the guards are
                // not variables to be aggregated over.
                assert( (*lit).isAggregate() );
                if( contains(vars,(*lit).getAggregate().getLowerGuardAsVar())
                    || contains(vars,(*lit).getAggregate().getUpperGuardAsVar()))
                    return false;
                }
            }
        }
    else
        {
        return false;
        }
    return true;
    }

/////////////////////////////////////////////////////////////////////////////
/**Create a string representing a TERM as follows:
 * o if the TERM represents a variable build the string "_"localIndex,
 *   where localIndex is an index obtained using the class LOCAL_VARIABLES.
 *   The use of a local index its necessary to obtain for a variable an 
 *   association with a value non depending from the order of the literals 
 *   in the conjunction in which the variable appears.
 * o if the TERM represents an integer build the string "#"intValue;
 * o if the TERM represents a constant build the string "$"constantIndex;
 */
static void identToToken( TERMS::const_iterator j,
    char *str, 
    LOCAL_VARIABLES &vars)
    {
    switch( (*j).getType() )
        {
        case TERM::Variable:
            {
            // Convert the index of a variable into a string. 
            sprintf( str,"%u",(*j).getVar() );
            // Associate a local index to a string.
            unsigned localIndex = vars.record(str);
            // Convert the local index into a string.
            sprintf(str,"_%u",localIndex);
            break;
            }
        case TERM::String:
            sprintf( str,"$%lu",static_cast<unsigned long>((*j).getIndex()) );
            break;
        case TERM::Integer:
            sprintf( str,"#%u",(*j).getInt() );
            break;
        default:
            assert( 0 );
        }
    }

/////////////////////////////////////////////////////////////////////////////
/**Build the name of the auxiliary atom as follows:
 *   o the string "aux#", followed by
 *   o the strings associated with the free variables of the aggregate 
 *     function (where, for every variable, we print a local index, obtained 
 *     by using an instance of the class LOCAL_VARIABLES, and the 
 *     entries are separated by "_"), followed by
 *   o the strings associated with the predicate names and the parameters
 *     contained into the body of the auxiliary rule, and finally 
 *     followed by
 *   o the arity of the auxiliary atom.
 *
 * - Example 1 -
 * Given the following constraint
 *     :- #count{Y:b(Y,a), c(X), not a(Y,1,X)} > 1.
 * the auxiliary atom the name is:
 *     aux#_0~10_0$1~11_1!~12_0#1_1|1
 * - Example 2 -
 * Given the following constraint
 *     :- p(X), #count{Y:b(Y,a), c(X), not a(Y,1,X)} > 1.
 * the auxiliary atom the name is:
 *     aux#_0~10_1~11_0$1~12_1!~13_0#1_1|2
 * - Example 3 -
 * Given the program with th following constraints
 *     :- #count{Y:a(Y),b(Y,X)} > 5.
 *     :- p(X), #count{Y:a(Y),b(Y,X)} > 1.
 * for the first aggregate the auxiliary name is
 *     aux#_0~11_0~12_0_1!|1
 * and for the second aggregate is
 *     aux#_0~11_0~12_0_1!|2
 * - Example 4 - 
 * Given the program with the following constraints
 *     :- #count{Y: not a(Y),b(Y,X)} > 5.
 *     :- #count{Y: b(Y,X),not a(Y)} > 5.
 * for the two aggregates we obtain the same auxiliary atom name
 *     aux#_0~11_0_1!~10_0|1
 */
string createAuxAtomName( const AGGREGATEATOM &aggr,
    const CONJUNCTION &auxConj,
    unsigned arity )
    { 
    LOCAL_VARIABLES vars;
    
    // Initialize auxAtomName as "aux#".
    string auxAtomName(AUXNAME);
    
    // Initialize the string to associate to a TERM.
    char str[21];
    
    for( TERMS::const_iterator i = aggr.getFreeVars().begin(); 
        i != aggr.getFreeVars().end();  
        i++ )
        {
        assert( (*i).isVar() );
        identToToken(i,str,vars);
        auxAtomName += str;
        }

    for( CONJUNCTION::const_iterator i = auxConj.begin();
        i != auxConj.end(); 
        i++ )
        {
        if ( (*i).isNegative() )
            auxAtomName += "!";

        // Build the string to associate to the name of the current 
        // literal and append it to auxAtomName.  
        sprintf ( str,"~%u",(*i).getIndex() );
        auxAtomName += str;

        if ( (*i).getParams() )
            for( TERMS::const_iterator j = (*i).getParams()->begin(); 
                j != (*i).getParams()->end();  
                j++ )
                {
                identToToken(j,str,vars);
                auxAtomName += str;
                }
        }

    // Finally, append the arity of the auxiliary atom to auxAtomName.
    sprintf ( str,"|%u",arity );
    auxAtomName += str;

    return auxAtomName;
    }

/////////////////////////////////////////////////////////////////////////////
/**For each aggregate aggr in CONJUNCTION c of the form
 * #aggr_type( Vars : Conj(Free,Bound) )
 * is built a new auxiliary atom of the form
 * aux#conjunction2string(Vars,Bound).
 * which is the head of the auxiliary rule.
 *
 * Free is the set of variables appearing only in aggr.
 * Bound is the set of variables appearing in c and aggr conjunction.
 * Vars should be included into Free otherwise it is raised an error.
 */
static ATOM buildAuxAtom(const AGGREGATEATOM &aggr,
    const CONJUNCTION &conj,
    const CONJUNCTION &auxConj)
//
// @param aggr    is the aggregateatom.
// @param conj    is the body of the rule to be standardized.
// @param auxConj is the body of the auxiliary rule.
// returns the built auxAtom.
//
    {
    assert( aggr.getConjunction().size() > 0 );
    assert( aggr.getFreeVars().size() > 0 );
 
    TERMS auxparams(aggr.getFreeVars());
    CONJUNCTION aggrConj(aggr.getConjunction());

    for(CONJUNCTION::const_iterator aggLit = aggrConj.begin();
        aggLit != aggrConj.end();
        aggLit++)
        {
        assert( (*aggLit).isRegularAtom() );
        if( (*aggLit).getParams() )
            {
            for(TERMS::const_iterator t = (*aggLit).getParams()->begin();
                t != (*aggLit).getParams()->end();
                t++)
                {
                // If param is not a variable to be aggregated over,
                // check whether it is contained in some literals of
                // c, i.e, whether it is bound.
                if((*t).isVar())
                    {
                    for(CONJUNCTION::const_iterator lit = conj.begin();
                        lit != conj.end();
                        lit++)
                        {
                        if( (*lit).isRegularAtom() && (*lit).getParams()
                            && contains(*((*lit).getParams()),*t))
                            {
                            // Check whether t is a variable to be
                            // aggregated over. This is an error and
                            // should have been discovered earlier by
                            // freeVarsToBeAggregatedOver().
                            assert( ! contains(aggr.getFreeVars(),*t) );
                            if(!contains(auxparams,*t))
                                {
                                // t is Bound,add unique in auxparams.
                                auxparams.push_back(*t);
                                }
                            }
                        }
                    }//if((*t).isVar())
                }//for(TERMS::const_iterator t
            }//if( (*aggLit).getParams() )
        }//for(CONJUNCTION::const_iterator aggLit

    // There should always be variables to be aggregated over.
    assert( auxparams.size() > 0 );

    // Build a new name for auxAtom.
    string auxname = createAuxAtomName(aggr,auxConj,auxparams.size());   

    // Build the atom and return.
    return ATOM(auxname.c_str(),&auxparams);
    }

/////////////////////////////////////////////////////////////////////////////
/**Return true if at least one variable appearing in lit1 occurs in lit2.
 */
static bool isPartiallyBoundBy(const LITERAL &lit1, const LITERAL &lit2)
    {
    assert( lit1.isRegularAtom() && lit2.isRegularAtom() );

    if( lit1.getParams() && lit2.getParams() )
        {
        for(TERMS::const_iterator t = lit1.getParams()->begin();
            t != lit1.getParams()->end();t++)
            if( contains( *( lit2.getParams() ), *t) )
                return true;
        }

    return false; 
    }

/////////////////////////////////////////////////////////////////////////////
static bool checkAndRemoveQuotes(char *s)
// 
// Remove enclosing quotes from a quoted string.
// Return true if the string was properly quoted, false otherwise.
//
    {
    size_t l=strlen(s);

    if( s[0] != '\"'  ||  s[l-1] != '\"' )
        return false;

    memmove(s,s+1,l-2);
    s[l-2]='\0';

    return true;
    }

/////////////////////////////////////////////////////////////////////////////
/**Return true if each variable appearing in lit1 occurs in
 * a saviour literal of either c1 or c2, for which isRegularAtom() holds.
 */
static bool checkBinding(
    const LITERAL &lit1,
    const CONJUNCTION &c1,
    const CONJUNCTION &c2 )
    {
    assert( lit1.isRegularAtom() && lit1.getParams() );

    bool binding = true;
    for(TERMS::const_iterator t = lit1.getParams()->begin();
       t != lit1.getParams()->end();
       t++)
       {
       if( (*t).isVar() )
           {
           // We don't have a binding for this variable yet.
           binding = false;

           // Search a binding for t in conjunction c1.
           for(CONJUNCTION::const_iterator lit2 = c1.begin();
               !binding && lit2 != c1.end(); lit2++)
               {
               if( (*lit2).isSaviour()
                   && (*lit2).isRegularAtom()
                   && (*lit2).getParams()
                   && contains(*((*lit2).getParams()),*t) )
                   // Binding found.
                   binding = true;
               }

           // Search a binding for t in conjunction c2.
           for(CONJUNCTION::const_iterator lit2 = c2.begin();
               !binding && lit2 != c2.end(); lit2++)
               {
               if( (*lit2).isSaviour()
                   && (*lit2).isRegularAtom()
                   && (*lit2).getParams()
                   && contains(*((*lit2).getParams()),*t) )
                   // Binding found.
                   binding = true;
               }

           if(! binding)
               // There is at least a variable
               // of lit1 which is unbound.
               return false;
           }
       }
    assert(binding);

    return true;
    }

/////////////////////////////////////////////////////////////////////////////
/**Build a safe conjunction as the union of the literals appearing in c1
 * and c2, representing the body of an auxiliary rule, without considering 
 * aggregates and propositional literals appearing in c1. 
 * A literal lit1 of c1 is added iff, either it is saved by one (or more)
 * literal(s) of c1, or it saves one (or more) literal(s) appearing in c1,
 * or it is safe and all of its variables occur in one or more literals of 
 * c2.
 * If lit1 is not safe an error is returned.
 * A literal lit2 of c2 is added iff it is safe, otherwise an error is 
 * returned.
 */
static pair <CONJUNCTION,bool> buildAuxRuleBody(const CONJUNCTION &c1,
    const CONJUNCTION &c2)
//
// @param c1 the body of the rule, constraint where aggregates appear.
// @param c2 the internal conjunction of a aggregate.
// return a pair<CONJUNCTION,bool>, the second item indicates whether the
// body has been built successfully; the first item contains the body.
//
    {
    CONJUNCTION auxbody;

    for(CONJUNCTION::const_iterator lit2 = c2.begin();
        lit2 != c2.end();
        lit2++)
        {
        assert( (*lit2).isRegularAtom() );

        if( (*lit2).getParams() )
            {
            if( !( (*lit2).isSaviour() || checkBinding(*lit2,c1,c2) ) )
                {
                yyerror("Aggregate conjunction is not safe");
                parser_errors++;
                return pair<CONJUNCTION,bool>(CONJUNCTION(),false);
                }
            }

        auxbody.addOrderedUnique(*lit2);
        }

    assert ( auxbody.begin() != auxbody.end() );

    for(CONJUNCTION::const_iterator lit1 = c1.begin();
        lit1 != c1.end();
        lit1++)
        {
        if( (*lit1).isRegularAtom() )
            {
            if( (*lit1).getParams() )
                {
                if(! (*lit1).isSaviour() )
                    {
                    // Add lit1 iff all of its variables are bound.
                    if( checkBinding(*lit1,c1,c2) )
                        auxbody.addOrderedUnique(*lit1);
                    else if(! c1.isSafe() )
                        {
                        // A safety error has occurred, anyway the
                        // error message is printed out later, when
                        // the safety check is performed upon the
                        // body of the rule/constraint containing lit1.
                        if(PTraceLevel >=1)
                            cdebug << "Safety violation; "
                                      "cannot build the body of aux rule"
                                   << endl;

                        parser_errors++;
                        return pair<CONJUNCTION,bool>(CONJUNCTION(),false);
                        }
                    }
                else
                    {
                    bool found = false;
 
                    // Add the literal either if there exists
                    // a literal of c1 to be saved by lit1...
                    for(CONJUNCTION::const_iterator i = c1.begin();
                        i != c1.end() && !found;
                        i++)
                        {
                        if( (*i).isRegularAtom()
                            && ! (*i).isSaviour()
                            && isPartiallyBoundBy(*i,*lit1) )
                            {
                            found = true;
                            auxbody.addOrderedUnique(*lit1);
                            }
                        }
 
                    // ...or if there is a binding with a literal of 
                    // the inner conjunction of the aggregate.
                    for(CONJUNCTION::const_iterator i = c2.begin();
                        i != c2.end() && !found;
                        i++)
                        {
                        // In the inner conjunction of the aggregate
                        // only regular atoms are allowed.
                        assert((*i).isRegularAtom());

                        if( isPartiallyBoundBy(*i,*lit1) )
                            {
                            found = true;
                            auxbody.addOrderedUnique(*lit1);
                            }
                        }
                    }
                }
            }
        }

    return pair<CONJUNCTION,bool>(auxbody,true);
    }

/////////////////////////////////////////////////////////////////////////////
/**For each aggregate into CONJUNCTION c of the form
 * #aggr_type( Vars : Conj(Free,Bound) )
 * is built a new auxiliary rule of the form
 * aux#conjunction2string(Vars,Bound) :- Body(Free,Bound,Const).
 *
 * The head of the auxiliary rule, i.e. auxAtom(Vars,Bound), replaces
 * the aggregate's conjunction into the current aggregate
 * #aggr_type( Vars : aux#conjunction2string(Vars,Bound) )
 *
 * Bound is the set of variables appearing in both c and the aggregate's 
 * conj.
 * Free is the set of variables appearing in the aggregate only.
 * Vars must be included in Free, this is checked when building auxAtom.
 *
 * The body of the auxiliary rule Body(Free,Bound,Const) is the union of the
 * literals (but aggregates) contained in c and the aggregate's conjunction.
 */
static void standardizeBody(CONJUNCTION &c)
//
// @param c is the body of the rule to be standardized.
// Side effects: if building auxiliary rule fails auxAtom doesn't replace
// the inner conjunction of the current aggregate. 
// Note: in the special case that the current aggregate conjunction contains
// only one atom to be aggregated over, and the body of the corresponding 
// auxiliary rule would only contain that literal in its body, no auxiliary
// rule is needed as the aggregate already is standardized.
//
    {
    if( PTraceLevel >= 1 )
        cdebug << "Body standardization" << endl;

    for(CONJUNCTION::const_iterator i = c.begin();
        i != c.end();
        i++)
        {
        if( (*i).isAggregate() )
            {
            // First check admissibility (variables must be "free").
            if( ! freeVarsToBeAggregatedOver((*i).getAggregate(),c) )
                {
                yyerror("Variables to be aggregated over must be free");
                parser_errors++;
                // Do not process this aggregate. Potentially there
                // are others, process them (even if the parsing will
                // eventually fail) to discover more errors.
                continue;
                }

            // Build the body of the auxiliary rule.
            CONJUNCTION aggrConj((*i).getAggregate().getConjunction());
            pair<CONJUNCTION,bool> result1 
                 = buildAuxRuleBody(c,aggrConj);

            // Upon success build the auxiliary rule and insert
            // the auxiliary atom into the aggregate.   
            if(result1.second)
                {
                bool buildAuxRule = true;

                // Don't build the auxiliary rule, if its body
                // consists of only one atom, the variables of which
                // are precisely the variables aggregated over.
                if( result1.first.size() == 1 )
                    {
                    // We will not build the aux. rule, unless projected
                    // variables are found.
                    buildAuxRule = false;

                    // There is no front() in CONJUNCTION.
                    const TERMS* auxTerms =
                        (*(result1.first.begin())).getParams();

                    if( auxTerms )
                        for( TERMS::const_iterator t = (*auxTerms).begin();
                             t != (*auxTerms).end();
                             t++ )
                            if( (*t).isVar() 
                                && !contains((*i).getAggregate().getFreeVars(),
                                         *t) )
                                buildAuxRule = true;
                    }

                if( ! buildAuxRule )
                    {
                    // We don't need to build the aux rule.
                    if( PTraceLevel >= 1 )
                        cdebug << "  Aggregate is already standardized, "
                                  "no need to build aux rule."
                               << endl;
                    }
                else
                    {
                    // Build auxAtom(Vars,Bound). 
                    ATOM auxAtom = 
                    buildAuxAtom( (*i).getAggregate(),c,result1.first );

                    // Build the auxiliary rule, add it to the IDB and
                    // insert the aux atom into the aggregate.

                    // Build the head of the auxiliary rule.
                    DISJUNCTION auxhead;
                    auxhead.add(auxAtom);

                    if( PTraceLevel >= 1 )      
                        cdebug << "  Adding aux rule "
                               << RULE(&auxhead,&result1.first)
                               << endl;

                    newRule( RULE(&auxhead,&result1.first) );


                    // Insert auxAtom into aggregate.
                    (*i).getAggregate().setAuxAtom(auxAtom);
                    }
                }
            else
                {
                if( PTraceLevel >= 1 )
                    cdebug <<"  Cannot build body of aux rule."
                           << endl ;
                }
            }
        }
    }

//////////////////////////////////////////////////////////////////////////////
// This helper function throws a parse Error whenever MaxInteger is not 
// specified:
void checkMaxintDefined()
    {
    if( MaxInteger == -1 )
        {
        yyerror("arithmetics is only supported if "
                "#maxint has been set");
        parser_errors++;
        }
    }
 
//////////////////////////////////////////////////////////////////////////////



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 1335 "parser.y"
typedef union YYSTYPE {
    char*          string;
    BUILTIN        builtin;
    TERMS*         terms;
    TERM*          term;
    ATOM*          atom;
    DISJUNCTION*   head;
    LITERAL*       literal;
    CONJUNCTION*   conjunction;
    AGGREGATE_TYPE*aggregate_type;
    AGGREGATEPRED* aggregate_pred;
    RULE*          rule;
    unsigned       integer;
    WEIGHTS*       weights;
    OIDindices*    oids;
    } YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1519 "parser.tmp"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1531 "parser.tmp"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   389

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  48
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  55
/* YYNRULES -- Number of rules. */
#define YYNRULES  133
/* YYNRULES -- Number of states. */
#define YYNSTATES  265

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   302

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    16,
      19,    21,    24,    26,    28,    30,    33,    34,    37,    38,
      45,    46,    49,    51,    53,    57,    59,    61,    63,    65,
      69,    71,    73,    88,    89,    94,    96,   100,   115,   128,
     130,   132,   134,   135,   138,   141,   144,   146,   149,   153,
     161,   165,   170,   171,   176,   181,   187,   189,   191,   193,
     195,   197,   201,   203,   206,   208,   212,   214,   218,   220,
     223,   225,   227,   230,   232,   237,   243,   245,   248,   250,
     254,   257,   260,   264,   268,   271,   274,   277,   283,   287,
     291,   295,   299,   303,   307,   311,   315,   319,   323,   327,
     333,   339,   345,   351,   353,   355,   357,   359,   361,   363,
     365,   367,   374,   376,   378,   380,   382,   384,   386,   388,
     392,   398,   406,   408,   410,   412,   414,   417,   419,   421,
     423,   425,   427,   429
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      53,     0,    -1,    16,    -1,    15,    -1,    10,    -1,     7,
      -1,     7,    -1,     7,    -1,    -1,    53,    54,    -1,     1,
      -1,    63,     6,    -1,    56,    -1,    61,    -1,    82,    -1,
      62,     8,    -1,    -1,    55,    61,    -1,    -1,    59,    58,
      57,    24,    55,    25,    -1,    -1,     9,    60,    -1,   100,
      -1,    59,    -1,    60,    52,    59,    -1,    72,    -1,    73,
      -1,    75,    -1,    76,    -1,    43,    14,    98,    -1,    64,
      -1,    67,    -1,    45,    20,     3,     7,    68,     7,    69,
       7,    70,     7,     3,    65,    21,     8,    -1,    -1,     7,
       3,     9,    66,    -1,     3,    -1,    66,     7,     3,    -1,
      46,    20,     3,     7,    68,     7,    69,     7,     3,     7,
       3,    71,    21,     8,    -1,    47,    20,     3,     7,    68,
       7,    69,     7,     3,    71,    21,     8,    -1,     3,    -1,
       3,    -1,     3,    -1,    -1,     7,     3,    -1,    74,     8,
      -1,    74,    11,    -1,    83,    -1,    83,    17,    -1,    83,
      17,    84,    -1,   100,    20,   101,     8,     8,   101,    21,
      -1,    17,    84,     8,    -1,    18,    84,     8,    77,    -1,
      -1,    22,     9,    79,    23,    -1,    22,    78,     9,    23,
      -1,    22,    78,     9,    79,    23,    -1,   100,    -1,    80,
      -1,   100,    -1,    81,    -1,    81,    -1,    81,     8,     4,
      -1,     4,    -1,    84,    44,    -1,    86,    -1,    83,    49,
      86,    -1,    85,    -1,    84,    50,    85,    -1,    86,    -1,
      41,    86,    -1,    89,    -1,    90,    -1,    41,    90,    -1,
      87,    -1,   100,    20,    88,    21,    -1,    42,   100,    20,
      88,    21,    -1,   100,    -1,    42,   100,    -1,    98,    -1,
      88,    51,    98,    -1,    91,    96,    -1,    14,    96,    -1,
      98,    91,    98,    -1,    99,    14,    98,    -1,    32,    95,
      -1,    33,    96,    -1,    92,    97,    -1,    99,    14,    98,
      92,    98,    -1,    62,    92,    98,    -1,    98,    28,    93,
      -1,    98,    30,    93,    -1,    99,    14,    93,    -1,    98,
      31,    93,    -1,    98,    29,    93,    -1,    93,    28,    98,
      -1,    93,    30,    98,    -1,    93,    14,    98,    -1,    93,
      31,    98,    -1,    93,    29,    98,    -1,    98,    28,    93,
      28,    98,    -1,    98,    28,    93,    30,    98,    -1,    98,
      30,    93,    28,    98,    -1,    98,    30,    93,    30,    98,
      -1,    26,    -1,    27,    -1,    28,    -1,    29,    -1,    30,
      -1,    31,    -1,    12,    -1,    13,    -1,    94,    24,    88,
       9,    84,    25,    -1,    34,    -1,    35,    -1,    36,    -1,
      37,    -1,    38,    -1,    39,    -1,    40,    -1,    20,    98,
      21,    -1,    20,    98,    51,    98,    21,    -1,    20,    98,
      51,    98,    51,    98,    21,    -1,   100,    -1,   101,    -1,
      19,    -1,   102,    -1,    42,    98,    -1,   100,    -1,   101,
      -1,    19,    -1,     3,    -1,    16,    -1,    81,    -1,    43,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1392,  1392,  1392,  1392,  1394,  1396,  1398,  1401,  1402,
    1403,  1406,  1407,  1408,  1409,  1410,  1442,  1443,  1448,  1446,
    1455,  1456,  1459,  1462,  1463,  1466,  1467,  1468,  1469,  1472,
    1478,  1479,  1482,  1512,  1516,  1528,  1531,  1539,  1562,  1588,
    1598,  1608,  1618,  1619,  1629,  1632,  1635,  1636,  1637,  1642,
    1679,  1685,  1693,  1699,  1707,  1715,  1726,  1730,  1735,  1739,
    1744,  1745,  1768,  1777,  1803,  1808,  1817,  1822,  1832,  1836,
    1841,  1846,  1850,  1857,  1858,  1864,  1872,  1876,  1882,  1888,
    1898,  1903,  1908,  1917,  1926,  1932,  1938,  1943,  1953,  1971,
    1979,  1987,  1993,  2000,  2009,  2016,  2023,  2029,  2036,  2045,
    2051,  2057,  2063,  2071,  2074,  2077,  2080,  2083,  2086,  2091,
    2095,  2101,  2110,  2114,  2118,  2122,  2126,  2130,  2134,  2140,
    2147,  2155,  2164,  2168,  2171,  2174,  2177,  2185,  2189,  2192,
    2197,  2208,  2215,  2231
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "NUM", "ERROR", "NEWLINE", "COMMA", 
  "DOT", "COLON", "SEMICOLON", "EXCLAMATION", "PLUS", "ASTERISK", 
  "EQUALS", "VERTICAL_BAR", "ID_OR_VEL", "CONS", "WEAK_CONS", "ANON_VAR", 
  "PARAM_OPEN", "PARAM_CLOSE", "BRACKET_OPEN", "BRACKET_CLOSE", 
  "CURLY_OPEN", "CURLY_CLOSE", "PRED_EQUAL", "PRED_UNEQUAL", "PRED_LESS", 
  "PRED_GREATER", "PRED_LESS_OR_EQ", "PRED_GREATER_OR_EQ", "PRED_INT", 
  "PRED_SUCC", "PRED_ANY", "PRED_AVG", "PRED_COUNT", "PRED_MAX", 
  "PRED_MIN", "PRED_SUM", "PRED_TIMES", "NOT", "TRUE_NOT", "MAXINTEGER", 
  "BOOL_QUERY", "META_IMPORT", "META_EXPORT", "META_QUERY_EXPORT", 
  "$accept", "HEAD_SEPARATOR", "TAIL_SEPARATOR", "PARAM_SEPARATOR", 
  "OBJECTID_SEPARATOR", "input", "line", "clauses", "object", "@1", 
  "inherit", "object_id", "object_ids", "clause", 
  "MAXINTEGER_EQUALS_term", "meta_rule", "import", "importTypes", 
  "importConversions", "export", "username", "password", "sql_select", 
  "exportReplace", "rule", "strictrule", "rule0", "constraint", 
  "wconstraint", "weights", "ident_or_fixedpt", "ident_or_number", 
  "fixedpt", "number", "query", "head", "body", "literal", "user_pred", 
  "propositional_atom", "terms", "builtin_pred", "aggregate", "binop", 
  "tertop", "aggregate_pred", "aggregate_type", "terms1", "terms2", 
  "terms3", "term", "term_sans_maxint", "ident", "number_param", 
  "maxinteger", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    48,    49,    49,    49,    50,    51,    52,    53,    53,
      53,    54,    54,    54,    54,    54,    55,    55,    57,    56,
      58,    58,    59,    60,    60,    61,    61,    61,    61,    62,
      63,    63,    64,    65,    65,    66,    66,    67,    67,    68,
      69,    70,    71,    71,    72,    73,    74,    74,    74,    74,
      75,    76,    77,    77,    77,    77,    78,    78,    79,    79,
      80,    80,    81,    82,    83,    83,    84,    84,    85,    85,
      85,    85,    85,    86,    86,    86,    87,    87,    88,    88,
      89,    89,    89,    89,    89,    89,    89,    89,    89,    90,
      90,    90,    90,    90,    90,    90,    90,    90,    90,    90,
      90,    90,    90,    91,    91,    91,    91,    91,    91,    92,
      92,    93,    94,    94,    94,    94,    94,    94,    94,    95,
      96,    97,    98,    98,    98,    98,    98,    99,    99,    99,
     100,   100,   101,   102
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     0,     2,
       1,     2,     1,     1,     1,     2,     0,     2,     0,     6,
       0,     2,     1,     1,     3,     1,     1,     1,     1,     3,
       1,     1,    14,     0,     4,     1,     3,    14,    12,     1,
       1,     1,     0,     2,     2,     2,     1,     2,     3,     7,
       3,     4,     0,     4,     4,     5,     1,     1,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     3,     1,     2,
       1,     1,     2,     1,     4,     5,     1,     2,     1,     3,
       2,     2,     3,     3,     2,     2,     2,     5,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       5,     5,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     6,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     7,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,    10,     0,     1,   130,    62,   109,   110,     0,   131,
       0,     0,   124,   103,   104,   105,   106,   107,   108,     0,
       0,   112,   113,   114,   115,   116,   117,   118,     0,     0,
     133,     0,     0,     0,     9,    12,    20,    13,     0,     0,
      30,    31,    25,    26,     0,    27,    28,   132,    14,    46,
       0,    66,    64,    73,    70,    71,     0,     0,     0,     0,
       0,     0,    76,   123,   125,     0,    81,     0,     0,    68,
     122,     0,     0,    84,    85,   133,    69,    72,     0,     0,
     124,     0,   126,    77,   123,     0,     0,     0,     0,     0,
      18,    15,     0,    11,    44,    45,     4,     3,     2,    47,
       0,     5,    63,     0,    80,     0,    86,     0,     0,     0,
       0,     0,     0,   105,   106,   107,   108,     0,     0,     0,
       0,   122,    50,     0,    52,     0,     0,     0,     0,     0,
       0,     0,    29,     0,     0,     0,    23,    21,    22,     0,
      88,    48,     0,    65,    76,    67,     0,    96,    94,    98,
      95,    97,     0,    78,    89,    93,    90,    92,    82,    91,
      83,     0,   123,     6,     0,     0,    51,   119,     0,     0,
       0,     0,     7,     0,    16,    77,     0,     0,     0,     0,
       0,     0,     0,     0,    74,     0,     0,     0,     0,    57,
      60,    56,    75,    39,     0,     0,     0,    24,     0,     0,
       0,    79,    99,   100,   101,   102,    87,     0,   120,     0,
      59,    58,     0,     0,     0,     0,     0,    19,    17,    64,
      76,     0,   111,     0,    53,    54,     0,    61,    40,     0,
       0,     0,     0,    49,    55,     0,     0,     0,   121,    41,
       0,     0,    42,     0,     0,     0,     0,    33,    42,    43,
       0,     0,     0,     0,    38,     0,     0,     0,     0,    32,
      37,    35,    34,     0,    36
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,   100,   103,   178,   173,     2,    34,   198,    35,   139,
      90,    36,   137,    37,    67,    39,    40,   252,   262,    41,
     194,   229,   240,   246,    42,    43,    44,    45,    46,   166,
     188,   209,   189,    47,    48,    49,    50,    51,    69,    53,
     161,    54,    55,    56,    57,    58,    59,    73,    66,   106,
      60,    61,   121,    84,    64
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -154
static const short yypact[] =
{
     235,  -154,   283,  -154,  -154,  -154,  -154,  -154,    29,  -154,
     328,   328,    30,  -154,  -154,  -154,  -154,  -154,  -154,    41,
      29,  -154,  -154,  -154,  -154,  -154,  -154,  -154,    35,    21,
      67,    68,    71,    75,  -154,  -154,    91,  -154,   147,   115,
    -154,  -154,  -154,  -154,    82,  -154,  -154,  -154,  -154,     4,
       6,  -154,     8,  -154,  -154,  -154,    29,    87,    17,   106,
     138,   119,   108,   131,  -154,    21,  -154,   103,   145,  -154,
      98,   183,    21,  -154,  -154,  -154,  -154,  -154,   158,   140,
    -154,    21,  -154,   153,  -154,    21,   171,   173,   175,    76,
    -154,  -154,    21,  -154,  -154,  -154,  -154,  -154,  -154,   328,
      13,  -154,  -154,   328,  -154,    21,  -154,    21,    21,    21,
      21,    21,    21,   206,   206,   206,   206,    21,   189,    21,
     154,  -154,  -154,    21,   177,   180,   206,   206,   206,   206,
     206,    21,  -154,   195,   197,   199,  -154,   202,  -154,   187,
    -154,   205,    76,  -154,   193,  -154,   154,  -154,  -154,  -154,
    -154,  -154,   101,  -154,    99,  -154,   113,  -154,  -154,  -154,
     103,    55,   208,  -154,    21,    80,  -154,  -154,    59,   211,
     211,   211,  -154,    76,  -154,   210,    21,   328,    21,    21,
      21,    21,    21,    21,  -154,   225,   213,   110,   228,  -154,
     242,  -154,  -154,  -154,   248,   249,   250,  -154,    40,   154,
      11,  -154,  -154,  -154,  -154,  -154,  -154,   254,  -154,   236,
    -154,  -154,    19,   275,   281,   281,   281,  -154,  -154,  -154,
     265,    21,  -154,   267,  -154,  -154,   266,  -154,  -154,   284,
     285,   286,   269,  -154,  -154,   291,   295,   300,  -154,  -154,
     297,   298,   299,   304,   305,   324,   312,   327,   299,  -154,
     329,   332,   315,   317,  -154,   330,   335,   337,   343,  -154,
    -154,  -154,   341,   346,  -154
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -154,  -154,  -154,  -113,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,   -88,  -154,   152,   349,  -154,  -154,  -154,  -154,  -154,
      24,   -18,  -154,   104,  -154,  -154,  -154,  -154,  -154,  -154,
    -154,   141,  -154,  -153,  -154,  -154,    -5,   273,     2,  -154,
     -71,  -154,   350,   319,   -35,   259,  -154,  -154,    -3,  -154,
      39,   352,    -2,     0,  -154
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -130
static const short yytable[] =
{
      62,   136,    63,    92,    52,    68,    71,   164,    70,    70,
      63,    63,   190,   101,    96,   -68,     4,    74,   101,    97,
      98,    99,     4,     5,     4,     5,    70,    83,    63,     9,
      76,   107,    92,   176,   210,     9,   222,     9,     4,     5,
      80,   152,   225,     4,  -129,   108,   109,   110,   111,    65,
     102,     9,   -68,   104,    12,   142,     9,    10,    11,   210,
     168,    72,   163,    81,    75,   217,   163,    78,    82,    21,
      22,    23,    24,    25,    26,    27,   184,    29,    75,     4,
     192,    85,   142,     4,     5,   197,   221,   138,    86,   187,
      94,    87,     9,    95,   141,    88,     9,    70,   144,    63,
      89,    70,   143,    63,   120,   -76,   -76,   105,   163,   -76,
     177,   125,  -127,     4,     5,     6,     7,   -22,   123,   162,
      82,    93,  -127,   -76,   132,   183,     9,   179,   119,   180,
     112,   140,   -22,   118,  -122,  -122,  -122,  -122,  -122,  -122,
     175,   181,   -76,   182,   146,  -128,   147,   148,   149,   150,
     151,   153,   101,   122,   130,    91,   158,   160,   153,     6,
       7,   163,   153,   191,    13,    14,   113,   114,   115,   116,
     153,   138,   200,   131,   133,    70,   134,    63,   135,  -122,
    -122,  -122,  -122,  -122,  -122,   211,   126,   127,   128,   129,
     101,   124,     4,     5,   195,   196,   220,   230,   231,   165,
     219,   167,   169,   186,   170,     9,   171,   223,    80,   172,
     211,   174,   101,   123,   193,   199,   185,   201,   202,   203,
     204,   205,   206,    21,    22,    23,    24,    25,    26,    27,
     131,    81,    75,   207,   208,    -8,     1,   212,    -8,    -8,
      21,    22,    23,    24,    25,    26,    27,    -8,    -8,    -8,
     213,    -8,    -8,    -8,    -8,   214,   215,   216,     5,   224,
     232,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,
      -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,    -8,   227,
      -8,    -8,    -8,     3,   228,   119,     4,     5,   233,   234,
     238,   235,   236,   237,   239,     6,     7,     8,   241,     9,
      10,    11,    12,   242,   243,   244,   245,   247,   248,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,   249,    31,    32,
      33,     4,     5,   250,   251,   255,   256,   254,   257,   258,
       6,     7,     8,   259,     9,   260,   261,    12,   263,   264,
     218,    38,   253,   226,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,   154,   155,   156,   157,   145,   159,    77,   117,
      79,     0,     0,     0,     0,   154,   155,   156,   157,   159
};

static const short yycheck[] =
{
       2,    89,     2,    38,     2,    10,    11,   120,    10,    11,
      10,    11,   165,     7,    10,     7,     3,    20,     7,    15,
      16,    17,     3,     4,     3,     4,    28,    29,    28,    16,
      28,    14,    67,   146,   187,    16,    25,    16,     3,     4,
      19,   112,    23,     3,    14,    28,    29,    30,    31,    20,
      44,    16,    44,    56,    19,    42,    16,    17,    18,   212,
     131,    20,     7,    42,    43,    25,     7,    28,    29,    34,
      35,    36,    37,    38,    39,    40,    21,    42,    43,     3,
      21,    14,    42,     3,     4,   173,   199,    89,    20,     9,
       8,    20,    16,    11,    99,    20,    16,    99,   100,    99,
       9,   103,   100,   103,    65,     7,     8,    20,     7,    11,
       9,    72,    14,     3,     4,    12,    13,     9,    20,   119,
      81,     6,    14,    25,    85,   160,    16,    28,    20,    30,
      24,    92,    24,    14,    26,    27,    28,    29,    30,    31,
     142,    28,    44,    30,   105,    14,   107,   108,   109,   110,
     111,   112,     7,     8,    14,     8,   117,   118,   119,    12,
      13,     7,   123,   165,    26,    27,    28,    29,    30,    31,
     131,   173,   177,    20,     3,   177,     3,   177,     3,    26,
      27,    28,    29,    30,    31,   187,    28,    29,    30,    31,
       7,     8,     3,     4,   170,   171,   198,   215,   216,    22,
     198,    21,     7,   164,     7,    16,     7,   207,    19,     7,
     212,    24,     7,    20,     3,   176,     8,   178,   179,   180,
     181,   182,   183,    34,    35,    36,    37,    38,    39,    40,
      20,    42,    43,     8,    21,     0,     1,     9,     3,     4,
      34,    35,    36,    37,    38,    39,    40,    12,    13,    14,
       8,    16,    17,    18,    19,     7,     7,     7,     4,    23,
     221,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,     4,
      45,    46,    47,     0,     3,    20,     3,     4,    21,    23,
      21,     7,     7,     7,     3,    12,    13,    14,     3,    16,
      17,    18,    19,     3,     7,     7,     7,     3,     3,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,     3,    45,    46,
      47,     3,     4,    21,     7,     3,    21,     8,    21,     9,
      12,    13,    14,     8,    16,     8,     3,    19,     7,     3,
     198,     2,   248,   212,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,   113,   114,   115,   116,   103,   118,    28,    60,
      28,    -1,    -1,    -1,    -1,   126,   127,   128,   129,   130
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    53,     0,     3,     4,    12,    13,    14,    16,
      17,    18,    19,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    45,    46,    47,    54,    56,    59,    61,    62,    63,
      64,    67,    72,    73,    74,    75,    76,    81,    82,    83,
      84,    85,    86,    87,    89,    90,    91,    92,    93,    94,
      98,    99,   100,   101,   102,    20,    96,    62,    84,    86,
     100,    84,    20,    95,    96,    43,    86,    90,    98,    99,
      19,    42,    98,   100,   101,    14,    20,    20,    20,     9,
      58,     8,    92,     6,     8,    11,    10,    15,    16,    17,
      49,     7,    44,    50,    96,    20,    97,    14,    28,    29,
      30,    31,    24,    28,    29,    30,    31,    91,    14,    20,
      98,   100,     8,    20,     8,    98,    28,    29,    30,    31,
      14,    20,    98,     3,     3,     3,    59,    60,   100,    57,
      98,    84,    42,    86,   100,    85,    98,    98,    98,    98,
      98,    98,    88,    98,    93,    93,    93,    93,    98,    93,
      98,    88,   101,     7,    51,    22,    77,    21,    88,     7,
       7,     7,     7,    52,    24,   100,    51,     9,    51,    28,
      30,    28,    30,    92,    21,     8,    98,     9,    78,    80,
      81,   100,    21,     3,    68,    68,    68,    59,    55,    98,
      84,    98,    98,    98,    98,    98,    98,     8,    21,    79,
      81,   100,     9,     8,     7,     7,     7,    25,    61,    86,
     100,    51,    25,   101,    23,    23,    79,     4,     3,    69,
      69,    69,    98,    21,    23,     7,     7,     7,    21,     3,
      70,     3,     3,     7,     7,     7,    71,     3,     3,     3,
      21,     7,    65,    71,     8,     3,    21,    21,     9,     8,
       8,     3,    66,     7,     3
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 10:
#line 1403 "parser.y"
    { parser_errors++; }
    break;

  case 15:
#line 1411 "parser.y"
    {
                                TERM* ident=yyvsp[-1].term;

                                if( MaxInteger == -1 )
                                    {
                                    if( ident->getType() == TERM::Integer )
                                        {
                                        MaxInteger=ident->getInt();

                                        if( MaxInteger < MaxIntegerSeen )
                                            {
                                            yyerror("#maxint must not be less "
                                                    "than the maximum integer "
                                                    "occurring in the input");
                                            parser_errors++;
                                            }
                                        }
                                    else
                                        {
                                        yyerror("syntax error in #maxint statement");
                                        parser_errors++;
                                        }

                                    delete ident;
                                    }
                                else
                                    yyerror("Cannot redefine #maxint. "
                                            "Ignoring this definition");
                              }
    break;

  case 18:
#line 1448 "parser.y"
    { newObjectID(yyvsp[-1].string,yyvsp[0].oids); }
    break;

  case 19:
#line 1452 "parser.y"
    { CurrentOID = 0; }
    break;

  case 20:
#line 1455 "parser.y"
    { yyval.oids = 0; }
    break;

  case 21:
#line 1456 "parser.y"
    { yyval.oids = yyvsp[0].oids; }
    break;

  case 22:
#line 1459 "parser.y"
    { yyval.string=yyvsp[0].string; }
    break;

  case 23:
#line 1462 "parser.y"
    { yyval.oids = newOIDindex(new OIDindices,yyvsp[0].string); }
    break;

  case 24:
#line 1463 "parser.y"
    { yyval.oids = newOIDindex(yyvsp[-2].oids,yyvsp[0].string); }
    break;

  case 25:
#line 1466 "parser.y"
    { newRule(*(yyvsp[0].rule)); delete yyvsp[0].rule; }
    break;

  case 26:
#line 1467 "parser.y"
    { newStrictRule(*(yyvsp[0].rule)); delete yyvsp[0].rule; }
    break;

  case 27:
#line 1468 "parser.y"
    { }
    break;

  case 28:
#line 1469 "parser.y"
    { }
    break;

  case 29:
#line 1473 "parser.y"
    {
                              yyval.term=yyvsp[0].term;
                              }
    break;

  case 32:
#line 1483 "parser.y"
    {
                                // Import EDB atoms from a relational database.
                                // This is the five-argument version of #import;
                                // The first argument contains a valid DNS, the
                                // second contains the name of the user, the
                                // third the password of the user, the
                                // fourth contains a select string and the fifth
                                // contains a predicate name, the sixth last contains
                                // the conversion.
                                // note: to pass a select string, the user has
                                // to enclose it in " ".

                                if( PTraceLevel >=1 )
                                    cdebug << "#import " << yyvsp[-11].string << " " << yyvsp[-9].string
                                           << " " << " " << yyvsp[-7].string << " "
                                           << yyvsp[-5].string <<  " " << yyvsp[-3].string << endl;

                                odbcAddImport( yyvsp[-11].string, yyvsp[-9].string, yyvsp[-7].string,
                                               yyvsp[-5].string, yyvsp[-3].string, yyvsp[-2].string );

                                delete[] yyvsp[-11].string;
                                delete[] yyvsp[-9].string;
                                delete[] yyvsp[-7].string;
                                delete[] yyvsp[-5].string;
                                delete[] yyvsp[-3].string;
                                delete[] yyvsp[-2].string;
                              }
    break;

  case 33:
#line 1512 "parser.y"
    {
                                yyval.string = new char[2];
                                strcpy(yyval.string,"");
                              }
    break;

  case 34:
#line 1517 "parser.y"
    {
                                if ( strcmp(yyvsp[-2].string,"type") )
                                    {
                                    yyerror("type definition must be start with keyword 'type'");
                                    parser_errors++;
                                    }

                                yyval.string = yyvsp[0].string;
                              }
    break;

  case 35:
#line 1528 "parser.y"
    {
                                yyval.string = yyvsp[0].string;
                              }
    break;

  case 36:
#line 1531 "parser.y"
    {
                                yyval.string = new char[strlen(yyvsp[-2].string)+strlen(yyvsp[0].string)+3];
                                sprintf(yyval.string, "%s, %s", yyvsp[-2].string, yyvsp[0].string);
                                delete[] yyvsp[-2].string;
                                delete[] yyvsp[0].string;
                              }
    break;

  case 37:
#line 1540 "parser.y"
    {

                                // This is the six-argument version of #export,
                                // the arguments being: a valid DNS, the name
                                // of the user, the password, the name of the
                                // predicate to export, the name of the table,
                                // and a delete condition.

                                if( PTraceLevel >=1 )
                                    cdebug << "#export " << yyvsp[-11].string << " " << yyvsp[-9].string
                                           << " " << " "<< yyvsp[-7].string << " " << yyvsp[-5].string <<  " "
                                           << yyvsp[-3].string << " " << yyvsp[-2].string << endl;
                                ODBC_Exports.push_back(
                                     ODBC_EXPORT(  yyvsp[-11].string, yyvsp[-9].string, yyvsp[-7].string,
                                                   yyvsp[-3].string, yyvsp[-5].string, yyvsp[-2].string ) );
                                delete[] yyvsp[-11].string;
                                delete[] yyvsp[-9].string;
                                delete[] yyvsp[-7].string;
                                delete[] yyvsp[-5].string;
                                delete[] yyvsp[-3].string;
                                delete[] yyvsp[-2].string;
                              }
    break;

  case 38:
#line 1563 "parser.y"
    {

                                // This is the five-argument version of #export,
                                // to export query results,
                                // the arguments being: a valid DNS, the name
                                // of the user, the password, 
                                // the name of the table,
                                // and a delete condition.

                                if( PTraceLevel >=1 )
                                    cdebug << "#exportQueryResult " << yyvsp[-9].string << " " << yyvsp[-7].string
                                           << " " << " "<< yyvsp[-5].string << " " << yyvsp[-3].string <<  " "
                                           << yyvsp[-2].string << endl;
                                ODBC_Exports.push_back(
                                     ODBC_EXPORT(  yyvsp[-9].string, yyvsp[-7].string, yyvsp[-5].string,
                                                   yyvsp[-3].string, "", yyvsp[-2].string ) );
                                delete[] yyvsp[-9].string;
                                delete[] yyvsp[-7].string;
                                delete[] yyvsp[-5].string;
                                delete[] yyvsp[-3].string;
                                delete[] yyvsp[-2].string;
                              }
    break;

  case 39:
#line 1588 "parser.y"
    {
                                if( ! checkAndRemoveQuotes(yyvsp[0].string) )
                                    {
                                    yyerror("user string must be enclosed by double quotes");
                                    parser_errors++;
                                    }
                                yyval.string = yyvsp[0].string;
                              }
    break;

  case 40:
#line 1598 "parser.y"
    {
                                if( ! checkAndRemoveQuotes(yyvsp[0].string) )
                                    {
                                    yyerror("password string must be enclosed by double quotes");
                                    parser_errors++;
                                    }
                                yyval.string = yyvsp[0].string;
                              }
    break;

  case 41:
#line 1608 "parser.y"
    {
                                if ( ! checkAndRemoveQuotes(yyvsp[0].string) )
                                    {
                                    yyerror("select string must be enclosed by double quotes");
                                    parser_errors++;
                                    }
                                yyval.string = yyvsp[0].string;
                              }
    break;

  case 42:
#line 1618 "parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string,""); }
    break;

  case 43:
#line 1619 "parser.y"
    {
                              if( !checkAndRemoveQuotes(yyvsp[0].string) )
                                  {
                                  yyerror("delete condition must be enclosed by double quotes");
                                  parser_errors++;
                                  }
                              yyval.string = yyvsp[0].string; 
                              }
    break;

  case 46:
#line 1635 "parser.y"
    { yyval.rule=new RULE(yyvsp[0].head, 0); delete yyvsp[0].head; }
    break;

  case 47:
#line 1636 "parser.y"
    { yyval.rule=new RULE(yyvsp[-1].head, 0); delete yyvsp[-1].head; }
    break;

  case 48:
#line 1637 "parser.y"
    { standardizeBody(*yyvsp[0].conjunction);
                                yyval.rule=new RULE(yyvsp[-2].head,yyvsp[0].conjunction); 
                                delete yyvsp[-2].head;
                                delete yyvsp[0].conjunction;
                              }
    break;

  case 49:
#line 1643 "parser.y"
    {
                                const TERM var(0U);
                                TERMS params;
                                params.push_back(var);

                                const ATOM headatom((yyvsp[-6].string),&params);
                                DISJUNCTION head;
                                head.add(headatom);
 
                                const ATOM *b1=newBuiltin(BuiltinInt,&params);
 
                                const TERMS *p2=newTERMS(&var,(yyvsp[-4].term));
                                const ATOM *b2=newBuiltin(BuiltinGreaterEqual,p2);
                                delete p2;
 
                                const TERMS *p3=newTERMS(&var,(yyvsp[-1].term));
                                const ATOM *b3=newBuiltin(BuiltinLessEqual,p3);
                                delete p3;
 
                                CONJUNCTION body;
                                body.add(*b1);
                                body.add(*b2);
                                body.add(*b3);
 
                                delete b1;
                                delete b2;
                                delete b3;
 
                                yyval.rule=new RULE(&head, &body);
 
                                delete[] yyvsp[-6].string;
                                delete yyvsp[-4].term;
                                delete yyvsp[-1].term;
                              }
    break;

  case 50:
#line 1679 "parser.y"
    { standardizeBody(*yyvsp[-1].conjunction);
                                newConstraint(*(yyvsp[-1].conjunction)); 
                                delete yyvsp[-1].conjunction; 
                              }
    break;

  case 51:
#line 1685 "parser.y"
    {
                                standardizeBody(*yyvsp[-2].conjunction);
                                newWeakConstraint(yyvsp[-2].conjunction,yyvsp[0].weights);
                                delete yyvsp[-2].conjunction;
                                delete yyvsp[0].weights;
                              }
    break;

  case 52:
#line 1693 "parser.y"
    {
                                if( checkWC(WCnone) )
                                    yyval.weights = new WEIGHTS(TERM(SCALEFACT,0), TERM(1,0));
                                else
                                    yyval.weights = 0;
			      }
    break;

  case 53:
#line 1699 "parser.y"
    {
                                if( checkWC(WClayer) )
                                    yyval.weights = new WEIGHTS(TERM(SCALEFACT,0),*(yyvsp[-1].term));
                                else
                                    yyval.weights = 0;

                                delete yyvsp[-1].term;
                              }
    break;

  case 54:
#line 1707 "parser.y"
    {
                                if( checkWC(WCweight) )
                                    yyval.weights = new WEIGHTS(*(yyvsp[-2].term), TERM(1,0));
                                else
                                    yyval.weights = 0;

                                delete yyvsp[-2].term;
                              }
    break;

  case 55:
#line 1715 "parser.y"
    {
                                if( checkWC(WCfull) )
                                    yyval.weights = new WEIGHTS(*(yyvsp[-3].term),*(yyvsp[-1].term));
                                else
                                    yyval.weights = 0;

                                delete yyvsp[-3].term;
                                delete yyvsp[-1].term;
                              }
    break;

  case 56:
#line 1726 "parser.y"
    {
                                yyval.term = newTERM(yyvsp[0].string);
                                delete[] yyvsp[0].string;
                              }
    break;

  case 57:
#line 1730 "parser.y"
    {
                                yyval.term = new TERM(yyvsp[0].integer,0);
                              }
    break;

  case 58:
#line 1735 "parser.y"
    {
                                yyval.term = newTERM(yyvsp[0].string);
                                delete[] yyvsp[0].string;
                              }
    break;

  case 59:
#line 1739 "parser.y"
    {
                                yyval.term = new TERM(yyvsp[0].integer,0);
                              }
    break;

  case 60:
#line 1744 "parser.y"
    { yyval.integer=(yyvsp[0].integer)*SCALEFACT; }
    break;

  case 61:
#line 1745 "parser.y"
    {
				char *err;
				static char buf[1024];
				unsigned s=strlen(yyvsp[0].string);
				if (s>SCALE)
				    {
				    yyerror("Number has more precision "
					    "than supported. Truncated");
				    strncpy(buf,(yyvsp[0].string),SCALE);
				    }
				else
				    {
				    strcpy(buf,(yyvsp[0].string));
				    memset(buf+s,'0',SCALE-s);
				    }
				buf[SCALE]='\0';
				yyval.integer=((yyvsp[-2].integer)*SCALEFACT)+strtoul(buf,&err,10);
				assert( *err == '\0' );

				delete[] yyvsp[0].string;
			      }
    break;

  case 62:
#line 1768 "parser.y"
    {
				char *err;
				yyval.integer=strtoul((yyvsp[0].string),&err,10);
				assert( *err == '\0' );

				delete[] yyvsp[0].string;
			      }
    break;

  case 63:
#line 1777 "parser.y"
    { 
                                if( Query )
                                    {
                                    cout << "Query " << *(yyvsp[-1].conjunction) << " replaces " 
                                         << *Query << "." << endl;
                                    delete Query; 
                                    }

                                if( ! yyvsp[-1].conjunction->isSafe() )
                                    {
                                    yyerror("Query is not safe");
                                    parser_errors++;
                                    }
                                else if( LocalVariables.getNumber() > n_par )
                                    {
                                    yyerror("Query contains too many variables");
                                    parser_errors++;
                                    }

                                Query=yyvsp[-1].conjunction;

                                LocalVariables.clear();
                              }
    break;

  case 64:
#line 1803 "parser.y"
    {
                                yyval.head=new DISJUNCTION;
                                yyval.head->add(*(yyvsp[0].atom)); 
                                delete yyvsp[0].atom;
                              }
    break;

  case 65:
#line 1809 "parser.y"
    {
                                yyvsp[-2].head->add(*(yyvsp[0].atom)); 
                                delete yyvsp[0].atom;
                                yyval.head=yyvsp[-2].head;
                              }
    break;

  case 66:
#line 1817 "parser.y"
    {
                                yyval.conjunction=new CONJUNCTION;
                                yyval.conjunction->add(*(yyvsp[0].literal)); 
                                delete yyvsp[0].literal;
                              }
    break;

  case 67:
#line 1823 "parser.y"
    {
                                yyvsp[-2].conjunction->addUnique(*(yyvsp[0].literal));
                                delete yyvsp[0].literal;
                                yyval.conjunction=yyvsp[-2].conjunction;
                              }
    break;

  case 68:
#line 1832 "parser.y"
    {
                                yyval.literal=new LITERAL(false,*(yyvsp[0].atom));
                                delete yyvsp[0].atom;
                              }
    break;

  case 69:
#line 1836 "parser.y"
    { 
                                yyval.literal=new LITERAL(true,*(yyvsp[0].atom));
                                delete yyvsp[0].atom;
                              }
    break;

  case 70:
#line 1841 "parser.y"
    { 
                                yyval.literal=new LITERAL(false,*(yyvsp[0].atom));
                                delete yyvsp[0].atom;
                              }
    break;

  case 71:
#line 1846 "parser.y"
    {
                                yyval.literal=new LITERAL(false,*(yyvsp[0].atom));
                                delete yyvsp[0].atom;
                              }
    break;

  case 72:
#line 1850 "parser.y"
    { 
                                yyval.literal=new LITERAL(true,*(yyvsp[0].atom));
                                delete yyvsp[0].atom;
                              }
    break;

  case 74:
#line 1859 "parser.y"
    {
                                yyval.atom = new ATOM(yyvsp[-3].string,yyvsp[-1].terms,PREDICATE_NAMES::typeUndef);
			        delete[] yyvsp[-3].string;
                                delete yyvsp[-1].terms;
                              }
    break;

  case 75:
#line 1865 "parser.y"
    {
                                yyval.atom=newNegativeATOM(yyvsp[-3].string,yyvsp[-1].terms);
				delete[] yyvsp[-3].string;
                                delete yyvsp[-1].terms;
                              }
    break;

  case 76:
#line 1872 "parser.y"
    {
                                yyval.atom = new ATOM(yyvsp[0].string,0,PREDICATE_NAMES::typeUndef);
				delete[] yyvsp[0].string;
                              }
    break;

  case 77:
#line 1876 "parser.y"
    {
                                yyval.atom=newNegativeATOM(yyvsp[0].string,0);
				delete[] yyvsp[0].string;
                              }
    break;

  case 78:
#line 1882 "parser.y"
    {
                                yyval.terms=new TERMS;

                                yyval.terms->push_back(*(yyvsp[0].term));
				delete yyvsp[0].term;
                              }
    break;

  case 79:
#line 1889 "parser.y"
    {
                                yyval.terms=yyvsp[-2].terms;

                                yyval.terms->push_back(*(yyvsp[0].term));
				delete yyvsp[0].term;
                              }
    break;

  case 80:
#line 1899 "parser.y"
    {
                                yyval.atom=newBuiltin(yyvsp[-1].builtin,yyvsp[0].terms); 
                                delete yyvsp[0].terms;
                              }
    break;

  case 81:
#line 1904 "parser.y"
    {
                                yyval.atom=newBuiltin(BuiltinEquality,yyvsp[0].terms);
                                delete yyvsp[0].terms;
                              }
    break;

  case 82:
#line 1909 "parser.y"
    {
                                TERMS* terms=newTERMS(yyvsp[-2].term,yyvsp[0].term);

                                yyval.atom=newBuiltin(yyvsp[-1].builtin,terms);
                                delete terms;
				delete yyvsp[-2].term;
				delete yyvsp[0].term;
                              }
    break;

  case 83:
#line 1918 "parser.y"
    {
                                TERMS *terms=newTERMS(yyvsp[-2].term,yyvsp[0].term);

                                yyval.atom=newBuiltin(BuiltinEquality,terms);
                                delete terms;
                                delete yyvsp[-2].term;
                                delete yyvsp[0].term;
                              }
    break;

  case 84:
#line 1927 "parser.y"
    {
                                checkMaxintDefined();
                                yyval.atom=newBuiltin(BuiltinInt,yyvsp[0].terms);
                                delete yyvsp[0].terms;
			      }
    break;

  case 85:
#line 1933 "parser.y"
    {
                                checkMaxintDefined();
			        yyval.atom=newBuiltin(BuiltinSucc,yyvsp[0].terms);
				delete yyvsp[0].terms;
			      }
    break;

  case 86:
#line 1939 "parser.y"
    {
			        yyval.atom=newBuiltin(yyvsp[-1].builtin,yyvsp[0].terms);
				delete yyvsp[0].terms;
			      }
    break;

  case 87:
#line 1944 "parser.y"
    {
                                TERMS* terms=newTERMS(yyvsp[-2].term,yyvsp[0].term,yyvsp[-4].term);

                                yyval.atom=newBuiltin(yyvsp[-1].builtin,terms);
                                delete terms;
                                delete yyvsp[-4].term;
                                delete yyvsp[-2].term;
                                delete yyvsp[0].term;
                              }
    break;

  case 88:
#line 1954 "parser.y"
    {
				if( MaxInteger == -1 )
				    {
				    yyerror("#maxint used but no upper "
					    "integer bound (option -N) given");
                                    parser_errors++;
				    }

                                TERM ident(MaxInteger,0);
                                TERMS *terms=newTERMS(yyvsp[-2].term,yyvsp[0].term,&ident);
                                yyval.atom=newBuiltin(yyvsp[-1].builtin,terms);
                                delete terms;
				delete yyvsp[-2].term;
				delete yyvsp[0].term;
			      }
    break;

  case 89:
#line 1971 "parser.y"
    {

                                yyval.atom=newAggregate(
                                       standardizeGuard(yyvsp[-2].term,false,true),
                                       standardizeGuard(new TERM(INT_MAX,0), 
                                           true,false),
                                       yyvsp[0].aggregate_pred );
                              }
    break;

  case 90:
#line 1979 "parser.y"
    {
                                yyval.atom=newAggregate(
                                       standardizeGuard(yyvsp[-2].term,true,true),
                                       standardizeGuard(new TERM(INT_MAX,0),
                                           true,false),
                                       yyvsp[0].aggregate_pred );
                              }
    break;

  case 91:
#line 1987 "parser.y"
    {
                                yyval.atom=newAggregate(
                                       standardizeGuard(yyvsp[-2].term,true,true),
                                       standardizeGuard(yyvsp[-2].term,true,false),
                                       yyvsp[0].aggregate_pred );
                              }
    break;

  case 92:
#line 1993 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(new TERM(0,0),
                                        true,true),
                                    standardizeGuard(yyvsp[-2].term,true,false),
                                    yyvsp[0].aggregate_pred );
                              }
    break;

  case 93:
#line 2000 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(new TERM(0,0),
                                        true,true),
                                    standardizeGuard(yyvsp[-2].term,false,false),
                                    yyvsp[0].aggregate_pred );
                              }
    break;

  case 94:
#line 2009 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(new TERM(0,0),
                                        true,true),
                                    standardizeGuard(yyvsp[0].term,false,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 95:
#line 2016 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(new TERM(0,0),
                                        true,true),
                                    standardizeGuard(yyvsp[0].term,true,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 96:
#line 2023 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[0].term,true,true),
                                    standardizeGuard(yyvsp[0].term,true,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 97:
#line 2029 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[0].term,true,true),
                                    standardizeGuard(new TERM(INT_MAX,0),
                                        true,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 98:
#line 2036 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[0].term,false,true),
                                    standardizeGuard(new TERM(INT_MAX,0),
                                        true,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 99:
#line 2045 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[-4].term,false,true),
                                    standardizeGuard(yyvsp[0].term,false,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 100:
#line 2051 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[-4].term,false,true),
                                    standardizeGuard(yyvsp[0].term,true,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 101:
#line 2057 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[-4].term,true,true),
                                    standardizeGuard(yyvsp[0].term,false,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 102:
#line 2063 "parser.y"
    {
                                yyval.atom=newAggregate(
                                    standardizeGuard(yyvsp[-4].term,true,true),
                                    standardizeGuard(yyvsp[0].term,true,false),
                                    yyvsp[-2].aggregate_pred );
                              }
    break;

  case 103:
#line 2071 "parser.y"
    {
				yyval.builtin=BuiltinEquality;
                              }
    break;

  case 104:
#line 2074 "parser.y"
    {
				yyval.builtin=BuiltinInequality;
                              }
    break;

  case 105:
#line 2077 "parser.y"
    {
				yyval.builtin=BuiltinLess;
                              }
    break;

  case 106:
#line 2080 "parser.y"
    {
				yyval.builtin=BuiltinGreater;
                              }
    break;

  case 107:
#line 2083 "parser.y"
    {
			        yyval.builtin=BuiltinLessEqual;
			      }
    break;

  case 108:
#line 2086 "parser.y"
    {
			        yyval.builtin=BuiltinGreaterEqual;
			      }
    break;

  case 109:
#line 2091 "parser.y"
    {
                                checkMaxintDefined();
			        yyval.builtin=BuiltinAddition;
                              }
    break;

  case 110:
#line 2095 "parser.y"
    {
                                checkMaxintDefined();
				yyval.builtin=BuiltinMultiplication;
                              }
    break;

  case 111:
#line 2102 "parser.y"
    { 
                                yyval.aggregate_pred = new AGGREGATEPRED(*yyvsp[-5].aggregate_type,*yyvsp[-3].terms,*yyvsp[-1].conjunction);
                                delete yyvsp[-5].aggregate_type;
                                delete yyvsp[-3].terms;
                                delete yyvsp[-1].conjunction;
                              }
    break;

  case 112:
#line 2111 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Any);
                              }
    break;

  case 113:
#line 2115 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Avg);
                              }
    break;

  case 114:
#line 2119 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Count);
                              }
    break;

  case 115:
#line 2123 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Max);
                              }
    break;

  case 116:
#line 2127 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Min);
                              }
    break;

  case 117:
#line 2131 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Sum);
                              }
    break;

  case 118:
#line 2135 "parser.y"
    {
                                yyval.aggregate_type=new AGGREGATE_TYPE(AGGREGATE_TYPE::Times);
                              }
    break;

  case 119:
#line 2141 "parser.y"
    {
                                yyval.terms=newTERMS(yyvsp[-1].term);
				delete yyvsp[-1].term;
                              }
    break;

  case 120:
#line 2148 "parser.y"
    {
                                yyval.terms=newTERMS(yyvsp[-3].term,yyvsp[-1].term);
				delete yyvsp[-3].term;
				delete yyvsp[-1].term;
                              }
    break;

  case 121:
#line 2156 "parser.y"
    {
                                yyval.terms=newTERMS(yyvsp[-5].term,yyvsp[-3].term,yyvsp[-1].term);
				delete yyvsp[-5].term;
				delete yyvsp[-3].term;
				delete yyvsp[-1].term;
                              }
    break;

  case 122:
#line 2164 "parser.y"
    {
				yyval.term=newTERM(yyvsp[0].string);
                                delete[] yyvsp[0].string;
			      }
    break;

  case 123:
#line 2168 "parser.y"
    {
                                yyval.term=yyvsp[0].term;
                              }
    break;

  case 124:
#line 2171 "parser.y"
    {
			        yyval.term=new TERM(LocalVariables.anonymous());
			      }
    break;

  case 125:
#line 2174 "parser.y"
    {
                                yyval.term=new TERM(MaxInteger,0);
                              }
    break;

  case 126:
#line 2177 "parser.y"
    {
                                yyerror("Cannot use true negation for terms");
                                parser_errors++;

                                yyval.term=yyvsp[0].term;
                              }
    break;

  case 127:
#line 2185 "parser.y"
    {
                                yyval.term=newTERM(yyvsp[0].string);
                                delete[] yyvsp[0].string;
                              }
    break;

  case 128:
#line 2189 "parser.y"
    {
                                yyval.term=yyvsp[0].term;
                              }
    break;

  case 129:
#line 2192 "parser.y"
    {
                                yyval.term=new TERM(LocalVariables.anonymous());
                              }
    break;

  case 130:
#line 2197 "parser.y"
    {
				yyval.string=yyvsp[0].string;
				if (strlen(yyval.string) > IDENT_LENGTH)
				    {
				    yyval.string[IDENT_LENGTH]=0;
				    yyerror("identifier too long, truncated "
					    "to " STRINGIFY(IDENT_LENGTH)
					    " characters");
                                    parser_errors++;
				    } 
			      }
    break;

  case 131:
#line 2208 "parser.y"
    {
				yyval.string=new char[2];
				yyval.string[0]='v';
				yyval.string[1]=0;
			      }
    break;

  case 132:
#line 2215 "parser.y"
    {
                                if( MaxInteger != -1  
                                    && static_cast<int>(yyvsp[0].integer) > MaxInteger )
                                    {
                                    yyerror("number outside of given "
                                            "integer range");
                                    parser_errors++;
                                    }

                                if( static_cast<int>(yyvsp[0].integer) > MaxIntegerSeen )
                                    MaxIntegerSeen=yyvsp[0].integer;

                                yyval.term=new TERM(yyvsp[0].integer,0);
                              }
    break;

  case 133:
#line 2231 "parser.y"
    {
                                if( MaxInteger == -1 )
                                    {
                                    yyerror("#maxint used but no upper "
                                            "integer bound (option -N) given");
                                    parser_errors++;

                                    MaxInteger=0;
                                    }
                              }
    break;


    }

/* Line 991 of yacc.c.  */
#line 3810 "parser.tmp"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 2243 "parser.y"


// Local Variables:
// mode: c++
// c-file-style: "dl"
// End:


