/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse planyyparse
#define yylex   planyylex
#define yyerror planyyerror
#define yylval  planyylval
#define yychar  planyychar
#define yydebug planyydebug
#define yynerrs planyynerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID = 258,
     NUM = 259,
     ERROR = 260,
     NEWLINE = 261,
     COMMA = 262,
     DOT = 263,
     COLON = 264,
     SEMICOLON = 265,
     PLUS = 266,
     ASTERISK = 267,
     EQUALS = 268,
     VERTICAL_BAR = 269,
     BOOL_QUERY = 270,
     CONS = 271,
     WEAK_CONS = 272,
     ANON_VAR = 273,
     PARAM_OPEN = 274,
     PARAM_CLOSE = 275,
     PRED_EQUAL = 276,
     PRED_UNEQUAL = 277,
     PRED_LESS = 278,
     PRED_GREATER = 279,
     PRED_LESS_OR_EQ = 280,
     PRED_GREATER_OR_EQ = 281,
     PRED_INT = 282,
     PRED_SUCC = 283,
     TRUE_NOT = 284,
     NOT = 285,
     MAXINTEGER = 286,
     CAUSED = 287,
     IF = 288,
     AFTER = 289,
     ACTION = 290,
     FLUENT = 291,
     NONEX = 292,
     EXEC = 293,
     FORBIDDEN = 294,
     INERTIAL = 295,
     DEFAULT = 296,
     ALWAYS = 297,
     REQUIRES = 298,
     COSTS = 299,
     WHERE = 300,
     NOCONC = 301,
     SECPLAN = 302,
     INITIALLY = 303,
     TOTAL = 304,
     GOAL = 305,
     CONST_FALSE = 306,
     TIMESTAMP = 307
   };
#endif
#define ID 258
#define NUM 259
#define ERROR 260
#define NEWLINE 261
#define COMMA 262
#define DOT 263
#define COLON 264
#define SEMICOLON 265
#define PLUS 266
#define ASTERISK 267
#define EQUALS 268
#define VERTICAL_BAR 269
#define BOOL_QUERY 270
#define CONS 271
#define WEAK_CONS 272
#define ANON_VAR 273
#define PARAM_OPEN 274
#define PARAM_CLOSE 275
#define PRED_EQUAL 276
#define PRED_UNEQUAL 277
#define PRED_LESS 278
#define PRED_GREATER 279
#define PRED_LESS_OR_EQ 280
#define PRED_GREATER_OR_EQ 281
#define PRED_INT 282
#define PRED_SUCC 283
#define TRUE_NOT 284
#define NOT 285
#define MAXINTEGER 286
#define CAUSED 287
#define IF 288
#define AFTER 289
#define ACTION 290
#define FLUENT 291
#define NONEX 292
#define EXEC 293
#define FORBIDDEN 294
#define INERTIAL 295
#define DEFAULT 296
#define ALWAYS 297
#define REQUIRES 298
#define COSTS 299
#define WHERE 300
#define NOCONC 301
#define SECPLAN 302
#define INITIALLY 303
#define TOTAL 304
#define GOAL 305
#define CONST_FALSE 306
#define TIMESTAMP 307




/* Copy the first part of user declarations.  */
#line 1 "plan_parser.y"

//////////////////////////////////////////////////////////////////////////////
// plan_parser.y

#include <string>
#include <stdio.h>
#include "plan.h"

#define STRINGIFY(X) STRINGIFY1(X)
#define STRINGIFY1(X) #X

static enum { ACT, FLU } declType = ACT;

// Variable init states whether we are in an "initially" block 
// or in an "always" block.
static bool init = false;

// Is the keyword "time" is allowed at the current state of the parser?
// So far "time" is only allowed for idents in the where-clause of
// an action declaration cost statement.
static bool timeAllowed = false;

//////////////////////////////////////////////////////////////////////////////
static void processRule(
//
// This procedure handles translation of all static and dynamic rules.
//
// When the guess-flag is set it generates a guessing rule instead of a normal
// rule is used to generate the guessing rules for "executable A if B".

    const KATOM *caused_Part,
    const KLITERALS *if_Part,  
    const KLITERALS *after_Part,
    bool guess = false ) 
    {

    if( !caused_Part && !if_Part && !after_Part)
        {
        yyerror("Empty rules not allowed");
        parser_errors++;
        }

    // Dynamic rules are not allowed under initial scope!
    if ( init && after_Part)
        {
        yyerror("No dynamic rules allowed in initial section");
        parser_errors++;
        }

    if( caused_Part )
        if ( guess  )
	     {
#ifndef NDEBUG
	     // This is checked when parsing the EXEC and TOTAL statement.
	     // To be cautious check again here.
	     if( ! ( (actions.find(caused_Part->getName())).second ||
		     (fluents.find(caused_Part->getName())).second ) )
                 {
                 parser_errors++;
                 }
#endif
	     }
        // normal caused - rule: Check whether the head is a
        // declared fluent:
        else if( ! (fluents.find(caused_Part->getName())).second ) 
            {
            yyerror("Only fluents can be caused");
            parser_errors++;
            }

    krules.push_back( KRULE(caused_Part, if_Part, after_Part, 
                                  init, 
                                  guess) );
    
    LocalVariables.clear();
    }
 
static void processDecl(KATOM *declared, KLITERALS *requires, 
                        char* costs = 0, KLITERALS *whereclause = 0)
    {
    
    // No costs allowed for fluents!
    if ( costs && declType == FLU)
        {
        yyerror("Costs not allowed for fluents");
        parser_errors++;
        }
    
    // Check whether only variables are used in fluent/action!!!    
    if(declared->getParams())
        {
        for(KPARAMS::const_iterator i = declared->getParams()->begin();
            i != declared->getParams()->end(); i++)
            {
            if( !isupper(*(i->begin())) )
                {
                yyerror("Only variables allowed in action/fluent declaration");
                parser_errors++;
                }
            }
        }


    // Check, that not already defined.
    // and add fluent/action-name to global variable actions/fluents
    if( (fluents.find(declared->getName())).second ||
        (actions.find(declared->getName())).second )
        {
        yyerror("Action/Fluent name already in use");
        parser_errors++;
        }

    pair<PREDICATE_NAMES::index_t,bool> r;

    switch(declType)
        {
        case ACT:
            r = actions.add( declared->getName(),
                             // Inc arity to take timestamp into account:
                             declared->getArity() + 1, 
                             PREDICATE_NAMES::typeIDB );

            if (declared->getArity() > maxActionArity)
                maxActionArity = declared->getArity();
            break;
        case FLU: 
            r = fluents.add( declared->getName(), 
                             // Inc arity to take timestamp into account:
                             declared->getArity() + 1, 
                             PREDICATE_NAMES::typeIDB );
            break; 
        default:
            assert(0);
        }
    if( ! r.second )
        {
        assert(0);
        }

    declarations.push_back( KRULE(declared, 
                                  requires, 
                                  whereclause,
                                  // This is mainly for the C Frontend,
                                  // where we have to create a initial guessing
                                  // rule for fluents and a guess for all 
                                  // states for actions, 
                                  // as no executable statements are used
                                  // in C.
                                  (OptionFrontend == FRONTEND_PLANNING_C && 
                                   declType == ACT)? false : true,
                                  true,
                                  true,
                                  costs) );
    // FIXME: do we still need this
    LocalVariables.clear();
    }
//////////////////////////////////////////////////////////////////////////////



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 163 "plan_parser.y"
typedef union YYSTYPE {
    char*         string;
    KPARAMS*      params;
    KATOM*        katom;
    ATOM*         atom;
    KLITERAL*     kliteral;
    KLITERALS*    kliterals;
    DISJUNCTION*  head;
    LITERAL*      literal;
    unsigned	  integer;
    pair<KLITERALS*, KLITERALS*>* ifafter;
    } YYSTYPE;
/* Line 191 of yacc.c.  */
#line 361 "plan_parser.tmp"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 373 "plan_parser.tmp"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   195

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  53
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  37
/* YYNRULES -- Number of rules. */
#define YYNRULES  89
/* YYNRULES -- Number of states. */
#define YYNSTATES  155

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   307

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     8,    11,    14,    15,    20,
      21,    26,    28,    31,    35,    36,    37,    46,    47,    50,
      51,    54,    56,    60,    62,    64,    66,    67,    72,    73,
      78,    82,    85,    89,    91,    93,    94,    97,   100,   105,
     109,   111,   115,   118,   123,   127,   131,   135,   138,   140,
     142,   144,   147,   149,   151,   153,   154,   156,   160,   162,
     165,   167,   173,   176,   178,   183,   189,   192,   195,   198,
     202,   205,   211,   213,   217,   221,   223,   225,   227,   229,
     231,   233,   239,   241,   243,   251,   253,   255,   257,   259
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      54,     0,    -1,    55,    -1,     1,    -1,    -1,    55,    56,
      -1,    55,    67,    -1,    -1,    35,    57,     9,    59,    -1,
      -1,    36,    58,     9,    59,    -1,    60,    -1,    59,    60,
      -1,    80,    63,     8,    -1,    -1,    -1,    80,    63,    44,
      65,    61,    64,    62,     8,    -1,    -1,    43,    77,    -1,
      -1,    45,    77,    -1,    66,    -1,    66,     9,    66,    -1,
      52,    -1,    75,    -1,    88,    -1,    -1,    48,    68,     9,
      70,    -1,    -1,    42,    69,     9,    70,    -1,    50,     9,
      79,    -1,    73,     8,    -1,    70,    73,     8,    -1,    80,
      -1,    51,    -1,    -1,    33,    77,    -1,    34,    77,    -1,
      33,    77,    34,    77,    -1,    32,    71,    72,    -1,    80,
      -1,    37,    77,    72,    -1,    39,    77,    -1,    39,    77,
      34,    77,    -1,    38,    80,    72,    -1,    40,    77,    72,
      -1,    49,    80,    72,    -1,    41,    77,    -1,    46,    -1,
      47,    -1,    88,    -1,    29,    88,    -1,    76,    -1,    31,
      -1,     4,    -1,    -1,    78,    -1,    77,     7,    78,    -1,
      80,    -1,    30,    80,    -1,    81,    -1,    77,    15,    19,
      76,    20,    -1,    77,    15,    -1,    74,    -1,    88,    19,
      82,    20,    -1,    29,    88,    19,    82,    20,    -1,    27,
      83,    -1,    28,    85,    -1,    84,    85,    -1,    89,    84,
      89,    -1,    86,    87,    -1,    89,    13,    89,    86,    89,
      -1,    89,    -1,    82,     7,    89,    -1,    19,    89,    20,
      -1,    21,    -1,    22,    -1,    23,    -1,    24,    -1,    25,
      -1,    26,    -1,    19,    89,     7,    89,    20,    -1,    11,
      -1,    12,    -1,    19,    89,     7,    89,     7,    89,    20,
      -1,     3,    -1,    88,    -1,    75,    -1,    18,    -1,    52,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   208,   208,   209,   212,   213,   214,   217,   217,   218,
     218,   221,   222,   225,   237,   237,   236,   253,   254,   257,
     258,   261,   267,   276,   281,   286,   299,   299,   300,   300,
     301,   304,   305,   308,   309,   313,   314,   318,   322,   328,
     334,   339,   381,   386,   392,   420,   472,   495,   529,   536,
     555,   560,   567,   577,   589,   601,   602,   615,   636,   640,
     650,   653,   681,   706,   707,   713,   721,   726,   731,   737,
     746,   752,   764,   771,   780,   787,   788,   789,   790,   791,
     792,   795,   803,   804,   807,   816,   830,   834,   839,   844
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "NUM", "ERROR", "NEWLINE", "COMMA", 
  "DOT", "COLON", "SEMICOLON", "PLUS", "ASTERISK", "EQUALS", 
  "VERTICAL_BAR", "BOOL_QUERY", "CONS", "WEAK_CONS", "ANON_VAR", 
  "PARAM_OPEN", "PARAM_CLOSE", "PRED_EQUAL", "PRED_UNEQUAL", "PRED_LESS", 
  "PRED_GREATER", "PRED_LESS_OR_EQ", "PRED_GREATER_OR_EQ", "PRED_INT", 
  "PRED_SUCC", "TRUE_NOT", "NOT", "MAXINTEGER", "CAUSED", "IF", "AFTER", 
  "ACTION", "FLUENT", "NONEX", "EXEC", "FORBIDDEN", "INERTIAL", "DEFAULT", 
  "ALWAYS", "REQUIRES", "COSTS", "WHERE", "NOCONC", "SECPLAN", 
  "INITIALLY", "TOTAL", "GOAL", "CONST_FALSE", "TIMESTAMP", "$accept", 
  "input", "kprogram", "decls", "@1", "@2", "decllist", "declaration", 
  "@3", "@4", "requiresclause", "whereclause", "weight", "weightpart", 
  "rules", "@5", "@6", "ruleslist", "head", "ifafter", "rule", 
  "propositional_atom", "integer", "number", "kliterals", "kliteral", 
  "query", "user_pred", "builtin_pred", "terms", "terms1", "binop", 
  "terms2", "tertop", "terms3", "ident", "term", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    53,    54,    54,    55,    55,    55,    57,    56,    58,
      56,    59,    59,    60,    61,    62,    60,    63,    63,    64,
      64,    65,    65,    66,    66,    66,    68,    67,    69,    67,
      67,    70,    70,    71,    71,    72,    72,    72,    72,    73,
      73,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      74,    74,    75,    75,    76,    77,    77,    77,    78,    78,
      78,    79,    79,    80,    80,    80,    81,    81,    81,    81,
      81,    81,    82,    82,    83,    84,    84,    84,    84,    84,
      84,    85,    86,    86,    87,    88,    89,    89,    89,    89
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     0,     2,     2,     0,     4,     0,
       4,     1,     2,     3,     0,     0,     8,     0,     2,     0,
       2,     1,     3,     1,     1,     1,     0,     4,     0,     4,
       3,     2,     3,     1,     1,     0,     2,     2,     4,     3,
       1,     3,     2,     4,     3,     3,     3,     2,     1,     1,
       1,     2,     1,     1,     1,     0,     1,     3,     1,     2,
       1,     5,     2,     1,     4,     5,     2,     2,     2,     3,
       2,     5,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     5,     1,     1,     7,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     3,     0,     2,     1,     7,     9,    28,    26,     0,
       5,     6,     0,     0,     0,     0,    55,     0,     0,     0,
       0,    85,    54,    82,    83,    88,    75,    76,    77,    78,
      79,    80,     0,     0,     0,     0,    53,    89,    63,    87,
      52,     0,    56,    30,    58,    60,     0,     0,    86,     0,
       8,    11,    17,    50,    10,     0,    55,     0,    55,    55,
      55,    48,    49,     0,    29,     0,    40,    27,     0,    66,
       0,    67,    51,    59,     0,    62,    68,     0,    70,     0,
       0,     0,    12,    55,     0,    34,    35,    33,    35,    35,
      42,    35,    47,    35,     0,    31,    86,     0,     0,     0,
      57,     0,     0,     0,    72,     0,    69,    18,    13,     0,
      55,    55,    39,    41,    44,    55,    45,    46,    32,    74,
       0,     0,     0,     0,     0,    64,     0,    23,    14,    21,
      24,    25,    36,    37,    43,     0,    65,    61,     0,    73,
      71,    19,     0,    55,    81,     0,    55,    15,    22,    38,
       0,    20,     0,    84,    16
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     2,     3,    10,    12,    13,    50,    51,   141,   152,
      84,   147,   128,   129,    11,    15,    14,    64,    86,   112,
      65,    38,    39,    40,    41,    42,    43,    44,    45,   103,
      69,    46,    71,    47,    78,    48,    49
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -82
static const short yypact[] =
{
       7,   -82,    11,    69,   -82,   -82,   -82,   -82,   -82,    15,
     -82,   -82,    64,    78,    80,    81,   123,    62,    62,   133,
     133,   -82,   -82,   -82,   -82,   -82,   -82,   -82,   -82,   -82,
     -82,   -82,    77,    79,    94,    62,   -82,   -82,   -82,   -82,
     -82,    73,   -82,   -82,   -82,   -82,    79,    89,   124,   163,
      62,   -82,    67,    93,    62,     1,   123,    62,   123,   123,
     123,   -82,   -82,    62,   133,   105,   -82,   133,    41,   -82,
      41,   -82,    95,   -82,   123,    96,   -82,    41,   -82,    41,
      41,    41,   -82,   123,    -3,   -82,    -7,   -82,    61,    -7,
      22,    61,   111,    -7,   114,   -82,   -82,   104,   148,    41,
     -82,   152,   153,    -1,   -82,    65,   -82,   111,   -82,    17,
     123,   123,   -82,   -82,   -82,   123,   -82,   -82,   -82,   -82,
      41,     2,   139,    41,    41,   -82,    41,   -82,   -82,   154,
     -82,   -82,    24,   111,   111,   141,   -82,   -82,   157,   -82,
     -82,   121,    17,   123,   -82,    41,   123,   -82,   -82,   111,
     147,   111,   161,   -82,   -82
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
     -82,   -82,   -82,   -82,   -82,   -82,   159,    20,   -82,   -82,
     -82,   -82,   -82,    36,   -82,   -82,   -82,   170,   -82,    49,
     -54,   -82,   -81,    82,   -44,   107,   -82,    66,   -82,    92,
     -82,   143,   149,    88,   -82,   -17,   -45
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -51
static const short yytable[] =
{
      53,    53,    53,    53,    21,   108,   124,    -4,     1,   124,
      94,     4,    88,    94,    90,    91,    92,    72,    53,   125,
      21,    22,   136,    97,    16,    98,   110,   111,   130,    74,
      34,    74,   102,    53,   104,   105,   106,    53,    53,   107,
      53,   109,    -4,    -4,    21,    22,    53,    53,    36,    -4,
      53,    96,    85,    96,   104,    -4,   115,    -4,   143,    25,
      96,   130,    96,    96,    96,    21,   132,   133,    74,   127,
      82,   134,    36,    17,    82,   135,    23,    24,   138,   139,
      74,   140,    96,    52,    52,    66,    66,    18,    75,    19,
      20,    34,   131,    37,   110,   111,    68,    21,    70,   149,
     150,    73,   151,    96,     5,     6,    96,    96,    77,    96,
      83,     7,    79,    95,    99,   101,    52,     8,    74,     9,
      52,    87,   118,    89,   119,   131,    21,    22,    96,    93,
      66,   -50,   -50,    66,    23,    24,    21,   113,   114,   -50,
     116,    25,   117,    79,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,   120,    22,   -50,   -50,   137,
     123,   144,    34,   142,   145,    55,   146,   153,   -50,   154,
      56,    57,    58,    59,    60,    37,    80,    54,   148,    61,
      62,   100,    63,   122,    26,    27,    28,    29,    30,    31,
      67,   121,    81,   126,     0,    76
};

static const short yycheck[] =
{
      17,    18,    19,    20,     3,     8,     7,     0,     1,     7,
      64,     0,    56,    67,    58,    59,    60,    34,    35,    20,
       3,     4,    20,    68,     9,    70,    33,    34,   109,     7,
      29,     7,    77,    50,    79,    80,    81,    54,    55,    83,
      57,    44,    35,    36,     3,     4,    63,    64,    31,    42,
      67,    68,    51,    70,    99,    48,    34,    50,    34,    18,
      77,   142,    79,    80,    81,     3,   110,   111,     7,    52,
      50,   115,    31,     9,    54,   120,    11,    12,   123,   124,
       7,   126,    99,    17,    18,    19,    20,     9,    15,     9,
       9,    29,   109,    52,    33,    34,    19,     3,    19,   143,
     145,    35,   146,   120,    35,    36,   123,   124,    19,   126,
      43,    42,    19,     8,    19,    19,    50,    48,     7,    50,
      54,    55,     8,    57,    20,   142,     3,     4,   145,    63,
      64,     7,     8,    67,    11,    12,     3,    88,    89,    15,
      91,    18,    93,    19,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,     7,     4,    33,    34,    20,
       7,    20,    29,     9,     7,    32,    45,    20,    44,     8,
      37,    38,    39,    40,    41,    52,    13,    18,   142,    46,
      47,    74,    49,   101,    21,    22,    23,    24,    25,    26,
      20,    99,    49,   105,    -1,    46
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    54,    55,     0,    35,    36,    42,    48,    50,
      56,    67,    57,    58,    69,    68,     9,     9,     9,     9,
       9,     3,     4,    11,    12,    18,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    52,    74,    75,
      76,    77,    78,    79,    80,    81,    84,    86,    88,    89,
      59,    60,    80,    88,    59,    32,    37,    38,    39,    40,
      41,    46,    47,    49,    70,    73,    80,    70,    19,    83,
      19,    85,    88,    80,     7,    15,    85,    19,    87,    19,
      13,    84,    60,    43,    63,    51,    71,    80,    77,    80,
      77,    77,    77,    80,    73,     8,    88,    89,    89,    19,
      78,    19,    89,    82,    89,    89,    89,    77,     8,    44,
      33,    34,    72,    72,    72,    34,    72,    72,     8,    20,
       7,    82,    76,     7,     7,    20,    86,    52,    65,    66,
      75,    88,    77,    77,    77,    89,    20,    20,    89,    89,
      89,    61,     9,    34,    20,     7,    45,    64,    66,    77,
      89,    77,    62,    20,     8
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 208 "plan_parser.y"
    {}
    break;

  case 3:
#line 209 "plan_parser.y"
    { parser_errors++; }
    break;

  case 7:
#line 217 "plan_parser.y"
    { declType = ACT; }
    break;

  case 8:
#line 217 "plan_parser.y"
    {}
    break;

  case 9:
#line 218 "plan_parser.y"
    { declType = FLU; }
    break;

  case 10:
#line 218 "plan_parser.y"
    {}
    break;

  case 11:
#line 221 "plan_parser.y"
    {}
    break;

  case 12:
#line 222 "plan_parser.y"
    {}
    break;

  case 13:
#line 226 "plan_parser.y"
    { 
                                    processDecl( yyvsp[-2].katom, yyvsp[-1].kliterals  );
                                    if( OptionFrontend == FRONTEND_PLANNING_C )
                                        {
                                        init = (declType==FLU)?true:false;
                                        processRule(yyvsp[-2].katom, yyvsp[-1].kliterals, 0, true);
                                        }
                                    delete yyvsp[-2].katom;
                                    delete yyvsp[-1].kliterals;
                                    }
    break;

  case 14:
#line 237 "plan_parser.y"
    { timeAllowed = true; }
    break;

  case 15:
#line 237 "plan_parser.y"
    { timeAllowed = false; }
    break;

  case 16:
#line 238 "plan_parser.y"
    { 
                                    if( OptionFrontend == FRONTEND_PLANNING_C )
                                        {
                                        yyerror("Costs not allowed in"
                                                "Planning Language C");
                                        parser_errors++;
                                        }
                                    processDecl( yyvsp[-7].katom, yyvsp[-6].kliterals, yyvsp[-4].string, yyvsp[-2].kliterals ); 
                                    delete yyvsp[-7].katom;
                                    delete yyvsp[-6].kliterals;
                                    delete[] yyvsp[-4].string;
                                    delete yyvsp[-2].kliterals;
                                    }
    break;

  case 17:
#line 253 "plan_parser.y"
    { yyval.kliterals = 0; }
    break;

  case 18:
#line 254 "plan_parser.y"
    { yyval.kliterals = yyvsp[0].kliterals; }
    break;

  case 19:
#line 257 "plan_parser.y"
    { yyval.kliterals = 0; }
    break;

  case 20:
#line 258 "plan_parser.y"
    { yyval.kliterals = yyvsp[0].kliterals; }
    break;

  case 21:
#line 262 "plan_parser.y"
    {
                 costsUsed = true;
                 yyval.string = new char[NUM_LENGTH+3];
                 sprintf(yyval.string,"%s:1",yyvsp[0].string);
                 }
    break;

  case 22:
#line 268 "plan_parser.y"
    { 
                 costsUsed = true;
                 costLevelsUsed = true;
                 yyval.string = new char[2*NUM_LENGTH+2];
                 sprintf(yyval.string,"%s:%s",yyvsp[-2].string,yyvsp[0].string);
                 }
    break;

  case 23:
#line 277 "plan_parser.y"
    { 
                 yyval.string = new char[strlen(VAR_T1)+1];
                 strcpy( yyval.string, VAR_T1 ); 
                 }
    break;

  case 24:
#line 282 "plan_parser.y"
    {
                 yyval.string = new char[NUM_LENGTH+1];
                 sprintf( yyval.string, "%d", yyvsp[0].integer ); 
                 }
    break;

  case 25:
#line 287 "plan_parser.y"
    {
                 // Non-integer constants are forbidden
                 if( !isupper(yyvsp[0].string[0]) )
                     {
                     yyerror( "Action costs or cost levels should be 'time', "
                              "a number, or a variable" );
                     parser_errors++;
                     }
                 yyval.string = yyvsp[0].string; 
                 }
    break;

  case 26:
#line 299 "plan_parser.y"
    { init = true;  }
    break;

  case 27:
#line 299 "plan_parser.y"
    {}
    break;

  case 28:
#line 300 "plan_parser.y"
    { init = false; }
    break;

  case 29:
#line 300 "plan_parser.y"
    {}
    break;

  case 30:
#line 301 "plan_parser.y"
    {}
    break;

  case 31:
#line 304 "plan_parser.y"
    {}
    break;

  case 32:
#line 305 "plan_parser.y"
    {}
    break;

  case 34:
#line 309 "plan_parser.y"
    { yyval.katom = 0; }
    break;

  case 35:
#line 313 "plan_parser.y"
    { yyval.ifafter = new pair<KLITERALS*, KLITERALS*>(0,0); }
    break;

  case 36:
#line 315 "plan_parser.y"
    {
                          yyval.ifafter = new pair<KLITERALS*, KLITERALS*>(yyvsp[0].kliterals,0);
                          }
    break;

  case 37:
#line 319 "plan_parser.y"
    { 
                          yyval.ifafter = new pair<KLITERALS*, KLITERALS*>(0,yyvsp[0].kliterals);
                          }
    break;

  case 38:
#line 323 "plan_parser.y"
    { 
                          yyval.ifafter = new pair<KLITERALS*, KLITERALS*>(yyvsp[-2].kliterals,yyvsp[0].kliterals); 
                          }
    break;

  case 39:
#line 329 "plan_parser.y"
    {
              processRule( yyvsp[-1].katom, yyvsp[0].ifafter->first, yyvsp[0].ifafter->second );
              delete yyvsp[-1].katom;
              delete yyvsp[0].ifafter;
              }
    break;

  case 40:
#line 335 "plan_parser.y"
    {
              processRule( yyvsp[0].katom, 0, 0 );
              delete yyvsp[0].katom;
              }
    break;

  case 41:
#line 340 "plan_parser.y"
    { // Concatenate kliterals and if-part,
                // after part not allowed!

              if(yyvsp[0].ifafter->second)
                  {
                  yyerror("No after part allowed in "
                          "nonexecutable statements");
                  parser_errors++;
                  }

              // Check whether first argument are only actions
              for( KLITERALS::const_iterator i = yyvsp[-1].kliterals->begin();
                   i != yyvsp[-1].kliterals->end(); i++)
                  if (i->isNegative())
                      {
                      yyerror("Negation as failure not allowed for A "
                              "in rule: nonexecutable A if B");
                      parser_errors++;
                      }
                  else if( ( ! (actions.find((*i).getName())).second) )
                      {
                      yyerror("Only actions allowed for A in rule: "
                              "nonexecutable A if B");
                      parser_errors++;
                      }

              KLITERALS *hkliterals = yyvsp[0].ifafter->first ? yyvsp[0].ifafter->first 
                                               : new KLITERALS();     

              for( KLITERALS::const_iterator i = yyvsp[-1].kliterals->begin(); 
                   i != yyvsp[-1].kliterals->end(); i++) 
                  {
                  hkliterals->push_back(*i);
                  }

              processRule( 0, 0, hkliterals );

              delete hkliterals;
              delete yyvsp[-1].kliterals;
              delete yyvsp[0].ifafter;
              }
    break;

  case 42:
#line 382 "plan_parser.y"
    {
              processRule( 0, yyvsp[0].kliterals, 0 );
              delete yyvsp[0].kliterals;      
              }
    break;

  case 43:
#line 387 "plan_parser.y"
    {
              processRule( 0, yyvsp[-2].kliterals, yyvsp[0].kliterals );
              delete yyvsp[-2].kliterals;      
              delete yyvsp[0].kliterals;      
              }
    break;

  case 44:
#line 393 "plan_parser.y"
    {
              if( OptionFrontend == FRONTEND_PLANNING_C )
                  {
                  yyerror("Executable not allowed in Frontend -FPc");
                  parser_errors++;
                  }
              else if( ( ! (actions.find(yyvsp[-1].katom->getName())).second) )
                  {
                  yyerror("Only actions allowed for A in rule: "
                          "executable A if B");
                  parser_errors++;
                  }
              
              if( yyvsp[0].ifafter->second )
                  {
                  yyerror("No after part allowed in "
                          "executable statements");
                  parser_errors++;
                  }

              bool hinit = init;
              init = false;
              processRule( yyvsp[-1].katom, yyvsp[0].ifafter->first, 0, true);
              init = hinit; 
              delete yyvsp[-1].katom;
              delete yyvsp[0].ifafter;
              }
    break;

  case 45:
#line 421 "plan_parser.y"
    {
              if(( yyvsp[0].ifafter->first || yyvsp[0].ifafter->second) 
                 && OptionFrontend == FRONTEND_PLANNING_C )
                  {
                  yyerror("inertial ... if... after ... not allowed "
                          "in Frontend -FPc");
                  parser_errors++;
                  }

              KLITERALS *if_part = yyvsp[0].ifafter->first?yyvsp[0].ifafter->first:new KLITERALS(), 
                        *after_part = yyvsp[0].ifafter->second?yyvsp[0].ifafter->second:new KLITERALS();

              for( KLITERALS::const_iterator i = yyvsp[-1].kliterals->begin();
                   i != yyvsp[-1].kliterals->end();
                   i++)
                  {
                  if (i->isNegative() )
                      {
                      yyerror("Negation as failure not allowed for A "
                              "in rule: inertial A if B after C");
                      parser_errors++;
                      }

                  
                  KLITERAL dneg_i(*i);
                  dneg_i.setNegative(true);
                  dneg_i.setTrueNegative(!dneg_i.isTrueNegative());

                  // For each kliteral i create a rule:
                  // caused i if not -.i after i.
                  // For FRONTEND_PLANNING_C:
                  // caused i if i after i.
                  
                  if ( OptionFrontend == FRONTEND_PLANNING_C )
                      {
                      if_part->push_back(*i);
                      }
                  else
                      {
                      if_part->push_back(dneg_i);
                      }
                  
                  after_part->push_back(*i);

                  processRule( i->getKatom(), if_part, after_part );
                  }
              delete if_part; 
              delete after_part;
              delete yyvsp[-1].kliterals;
              delete yyvsp[0].ifafter;
              }
    break;

  case 46:
#line 473 "plan_parser.y"
    {
              if( yyvsp[-1].katom->isTrueNegative() )
                  {
                  yyerror("True negation not allowed for A in rule: "
                          "total A if B after C");
                  parser_errors++;
                  }
              if( OptionFrontend == FRONTEND_PLANNING_C )
                  {
                  yyerror("Total not allowed in Frontend -FPc");
                  parser_errors++;
                  }
              else if( ( ! (fluents.find(yyvsp[-1].katom->getName())).second) )
                  {
                  yyerror("Only fluents allowed for A in rule: "
                          "total A if B");
                  parser_errors++;
                  }
              processRule( yyvsp[-1].katom, yyvsp[0].ifafter->first, yyvsp[0].ifafter->second, true);
              delete yyvsp[-1].katom;
              delete yyvsp[0].ifafter;
              }
    break;

  case 47:
#line 497 "plan_parser.y"
    {            
              for( KLITERALS::const_iterator i = yyvsp[0].kliterals->begin();
                   i != yyvsp[0].kliterals->end();
                   i++)
                  {
                  if (i->isNegative() )
                      {
                      yyerror("Negation as failure not allowed for A "
                              "in rule: default A");
                      parser_errors++;
                      }

                  // For each kliteral i create a rule:
                  // caused i if not -.i.
                  // For FRONTEND_PLANNING_C:
                  // caused i if i.
                  KLITERAL dneg_i(*i);
                  dneg_i.setTrueNegative(!dneg_i.isTrueNegative());
                  dneg_i.setNegative(!dneg_i.isNegative());
                  KLITERALS if_part;
                  if ( OptionFrontend == FRONTEND_PLANNING_C )
                      {
                      if_part.push_back(*i);
                      }
                  else
                      {
                      if_part.push_back(dneg_i);
                      }
                  processRule( i->getKatom(), &if_part, 0 );			  
                  } 
              delete yyvsp[0].kliterals;
              }
    break;

  case 48:
#line 530 "plan_parser.y"
    { 
              // Set maxActions to 1, if minActions/maxActions has not been
              // already set to a value > 0 by commandline.
              if(!minActions && !maxActions)
                  maxActions = 1;
              }
    break;

  case 49:
#line 537 "plan_parser.y"
    {
              // Disallow in frontend C
              if( OptionFrontend == FRONTEND_PLANNING_C )
                  {
                  yyerror("Secure Planning not allowed in Frontend -FPc");
                  parser_errors++;
                  }
               
              // Only switch to secure mode if optimistic mode has not
              // been requested explicitly.
              if( ! ( FPlan & FRONTEND_PLANNING_OPTIMISTIC ) )
                  {    
                  FPlan = static_cast<FPLAN>
                      (FPlan|FRONTEND_PLANNING_SECURE);
                  }
              }
    break;

  case 50:
#line 556 "plan_parser.y"
    {
             yyval.katom = new KATOM(false, yyvsp[0].string, 0);
             delete[] yyvsp[0].string;
             }
    break;

  case 51:
#line 561 "plan_parser.y"
    {
             yyval.katom = new KATOM(true, yyvsp[0].string, 0);
             delete[] yyvsp[0].string;
             }
    break;

  case 52:
#line 568 "plan_parser.y"
    {
             yyval.integer = yyvsp[0].integer;
             if( MaxInteger != -1  &&  (int)yyval.integer > MaxInteger )
                 {
                 yyerror("number outside of given "
                         "integer range");
                 parser_errors++;
                 }
             }
    break;

  case 53:
#line 578 "plan_parser.y"
    {
             if( MaxInteger == -1 )
                 {
                 yyerror("#maxint used but no upper "
                         "integer bound (option -N) given");
                 parser_errors++;
                 }
             yyval.integer = MaxInteger; 
             }
    break;

  case 54:
#line 590 "plan_parser.y"
    {
             char *err;
             yyval.integer = strtoul((yyvsp[0].string),&err,10);
             assert(*err==0);
             delete[] yyvsp[0].string;

             if( static_cast<int>(yyval.integer) > MaxIntegerSeen )
                 MaxIntegerSeen=yyval.integer;
             }
    break;

  case 55:
#line 601 "plan_parser.y"
    { yyval.kliterals=0; }
    break;

  case 56:
#line 603 "plan_parser.y"
    {                                  
             // "True" in the body is equal to an empty body
             if(yyvsp[0].kliteral) 
                 {
                 yyval.kliterals = new KLITERALS;
                 yyval.kliterals->push_back(*yyvsp[0].kliteral);
		    
                 delete yyvsp[0].kliteral;
                 }
             else
                 yyval.kliterals = 0;
             }
    break;

  case 57:
#line 616 "plan_parser.y"
    {
             // "True" in the body is equal to an empty body
             // theoretically the user could write something
             // caused X if true,true,true,Y.
             if( yyvsp[-2].kliterals )
                 yyval.kliterals = yyvsp[-2].kliterals;
             else if( yyvsp[0].kliteral )
                 yyval.kliterals = new KLITERALS;
             else 
                 yyval.kliterals = 0;

             if(yyvsp[0].kliteral) 
                 {
                 yyval.kliterals->push_back(*yyvsp[0].kliteral);
		    
                 delete yyvsp[0].kliteral;
                 }  
             }
    break;

  case 58:
#line 637 "plan_parser.y"
    {
             yyval.kliteral = new KLITERAL( false, *yyvsp[0].katom ); delete yyvsp[0].katom; 
             }
    break;

  case 59:
#line 641 "plan_parser.y"
    { 
             if ( OptionFrontend == FRONTEND_PLANNING_C ) 
                 { 
                 yyerror("Negation as failure not allowed in "
                         "Planning Language C");
                 parser_errors++;
                 }
             yyval.kliteral = new KLITERAL( true,  *yyvsp[0].katom ); delete yyvsp[0].katom; 
             }
    break;

  case 60:
#line 650 "plan_parser.y"
    { yyval.kliteral = new KLITERAL(false, *yyvsp[0].katom); delete yyvsp[0].katom; }
    break;

  case 61:
#line 654 "plan_parser.y"
    {
             if( Goal )
                 {
                 cerr << "Warning: goal: " << *(yyvsp[-4].kliterals) 
                      << "? ("
                      << ( maxPlanLength < 0 ? yyvsp[-1].integer 
                           : maxPlanLength )
                      << ") replaces goal: " 
                      << *Goal << "? (" 
                      << ( maxPlanLength < 0 ? 
                           ( maxPlanLengthParsed < 0 ? 
                             0 : maxPlanLengthParsed )
                           : maxPlanLength )
                      << ")" << endl;
                 delete Goal; 
                 }
             
             // Commandline option overrides query-argument,
             // so defaultValue 0 of maxPlanLengthParsed is
             // only changed if no maxPlanLength has been
             // given as a commandline option:
             if(maxPlanLength < 0)
                 maxPlanLengthParsed = yyvsp[-1].integer;


             Goal =  yyvsp[-4].kliterals;
             }
    break;

  case 62:
#line 682 "plan_parser.y"
    {
             if( Goal )
                 {
                 cerr << "Warning: goal: " << *(yyvsp[-1].kliterals) 
                      << "? ("
                      << ( maxPlanLength < 0 ? 0 : maxPlanLength ) 
                      << ") replaces goal:" 
                      << *Goal << "? (" 
                      << ( maxPlanLength < 0 ? 
                           ( maxPlanLengthParsed < 0 ? 
                             0 : maxPlanLengthParsed )
                           : maxPlanLength ) 
                      << ")" << endl;
                 delete Goal; 
                 }
             
             // Reset maxPlanLengthParsed:
             maxPlanLengthParsed = -1;
             
             Goal = yyvsp[-1].kliterals;
             }
    break;

  case 64:
#line 708 "plan_parser.y"
    {
             yyval.katom = new KATOM(false,yyvsp[-3].string,yyvsp[-1].params);
             delete[] yyvsp[-3].string;
             delete yyvsp[-1].params;
             }
    break;

  case 65:
#line 714 "plan_parser.y"
    {
             yyval.katom = new KATOM(true,yyvsp[-3].string,yyvsp[-1].params);
             delete[] yyvsp[-3].string;
             delete yyvsp[-1].params;
             }
    break;

  case 66:
#line 722 "plan_parser.y"
    {
                 yyval.katom = new KATOM(false, "#int", yyvsp[0].params);
                 delete yyvsp[0].params;
                 }
    break;

  case 67:
#line 727 "plan_parser.y"
    {
                 yyval.katom = new KATOM(false, "#succ",yyvsp[0].params);
                 delete yyvsp[0].params;
                 }
    break;

  case 68:
#line 732 "plan_parser.y"
    {
                 yyval.katom = new KATOM(false,yyvsp[-1].string,yyvsp[0].params); 
                 delete[] yyvsp[-1].string;
                 delete yyvsp[0].params;
                 }
    break;

  case 69:
#line 738 "plan_parser.y"
    {
                 KPARAMS terms(yyvsp[-2].string,yyvsp[0].string);
                 
                 yyval.katom = new KATOM(false,yyvsp[-1].string,&terms);
                 delete[] yyvsp[-2].string;
                 delete[] yyvsp[-1].string;                 
                 delete[] yyvsp[0].string;
                 }
    break;

  case 70:
#line 747 "plan_parser.y"
    {
                 yyval.katom = new KATOM(false,yyvsp[-1].string,yyvsp[0].params);
                 delete[] yyvsp[-1].string;
                 delete   yyvsp[0].params;
                 }
    break;

  case 71:
#line 753 "plan_parser.y"
    {
                 KPARAMS terms(yyvsp[-2].string,yyvsp[0].string,yyvsp[-4].string);
                 
                 yyval.katom = new KATOM(false,yyvsp[-1].string,&terms);
                 delete[] yyvsp[-4].string;
                 delete[] yyvsp[-2].string;
                 delete[] yyvsp[-1].string;
                 delete[] yyvsp[0].string;
                 }
    break;

  case 72:
#line 765 "plan_parser.y"
    {
             yyval.params = new KPARAMS;

             yyval.params->push_back(yyvsp[0].string);
             delete[] yyvsp[0].string;
             }
    break;

  case 73:
#line 772 "plan_parser.y"
    {
             yyval.params = yyvsp[-2].params;

             yyval.params->push_back(yyvsp[0].string);
             delete[] yyvsp[0].string;
             }
    break;

  case 74:
#line 781 "plan_parser.y"
    {
             yyval.params = new KPARAMS(yyvsp[-1].string);
             delete[] yyvsp[-1].string;
             }
    break;

  case 75:
#line 787 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string, "=="); }
    break;

  case 76:
#line 788 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string, "!="); }
    break;

  case 77:
#line 789 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string, "<" ); }
    break;

  case 78:
#line 790 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string, ">" ); }
    break;

  case 79:
#line 791 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string, "<="); }
    break;

  case 80:
#line 792 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string, ">="); }
    break;

  case 81:
#line 796 "plan_parser.y"
    {
             yyval.params = new KPARAMS(yyvsp[-3].string,yyvsp[-1].string);
             delete[] yyvsp[-3].string;
             delete[] yyvsp[-1].string;
             }
    break;

  case 82:
#line 803 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string,"+"); }
    break;

  case 83:
#line 804 "plan_parser.y"
    { yyval.string = new char[2]; strcpy(yyval.string,"*"); }
    break;

  case 84:
#line 808 "plan_parser.y"
    {
             yyval.params = new KPARAMS(yyvsp[-5].string,yyvsp[-3].string,yyvsp[-1].string);
             delete[] yyvsp[-5].string;
             delete[] yyvsp[-3].string;
             delete[] yyvsp[-1].string;
             }
    break;

  case 85:
#line 817 "plan_parser.y"
    {
             yyval.string = yyvsp[0].string;
             if (strlen(yyval.string) > IDENT_LENGTH)
                 {
                 yyval.string[IDENT_LENGTH]=0;
                 yyerror("identifier too long, truncated "
                         "to " STRINGIFY(IDENT_LENGTH)
                         " characters");
                 parser_errors++;
                 }
             }
    break;

  case 86:
#line 831 "plan_parser.y"
    {
             yyval.string = yyvsp[0].string;
             }
    break;

  case 87:
#line 835 "plan_parser.y"
    {
             yyval.string = new char[NUM_LENGTH+1];
             sprintf( yyval.string, "%d", yyvsp[0].integer );
             }
    break;

  case 88:
#line 840 "plan_parser.y"
    {
             yyval.string = new char[2];
             strcpy( yyval.string, "_" );
             }
    break;

  case 89:
#line 845 "plan_parser.y"
    { 
             if(!timeAllowed)
                 {
                 yyerror("Keyword 'time' not allowed here");
                 parser_errors++;
                 }
             yyval.string = new char[strlen(VAR_T1)+1];
             strcpy( yyval.string, VAR_T1 ); 
             }
    break;


    }

/* Line 991 of yacc.c.  */
#line 2270 "plan_parser.tmp"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 856 "plan_parser.y"


// Local Variables:
// mode: c++
// c-file-style: "dl"
// End:


