%{
/////////////////////////////////////////////////////////////////////////////
// plan_scanner.l
#include "plan.h"
#include "plan_parser.h"
#include <stdio.h>

 // We don't need unput, and it can yield a "defined but not used"-warning.
#define YY_NO_UNPUT
%}

BLANK       ([ \t]+)
NEWLINE     \15?\n
                       // some OSs use \r\n as end-of-line instead of \n

ID          ([A-Za-z][A-Za-z_0-9]*)
QUOTED_ID   (\"[^\"]+\")

NUM         ([0-9]+)

 // BUG-FIX: lex[AIX 4.1.4] defaults to too small a number of packed 
 //          character classes.
 // %kn 7000

%%
initially               { return INITIALLY; }
goal                    { return GOAL; }
caused			{ return CAUSED; }
if			{ return IF; }
after			{ return AFTER; }
actions			{ return ACTION; }
fluents                 { return FLUENT; }
nonexecutable		{ return NONEX; }
executable              { return EXEC; }
noConcurrency           { return NOCONC; }
securePlan              { return SECPLAN; }
inertial                { return INERTIAL; }
always                  { return ALWAYS; }
default                 { return DEFAULT; }
requires                { return REQUIRES; }
costs                   { return COSTS; }
where                   { return WHERE; }
total                   { return TOTAL; }
forbidden               { return FORBIDDEN; }
[fF]alse                { return CONST_FALSE; }
time                    { return TIMESTAMP; }

"not"                   |
"non"                   { return NOT; }


{NEWLINE}		{ parser_line++;	}

","			{ return COMMA;		}
"."			{ return DOT;		}
":"                     { return COLON;         }
"-"			|
"~"			{ return TRUE_NOT;	}
"+"			{ return PLUS;		}
"*"			{ return ASTERISK;	}
"="			{ return EQUALS;	}
"|"                     { return VERTICAL_BAR;  }

"("			{ return PARAM_OPEN;	}
")"			{ return PARAM_CLOSE;	}


"=="			{ return PRED_EQUAL;	}
"<>"			|
"!="			{ return PRED_UNEQUAL;		}
"<"			{ return PRED_LESS;		}
">"			{ return PRED_GREATER;		}
"<="			{ return PRED_LESS_OR_EQ;	}
">="			{ return PRED_GREATER_OR_EQ;	}

"?"                     { return BOOL_QUERY; }
        
#maxint			{ return MAXINTEGER;		}

#int			{ return PRED_INT;		}
#succ			{ return PRED_SUCC;		}


"_"			{ return ANON_VAR;	}

{ID} |
{QUOTED_ID}		{
			  planyylval.string=new char[strlen(planyytext)+1];
                          strcpy(planyylval.string,planyytext);
                          return ID;
			}

{NUM}			{ 
  			  if( strlen(planyytext) > NUM_LENGTH )
  			      {
  			      char s[1024];
 			      sprintf( s,
 			               "numeric constant %s is too long",
 			               planyytext );
  			      planyyerror(s);

                              parser_errors++; 
 			      return ERROR;
  			      }
			  else
			      {
			      planyylval.string=new char[strlen(planyytext)+1];
			      strcpy(planyylval.string,planyytext);
			      }

			  return NUM; 
			}

\%.*			{ /* Skip comments */   }


{BLANK}			{ /* Skip blanks */	}


.			{ // Anything not matching one of the patterns
			  // given above is considered an error.
			  char s[1024];
			  assert(planyytext[1]==0);
			  sprintf(s,"syntax error (%s)",planyytext); 
			  yyerror(s);
                          parser_errors++; 
                          return ERROR;
			}
%%

// Local Variables:
// mode: c++
// c-file-style: "dl"
// End:
