#!/bin/sh

# Usage: DLV.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/DLV-performance-`date +%y%m%d-%s`"

cd $TMPDIR

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

rm -Rf DLV
tar xzf $BASEDIR/DLV.tar.gz
( cd DLV
CODE=-O2 GCC=$GCCINSTALLDIR/bin/g++ /usr/bin/time -f "TIME: %U" $BASEDIR/../maxmem2.sh make 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./dl` 2>&1 | tee -a $LOGFILE
)

rm -Rf dlvbench
tar xzf $BASEDIR/dlvbench.tar.gz
( cd dlvbench
LD_LIBRARY_PATH=$GCCINSTALLDIR/lib64:$GCCINSTALLDIR/lib:$LD_LIBRARY_PATH
./run ../DLV/dl ) 2>&1 | tee -a $LOGFILE

cp $LOGFILE $LOGDIR/DLV-performance-latest
