#!/bin/sh

# Usage: boost.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/boost-performance-`date +%y%m%d-%s`"

cd $TMPDIR

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

rm -Rf boost_1_33_1
tar xzf $BASEDIR/boost_1_33_1.tar.gz
cd boost_1_33_1
patch -p0 < $BASEDIR/boost_1_33_1.patch
export LANG=C

# build bjam (boost 1.33.1)
( cd tools/build/jam_src
./build.sh
cp bin.*/bjam ../../../ )
# newer boost have
#( cd tools/jam
#/bin/sh build_dist.sh
#cp src/bin.*/bjam ../../ )
date 2>&1 | tee -a $LOGFILE

cd tools/wave/build
( /usr/bin/time -f "TIME: %U" ../../../bjam "-sGCC_ROOT_DIRECTORY=$GCCINSTALLDIR" "-sBUILD=release <runtime-link>dynamic <threading>single <debug-symbols>on" ) 2>&1 | tee -a $LOGFILE
cd ../../..
date 2>&1 | tee -a $LOGFILE

echo FILESIZE: `size ./bin/boost/tools/wave/build/wave/gcc/release/wave` 2>&1 | tee -a $LOGFILE

# searchdir and includes are hardcoded
args="-S $BASEDIR/usr/include -S $BASEDIR/usr/lib/gcc/i586-suse-linux/4.1.0/include -S $BASEDIR/usr/include/c++/4.1.0 -S $BASEDIR/usr/include/c++/4.1.0/i586-suse-linux"

env | tee -a $LOGFILE

# boost build system does not cope with 64bit library paths
export LD_LIBRARY_PATH=$GCCINSTALLDIR/lib64:$GCCINSTALLDIR/lib:$LD_LIBRARY_PATH
ldd ./bin/boost/tools/wave/build/wave/gcc/release/wave 2>&1 | tee -a $LOGFILE

echo ./bin/boost/tools/wave/build/wave/gcc/release/wave --timer --long_long --variadics $args $BASEDIR/tramp3d-v4.cpp -o /dev/null | tee -a $LOGFILE
echo "=============================" | tee -a $LOGFILE
$BASEDIR/../maxmem2.sh ./bin/boost/tools/wave/build/wave/gcc/release/wave --long_long --variadics $args $BASEDIR/tramp3d-v4.cpp -o /dev/null 2>&1 | tee -a $LOGFILE
./bin/boost/tools/wave/build/wave/gcc/release/wave --timer --long_long --variadics $args $BASEDIR/tramp3d-v4.cpp -o /dev/null | tee -a $LOGFILE

cp $LOGFILE $LOGDIR/boost-performance-latest
