#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="freefem-summary.txt"

echo -n "# DATE build-time build-mem ff3d-textsize " > $summary
cat $BASEDIR/tests >> $summary

for i in $LOGDIR/freefem-performance-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  cat $i | grep '^TIME:' | head -1 | sed -e 's/^[^0-9]*\([0-9][0-9\.]*\).*$/\1/' | tr '\n' ' ' >> $summary
  cat $i | grep '^total:\|FILESIZE:' | sort -r | sed -e 's/^[^0-9]*\([0-9][0-9\.]*\).*$/\1/' | tr '\n' ' ' >> $summary
  cat $i | grep '^TIME:' | sed -e '1d' | sed -e 's/^[^0-9]*\([0-9][0-9\.]*\).*$/\1/' | tr '\n' ' ' >> $summary
  echo >> $summary;
done

if test -f $BASEDIR/freefem-summary.gp-`hostname`; then
  gnuplot $BASEDIR/freefem-summary.gp-`hostname`
else
  gnuplot $BASEDIR/freefem-summary.gp
fi
