#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="libstdc++-summary.txt"

echo -n "# DATE " > $summary
for i in $LOGDIR/libstdc++-performance*; do
  cat $i | grep -v '^DATE-MARKER' | tr '\t' ' ' | cut -d ' ' -f 1 | tr '\n' ' ' >> $summary
  echo >> $summary
  break;
done
for i in $LOGDIR/libstdc++-performance*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  cat $i | sed -e '/[0-9]\+r.*[0-9]\+u.*[0-9]\+s/!d' | sed -e 's/^.*[^0-9]\([0-9]\+\)r.*\([0-9]\+\)u.*\([0-9]\+\)s.*\([0-9]\+\)mem.*\([0-9]\+\)pf.*$/\1 \4/' | tr '\n' ' ' | cat >> $summary
  echo >> $summary
done

# tests generated with:
#   cat libstdc++-performance-060227 | sed -e 's/^\([^[:space:]]*\)[[:space:]]*type: .*::\(.*\)_alloc\(.*\)$/\1-\2 \3/' | tr '\t' ' ' | cut -d ' ' -f 1

if test -f $BASEDIR/libstdc++-summary.gp-`hostname`; then
  gnuplot $BASEDIR/libstdc++-summary.gp-`hostname`
else
  gnuplot $BASEDIR/libstdc++-summary.gp
fi
