set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


# ../gen-gp.sh --title "Compile time memory usage in kB" --ylabel "kB" mico-summary.txt tests 1 3
set ylabel "kB"

set logscale y
set output "mico-summary.txt-1-0.png"
set title "Compile time memory usage in kB"
plot [:] [:] "mico-summary.txt"  u 1:2 title "address.cc" w lp, \
	"" u 1:5 title "any.cc" w lp, \
	"" u 1:8 title "basic_seq.cc" w lp, \
	"" u 1:11 title "buffer.cc" w lp, \
	"" u 1:14 title "codec.cc" w lp, \
	"" u 1:17 title "codeset.cc" w lp, \
	"" u 1:20 title "context.cc" w lp, \
	"" u 1:23 title "current.cc" w lp, \
	"" u 1:26 title "dii.cc" w lp, \
	"" u 1:29 title "dispatch.cc" w lp, \
	"" u 1:32 title "dsi.cc" w lp, \
	"" u 1:35 title "dynany.cc" w lp, \
	"" u 1:38 title "dynany_impl.cc" w lp, \
	"" u 1:41 title "except2.cc" w lp, \
	"" u 1:44 title "except.cc" w lp, \
	"" u 1:47 title "fast_array.cc" w lp, \
	"" u 1:50 title "fixed.cc" w lp, \
	"" u 1:53 title "imr.cc" w lp, \
	"" u 1:56 title "intercept.cc" w lp, \
	"" u 1:59 title "iop.cc" w lp, \
	"" u 1:62 title "ioptypes.cc" w lp, \
	"" u 1:65 title "ior.cc" w lp, \
	"" u 1:68 title "ir_base.cc" w lp, \
	"" u 1:71 title "ir.cc" w lp, \
	"" u 1:74 title "message.cc" w lp, \
	"" u 1:77 title "mtdebug.cc" w lp, \
	"" u 1:80 title "mt_dispatcher.cc" w lp, \
	"" u 1:83 title "mt_manager.cc" w lp, \
	"" u 1:86 title "object.cc" w lp, \
	"" u 1:89 title "operation.cc" w lp, \
	"" u 1:92 title "orb.cc" w lp, \
	"" u 1:95 title "orb_excepts.cc" w lp
set output "mico-summary.txt-1-1.png"
plot [:] [:] "mico-summary.txt"  u 1:98 title "os-thread.cc" w lp, \
	"" u 1:101 title "os-unix.cc" w lp, \
	"" u 1:104 title "pi.cc" w lp, \
	"" u 1:107 title "pi_impl.cc" w lp, \
	"" u 1:110 title "poa_base.cc" w lp, \
	"" u 1:113 title "poa.cc" w lp, \
	"" u 1:116 title "poa_impl.cc" w lp, \
	"" u 1:119 title "policy2.cc" w lp, \
	"" u 1:122 title "policy.cc" w lp, \
	"" u 1:125 title "policy_impl.cc" w lp, \
	"" u 1:128 title "queue.cc" w lp, \
	"" u 1:131 title "reflection.cc" w lp, \
	"" u 1:134 title "service_info.cc" w lp, \
	"" u 1:137 title "ssl.cc" w lp, \
	"" u 1:140 title "ssliop.cc" w lp, \
	"" u 1:143 title "static.cc" w lp, \
	"" u 1:146 title "string.cc" w lp, \
	"" u 1:149 title "tckind.cc" w lp, \
	"" u 1:152 title "timebase.cc" w lp, \
	"" u 1:155 title "transport.cc" w lp, \
	"" u 1:158 title "transport-tcp.cc" w lp, \
	"" u 1:161 title "transport-udp.cc" w lp, \
	"" u 1:164 title "transport-unix.cc" w lp, \
	"" u 1:167 title "typecode.cc" w lp, \
	"" u 1:170 title "typecode_seq.cc" w lp, \
	"" u 1:173 title "uni_base64.cc" w lp, \
	"" u 1:176 title "uni_fromuni.cc" w lp, \
	"" u 1:179 title "uni_touni.cc" w lp, \
	"" u 1:182 title "uni_unicode.cc" w lp, \
	"" u 1:185 title "util.cc" w lp, \
	"" u 1:188 title "value.cc" w lp, \
	"" u 1:191 title "valuetype.cc" w lp
set output "mico-summary.txt-1-2.png"
plot [:] [:] "mico-summary.txt"  u 1:194 title "valuetype_impl.cc" w lp
set nologscale

set output "mico-summary.txt-address.cc-2.png"
set title "Compile time memory usage in kB for address.cc"
plot [:] [:] "mico-summary.txt" u 1:2 title "address.cc" w lp
set output "mico-summary.txt-any.cc-5.png"
set title "Compile time memory usage in kB for any.cc"
plot [:] [:] "mico-summary.txt" u 1:5 title "any.cc" w lp
set output "mico-summary.txt-basic_seq.cc-8.png"
set title "Compile time memory usage in kB for basic_seq.cc"
plot [:] [:] "mico-summary.txt" u 1:8 title "basic_seq.cc" w lp
set output "mico-summary.txt-buffer.cc-11.png"
set title "Compile time memory usage in kB for buffer.cc"
plot [:] [:] "mico-summary.txt" u 1:11 title "buffer.cc" w lp
set output "mico-summary.txt-codec.cc-14.png"
set title "Compile time memory usage in kB for codec.cc"
plot [:] [:] "mico-summary.txt" u 1:14 title "codec.cc" w lp
set output "mico-summary.txt-codeset.cc-17.png"
set title "Compile time memory usage in kB for codeset.cc"
plot [:] [:] "mico-summary.txt" u 1:17 title "codeset.cc" w lp
set output "mico-summary.txt-context.cc-20.png"
set title "Compile time memory usage in kB for context.cc"
plot [:] [:] "mico-summary.txt" u 1:20 title "context.cc" w lp
set output "mico-summary.txt-current.cc-23.png"
set title "Compile time memory usage in kB for current.cc"
plot [:] [:] "mico-summary.txt" u 1:23 title "current.cc" w lp
set output "mico-summary.txt-dii.cc-26.png"
set title "Compile time memory usage in kB for dii.cc"
plot [:] [:] "mico-summary.txt" u 1:26 title "dii.cc" w lp
set output "mico-summary.txt-dispatch.cc-29.png"
set title "Compile time memory usage in kB for dispatch.cc"
plot [:] [:] "mico-summary.txt" u 1:29 title "dispatch.cc" w lp
set output "mico-summary.txt-dsi.cc-32.png"
set title "Compile time memory usage in kB for dsi.cc"
plot [:] [:] "mico-summary.txt" u 1:32 title "dsi.cc" w lp
set output "mico-summary.txt-dynany.cc-35.png"
set title "Compile time memory usage in kB for dynany.cc"
plot [:] [:] "mico-summary.txt" u 1:35 title "dynany.cc" w lp
set output "mico-summary.txt-dynany_impl.cc-38.png"
set title "Compile time memory usage in kB for dynany_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:38 title "dynany_impl.cc" w lp
set output "mico-summary.txt-except2.cc-41.png"
set title "Compile time memory usage in kB for except2.cc"
plot [:] [:] "mico-summary.txt" u 1:41 title "except2.cc" w lp
set output "mico-summary.txt-except.cc-44.png"
set title "Compile time memory usage in kB for except.cc"
plot [:] [:] "mico-summary.txt" u 1:44 title "except.cc" w lp
set output "mico-summary.txt-fast_array.cc-47.png"
set title "Compile time memory usage in kB for fast_array.cc"
plot [:] [:] "mico-summary.txt" u 1:47 title "fast_array.cc" w lp
set output "mico-summary.txt-fixed.cc-50.png"
set title "Compile time memory usage in kB for fixed.cc"
plot [:] [:] "mico-summary.txt" u 1:50 title "fixed.cc" w lp
set output "mico-summary.txt-imr.cc-53.png"
set title "Compile time memory usage in kB for imr.cc"
plot [:] [:] "mico-summary.txt" u 1:53 title "imr.cc" w lp
set output "mico-summary.txt-intercept.cc-56.png"
set title "Compile time memory usage in kB for intercept.cc"
plot [:] [:] "mico-summary.txt" u 1:56 title "intercept.cc" w lp
set output "mico-summary.txt-iop.cc-59.png"
set title "Compile time memory usage in kB for iop.cc"
plot [:] [:] "mico-summary.txt" u 1:59 title "iop.cc" w lp
set output "mico-summary.txt-ioptypes.cc-62.png"
set title "Compile time memory usage in kB for ioptypes.cc"
plot [:] [:] "mico-summary.txt" u 1:62 title "ioptypes.cc" w lp
set output "mico-summary.txt-ior.cc-65.png"
set title "Compile time memory usage in kB for ior.cc"
plot [:] [:] "mico-summary.txt" u 1:65 title "ior.cc" w lp
set output "mico-summary.txt-ir_base.cc-68.png"
set title "Compile time memory usage in kB for ir_base.cc"
plot [:] [:] "mico-summary.txt" u 1:68 title "ir_base.cc" w lp
set output "mico-summary.txt-ir.cc-71.png"
set title "Compile time memory usage in kB for ir.cc"
plot [:] [:] "mico-summary.txt" u 1:71 title "ir.cc" w lp
set output "mico-summary.txt-message.cc-74.png"
set title "Compile time memory usage in kB for message.cc"
plot [:] [:] "mico-summary.txt" u 1:74 title "message.cc" w lp
set output "mico-summary.txt-mtdebug.cc-77.png"
set title "Compile time memory usage in kB for mtdebug.cc"
plot [:] [:] "mico-summary.txt" u 1:77 title "mtdebug.cc" w lp
set output "mico-summary.txt-mt_dispatcher.cc-80.png"
set title "Compile time memory usage in kB for mt_dispatcher.cc"
plot [:] [:] "mico-summary.txt" u 1:80 title "mt_dispatcher.cc" w lp
set output "mico-summary.txt-mt_manager.cc-83.png"
set title "Compile time memory usage in kB for mt_manager.cc"
plot [:] [:] "mico-summary.txt" u 1:83 title "mt_manager.cc" w lp
set output "mico-summary.txt-object.cc-86.png"
set title "Compile time memory usage in kB for object.cc"
plot [:] [:] "mico-summary.txt" u 1:86 title "object.cc" w lp
set output "mico-summary.txt-operation.cc-89.png"
set title "Compile time memory usage in kB for operation.cc"
plot [:] [:] "mico-summary.txt" u 1:89 title "operation.cc" w lp
set output "mico-summary.txt-orb.cc-92.png"
set title "Compile time memory usage in kB for orb.cc"
plot [:] [:] "mico-summary.txt" u 1:92 title "orb.cc" w lp
set output "mico-summary.txt-orb_excepts.cc-95.png"
set title "Compile time memory usage in kB for orb_excepts.cc"
plot [:] [:] "mico-summary.txt" u 1:95 title "orb_excepts.cc" w lp
set output "mico-summary.txt-os-thread.cc-98.png"
set title "Compile time memory usage in kB for os-thread.cc"
plot [:] [:] "mico-summary.txt" u 1:98 title "os-thread.cc" w lp
set output "mico-summary.txt-os-unix.cc-101.png"
set title "Compile time memory usage in kB for os-unix.cc"
plot [:] [:] "mico-summary.txt" u 1:101 title "os-unix.cc" w lp
set output "mico-summary.txt-pi.cc-104.png"
set title "Compile time memory usage in kB for pi.cc"
plot [:] [:] "mico-summary.txt" u 1:104 title "pi.cc" w lp
set output "mico-summary.txt-pi_impl.cc-107.png"
set title "Compile time memory usage in kB for pi_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:107 title "pi_impl.cc" w lp
set output "mico-summary.txt-poa_base.cc-110.png"
set title "Compile time memory usage in kB for poa_base.cc"
plot [:] [:] "mico-summary.txt" u 1:110 title "poa_base.cc" w lp
set output "mico-summary.txt-poa.cc-113.png"
set title "Compile time memory usage in kB for poa.cc"
plot [:] [:] "mico-summary.txt" u 1:113 title "poa.cc" w lp
set output "mico-summary.txt-poa_impl.cc-116.png"
set title "Compile time memory usage in kB for poa_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:116 title "poa_impl.cc" w lp
set output "mico-summary.txt-policy2.cc-119.png"
set title "Compile time memory usage in kB for policy2.cc"
plot [:] [:] "mico-summary.txt" u 1:119 title "policy2.cc" w lp
set output "mico-summary.txt-policy.cc-122.png"
set title "Compile time memory usage in kB for policy.cc"
plot [:] [:] "mico-summary.txt" u 1:122 title "policy.cc" w lp
set output "mico-summary.txt-policy_impl.cc-125.png"
set title "Compile time memory usage in kB for policy_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:125 title "policy_impl.cc" w lp
set output "mico-summary.txt-queue.cc-128.png"
set title "Compile time memory usage in kB for queue.cc"
plot [:] [:] "mico-summary.txt" u 1:128 title "queue.cc" w lp
set output "mico-summary.txt-reflection.cc-131.png"
set title "Compile time memory usage in kB for reflection.cc"
plot [:] [:] "mico-summary.txt" u 1:131 title "reflection.cc" w lp
set output "mico-summary.txt-service_info.cc-134.png"
set title "Compile time memory usage in kB for service_info.cc"
plot [:] [:] "mico-summary.txt" u 1:134 title "service_info.cc" w lp
set output "mico-summary.txt-ssl.cc-137.png"
set title "Compile time memory usage in kB for ssl.cc"
plot [:] [:] "mico-summary.txt" u 1:137 title "ssl.cc" w lp
set output "mico-summary.txt-ssliop.cc-140.png"
set title "Compile time memory usage in kB for ssliop.cc"
plot [:] [:] "mico-summary.txt" u 1:140 title "ssliop.cc" w lp
set output "mico-summary.txt-static.cc-143.png"
set title "Compile time memory usage in kB for static.cc"
plot [:] [:] "mico-summary.txt" u 1:143 title "static.cc" w lp
set output "mico-summary.txt-string.cc-146.png"
set title "Compile time memory usage in kB for string.cc"
plot [:] [:] "mico-summary.txt" u 1:146 title "string.cc" w lp
set output "mico-summary.txt-tckind.cc-149.png"
set title "Compile time memory usage in kB for tckind.cc"
plot [:] [:] "mico-summary.txt" u 1:149 title "tckind.cc" w lp
set output "mico-summary.txt-timebase.cc-152.png"
set title "Compile time memory usage in kB for timebase.cc"
plot [:] [:] "mico-summary.txt" u 1:152 title "timebase.cc" w lp
set output "mico-summary.txt-transport.cc-155.png"
set title "Compile time memory usage in kB for transport.cc"
plot [:] [:] "mico-summary.txt" u 1:155 title "transport.cc" w lp
set output "mico-summary.txt-transport-tcp.cc-158.png"
set title "Compile time memory usage in kB for transport-tcp.cc"
plot [:] [:] "mico-summary.txt" u 1:158 title "transport-tcp.cc" w lp
set output "mico-summary.txt-transport-udp.cc-161.png"
set title "Compile time memory usage in kB for transport-udp.cc"
plot [:] [:] "mico-summary.txt" u 1:161 title "transport-udp.cc" w lp
set output "mico-summary.txt-transport-unix.cc-164.png"
set title "Compile time memory usage in kB for transport-unix.cc"
plot [:] [:] "mico-summary.txt" u 1:164 title "transport-unix.cc" w lp
set output "mico-summary.txt-typecode.cc-167.png"
set title "Compile time memory usage in kB for typecode.cc"
plot [:] [:] "mico-summary.txt" u 1:167 title "typecode.cc" w lp
set output "mico-summary.txt-typecode_seq.cc-170.png"
set title "Compile time memory usage in kB for typecode_seq.cc"
plot [:] [:] "mico-summary.txt" u 1:170 title "typecode_seq.cc" w lp
set output "mico-summary.txt-uni_base64.cc-173.png"
set title "Compile time memory usage in kB for uni_base64.cc"
plot [:] [:] "mico-summary.txt" u 1:173 title "uni_base64.cc" w lp
set output "mico-summary.txt-uni_fromuni.cc-176.png"
set title "Compile time memory usage in kB for uni_fromuni.cc"
plot [:] [:] "mico-summary.txt" u 1:176 title "uni_fromuni.cc" w lp
set output "mico-summary.txt-uni_touni.cc-179.png"
set title "Compile time memory usage in kB for uni_touni.cc"
plot [:] [:] "mico-summary.txt" u 1:179 title "uni_touni.cc" w lp
set output "mico-summary.txt-uni_unicode.cc-182.png"
set title "Compile time memory usage in kB for uni_unicode.cc"
plot [:] [:] "mico-summary.txt" u 1:182 title "uni_unicode.cc" w lp
set output "mico-summary.txt-util.cc-185.png"
set title "Compile time memory usage in kB for util.cc"
plot [:] [:] "mico-summary.txt" u 1:185 title "util.cc" w lp
set output "mico-summary.txt-value.cc-188.png"
set title "Compile time memory usage in kB for value.cc"
plot [:] [:] "mico-summary.txt" u 1:188 title "value.cc" w lp
set output "mico-summary.txt-valuetype.cc-191.png"
set title "Compile time memory usage in kB for valuetype.cc"
plot [:] [:] "mico-summary.txt" u 1:191 title "valuetype.cc" w lp
set output "mico-summary.txt-valuetype_impl.cc-194.png"
set title "Compile time memory usage in kB for valuetype_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:194 title "valuetype_impl.cc" w lp
set output


# ../gen-gp.sh --title "Compile time in s" --ylabel "s" mico-summary.txt tests 2 3
set ylabel "s"

set logscale y
set output "mico-summary.txt-2-0.png"
set title "Compile time in s"
plot [:] [:] "mico-summary.txt"  u 1:3 title "address.cc" w lp, \
	"" u 1:6 title "any.cc" w lp, \
	"" u 1:9 title "basic_seq.cc" w lp, \
	"" u 1:12 title "buffer.cc" w lp, \
	"" u 1:15 title "codec.cc" w lp, \
	"" u 1:18 title "codeset.cc" w lp, \
	"" u 1:21 title "context.cc" w lp, \
	"" u 1:24 title "current.cc" w lp, \
	"" u 1:27 title "dii.cc" w lp, \
	"" u 1:30 title "dispatch.cc" w lp, \
	"" u 1:33 title "dsi.cc" w lp, \
	"" u 1:36 title "dynany.cc" w lp, \
	"" u 1:39 title "dynany_impl.cc" w lp, \
	"" u 1:42 title "except2.cc" w lp, \
	"" u 1:45 title "except.cc" w lp, \
	"" u 1:48 title "fast_array.cc" w lp, \
	"" u 1:51 title "fixed.cc" w lp, \
	"" u 1:54 title "imr.cc" w lp, \
	"" u 1:57 title "intercept.cc" w lp, \
	"" u 1:60 title "iop.cc" w lp, \
	"" u 1:63 title "ioptypes.cc" w lp, \
	"" u 1:66 title "ior.cc" w lp, \
	"" u 1:69 title "ir_base.cc" w lp, \
	"" u 1:72 title "ir.cc" w lp, \
	"" u 1:75 title "message.cc" w lp, \
	"" u 1:78 title "mtdebug.cc" w lp, \
	"" u 1:81 title "mt_dispatcher.cc" w lp, \
	"" u 1:84 title "mt_manager.cc" w lp, \
	"" u 1:87 title "object.cc" w lp, \
	"" u 1:90 title "operation.cc" w lp, \
	"" u 1:93 title "orb.cc" w lp, \
	"" u 1:96 title "orb_excepts.cc" w lp
set output "mico-summary.txt-2-1.png"
plot [:] [:] "mico-summary.txt"  u 1:99 title "os-thread.cc" w lp, \
	"" u 1:102 title "os-unix.cc" w lp, \
	"" u 1:105 title "pi.cc" w lp, \
	"" u 1:108 title "pi_impl.cc" w lp, \
	"" u 1:111 title "poa_base.cc" w lp, \
	"" u 1:114 title "poa.cc" w lp, \
	"" u 1:117 title "poa_impl.cc" w lp, \
	"" u 1:120 title "policy2.cc" w lp, \
	"" u 1:123 title "policy.cc" w lp, \
	"" u 1:126 title "policy_impl.cc" w lp, \
	"" u 1:129 title "queue.cc" w lp, \
	"" u 1:132 title "reflection.cc" w lp, \
	"" u 1:135 title "service_info.cc" w lp, \
	"" u 1:138 title "ssl.cc" w lp, \
	"" u 1:141 title "ssliop.cc" w lp, \
	"" u 1:144 title "static.cc" w lp, \
	"" u 1:147 title "string.cc" w lp, \
	"" u 1:150 title "tckind.cc" w lp, \
	"" u 1:153 title "timebase.cc" w lp, \
	"" u 1:156 title "transport.cc" w lp, \
	"" u 1:159 title "transport-tcp.cc" w lp, \
	"" u 1:162 title "transport-udp.cc" w lp, \
	"" u 1:165 title "transport-unix.cc" w lp, \
	"" u 1:168 title "typecode.cc" w lp, \
	"" u 1:171 title "typecode_seq.cc" w lp, \
	"" u 1:174 title "uni_base64.cc" w lp, \
	"" u 1:177 title "uni_fromuni.cc" w lp, \
	"" u 1:180 title "uni_touni.cc" w lp, \
	"" u 1:183 title "uni_unicode.cc" w lp, \
	"" u 1:186 title "util.cc" w lp, \
	"" u 1:189 title "value.cc" w lp, \
	"" u 1:192 title "valuetype.cc" w lp
set output "mico-summary.txt-2-2.png"
plot [:] [:] "mico-summary.txt"  u 1:195 title "valuetype_impl.cc" w lp
set nologscale

set output "mico-summary.txt-address.cc-3.png"
set title "Compile time in s for address.cc"
plot [:] [:] "mico-summary.txt" u 1:3 title "address.cc" w lp
set output "mico-summary.txt-any.cc-6.png"
set title "Compile time in s for any.cc"
plot [:] [:] "mico-summary.txt" u 1:6 title "any.cc" w lp
set output "mico-summary.txt-basic_seq.cc-9.png"
set title "Compile time in s for basic_seq.cc"
plot [:] [:] "mico-summary.txt" u 1:9 title "basic_seq.cc" w lp
set output "mico-summary.txt-buffer.cc-12.png"
set title "Compile time in s for buffer.cc"
plot [:] [:] "mico-summary.txt" u 1:12 title "buffer.cc" w lp
set output "mico-summary.txt-codec.cc-15.png"
set title "Compile time in s for codec.cc"
plot [:] [:] "mico-summary.txt" u 1:15 title "codec.cc" w lp
set output "mico-summary.txt-codeset.cc-18.png"
set title "Compile time in s for codeset.cc"
plot [:] [:] "mico-summary.txt" u 1:18 title "codeset.cc" w lp
set output "mico-summary.txt-context.cc-21.png"
set title "Compile time in s for context.cc"
plot [:] [:] "mico-summary.txt" u 1:21 title "context.cc" w lp
set output "mico-summary.txt-current.cc-24.png"
set title "Compile time in s for current.cc"
plot [:] [:] "mico-summary.txt" u 1:24 title "current.cc" w lp
set output "mico-summary.txt-dii.cc-27.png"
set title "Compile time in s for dii.cc"
plot [:] [:] "mico-summary.txt" u 1:27 title "dii.cc" w lp
set output "mico-summary.txt-dispatch.cc-30.png"
set title "Compile time in s for dispatch.cc"
plot [:] [:] "mico-summary.txt" u 1:30 title "dispatch.cc" w lp
set output "mico-summary.txt-dsi.cc-33.png"
set title "Compile time in s for dsi.cc"
plot [:] [:] "mico-summary.txt" u 1:33 title "dsi.cc" w lp
set output "mico-summary.txt-dynany.cc-36.png"
set title "Compile time in s for dynany.cc"
plot [:] [:] "mico-summary.txt" u 1:36 title "dynany.cc" w lp
set output "mico-summary.txt-dynany_impl.cc-39.png"
set title "Compile time in s for dynany_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:39 title "dynany_impl.cc" w lp
set output "mico-summary.txt-except2.cc-42.png"
set title "Compile time in s for except2.cc"
plot [:] [:] "mico-summary.txt" u 1:42 title "except2.cc" w lp
set output "mico-summary.txt-except.cc-45.png"
set title "Compile time in s for except.cc"
plot [:] [:] "mico-summary.txt" u 1:45 title "except.cc" w lp
set output "mico-summary.txt-fast_array.cc-48.png"
set title "Compile time in s for fast_array.cc"
plot [:] [:] "mico-summary.txt" u 1:48 title "fast_array.cc" w lp
set output "mico-summary.txt-fixed.cc-51.png"
set title "Compile time in s for fixed.cc"
plot [:] [:] "mico-summary.txt" u 1:51 title "fixed.cc" w lp
set output "mico-summary.txt-imr.cc-54.png"
set title "Compile time in s for imr.cc"
plot [:] [:] "mico-summary.txt" u 1:54 title "imr.cc" w lp
set output "mico-summary.txt-intercept.cc-57.png"
set title "Compile time in s for intercept.cc"
plot [:] [:] "mico-summary.txt" u 1:57 title "intercept.cc" w lp
set output "mico-summary.txt-iop.cc-60.png"
set title "Compile time in s for iop.cc"
plot [:] [:] "mico-summary.txt" u 1:60 title "iop.cc" w lp
set output "mico-summary.txt-ioptypes.cc-63.png"
set title "Compile time in s for ioptypes.cc"
plot [:] [:] "mico-summary.txt" u 1:63 title "ioptypes.cc" w lp
set output "mico-summary.txt-ior.cc-66.png"
set title "Compile time in s for ior.cc"
plot [:] [:] "mico-summary.txt" u 1:66 title "ior.cc" w lp
set output "mico-summary.txt-ir_base.cc-69.png"
set title "Compile time in s for ir_base.cc"
plot [:] [:] "mico-summary.txt" u 1:69 title "ir_base.cc" w lp
set output "mico-summary.txt-ir.cc-72.png"
set title "Compile time in s for ir.cc"
plot [:] [:] "mico-summary.txt" u 1:72 title "ir.cc" w lp
set output "mico-summary.txt-message.cc-75.png"
set title "Compile time in s for message.cc"
plot [:] [:] "mico-summary.txt" u 1:75 title "message.cc" w lp
set output "mico-summary.txt-mtdebug.cc-78.png"
set title "Compile time in s for mtdebug.cc"
plot [:] [:] "mico-summary.txt" u 1:78 title "mtdebug.cc" w lp
set output "mico-summary.txt-mt_dispatcher.cc-81.png"
set title "Compile time in s for mt_dispatcher.cc"
plot [:] [:] "mico-summary.txt" u 1:81 title "mt_dispatcher.cc" w lp
set output "mico-summary.txt-mt_manager.cc-84.png"
set title "Compile time in s for mt_manager.cc"
plot [:] [:] "mico-summary.txt" u 1:84 title "mt_manager.cc" w lp
set output "mico-summary.txt-object.cc-87.png"
set title "Compile time in s for object.cc"
plot [:] [:] "mico-summary.txt" u 1:87 title "object.cc" w lp
set output "mico-summary.txt-operation.cc-90.png"
set title "Compile time in s for operation.cc"
plot [:] [:] "mico-summary.txt" u 1:90 title "operation.cc" w lp
set output "mico-summary.txt-orb.cc-93.png"
set title "Compile time in s for orb.cc"
plot [:] [:] "mico-summary.txt" u 1:93 title "orb.cc" w lp
set output "mico-summary.txt-orb_excepts.cc-96.png"
set title "Compile time in s for orb_excepts.cc"
plot [:] [:] "mico-summary.txt" u 1:96 title "orb_excepts.cc" w lp
set output "mico-summary.txt-os-thread.cc-99.png"
set title "Compile time in s for os-thread.cc"
plot [:] [:] "mico-summary.txt" u 1:99 title "os-thread.cc" w lp
set output "mico-summary.txt-os-unix.cc-102.png"
set title "Compile time in s for os-unix.cc"
plot [:] [:] "mico-summary.txt" u 1:102 title "os-unix.cc" w lp
set output "mico-summary.txt-pi.cc-105.png"
set title "Compile time in s for pi.cc"
plot [:] [:] "mico-summary.txt" u 1:105 title "pi.cc" w lp
set output "mico-summary.txt-pi_impl.cc-108.png"
set title "Compile time in s for pi_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:108 title "pi_impl.cc" w lp
set output "mico-summary.txt-poa_base.cc-111.png"
set title "Compile time in s for poa_base.cc"
plot [:] [:] "mico-summary.txt" u 1:111 title "poa_base.cc" w lp
set output "mico-summary.txt-poa.cc-114.png"
set title "Compile time in s for poa.cc"
plot [:] [:] "mico-summary.txt" u 1:114 title "poa.cc" w lp
set output "mico-summary.txt-poa_impl.cc-117.png"
set title "Compile time in s for poa_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:117 title "poa_impl.cc" w lp
set output "mico-summary.txt-policy2.cc-120.png"
set title "Compile time in s for policy2.cc"
plot [:] [:] "mico-summary.txt" u 1:120 title "policy2.cc" w lp
set output "mico-summary.txt-policy.cc-123.png"
set title "Compile time in s for policy.cc"
plot [:] [:] "mico-summary.txt" u 1:123 title "policy.cc" w lp
set output "mico-summary.txt-policy_impl.cc-126.png"
set title "Compile time in s for policy_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:126 title "policy_impl.cc" w lp
set output "mico-summary.txt-queue.cc-129.png"
set title "Compile time in s for queue.cc"
plot [:] [:] "mico-summary.txt" u 1:129 title "queue.cc" w lp
set output "mico-summary.txt-reflection.cc-132.png"
set title "Compile time in s for reflection.cc"
plot [:] [:] "mico-summary.txt" u 1:132 title "reflection.cc" w lp
set output "mico-summary.txt-service_info.cc-135.png"
set title "Compile time in s for service_info.cc"
plot [:] [:] "mico-summary.txt" u 1:135 title "service_info.cc" w lp
set output "mico-summary.txt-ssl.cc-138.png"
set title "Compile time in s for ssl.cc"
plot [:] [:] "mico-summary.txt" u 1:138 title "ssl.cc" w lp
set output "mico-summary.txt-ssliop.cc-141.png"
set title "Compile time in s for ssliop.cc"
plot [:] [:] "mico-summary.txt" u 1:141 title "ssliop.cc" w lp
set output "mico-summary.txt-static.cc-144.png"
set title "Compile time in s for static.cc"
plot [:] [:] "mico-summary.txt" u 1:144 title "static.cc" w lp
set output "mico-summary.txt-string.cc-147.png"
set title "Compile time in s for string.cc"
plot [:] [:] "mico-summary.txt" u 1:147 title "string.cc" w lp
set output "mico-summary.txt-tckind.cc-150.png"
set title "Compile time in s for tckind.cc"
plot [:] [:] "mico-summary.txt" u 1:150 title "tckind.cc" w lp
set output "mico-summary.txt-timebase.cc-153.png"
set title "Compile time in s for timebase.cc"
plot [:] [:] "mico-summary.txt" u 1:153 title "timebase.cc" w lp
set output "mico-summary.txt-transport.cc-156.png"
set title "Compile time in s for transport.cc"
plot [:] [:] "mico-summary.txt" u 1:156 title "transport.cc" w lp
set output "mico-summary.txt-transport-tcp.cc-159.png"
set title "Compile time in s for transport-tcp.cc"
plot [:] [:] "mico-summary.txt" u 1:159 title "transport-tcp.cc" w lp
set output "mico-summary.txt-transport-udp.cc-162.png"
set title "Compile time in s for transport-udp.cc"
plot [:] [:] "mico-summary.txt" u 1:162 title "transport-udp.cc" w lp
set output "mico-summary.txt-transport-unix.cc-165.png"
set title "Compile time in s for transport-unix.cc"
plot [:] [:] "mico-summary.txt" u 1:165 title "transport-unix.cc" w lp
set output "mico-summary.txt-typecode.cc-168.png"
set title "Compile time in s for typecode.cc"
plot [:] [:] "mico-summary.txt" u 1:168 title "typecode.cc" w lp
set output "mico-summary.txt-typecode_seq.cc-171.png"
set title "Compile time in s for typecode_seq.cc"
plot [:] [:] "mico-summary.txt" u 1:171 title "typecode_seq.cc" w lp
set output "mico-summary.txt-uni_base64.cc-174.png"
set title "Compile time in s for uni_base64.cc"
plot [:] [:] "mico-summary.txt" u 1:174 title "uni_base64.cc" w lp
set output "mico-summary.txt-uni_fromuni.cc-177.png"
set title "Compile time in s for uni_fromuni.cc"
plot [:] [:] "mico-summary.txt" u 1:177 title "uni_fromuni.cc" w lp
set output "mico-summary.txt-uni_touni.cc-180.png"
set title "Compile time in s for uni_touni.cc"
plot [:] [:] "mico-summary.txt" u 1:180 title "uni_touni.cc" w lp
set output "mico-summary.txt-uni_unicode.cc-183.png"
set title "Compile time in s for uni_unicode.cc"
plot [:] [:] "mico-summary.txt" u 1:183 title "uni_unicode.cc" w lp
set output "mico-summary.txt-util.cc-186.png"
set title "Compile time in s for util.cc"
plot [:] [:] "mico-summary.txt" u 1:186 title "util.cc" w lp
set output "mico-summary.txt-value.cc-189.png"
set title "Compile time in s for value.cc"
plot [:] [:] "mico-summary.txt" u 1:189 title "value.cc" w lp
set output "mico-summary.txt-valuetype.cc-192.png"
set title "Compile time in s for valuetype.cc"
plot [:] [:] "mico-summary.txt" u 1:192 title "valuetype.cc" w lp
set output "mico-summary.txt-valuetype_impl.cc-195.png"
set title "Compile time in s for valuetype_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:195 title "valuetype_impl.cc" w lp
set output


# ../gen-gp.sh --title "Text size in bytes" --ylabel "bytes" mico-summary.txt tests 3 3
set ylabel "bytes"

set logscale y
set output "mico-summary.txt-3-0.png"
set title "Text size in bytes"
plot [:] [:] "mico-summary.txt"  u 1:4 title "address.cc" w lp, \
	"" u 1:7 title "any.cc" w lp, \
	"" u 1:10 title "basic_seq.cc" w lp, \
	"" u 1:13 title "buffer.cc" w lp, \
	"" u 1:16 title "codec.cc" w lp, \
	"" u 1:19 title "codeset.cc" w lp, \
	"" u 1:22 title "context.cc" w lp, \
	"" u 1:25 title "current.cc" w lp, \
	"" u 1:28 title "dii.cc" w lp, \
	"" u 1:31 title "dispatch.cc" w lp, \
	"" u 1:34 title "dsi.cc" w lp, \
	"" u 1:37 title "dynany.cc" w lp, \
	"" u 1:40 title "dynany_impl.cc" w lp, \
	"" u 1:43 title "except2.cc" w lp, \
	"" u 1:46 title "except.cc" w lp, \
	"" u 1:49 title "fast_array.cc" w lp, \
	"" u 1:52 title "fixed.cc" w lp, \
	"" u 1:55 title "imr.cc" w lp, \
	"" u 1:58 title "intercept.cc" w lp, \
	"" u 1:61 title "iop.cc" w lp, \
	"" u 1:64 title "ioptypes.cc" w lp, \
	"" u 1:67 title "ior.cc" w lp, \
	"" u 1:70 title "ir_base.cc" w lp, \
	"" u 1:73 title "ir.cc" w lp, \
	"" u 1:76 title "message.cc" w lp, \
	"" u 1:79 title "mtdebug.cc" w lp, \
	"" u 1:82 title "mt_dispatcher.cc" w lp, \
	"" u 1:85 title "mt_manager.cc" w lp, \
	"" u 1:88 title "object.cc" w lp, \
	"" u 1:91 title "operation.cc" w lp, \
	"" u 1:94 title "orb.cc" w lp, \
	"" u 1:97 title "orb_excepts.cc" w lp
set output "mico-summary.txt-3-1.png"
plot [:] [:] "mico-summary.txt"  u 1:100 title "os-thread.cc" w lp, \
	"" u 1:103 title "os-unix.cc" w lp, \
	"" u 1:106 title "pi.cc" w lp, \
	"" u 1:109 title "pi_impl.cc" w lp, \
	"" u 1:112 title "poa_base.cc" w lp, \
	"" u 1:115 title "poa.cc" w lp, \
	"" u 1:118 title "poa_impl.cc" w lp, \
	"" u 1:121 title "policy2.cc" w lp, \
	"" u 1:124 title "policy.cc" w lp, \
	"" u 1:127 title "policy_impl.cc" w lp, \
	"" u 1:130 title "queue.cc" w lp, \
	"" u 1:133 title "reflection.cc" w lp, \
	"" u 1:136 title "service_info.cc" w lp, \
	"" u 1:139 title "ssl.cc" w lp, \
	"" u 1:142 title "ssliop.cc" w lp, \
	"" u 1:145 title "static.cc" w lp, \
	"" u 1:148 title "string.cc" w lp, \
	"" u 1:151 title "tckind.cc" w lp, \
	"" u 1:154 title "timebase.cc" w lp, \
	"" u 1:157 title "transport.cc" w lp, \
	"" u 1:160 title "transport-tcp.cc" w lp, \
	"" u 1:163 title "transport-udp.cc" w lp, \
	"" u 1:166 title "transport-unix.cc" w lp, \
	"" u 1:169 title "typecode.cc" w lp, \
	"" u 1:172 title "typecode_seq.cc" w lp, \
	"" u 1:175 title "uni_base64.cc" w lp, \
	"" u 1:178 title "uni_fromuni.cc" w lp, \
	"" u 1:181 title "uni_touni.cc" w lp, \
	"" u 1:184 title "uni_unicode.cc" w lp, \
	"" u 1:187 title "util.cc" w lp, \
	"" u 1:190 title "value.cc" w lp, \
	"" u 1:193 title "valuetype.cc" w lp
set output "mico-summary.txt-3-2.png"
plot [:] [:] "mico-summary.txt"  u 1:196 title "valuetype_impl.cc" w lp
set nologscale

set output "mico-summary.txt-address.cc-4.png"
set title "Text size in bytes for address.cc"
plot [:] [:] "mico-summary.txt" u 1:4 title "address.cc" w lp
set output "mico-summary.txt-any.cc-7.png"
set title "Text size in bytes for any.cc"
plot [:] [:] "mico-summary.txt" u 1:7 title "any.cc" w lp
set output "mico-summary.txt-basic_seq.cc-10.png"
set title "Text size in bytes for basic_seq.cc"
plot [:] [:] "mico-summary.txt" u 1:10 title "basic_seq.cc" w lp
set output "mico-summary.txt-buffer.cc-13.png"
set title "Text size in bytes for buffer.cc"
plot [:] [:] "mico-summary.txt" u 1:13 title "buffer.cc" w lp
set output "mico-summary.txt-codec.cc-16.png"
set title "Text size in bytes for codec.cc"
plot [:] [:] "mico-summary.txt" u 1:16 title "codec.cc" w lp
set output "mico-summary.txt-codeset.cc-19.png"
set title "Text size in bytes for codeset.cc"
plot [:] [:] "mico-summary.txt" u 1:19 title "codeset.cc" w lp
set output "mico-summary.txt-context.cc-22.png"
set title "Text size in bytes for context.cc"
plot [:] [:] "mico-summary.txt" u 1:22 title "context.cc" w lp
set output "mico-summary.txt-current.cc-25.png"
set title "Text size in bytes for current.cc"
plot [:] [:] "mico-summary.txt" u 1:25 title "current.cc" w lp
set output "mico-summary.txt-dii.cc-28.png"
set title "Text size in bytes for dii.cc"
plot [:] [:] "mico-summary.txt" u 1:28 title "dii.cc" w lp
set output "mico-summary.txt-dispatch.cc-31.png"
set title "Text size in bytes for dispatch.cc"
plot [:] [:] "mico-summary.txt" u 1:31 title "dispatch.cc" w lp
set output "mico-summary.txt-dsi.cc-34.png"
set title "Text size in bytes for dsi.cc"
plot [:] [:] "mico-summary.txt" u 1:34 title "dsi.cc" w lp
set output "mico-summary.txt-dynany.cc-37.png"
set title "Text size in bytes for dynany.cc"
plot [:] [:] "mico-summary.txt" u 1:37 title "dynany.cc" w lp
set output "mico-summary.txt-dynany_impl.cc-40.png"
set title "Text size in bytes for dynany_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:40 title "dynany_impl.cc" w lp
set output "mico-summary.txt-except2.cc-43.png"
set title "Text size in bytes for except2.cc"
plot [:] [:] "mico-summary.txt" u 1:43 title "except2.cc" w lp
set output "mico-summary.txt-except.cc-46.png"
set title "Text size in bytes for except.cc"
plot [:] [:] "mico-summary.txt" u 1:46 title "except.cc" w lp
set output "mico-summary.txt-fast_array.cc-49.png"
set title "Text size in bytes for fast_array.cc"
plot [:] [:] "mico-summary.txt" u 1:49 title "fast_array.cc" w lp
set output "mico-summary.txt-fixed.cc-52.png"
set title "Text size in bytes for fixed.cc"
plot [:] [:] "mico-summary.txt" u 1:52 title "fixed.cc" w lp
set output "mico-summary.txt-imr.cc-55.png"
set title "Text size in bytes for imr.cc"
plot [:] [:] "mico-summary.txt" u 1:55 title "imr.cc" w lp
set output "mico-summary.txt-intercept.cc-58.png"
set title "Text size in bytes for intercept.cc"
plot [:] [:] "mico-summary.txt" u 1:58 title "intercept.cc" w lp
set output "mico-summary.txt-iop.cc-61.png"
set title "Text size in bytes for iop.cc"
plot [:] [:] "mico-summary.txt" u 1:61 title "iop.cc" w lp
set output "mico-summary.txt-ioptypes.cc-64.png"
set title "Text size in bytes for ioptypes.cc"
plot [:] [:] "mico-summary.txt" u 1:64 title "ioptypes.cc" w lp
set output "mico-summary.txt-ior.cc-67.png"
set title "Text size in bytes for ior.cc"
plot [:] [:] "mico-summary.txt" u 1:67 title "ior.cc" w lp
set output "mico-summary.txt-ir_base.cc-70.png"
set title "Text size in bytes for ir_base.cc"
plot [:] [:] "mico-summary.txt" u 1:70 title "ir_base.cc" w lp
set output "mico-summary.txt-ir.cc-73.png"
set title "Text size in bytes for ir.cc"
plot [:] [:] "mico-summary.txt" u 1:73 title "ir.cc" w lp
set output "mico-summary.txt-message.cc-76.png"
set title "Text size in bytes for message.cc"
plot [:] [:] "mico-summary.txt" u 1:76 title "message.cc" w lp
set output "mico-summary.txt-mtdebug.cc-79.png"
set title "Text size in bytes for mtdebug.cc"
plot [:] [:] "mico-summary.txt" u 1:79 title "mtdebug.cc" w lp
set output "mico-summary.txt-mt_dispatcher.cc-82.png"
set title "Text size in bytes for mt_dispatcher.cc"
plot [:] [:] "mico-summary.txt" u 1:82 title "mt_dispatcher.cc" w lp
set output "mico-summary.txt-mt_manager.cc-85.png"
set title "Text size in bytes for mt_manager.cc"
plot [:] [:] "mico-summary.txt" u 1:85 title "mt_manager.cc" w lp
set output "mico-summary.txt-object.cc-88.png"
set title "Text size in bytes for object.cc"
plot [:] [:] "mico-summary.txt" u 1:88 title "object.cc" w lp
set output "mico-summary.txt-operation.cc-91.png"
set title "Text size in bytes for operation.cc"
plot [:] [:] "mico-summary.txt" u 1:91 title "operation.cc" w lp
set output "mico-summary.txt-orb.cc-94.png"
set title "Text size in bytes for orb.cc"
plot [:] [:] "mico-summary.txt" u 1:94 title "orb.cc" w lp
set output "mico-summary.txt-orb_excepts.cc-97.png"
set title "Text size in bytes for orb_excepts.cc"
plot [:] [:] "mico-summary.txt" u 1:97 title "orb_excepts.cc" w lp
set output "mico-summary.txt-os-thread.cc-100.png"
set title "Text size in bytes for os-thread.cc"
plot [:] [:] "mico-summary.txt" u 1:100 title "os-thread.cc" w lp
set output "mico-summary.txt-os-unix.cc-103.png"
set title "Text size in bytes for os-unix.cc"
plot [:] [:] "mico-summary.txt" u 1:103 title "os-unix.cc" w lp
set output "mico-summary.txt-pi.cc-106.png"
set title "Text size in bytes for pi.cc"
plot [:] [:] "mico-summary.txt" u 1:106 title "pi.cc" w lp
set output "mico-summary.txt-pi_impl.cc-109.png"
set title "Text size in bytes for pi_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:109 title "pi_impl.cc" w lp
set output "mico-summary.txt-poa_base.cc-112.png"
set title "Text size in bytes for poa_base.cc"
plot [:] [:] "mico-summary.txt" u 1:112 title "poa_base.cc" w lp
set output "mico-summary.txt-poa.cc-115.png"
set title "Text size in bytes for poa.cc"
plot [:] [:] "mico-summary.txt" u 1:115 title "poa.cc" w lp
set output "mico-summary.txt-poa_impl.cc-118.png"
set title "Text size in bytes for poa_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:118 title "poa_impl.cc" w lp
set output "mico-summary.txt-policy2.cc-121.png"
set title "Text size in bytes for policy2.cc"
plot [:] [:] "mico-summary.txt" u 1:121 title "policy2.cc" w lp
set output "mico-summary.txt-policy.cc-124.png"
set title "Text size in bytes for policy.cc"
plot [:] [:] "mico-summary.txt" u 1:124 title "policy.cc" w lp
set output "mico-summary.txt-policy_impl.cc-127.png"
set title "Text size in bytes for policy_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:127 title "policy_impl.cc" w lp
set output "mico-summary.txt-queue.cc-130.png"
set title "Text size in bytes for queue.cc"
plot [:] [:] "mico-summary.txt" u 1:130 title "queue.cc" w lp
set output "mico-summary.txt-reflection.cc-133.png"
set title "Text size in bytes for reflection.cc"
plot [:] [:] "mico-summary.txt" u 1:133 title "reflection.cc" w lp
set output "mico-summary.txt-service_info.cc-136.png"
set title "Text size in bytes for service_info.cc"
plot [:] [:] "mico-summary.txt" u 1:136 title "service_info.cc" w lp
set output "mico-summary.txt-ssl.cc-139.png"
set title "Text size in bytes for ssl.cc"
plot [:] [:] "mico-summary.txt" u 1:139 title "ssl.cc" w lp
set output "mico-summary.txt-ssliop.cc-142.png"
set title "Text size in bytes for ssliop.cc"
plot [:] [:] "mico-summary.txt" u 1:142 title "ssliop.cc" w lp
set output "mico-summary.txt-static.cc-145.png"
set title "Text size in bytes for static.cc"
plot [:] [:] "mico-summary.txt" u 1:145 title "static.cc" w lp
set output "mico-summary.txt-string.cc-148.png"
set title "Text size in bytes for string.cc"
plot [:] [:] "mico-summary.txt" u 1:148 title "string.cc" w lp
set output "mico-summary.txt-tckind.cc-151.png"
set title "Text size in bytes for tckind.cc"
plot [:] [:] "mico-summary.txt" u 1:151 title "tckind.cc" w lp
set output "mico-summary.txt-timebase.cc-154.png"
set title "Text size in bytes for timebase.cc"
plot [:] [:] "mico-summary.txt" u 1:154 title "timebase.cc" w lp
set output "mico-summary.txt-transport.cc-157.png"
set title "Text size in bytes for transport.cc"
plot [:] [:] "mico-summary.txt" u 1:157 title "transport.cc" w lp
set output "mico-summary.txt-transport-tcp.cc-160.png"
set title "Text size in bytes for transport-tcp.cc"
plot [:] [:] "mico-summary.txt" u 1:160 title "transport-tcp.cc" w lp
set output "mico-summary.txt-transport-udp.cc-163.png"
set title "Text size in bytes for transport-udp.cc"
plot [:] [:] "mico-summary.txt" u 1:163 title "transport-udp.cc" w lp
set output "mico-summary.txt-transport-unix.cc-166.png"
set title "Text size in bytes for transport-unix.cc"
plot [:] [:] "mico-summary.txt" u 1:166 title "transport-unix.cc" w lp
set output "mico-summary.txt-typecode.cc-169.png"
set title "Text size in bytes for typecode.cc"
plot [:] [:] "mico-summary.txt" u 1:169 title "typecode.cc" w lp
set output "mico-summary.txt-typecode_seq.cc-172.png"
set title "Text size in bytes for typecode_seq.cc"
plot [:] [:] "mico-summary.txt" u 1:172 title "typecode_seq.cc" w lp
set output "mico-summary.txt-uni_base64.cc-175.png"
set title "Text size in bytes for uni_base64.cc"
plot [:] [:] "mico-summary.txt" u 1:175 title "uni_base64.cc" w lp
set output "mico-summary.txt-uni_fromuni.cc-178.png"
set title "Text size in bytes for uni_fromuni.cc"
plot [:] [:] "mico-summary.txt" u 1:178 title "uni_fromuni.cc" w lp
set output "mico-summary.txt-uni_touni.cc-181.png"
set title "Text size in bytes for uni_touni.cc"
plot [:] [:] "mico-summary.txt" u 1:181 title "uni_touni.cc" w lp
set output "mico-summary.txt-uni_unicode.cc-184.png"
set title "Text size in bytes for uni_unicode.cc"
plot [:] [:] "mico-summary.txt" u 1:184 title "uni_unicode.cc" w lp
set output "mico-summary.txt-util.cc-187.png"
set title "Text size in bytes for util.cc"
plot [:] [:] "mico-summary.txt" u 1:187 title "util.cc" w lp
set output "mico-summary.txt-value.cc-190.png"
set title "Text size in bytes for value.cc"
plot [:] [:] "mico-summary.txt" u 1:190 title "value.cc" w lp
set output "mico-summary.txt-valuetype.cc-193.png"
set title "Text size in bytes for valuetype.cc"
plot [:] [:] "mico-summary.txt" u 1:193 title "valuetype.cc" w lp
set output "mico-summary.txt-valuetype_impl.cc-196.png"
set title "Text size in bytes for valuetype_impl.cc"
plot [:] [:] "mico-summary.txt" u 1:196 title "valuetype_impl.cc" w lp
set output

