#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="mico-summary.txt"

echo "# Three values per test, compile-time peak memory usage, compile-time and text size" > $summary
echo -n "# DATE " >> $summary
for i in `cat $BASEDIR/tests`; do
  echo -n $i" " >> $summary
done
echo >> $summary

for i in $LOGDIR/mico-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  cat $i | grep '^BENCHDATA' | sort | sed -e 's/^BENCHDATA \([^ ]*\) \([0-9]*\) \([0-9\.]*\) \([0-9]*\).*$/\2 \3 \4/' | tr '\n' ' ' >> $summary
  echo >> $summary;
done

# tests file by cat $i | grep '^BENCHDATA' | sort | sed -e 's/^BENCHDATA \([^ ]*\) \([0-9]*\) \([0-9\.]*\) \([0-9]*\).*$/\1/' | tr '/\n' '- '
# mico-summary.gp by gen-gp.sh mico-summary.txt tests [123] 3
if test -f $BASEDIR/mico-summary.gp-`hostname`; then
  gnuplot $BASEDIR/mico-summary.gp-`hostname`
else
  gnuplot $BASEDIR/mico-summary.gp
fi
