set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


# ../gen-gp.sh --title Compile time in s --ylabel s polyhedron-summary.txt tests 1 2
set ylabel "s"

set logscale y
set output "polyhedron-summary.txt-1-0.png"
set title "Compile time in s"
plot [:] [:] "polyhedron-summary.txt"  u 1:2 title "ac" w lp, \
	"" u 1:4 title "aermod" w lp, \
	"" u 1:6 title "air" w lp, \
	"" u 1:8 title "capacita" w lp, \
	"" u 1:10 title "channel" w lp, \
	"" u 1:12 title "doduc" w lp, \
	"" u 1:14 title "fatigue" w lp, \
	"" u 1:16 title "gas_dyn" w lp, \
	"" u 1:18 title "induct" w lp, \
	"" u 1:20 title "linpk" w lp, \
	"" u 1:22 title "mdbx" w lp, \
	"" u 1:24 title "nf" w lp, \
	"" u 1:26 title "protein" w lp, \
	"" u 1:28 title "rnflow" w lp, \
	"" u 1:30 title "test_fpu" w lp, \
	"" u 1:32 title "tfft" w lp
set nologscale

set output "polyhedron-summary.txt-ac-2.png"
set title "Compile time in s for ac"
plot [:] [:] "polyhedron-summary.txt" u 1:2 title "ac" w lp
set output "polyhedron-summary.txt-aermod-4.png"
set title "Compile time in s for aermod"
plot [:] [:] "polyhedron-summary.txt" u 1:4 title "aermod" w lp
set output "polyhedron-summary.txt-air-6.png"
set title "Compile time in s for air"
plot [:] [:] "polyhedron-summary.txt" u 1:6 title "air" w lp
set output "polyhedron-summary.txt-capacita-8.png"
set title "Compile time in s for capacita"
plot [:] [:] "polyhedron-summary.txt" u 1:8 title "capacita" w lp
set output "polyhedron-summary.txt-channel-10.png"
set title "Compile time in s for channel"
plot [:] [:] "polyhedron-summary.txt" u 1:10 title "channel" w lp
set output "polyhedron-summary.txt-doduc-12.png"
set title "Compile time in s for doduc"
plot [:] [:] "polyhedron-summary.txt" u 1:12 title "doduc" w lp
set output "polyhedron-summary.txt-fatigue-14.png"
set title "Compile time in s for fatigue"
plot [:] [:] "polyhedron-summary.txt" u 1:14 title "fatigue" w lp
set output "polyhedron-summary.txt-gas_dyn-16.png"
set title "Compile time in s for gas_dyn"
plot [:] [:] "polyhedron-summary.txt" u 1:16 title "gas_dyn" w lp
set output "polyhedron-summary.txt-induct-18.png"
set title "Compile time in s for induct"
plot [:] [:] "polyhedron-summary.txt" u 1:18 title "induct" w lp
set output "polyhedron-summary.txt-linpk-20.png"
set title "Compile time in s for linpk"
plot [:] [:] "polyhedron-summary.txt" u 1:20 title "linpk" w lp
set output "polyhedron-summary.txt-mdbx-22.png"
set title "Compile time in s for mdbx"
plot [:] [:] "polyhedron-summary.txt" u 1:22 title "mdbx" w lp
set output "polyhedron-summary.txt-nf-24.png"
set title "Compile time in s for nf"
plot [:] [:] "polyhedron-summary.txt" u 1:24 title "nf" w lp
set output "polyhedron-summary.txt-protein-26.png"
set title "Compile time in s for protein"
plot [:] [:] "polyhedron-summary.txt" u 1:26 title "protein" w lp
set output "polyhedron-summary.txt-rnflow-28.png"
set title "Compile time in s for rnflow"
plot [:] [:] "polyhedron-summary.txt" u 1:28 title "rnflow" w lp
set output "polyhedron-summary.txt-test_fpu-30.png"
set title "Compile time in s for test_fpu"
plot [:] [:] "polyhedron-summary.txt" u 1:30 title "test_fpu" w lp
set output "polyhedron-summary.txt-tfft-32.png"
set title "Compile time in s for tfft"
plot [:] [:] "polyhedron-summary.txt" u 1:32 title "tfft" w lp
set output


# ../gen-gp.sh --title Benchmark run time in s --ylabel s polyhedron-summary.txt tests 2 2
set ylabel "s"

set logscale y
set output "polyhedron-summary.txt-2-0.png"
set title "Benchmark run time in s"
plot [:] [:] "polyhedron-summary.txt"  u 1:3 title "ac" w lp, \
	"" u 1:5 title "aermod" w lp, \
	"" u 1:7 title "air" w lp, \
	"" u 1:9 title "capacita" w lp, \
	"" u 1:11 title "channel" w lp, \
	"" u 1:13 title "doduc" w lp, \
	"" u 1:15 title "fatigue" w lp, \
	"" u 1:17 title "gas_dyn" w lp, \
	"" u 1:19 title "induct" w lp, \
	"" u 1:21 title "linpk" w lp, \
	"" u 1:23 title "mdbx" w lp, \
	"" u 1:25 title "nf" w lp, \
	"" u 1:27 title "protein" w lp, \
	"" u 1:29 title "rnflow" w lp, \
	"" u 1:31 title "test_fpu" w lp, \
	"" u 1:33 title "tfft" w lp
set nologscale

set output "polyhedron-summary.txt-ac-3.png"
set title "Benchmark run time in s for ac"
plot [:] [:] "polyhedron-summary.txt" u 1:3 title "ac" w lp
set output "polyhedron-summary.txt-aermod-5.png"
set title "Benchmark run time in s for aermod"
plot [:] [:] "polyhedron-summary.txt" u 1:5 title "aermod" w lp
set output "polyhedron-summary.txt-air-7.png"
set title "Benchmark run time in s for air"
plot [:] [:] "polyhedron-summary.txt" u 1:7 title "air" w lp
set output "polyhedron-summary.txt-capacita-9.png"
set title "Benchmark run time in s for capacita"
plot [:] [:] "polyhedron-summary.txt" u 1:9 title "capacita" w lp
set output "polyhedron-summary.txt-channel-11.png"
set title "Benchmark run time in s for channel"
plot [:] [:] "polyhedron-summary.txt" u 1:11 title "channel" w lp
set output "polyhedron-summary.txt-doduc-13.png"
set title "Benchmark run time in s for doduc"
plot [:] [:] "polyhedron-summary.txt" u 1:13 title "doduc" w lp
set output "polyhedron-summary.txt-fatigue-15.png"
set title "Benchmark run time in s for fatigue"
plot [:] [:] "polyhedron-summary.txt" u 1:15 title "fatigue" w lp
set output "polyhedron-summary.txt-gas_dyn-17.png"
set title "Benchmark run time in s for gas_dyn"
plot [:] [:] "polyhedron-summary.txt" u 1:17 title "gas_dyn" w lp
set output "polyhedron-summary.txt-induct-19.png"
set title "Benchmark run time in s for induct"
plot [:] [:] "polyhedron-summary.txt" u 1:19 title "induct" w lp
set output "polyhedron-summary.txt-linpk-21.png"
set title "Benchmark run time in s for linpk"
plot [:] [:] "polyhedron-summary.txt" u 1:21 title "linpk" w lp
set output "polyhedron-summary.txt-mdbx-23.png"
set title "Benchmark run time in s for mdbx"
plot [:] [:] "polyhedron-summary.txt" u 1:23 title "mdbx" w lp
set output "polyhedron-summary.txt-nf-25.png"
set title "Benchmark run time in s for nf"
plot [:] [:] "polyhedron-summary.txt" u 1:25 title "nf" w lp
set output "polyhedron-summary.txt-protein-27.png"
set title "Benchmark run time in s for protein"
plot [:] [:] "polyhedron-summary.txt" u 1:27 title "protein" w lp
set output "polyhedron-summary.txt-rnflow-29.png"
set title "Benchmark run time in s for rnflow"
plot [:] [:] "polyhedron-summary.txt" u 1:29 title "rnflow" w lp
set output "polyhedron-summary.txt-test_fpu-31.png"
set title "Benchmark run time in s for test_fpu"
plot [:] [:] "polyhedron-summary.txt" u 1:31 title "test_fpu" w lp
set output "polyhedron-summary.txt-tfft-33.png"
set title "Benchmark run time in s for tfft"
plot [:] [:] "polyhedron-summary.txt" u 1:33 title "tfft" w lp
set output

