#!/bin/sh

# (use absoulte paths)
# Usage: polyhedron.sh BASEDIR GCCINSTALLDIR  LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"
LOGFILE="$LOGDIR/polyhedron-performance-`date +%y%m%d-%s`"

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

cd $TMPDIR
rm -Rf pb05
tar xzf $BASEDIR/pb05.tgz

cp $BASEDIR/daily.par $TMPDIR/pb05/lin/source/

case `uname -m` in
i?86) archstr="-march=pentium4" ;;
x86_64) archstr="-march=k8" ;;
*) archstr="" ;;
esac
cat $BASEDIR/gfortran_lin.par.in | sed -e "s,@INSTALLDIR@,$GCCINSTALLDIR," | sed -e "s,@ARCH@,$archstr," > $TMPDIR/pb05/lin/source/gfortran_lin.par

cd $TMPDIR/pb05/lin/source
../pbharness gfortran_lin daily.par 2>&1 | tee -a $LOGFILE

cat gfortran_lin.sum >> $LOGFILE

cp $LOGFILE $LOGDIR/polyhedron-performance-latest

