#!/bin/sh
# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary=tramp3d-summary.txt

echo '# date load build[s] run[s] build-leafify[s] run-leafify[s] mem[kb] mem-leafify[kb]' > $summary
for i in $LOGDIR/tramp3d-performance-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  grep 'load average:' $i | sed -e 's/.*load average: \(....\).*/\1/' | tr '\n' ' ' | cat >> $summary
  grep '^TIME: ' $i | sed -e 's/^TIME: \([0-9.]*\)/\1/g' | tr '\n' ' ' | cat >> $summary
  grep '^total: ' $i | cut -d ' ' -f 2 | tr '\n' ' ' | cat >> $summary
  grep '^PTIME: ' $i | sed -e 's/^PTIME: \([0-9.]*\)/\1/g' | tr '\n' ' ' | cat >> $summary
  grep '^FILESIZE:' $i | cut -d ' ' -f 8 | tr '\n' ' ' | cat >> $summary
  echo >> $summary
done

if test -f $BASEDIR/tramp3d-summary.gp-`hostname`; then
  gnuplot $BASEDIR/tramp3d-summary.gp-`hostname`
else
  gnuplot $BASEDIR/tramp3d-summary.gp
fi
