//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: ConformTransformation.cpp,v 1.13 2005/12/13 23:18:51 delpinux Exp $

#include <Domain.hpp>

#include <ConformTransformation.hpp>
#include <UserFunction.hpp>

real_t
ConformTransformationQ1Hexahedron::integrate(const UserFunction& f) const
{
  throw ErrorHandler(__FILE__,__LINE__,
		     "not implemented",
		     ErrorHandler::unexpected);
  return 0;
}

//! Computes Xhat, the point which transformed is (x,y,z)
bool
ConformTransformationQ1Hexahedron::invertT(const real_t& x,
					   const real_t& y,
					   const real_t& z,
					   TinyVector<3,real_t>& Xhat) const
{
  // initialization
  for(size_t i=0; i<3; ++i)
    Xhat[i] = 0.5;

  TinyVector<3,real_t> X;
  TinyVector<3,real_t> f;
  TinyVector<3> delta;
  const size_t maxiter = 100;
  size_t niter = 0;

  do {
    niter++;

    //! Computing F(Xhat) - (x,y,z).
    value(Xhat,f);
    f[0] -= x;
    f[1] -= y;
    f[2] -= z;

    // Evaluation of the Jacobian 
    TinyMatrix<3,3,real_t> J;
    dx(Xhat,X);
    for (size_t i=0; i<3; ++i)
      J(0,i) = X[i];

    dy(Xhat,X);
    for (size_t i=0; i<3; ++i)
      J(1,i) = X[i];

    dz(Xhat,X);
    for (size_t i=0; i<3; ++i)
      J(2,i) = X[i];


    delta = f/J;

    Xhat -= delta;
    
    if ((niter>maxiter)or(Norm(f)>10)) {
      value(Xhat,X);
      return false;
    }
  } while(Norm(f)>1E-2);
  value(Xhat,X);
  return true;
}

real_t
ConformTransformationP1Tetrahedron::integrate(const UserFunction& f) const
{
  throw ErrorHandler(__FILE__,__LINE__,
		     "not implemented",
		     ErrorHandler::unexpected);
  return 0;
}

real_t
ConformTransformationQ1CartesianHexahedron::
integrateCharacteristic(const Domain& d) const
{
  // Here we use order 4 Lobatto quadrature

  TinyVector<4, real_t>  x;
  x[0] = 0.;
  x[1] = .27639320225002103036; //(1-sqrt(5)/5)/2.;
  x[2] = .72360679774997896964; //(1+sqrt(5)/5)/2.;
  x[3] = 1.;

  TinyVector<4, real_t>  w;
  w[0] = 1./12.;
  w[1] = 5./12.;
  w[2] = 5./12.;
  w[3] = 1./12.;

  real_t sum = 0;
  TinyVector<3, real_t> X_hat;
  TinyVector<3, real_t> X;
  for (unsigned i=0; i<4; ++i) {
    X_hat[0] = x[i];
    for (unsigned j=0; j<4; ++j) {
      X_hat[1] = x[j];
      for (unsigned k=0; k<4; ++k) {
	X_hat[2] = x[k];
	this->value(X_hat, X);
	sum += w[i]*w[j]*w[k] * (d.inside(X) ? 1 : 0);
      }
    }
  }
  return sum;
}


real_t
ConformTransformationP1Triangle::integrate(const UserFunction& f) const
{
  throw ErrorHandler(__FILE__,__LINE__,
		     "not implemented",
		     ErrorHandler::unexpected);

  return 0.;
}

real_t
ConformTransformationQ1Quadrangle::integrate(const UserFunction& f) const
{
  throw ErrorHandler(__FILE__,__LINE__,
		     "not implemented",
		     ErrorHandler::unexpected);
  return 0.;
}

