//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Normal.hpp,v 1.1 2005/10/30 23:14:04 delpinux Exp $

#ifndef NORMAL_HPP
#define NORMAL_HPP

#include <Types.hpp>
/**
 * @file   Normal.hpp
 * @author Stephane Del Pino
 * @date   Mon Oct 31 00:00:14 2005
 * 
 * @brief This class is a simple normal component evaluating function
 * 
 * This works using the @see NormalManager class
 */
class Normal
{
public:
  enum ComponentType
  {
    undefined,
    x,
    y,
    z
  };

private:
  ComponentType __componentType; /**< The desired component */

public:
  /** 
   * Access to the value of the given component
   * 
   * @return the component value
   */
  real_t operator()(const real_t& x,
		    const real_t& y,
		    const real_t& z) const;

  /** 
   * Constructor
   * 
   * @param normalType the desired component
   */
  Normal(const ComponentType& normalType)
    : __componentType(normalType)
  {
    ;
  }

  /** 
   * Destructor
   * 
   */
  ~Normal()
  {
    ;
  }
};

#endif // NORMAL_HPP
