//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: ThreadStaticCenter.cpp,v 1.5 2005/10/30 23:17:28 delpinux Exp $

#include <ThreadStaticCenter.hpp>
#include <ThreadStaticBase.hpp>
#include <StreamCenter.hpp>

#include <config.h>

#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif // HAVE_PTHREAD

#include <Information.hpp>
#include <ParameterCenter.hpp>
#include <DegreeOfFreedomSetManager.hpp>
#include <NormalManager.hpp>

ThreadStaticCenter::ThreadStaticCenter()
{
  /// Language utils
  Information::create();
  ParameterCenter::create();
  DegreeOfFreedomSetManager::create();
  NormalManager::create();
}

ThreadStaticCenter::~ThreadStaticCenter()
{
  NormalManager::destroy();
  DegreeOfFreedomSetManager::destroy();
  /// Language utils
  ParameterCenter::destroy();
  Information::destroy();
}
