/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class BufferArgumentsMarshalTest
extends TestCase {
    TestLibrary lib;

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testByteBufferArgument() {
        ByteBuffer buf = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        int MAGIC = -19;
        this.lib.fillInt8Buffer(buf, 1024, (byte)-19);
        for (int i = 0; i < buf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (byte)-19, (byte)buf.get(i));
        }
    }

    public void testShortBufferArgument() {
        ShortBuffer buf = ShortBuffer.allocate(1024);
        int MAGIC = -21523;
        this.lib.fillInt16Buffer(buf, 1024, (short)-21523);
        for (int i = 0; i < buf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (short)-21523, (short)buf.get(i));
        }
    }

    public void testIntBufferArgument() {
        IntBuffer buf = IntBuffer.allocate(1024);
        int MAGIC = -1410478301;
        this.lib.fillInt32Buffer(buf, 1024, -1410478301);
        for (int i = 0; i < buf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (int)-1410478301, (int)buf.get(i));
        }
    }

    public void testLongBufferArgument() {
        LongBuffer buf = LongBuffer.allocate(1024);
        long MAGIC = 1311768467139281697L;
        this.lib.fillInt64Buffer(buf, 1024, 1311768467139281697L);
        for (int i = 0; i < buf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (long)1311768467139281697L, (long)buf.get(i));
        }
    }

    public void testDirectByteBufferArgument() {
        int i;
        ByteBuffer buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
        int MAGIC = -19;
        this.lib.fillInt8Buffer(buf, 1024, (byte)-19);
        for (i = 0; i < buf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (byte)-19, (byte)buf.get(i));
        }
        buf.position(512);
        this.lib.fillInt8Buffer(buf, 512, (byte)0);
        for (i = 0; i < buf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (byte)(i < 512 ? (byte)-19 : 0), (byte)buf.get(i));
        }
    }

    public void testDirectShortBufferArgument() {
        ByteBuffer buf = ByteBuffer.allocateDirect(2048).order(ByteOrder.nativeOrder());
        ShortBuffer shortBuf = buf.asShortBuffer();
        int MAGIC = -21523;
        this.lib.fillInt16Buffer(shortBuf, 1024, (short)-21523);
        for (int i = 0; i < shortBuf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (short)-21523, (short)shortBuf.get(i));
        }
    }

    public void testDirectIntBufferArgument() {
        ByteBuffer buf = ByteBuffer.allocateDirect(4096).order(ByteOrder.nativeOrder());
        IntBuffer intBuf = buf.asIntBuffer();
        int MAGIC = -1410478301;
        this.lib.fillInt32Buffer(intBuf, 1024, -1410478301);
        for (int i = 0; i < intBuf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (int)-1410478301, (int)intBuf.get(i));
        }
    }

    public void testDirectLongBufferArgument() {
        ByteBuffer buf = ByteBuffer.allocateDirect(8192).order(ByteOrder.nativeOrder());
        LongBuffer longBuf = buf.asLongBuffer();
        long MAGIC = 1311768467139281697L;
        this.lib.fillInt64Buffer(longBuf, 1024, 1311768467139281697L);
        for (int i = 0; i < longBuf.capacity(); ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (long)1311768467139281697L, (long)longBuf.get(i));
        }
    }

    public void testWrappedByteArrayArgument() {
        byte[] array = new byte[1024];
        ByteBuffer buf = ByteBuffer.wrap(array, 512, 512);
        int MAGIC = -85;
        this.lib.fillInt8Buffer(buf, 512, (byte)-85);
        for (int i = 0; i < array.length; ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (byte)(i < 512 ? (byte)0 : -85), (byte)array[i]);
        }
    }

    public void testWrappedShortArrayArgument() {
        short[] array = new short[1024];
        ShortBuffer buf = ShortBuffer.wrap(array, 512, 512);
        int MAGIC = -21523;
        this.lib.fillInt16Buffer(buf, 512, (short)-21523);
        for (int i = 0; i < array.length; ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (short)(i < 512 ? (short)0 : -21523), (short)array[i]);
        }
    }

    public void testWrappedIntArrayArgument() {
        int[] array = new int[1024];
        IntBuffer buf = IntBuffer.wrap(array, 512, 512);
        int MAGIC = -1410478301;
        this.lib.fillInt32Buffer(buf, 512, -1410478301);
        for (int i = 0; i < array.length; ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (int)(i < 512 ? 0 : -1410478301), (int)array[i]);
        }
    }

    public void testWrappedLongArrayArguent() {
        long[] array = new long[1024];
        LongBuffer buf = LongBuffer.wrap(array, 512, 512);
        long MAGIC = 1311768467139281697L;
        this.lib.fillInt64Buffer(buf, 512, 1311768467139281697L);
        for (int i = 0; i < array.length; ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (long)(i < 512 ? 0L : 1311768467139281697L), (long)array[i]);
        }
    }

    public void testWrappedFloatArrayArguent() {
        float[] array = new float[1024];
        FloatBuffer buf = FloatBuffer.wrap(array, 512, 512);
        float MAGIC = -118.625f;
        this.lib.fillFloatBuffer(buf, 512, -118.625f);
        for (int i = 0; i < array.length; ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (Object)Float.valueOf(i < 512 ? 0.0f : -118.625f), (Object)Float.valueOf(array[i]));
        }
    }

    public void testWrappedDoubleArrayArguent() {
        double[] array = new double[1024];
        DoubleBuffer buf = DoubleBuffer.wrap(array, 512, 512);
        double MAGIC = -118.625;
        this.lib.fillDoubleBuffer(buf, 512, -118.625);
        for (int i = 0; i < array.length; ++i) {
            BufferArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (Object)(i < 512 ? 0.0 : -118.625), (Object)array[i]);
        }
    }

    public static void main(String[] argList) {
        TestRunner.run(BufferArgumentsMarshalTest.class);
    }

    public static interface TestLibrary
    extends Library {
        public int fillInt8Buffer(ByteBuffer var1, int var2, byte var3);

        public int fillInt16Buffer(ByteBuffer var1, int var2, short var3);

        public int fillInt32Buffer(ByteBuffer var1, int var2, int var3);

        public int fillInt64Buffer(ByteBuffer var1, int var2, long var3);

        public int fillFloatBuffer(ByteBuffer var1, int var2, float var3);

        public int fillDoubleBuffer(ByteBuffer var1, int var2, double var3);

        public int fillInt16Buffer(ShortBuffer var1, int var2, short var3);

        public int fillInt32Buffer(IntBuffer var1, int var2, int var3);

        public int fillInt64Buffer(LongBuffer var1, int var2, long var3);

        public int fillFloatBuffer(FloatBuffer var1, int var2, float var3);

        public int fillDoubleBuffer(DoubleBuffer var1, int var2, double var3);
    }
}

