/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class NativeLibraryTest
extends TestCase {
    public void testGCNativeLibrary() throws Exception {
        NativeLibrary lib = NativeLibrary.getInstance((String)"testlib");
        WeakReference<NativeLibrary> ref = new WeakReference<NativeLibrary>(lib);
        lib = null;
        System.gc();
        long start = System.currentTimeMillis();
        while (ref.get() != null) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 5000L) continue;
        }
        NativeLibraryTest.assertNull((String)"Library not GC'd", ref.get());
    }

    public void testAvoidDuplicateLoads() {
        NativeLibrary.disposeAll();
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
        NativeLibraryTest.assertEquals((String)"Library should be newly loaded after all others disposed", (int)1, (int)lib.callCount());
        if (lib.callCount() <= 1) {
            NativeLibraryTest.fail((String)"Library should not be reloaded");
        }
    }

    public void testUseSingleLibraryInstance() {
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
        int count = lib.callCount();
        TestLibrary lib2 = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
        int count2 = lib2.callCount();
        NativeLibraryTest.assertEquals((String)"Interfaces should share a library instance", (int)(count + 1), (int)count2);
    }

    public void testAliasLibraryFilename() {
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
        int count = lib.callCount();
        NativeLibrary nl = NativeLibrary.getInstance((String)"testlib");
        TestLibrary lib2 = (TestLibrary)Native.loadLibrary((String)nl.getFile().getName(), TestLibrary.class);
        int count2 = lib2.callCount();
        NativeLibraryTest.assertEquals((String)"Simple filename load not aliased", (int)(count + 1), (int)count2);
    }

    public void testAliasLibraryFullPath() {
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
        int count = lib.callCount();
        NativeLibrary nl = NativeLibrary.getInstance((String)"testlib");
        TestLibrary lib2 = (TestLibrary)Native.loadLibrary((String)nl.getFile().getAbsolutePath(), TestLibrary.class);
        int count2 = lib2.callCount();
        NativeLibraryTest.assertEquals((String)"Full pathname load not aliased", (int)(count + 1), (int)count2);
    }

    public void testAliasSimpleLibraryName() throws Exception {
        NativeLibrary nl = NativeLibrary.getInstance((String)"testlib");
        File file = nl.getFile();
        WeakReference<NativeLibrary> ref = new WeakReference<NativeLibrary>(nl);
        nl = null;
        System.gc();
        long start = System.currentTimeMillis();
        while (ref.get() != null) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 5000L) continue;
            NativeLibraryTest.fail((String)"Timed out waiting for library to be GC'd");
        }
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)file.getAbsolutePath(), TestLibrary.class);
        int count = lib.callCount();
        TestLibrary lib2 = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
        int count2 = lib2.callCount();
        NativeLibraryTest.assertEquals((String)"Simple library name not aliased", (int)(count + 1), (int)count2);
    }

    public void testFunctionHoldsLibraryReference() throws Exception {
        NativeLibrary lib = NativeLibrary.getInstance((String)"testlib");
        WeakReference<NativeLibrary> ref = new WeakReference<NativeLibrary>(lib);
        Function f = lib.getFunction("callCount");
        lib = null;
        System.gc();
        long start = System.currentTimeMillis();
        while (ref.get() != null && System.currentTimeMillis() - start < 2000L) {
            Thread.sleep(10L);
        }
        NativeLibraryTest.assertNotNull((String)"Library GC'd when it should not be", ref.get());
        f.invokeInt(new Object[0]);
        f = null;
        System.gc();
        while (ref.get() != null && System.currentTimeMillis() - start < 5000L) {
            Thread.sleep(10L);
        }
        NativeLibraryTest.assertNull((String)"Library not GC'd", ref.get());
    }

    public void testLoadFrameworkLibrary() {
        if (Platform.isMac()) {
            try {
                NativeLibrary lib = NativeLibrary.getInstance((String)"CoreServices");
                NativeLibraryTest.assertNotNull((String)"CoreServices not found", (Object)lib);
            }
            catch (UnsatisfiedLinkError e) {
                NativeLibraryTest.fail((String)"Should search /System/Library/Frameworks");
            }
        }
    }

    public void testLoadFrameworkLibraryAbsolute() {
        if (Platform.isMac()) {
            try {
                NativeLibrary lib = NativeLibrary.getInstance((String)"/System/Library/Frameworks/CoreServices");
                NativeLibraryTest.assertNotNull((String)"CoreServices not found", (Object)lib);
            }
            catch (UnsatisfiedLinkError e) {
                NativeLibraryTest.fail((String)"Should try FRAMEWORK.framework/FRAMEWORK if absolute and exists");
            }
        }
    }

    public void testLoadFrameworkLibraryAbsoluteFull() {
        if (Platform.isMac()) {
            try {
                NativeLibrary lib = NativeLibrary.getInstance((String)"/System/Library/Frameworks/CoreServices.framework/CoreServices");
                NativeLibraryTest.assertNotNull((String)"CoreServices not found", (Object)lib);
            }
            catch (UnsatisfiedLinkError e) {
                NativeLibraryTest.fail((String)"Should try FRAMEWORK if absolute and exists");
            }
        }
    }

    public void testLookupGlobalVariable() {
        NativeLibrary lib = NativeLibrary.getInstance((String)"testlib");
        Pointer global = lib.getGlobalVariableAddress("test_global");
        NativeLibraryTest.assertNotNull((String)"Test variable not found", (Object)global);
        int MAGIC = 305419896;
        NativeLibraryTest.assertEquals((String)"Wrong value for library global variable", (int)305419896, (int)global.getInt(0L));
        global.setInt(0L, 305419897);
        NativeLibraryTest.assertEquals((String)"Library global variable not updated", (int)305419897, (int)global.getInt(0L));
    }

    public void testMatchUnversionedToVersioned() throws Exception {
        File lib0 = File.createTempFile("lib", ".so.0");
        File dir = lib0.getParentFile();
        String name = lib0.getName();
        name = name.substring(3, name.indexOf(".so"));
        lib0.deleteOnExit();
        File lib1 = new File(dir, "lib" + name + ".so.1.0");
        lib1.createNewFile();
        lib1.deleteOnExit();
        File lib1_1 = new File(dir, "lib" + name + ".so.1.1");
        lib1_1.createNewFile();
        lib1_1.deleteOnExit();
        List<String> path = Arrays.asList(dir.getAbsolutePath());
        NativeLibraryTest.assertEquals((String)"Latest versioned library not found when unversioned requested", (String)lib1_1.getAbsolutePath(), (String)NativeLibrary.matchLibrary((String)name, path));
    }

    public void testAvoidFalseMatch() throws Exception {
        File lib0 = File.createTempFile("lib", ".so.1");
        File dir = lib0.getParentFile();
        lib0.deleteOnExit();
        String name = lib0.getName();
        name = name.substring(3, name.indexOf(".so"));
        File lib1 = new File(dir, "lib" + name + "-client.so.2");
        lib1.createNewFile();
        lib1.deleteOnExit();
        List<String> path = Arrays.asList(dir.getAbsolutePath());
        NativeLibraryTest.assertEquals((String)"Library with similar prefix should be ignored", (String)lib0.getAbsolutePath(), (String)NativeLibrary.matchLibrary((String)name, path));
    }

    public void testParseVersion() throws Exception {
        String[] VERSIONS = new String[]{"1", "1.2", "1.2.3", "1.2.3.4"};
        double[] EXPECTED = new double[]{1.0, 1.02, 1.0203, 1.020304};
        for (int i = 0; i < VERSIONS.length; ++i) {
            NativeLibraryTest.assertEquals((String)"Badly parsed version", (double)EXPECTED[i], (double)NativeLibrary.parseVersion((String)VERSIONS[i]), (double)1.0E-7);
        }
    }

    public void testGetProcess() {
        if (Platform.isAndroid()) {
            NativeLibraryTest.fail((String)"dlopen(NULL) segfaults on Android");
        }
        NativeLibrary process = NativeLibrary.getProcess();
        process.getFunction("printf");
    }

    private String expected(String f) {
        return new File(f).exists() ? f : null;
    }

    public void testMatchFramework() {
        if (!Platform.isMac()) {
            return;
        }
        String[][] MAPPINGS = new String[][]{{"QtCore", this.expected("/Library/Frameworks/QtCore.framework/QtCore")}, {"Adobe AIR", this.expected("/Library/Frameworks/Adobe AIR.framework/Adobe AIR")}, {"QuickTime", this.expected("/System/Library/Frameworks/QuickTime.framework/QuickTime")}, {"QuickTime.framework/Versions/Current/QuickTime", this.expected("/System/Library/Frameworks/QuickTime.framework/Versions/Current/QuickTime")}};
        for (int i = 0; i < MAPPINGS.length; ++i) {
            NativeLibraryTest.assertEquals((String)"Wrong framework mapping", (String)MAPPINGS[i][1], (String)NativeLibrary.matchFramework((String)MAPPINGS[i][0]));
        }
    }

    public void testLoadLibraryWithOptions() {
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("open-flags", new Integer(-1));
        Native.loadLibrary((String)"testlib", TestLibrary.class, options);
    }

    public void testEmbeddedLibrary() {
        Native.loadLibrary((String)"embedded-testlib", TestLibrary.class);
    }

    public static void main(String[] args) {
        TestRunner.run(NativeLibraryTest.class);
    }

    public static interface TestLibrary
    extends Library {
        public int callCount();
    }
}

