/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.DirectTest;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import junit.framework.TestCase;

public class PerformanceTest
extends TestCase {
    private static final String BUILDDIR = System.getProperty("jna.builddir", "build" + (Platform.is64Bit() ? "-d64" : ""));

    public void testEmpty() {
    }

    public static void main(String[] argList) {
        PerformanceTest.checkPerformance();
    }

    public static void checkPerformance() {
        int i;
        int i2;
        int i3;
        long jresult;
        int iresult;
        int i4;
        int i5;
        int i6;
        int i7;
        double INPUT;
        long argv;
        long resp;
        long cif;
        int i8;
        double dresult;
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        int COUNT = 100000;
        System.out.println("Checking performance of different access methods (100000 iterations)");
        int SIZE = 8192;
        ByteBuffer b = ByteBuffer.allocateDirect(8192);
        b.order(ByteOrder.nativeOrder());
        Pointer pb = Native.getDirectBufferPointer((Buffer)b);
        String mname = Platform.MATH_LIBRARY_NAME;
        MathInterface mlib = (MathInterface)Native.loadLibrary((String)mname, MathInterface.class);
        Function f = NativeLibrary.getInstance((String)mname).getFunction("cos");
        Object[] args = new Object[]{new Double(0.0)};
        long start = System.currentTimeMillis();
        for (int i9 = 0; i9 < 100000; ++i9) {
            dresult = mlib.cos(0.0);
        }
        long delta = System.currentTimeMillis() - start;
        System.out.println("cos (JNA interface): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i8 = 0; i8 < 100000; ++i8) {
            dresult = f.invokeDouble(args);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("cos (JNA function): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i8 = 0; i8 < 100000; ++i8) {
            dresult = MathLibrary.cos(0.0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("cos (JNA direct): " + delta + "ms");
        long types = pb.peer;
        if (Native.POINTER_SIZE == 4) {
            b.putInt(0, (int)Structure.FFIType.get(Double.TYPE).peer);
            cif = Native.ffi_prep_cif((int)0, (int)1, (long)Structure.FFIType.get(Double.TYPE).peer, (long)types);
            resp = pb.peer + 4L;
            argv = pb.peer + 12L;
            INPUT = 42.0;
            start = System.currentTimeMillis();
            for (i7 = 0; i7 < 100000; ++i7) {
                b.putInt(12, (int)pb.peer + 16);
                b.putDouble(16, INPUT);
                Native.ffi_call((long)cif, (long)f.peer, (long)resp, (long)argv);
                dresult = b.getDouble(4);
            }
            delta = System.currentTimeMillis() - start;
        } else {
            b.putLong(0, Structure.FFIType.get(Double.TYPE).peer);
            cif = Native.ffi_prep_cif((int)0, (int)1, (long)Structure.FFIType.get(Double.TYPE).peer, (long)types);
            resp = pb.peer + 8L;
            argv = pb.peer + 16L;
            INPUT = 42.0;
            start = System.currentTimeMillis();
            for (i7 = 0; i7 < 100000; ++i7) {
                b.putLong(16, pb.peer + 24L);
                b.putDouble(24, INPUT);
                Native.ffi_call((long)cif, (long)f.peer, (long)resp, (long)argv);
                dresult = b.getDouble(8);
            }
            delta = System.currentTimeMillis() - start;
        }
        System.out.println("cos (JNI ffi): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i6 = 0; i6 < 100000; ++i6) {
            dresult = JNI.cos(0.0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("cos (JNI): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i6 = 0; i6 < 100000; ++i6) {
            dresult = Math.cos(0.0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("cos (pure java): " + delta + "ms");
        String cname = Platform.C_LIBRARY_NAME;
        CInterface clib = (CInterface)Native.loadLibrary((String)cname, CInterface.class);
        start = System.currentTimeMillis();
        for (i5 = 0; i5 < 100000; ++i5) {
            Pointer presult = clib.memset(null, 0, 0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("memset (JNA interface): " + delta + "ms");
        f = NativeLibrary.getInstance((String)cname).getFunction("memset");
        args = new Object[]{null, new Integer(0), new Integer(0)};
        start = System.currentTimeMillis();
        for (i5 = 0; i5 < 100000; ++i5) {
            Pointer presult = f.invokePointer(args);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("memset (JNA function): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i5 = 0; i5 < 100000; ++i5) {
            Pointer presult = CLibrary.memset((Pointer)null, 0, new CLibrary.size_t(0L));
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("memset (JNA direct Pointer/size_t): " + delta + "ms");
        start = System.currentTimeMillis();
        if (Native.POINTER_SIZE == 4) {
            for (i5 = 0; i5 < 100000; ++i5) {
                Pointer presult = CLibrary.memset((Pointer)null, 0, 0);
            }
        } else {
            for (i5 = 0; i5 < 100000; ++i5) {
                Pointer presult = CLibrary.memset((Pointer)null, 0, 0L);
            }
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("memset (JNA direct Pointer/primitive): " + delta + "ms");
        start = System.currentTimeMillis();
        if (Native.POINTER_SIZE == 4) {
            for (i4 = 0; i4 < 100000; ++i4) {
                iresult = CLibrary.memset(0, 0, 0);
            }
        } else {
            for (i4 = 0; i4 < 100000; ++i4) {
                jresult = CLibrary.memset(0L, 0, 0L);
            }
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("memset (JNA direct primitives): " + delta + "ms");
        if (Native.POINTER_SIZE == 4) {
            b.putInt(0, (int)Structure.FFIType.get(Pointer.class).peer);
            b.putInt(4, (int)Structure.FFIType.get(Integer.TYPE).peer);
            b.putInt(8, (int)Structure.FFIType.get(Integer.TYPE).peer);
            cif = Native.ffi_prep_cif((int)0, (int)3, (long)Structure.FFIType.get(Pointer.class).peer, (long)types);
            resp = pb.peer + 12L;
            argv = pb.peer + 16L;
            start = System.currentTimeMillis();
            for (i4 = 0; i4 < 100000; ++i4) {
                b.putInt(16, (int)pb.peer + 28);
                b.putInt(20, (int)pb.peer + 32);
                b.putInt(24, (int)pb.peer + 36);
                b.putInt(28, 0);
                b.putInt(32, 0);
                b.putInt(36, 0);
                Native.ffi_call((long)cif, (long)f.peer, (long)resp, (long)argv);
                b.getInt(12);
            }
            delta = System.currentTimeMillis() - start;
        } else {
            b.putLong(0, Structure.FFIType.get(Pointer.class).peer);
            b.putLong(8, Structure.FFIType.get(Integer.TYPE).peer);
            b.putLong(16, Structure.FFIType.get(Long.TYPE).peer);
            cif = Native.ffi_prep_cif((int)0, (int)3, (long)Structure.FFIType.get(Pointer.class).peer, (long)types);
            resp = pb.peer + 24L;
            argv = pb.peer + 32L;
            start = System.currentTimeMillis();
            for (i4 = 0; i4 < 100000; ++i4) {
                b.putLong(32, pb.peer + 56L);
                b.putLong(40, pb.peer + 64L);
                b.putLong(48, pb.peer + 72L);
                b.putLong(56, 0L);
                b.putInt(64, 0);
                b.putLong(72, 0L);
                Native.ffi_call((long)cif, (long)f.peer, (long)resp, (long)argv);
                b.getLong(24);
            }
            delta = System.currentTimeMillis() - start;
        }
        System.out.println("memset (JNI ffi): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i4 = 0; i4 < 100000; ++i4) {
            Native.setMemory((long)0L, (long)0L, (byte)0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("memset (JNI): " + delta + "ms");
        String str = "performance test";
        start = System.currentTimeMillis();
        for (i3 = 0; i3 < 100000; ++i3) {
            iresult = clib.strlen(str);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("strlen (JNA interface): " + delta + "ms");
        f = NativeLibrary.getInstance((String)cname).getFunction("strlen");
        args = new Object[]{str};
        start = System.currentTimeMillis();
        for (i3 = 0; i3 < 100000; ++i3) {
            iresult = f.invokeInt(args);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("strlen (JNA function): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i3 = 0; i3 < 100000; ++i3) {
            iresult = CLibrary.strlen(str);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("strlen (JNA direct - String): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i3 = 0; i3 < 100000; ++i3) {
            iresult = CLibrary.strlen(new NativeString(str).getPointer());
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("strlen (JNA direct - Pointer): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i3 = 0; i3 < 100000; ++i3) {
            iresult = CLibrary.strlen(Native.toByteArray((String)str));
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("strlen (JNA direct - byte[]): " + delta + "ms");
        start = System.currentTimeMillis();
        for (i3 = 0; i3 < 100000; ++i3) {
            byte[] bytes = str.getBytes();
            b.position(0);
            b.put(bytes);
            b.put((byte)0);
            iresult = CLibrary.strlen(b);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("strlen (JNA direct - Buffer): " + delta + "ms");
        if (Native.POINTER_SIZE == 4) {
            b.putInt(0, (int)Structure.FFIType.get(Pointer.class).peer);
            cif = Native.ffi_prep_cif((int)0, (int)1, (long)Structure.FFIType.get(Integer.TYPE).peer, (long)types);
            resp = pb.peer + 4L;
            argv = pb.peer + 8L;
            start = System.currentTimeMillis();
            for (i3 = 0; i3 < 100000; ++i3) {
                b.putInt(8, (int)pb.peer + 12);
                b.putInt(12, (int)pb.peer + 16);
                b.position(16);
                b.put(str.getBytes());
                b.put((byte)0);
                Native.ffi_call((long)cif, (long)f.peer, (long)resp, (long)argv);
                iresult = b.getInt(4);
            }
            delta = System.currentTimeMillis() - start;
        } else {
            b.putLong(0, Structure.FFIType.get(Pointer.class).peer);
            cif = Native.ffi_prep_cif((int)0, (int)1, (long)Structure.FFIType.get(Long.TYPE).peer, (long)types);
            resp = pb.peer + 8L;
            argv = pb.peer + 16L;
            start = System.currentTimeMillis();
            for (i3 = 0; i3 < 100000; ++i3) {
                b.putLong(16, pb.peer + 24L);
                b.putLong(24, pb.peer + 32L);
                b.position(32);
                b.put(str.getBytes());
                b.put((byte)0);
                Native.ffi_call((long)cif, (long)f.peer, (long)resp, (long)argv);
                jresult = b.getLong(8);
            }
            delta = System.currentTimeMillis() - start;
        }
        System.out.println("strlen (JNI ffi): " + delta + "ms");
        byte[] bulk = new byte[8192];
        start = System.currentTimeMillis();
        for (i2 = 0; i2 < 100000; ++i2) {
            b.putInt(0, 0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("direct Buffer write: " + delta + "ms");
        start = System.currentTimeMillis();
        for (i2 = 0; i2 < 100000; ++i2) {
            b.position(0);
            b.put(bulk);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("direct Buffer write (bulk): " + delta + "ms");
        Memory p = new Memory(8192L);
        start = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            p.setInt(0L, 0);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("Memory write: " + delta + "ms");
        start = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            p.write(0L, bulk, 0, bulk.length);
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("Memory write (bulk): " + delta + "ms");
        DirectTest.TestInterface tlib = (DirectTest.TestInterface)Native.loadLibrary((String)"testlib", DirectTest.TestInterface.class);
        start = System.currentTimeMillis();
        DirectTest.TestInterface.Int32Callback cb = new DirectTest.TestInterface.Int32Callback(){

            public int invoke(int arg1, int arg2) {
                return arg1 + arg2;
            }
        };
        tlib.callInt32CallbackRepeatedly(cb, 1, 2, 100000);
        delta = System.currentTimeMillis() - start;
        System.out.println("callback (JNA interface): " + delta + "ms");
        tlib = new DirectTest.TestLibrary();
        start = System.currentTimeMillis();
        tlib.callInt32CallbackRepeatedly(cb, 1, 2, 100000);
        delta = System.currentTimeMillis() - start;
        System.out.println("callback (JNA direct): " + delta + "ms");
        start = System.currentTimeMillis();
        DirectTest.TestInterface.NativeLongCallback nlcb = new DirectTest.TestInterface.NativeLongCallback(){

            public NativeLong invoke(NativeLong arg1, NativeLong arg2) {
                return new NativeLong(arg1.longValue() + arg2.longValue());
            }
        };
        tlib.callLongCallbackRepeatedly(nlcb, new NativeLong(1L), new NativeLong(2L), 100000);
        delta = System.currentTimeMillis() - start;
        System.out.println("callback w/NativeMapped (JNA interface): " + delta + "ms");
        tlib = new DirectTest.TestLibrary();
        start = System.currentTimeMillis();
        tlib.callLongCallbackRepeatedly(nlcb, new NativeLong(1L), new NativeLong(2L), 100000);
        delta = System.currentTimeMillis() - start;
        System.out.println("callback w/NativeMapped (JNA direct): " + delta + "ms");
    }

    static interface CInterface
    extends Library {
        public Pointer memset(Pointer var1, int var2, int var3);

        public int strlen(String var1);
    }

    static class CLibrary {
        CLibrary() {
        }

        public static native Pointer memset(Pointer var0, int var1, size_t var2);

        public static native Pointer memset(Pointer var0, int var1, int var2);

        public static native Pointer memset(Pointer var0, int var1, long var2);

        public static native long memset(long var0, int var2, long var3);

        public static native int memset(int var0, int var1, int var2);

        public static native int strlen(String var0);

        public static native int strlen(Pointer var0);

        public static native int strlen(byte[] var0);

        public static native int strlen(Buffer var0);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }

        public static class size_t
        extends IntegerType {
            public size_t() {
                super(Native.POINTER_SIZE);
            }

            public size_t(long value) {
                super(Native.POINTER_SIZE, value);
            }
        }
    }

    static interface MathInterface
    extends Library {
        public double cos(double var1);
    }

    static class MathLibrary {
        MathLibrary() {
        }

        public static native double cos(double var0);

        static {
            Native.register((String)Platform.MATH_LIBRARY_NAME);
        }
    }

    private static class JNI {
        private JNI() {
        }

        private static native double cos(double var0);

        static {
            String path = BUILDDIR + "/native/" + System.mapLibraryName("testlib");
            if (!new File(path).isAbsolute()) {
                path = System.getProperty("user.dir") + "/" + path;
            }
            if (path.endsWith(".jnilib")) {
                path = path.replace(".jnilib", ".dylib");
            }
            System.load(path);
        }
    }
}

