/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class StructureByValueTest
extends TestCase {
    TestLibrary lib;
    final long MAGIC = 81985529216486895L;

    public static void main(String[] argList) {
        TestRunner.run(StructureByValueTest.class);
    }

    public void testNativeMappedInByValue() {
        new TestNativeMappedInStructure.ByValue();
    }

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testStructureArgByValue8() {
        ByValue8 data = new ByValue8();
        int DATA = -17;
        data.data = (byte)-17;
        StructureByValueTest.assertEquals((String)"Failed to pass 8-bit struct by value", (byte)-17, (byte)this.lib.testStructureByValueArgument8(data));
    }

    public void testStructureArgByValue16() {
        ByValue16 data = new ByValue16();
        int DATA = -12817;
        data.data = (short)-12817;
        StructureByValueTest.assertEquals((String)"Failed to pass 16-bit struct by value", (short)-12817, (short)this.lib.testStructureByValueArgument16(data));
    }

    public void testStructureArgByValue32() {
        ByValue32 data = new ByValue32();
        int DATA = -1985229329;
        data.data = -1985229329;
        StructureByValueTest.assertEquals((String)"Failed to pass 32-bit struct by value", (int)-1985229329, (int)this.lib.testStructureByValueArgument32(data));
    }

    public void testStructureArgByValue64() {
        ByValue64 data = new ByValue64();
        long DATA = 81985529216486895L;
        data.data = 81985529216486895L;
        StructureByValueTest.assertEquals((String)"Failed to pass 64-bit struct by value", (long)81985529216486895L, (long)this.lib.testStructureByValueArgument64(data));
    }

    public void testStructureArgByValue128() {
        ByValue128 data = new ByValue128();
        long DATA = 81985529216486895L;
        data.data = 81985529216486895L;
        data.data1 = 81985529216486895L;
        StructureByValueTest.assertEquals((String)"Failed to pass 128-bit struct by value", (long)163971058432973790L, (long)this.lib.testStructureByValueArgument128(data));
    }

    public static class ByValue128
    extends ByValueStruct {
        public long data;
        public long data1;

        protected List getFieldOrder() {
            return Arrays.asList("data", "data1");
        }
    }

    public static class ByValue64
    extends ByValueStruct {
        public long data;

        protected List getFieldOrder() {
            return Arrays.asList("data");
        }
    }

    public static class ByValue32
    extends ByValueStruct {
        public int data;

        protected List getFieldOrder() {
            return Arrays.asList("data");
        }
    }

    public static class ByValue16
    extends ByValueStruct {
        public short data;

        protected List getFieldOrder() {
            return Arrays.asList("data");
        }
    }

    public static class ByValue8
    extends ByValueStruct {
        public byte data;

        protected List getFieldOrder() {
            return Arrays.asList("data");
        }
    }

    public static abstract class ByValueStruct
    extends Structure
    implements Structure.ByValue {
    }

    public static interface TestLibrary
    extends Library {
        public byte testStructureByValueArgument8(ByValue8 var1);

        public short testStructureByValueArgument16(ByValue16 var1);

        public int testStructureByValueArgument32(ByValue32 var1);

        public long testStructureByValueArgument64(ByValue64 var1);

        public long testStructureByValueArgument128(ByValue128 var1);
    }

    public static class TestNativeMappedInStructure
    extends Structure {
        public NativeLong field;

        protected List getFieldOrder() {
            return Arrays.asList("field");
        }

        public static class ByValue
        extends TestNativeMappedInStructure
        implements Structure.ByValue {
        }
    }
}

