/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text;

import clover.com.lowagie.text.Cell;
import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.ElementListener;
import clover.com.lowagie.text.MarkupAttributes;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Row
implements Element,
MarkupAttributes {
    public static final int NULL = 0;
    public static final int CELL = 1;
    public static final int TABLE = 2;
    protected int columns;
    protected int currentColumn;
    protected boolean[] reserved;
    protected Object[] cells;
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected Properties markupAttributes;
    static /* synthetic */ Class class$com$lowagie$text$Cell;
    static /* synthetic */ Class class$com$lowagie$text$Table;

    protected Row(int n) {
        this.columns = n;
        this.reserved = new boolean[n];
        this.cells = new Object[n];
        this.currentColumn = 0;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 21;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    void deleteColumn(int n) {
        if (n >= this.columns || n < 0) {
            throw new IndexOutOfBoundsException("getCell at illegal index : " + n);
        }
        --this.columns;
        boolean[] blArray = new boolean[this.columns];
        Cell[] cellArray = new Cell[this.columns];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = this.reserved[n2];
            cellArray[n2] = this.cells[n2];
            if (cellArray[n2] != null && n2 + cellArray[n2].colspan() > n) {
                cellArray[n2].setColspan(((Cell)this.cells[n2]).colspan() - 1);
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < this.columns) {
            blArray[n3] = this.reserved[n3 + 1];
            cellArray[n3] = this.cells[n3 + 1];
            ++n3;
        }
        if (this.cells[n] != null && ((Cell)this.cells[n]).colspan() > 1) {
            cellArray[n] = this.cells[n];
            cellArray[n].setColspan(cellArray[n].colspan() - 1);
        }
        this.reserved = blArray;
        this.cells = cellArray;
    }

    int addElement(Object object) {
        return this.addElement(object, this.currentColumn);
    }

    int addElement(Object object, int n) {
        int n2;
        if (object == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (n < 0 || n > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.getObjectID(object) != 1 && this.getObjectID(object) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        int n3 = n2 = (class$com$lowagie$text$Cell == null ? (class$com$lowagie$text$Cell = Row.class$("clover.com.lowagie.text.Cell")) : class$com$lowagie$text$Cell).isInstance(object) ? ((Cell)object).colspan() : 1;
        if (!this.reserve(n, n2)) {
            return -1;
        }
        this.cells[n] = object;
        this.currentColumn += n2 - 1;
        return n;
    }

    void setElement(Object object, int n) {
        if (this.reserved[n]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[n] = object;
        if (object != null) {
            this.reserved[n] = true;
        }
    }

    boolean reserve(int n) {
        return this.reserve(n, 1);
    }

    boolean reserve(int n, int n2) {
        if (n < 0 || n + n2 > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        int n3 = n;
        while (n3 < n + n2) {
            if (this.reserved[n3]) {
                int n4 = n3;
                while (n4 >= n) {
                    this.reserved[n3] = false;
                    --n4;
                }
                return false;
            }
            this.reserved[n3] = true;
            ++n3;
        }
        return true;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    boolean isReserved(int n) {
        return this.reserved[n];
    }

    int getElementID(int n) {
        if (this.cells[n] == null) {
            return 0;
        }
        if ((class$com$lowagie$text$Cell == null ? (class$com$lowagie$text$Cell = Row.class$("clover.com.lowagie.text.Cell")) : class$com$lowagie$text$Cell).isInstance(this.cells[n])) {
            return 1;
        }
        if ((class$com$lowagie$text$Table == null ? (class$com$lowagie$text$Table = Row.class$("clover.com.lowagie.text.Table")) : class$com$lowagie$text$Table).isInstance(this.cells[n])) {
            return 2;
        }
        return -1;
    }

    int getObjectID(Object object) {
        if (object == null) {
            return 0;
        }
        if ((class$com$lowagie$text$Cell == null ? (class$com$lowagie$text$Cell = Row.class$("clover.com.lowagie.text.Cell")) : class$com$lowagie$text$Cell).isInstance(object)) {
            return 1;
        }
        if ((class$com$lowagie$text$Table == null ? (class$com$lowagie$text$Table = Row.class$("clover.com.lowagie.text.Table")) : class$com$lowagie$text$Table).isInstance(object)) {
            return 2;
        }
        return -1;
    }

    public Object getCell(int n) {
        if (n < 0 || n > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + n + " max is " + this.columns);
        }
        return this.cells[n];
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.columns) {
            if (this.cells[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    int validPosition() {
        return this.currentColumn;
    }

    public int columns() {
        return this.columns;
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }

    public static boolean isTag(String string) {
        return "row".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

