/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.TestDetector;
import com.cenqua.clover.util.FilterUtils;
import java.io.File;
import java.util.Map;

public class AntPatternTestDetectorFilter
implements TestDetector {
    final String[] includeFilter;
    final String[] excludeFilter;
    private final String projectRoot;

    public AntPatternTestDetectorFilter(String projectRoot, String[] includeFilter, String[] excludeFilter) {
        this.includeFilter = includeFilter;
        this.excludeFilter = excludeFilter;
        this.projectRoot = projectRoot.endsWith("/") ? projectRoot : projectRoot + '/';
    }

    public boolean isClassMatch(InstrumentationState state, Map tags, Modifiers mods, String pkgName, String classname, String superclass) {
        return this.matchesPattern(state.getFileInfo().getPhyscialFile());
    }

    public boolean isMethodMatch(InstrumentationState state, MethodSignature sig) {
        return this.matchesPattern(state.getFileInfo().getPhyscialFile());
    }

    private boolean matchesPattern(File file) {
        String path = file.getPath();
        String relative = path.startsWith(this.projectRoot) ? path.substring(this.projectRoot.length()) : path;
        return FilterUtils.isIncluded(relative, this.excludeFilter, this.includeFilter, false);
    }
}

