/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StackTraceInfo;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FileInfo
extends BaseFileInfo
implements HasMetricsNode,
CoverageDataReceptor {
    private static final long serialVersionUID = 6165742860254131358L;
    public static final long NO_VERSION = -1L;
    private File actualFile;
    protected int dataIndex;
    private int dataLength;
    private long minVersion;
    private long maxVersion;
    private transient List orderedClasses;
    private transient LineInfo[] lineInfo;
    private transient Comparator orderby;
    private transient CoverageDataProvider data;
    private transient Map failStackInfos;

    public FileInfo(PackageInfo containingPackage, File actualFile, String encoding, int dataIndex, int lineCount, int nCLinecount, long timestamp, long filesize, long checksum, long minVersion) {
        super(containingPackage, actualFile.getName(), encoding, lineCount, nCLinecount, timestamp, filesize, checksum);
        this.name = actualFile.getName();
        this.actualFile = actualFile;
        this.encoding = encoding;
        this.containingPackage = containingPackage;
        this.dataIndex = dataIndex;
        this.lineCount = lineCount;
        this.ncLinecount = nCLinecount;
        this.timestamp = timestamp;
        this.filesize = filesize;
        this.checksum = checksum;
        this.minVersion = this.maxVersion = minVersion;
    }

    public File getPhyscialFile() {
        return this.actualFile;
    }

    public boolean validatePhysicalFile() {
        if (this.actualFile.exists()) {
            try {
                return FileUtils.calcAdlerChecksum(this.getPhyscialFile(), this.getEncoding()) == this.getChecksum();
            }
            catch (IOException e) {
                Logger.getInstance().warn("IOException calculating file checksum for " + this.actualFile, e);
            }
        }
        return false;
    }

    public Set getSourceRegions() {
        TreeSet regions = new TreeSet(SourceRegion.SOURCE_ORDER_COMP);
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            classInfo.gatherSourceRegions(regions);
        }
        return regions;
    }

    public LineInfo[] getLineInfo() {
        if (this.lineInfo == null) {
            final LineInfo[] tmpLineInfo = new LineInfo[this.getLineCount() + 1];
            this.visitElements(new FileElementVisitor(){

                private LineInfo getOrCreateLineInfo(SourceRegion r) {
                    if (tmpLineInfo[r.getStartLine()] == null) {
                        tmpLineInfo[r.getStartLine()] = new LineInfo(r.getStartLine());
                    }
                    return tmpLineInfo[r.getStartLine()];
                }

                public void visitClass(ClassInfo info) {
                    this.getOrCreateLineInfo(info).addClassStart(info);
                }

                public void visitMethod(MethodInfo info) {
                    this.getOrCreateLineInfo(info).addMethodStart(info);
                }

                public void visitStatement(StatementInfo info) {
                    this.getOrCreateLineInfo(info).addStatement(info);
                }

                public void visitBranch(BranchInfo info) {
                    this.getOrCreateLineInfo(info).addBranch(info);
                }
            });
            if (this.failStackInfos != null) {
                Iterator iterator = this.failStackInfos.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    int line = (Integer)entry.getKey();
                    List stackFrames = (List)entry.getValue();
                    if (line <= 0 || line >= tmpLineInfo.length) continue;
                    if (tmpLineInfo[line] == null) {
                        tmpLineInfo[line] = new LineInfo(line);
                    }
                    tmpLineInfo[line].setFailStackEntries(stackFrames.toArray(new StackTraceInfo.TraceEntry[stackFrames.size()]));
                }
            }
            this.lineInfo = tmpLineInfo;
        }
        return this.lineInfo;
    }

    public void visitElements(FileElementVisitor visitor) {
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            classInfo.visitElements(visitor);
        }
    }

    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingPackage().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingPackage().getContextFilter();
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    public void resolve(Path path) {
        File resolved = path.resolveFile(this.getPackagePath());
        if (resolved != null) {
            this.actualFile = resolved;
        }
    }

    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            classInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    public void setDataIndex(int dataIndex) {
        this.dataIndex = dataIndex;
    }

    public int getDataIndex() {
        return this.dataIndex;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void addVersion(long version) {
        if (this.minVersion == -1L) {
            this.minVersion = version;
        }
        this.maxVersion = Math.max(version, this.maxVersion);
    }

    public void addVersions(long minVersion, long maxVersion) {
        if (this.minVersion == -1L) {
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        } else {
            this.minVersion = Math.min(this.minVersion, minVersion);
            this.maxVersion = Math.max(this.maxVersion, maxVersion);
        }
    }

    public boolean supportsVersion(long version) {
        return version <= this.maxVersion && version >= this.minVersion;
    }

    public long getMinVersion() {
        return this.minVersion;
    }

    public long getMaxVersion() {
        return this.maxVersion;
    }

    public void resetVersions(long version) {
        this.minVersion = this.maxVersion = version;
    }

    public boolean changedFrom(long checksum, long filesize) {
        return this.getChecksum() != checksum || this.getFilesize() != filesize;
    }

    public String getChildType() {
        return "class";
    }

    public int getNumChildren() {
        return this.classes.size();
    }

    public HasMetricsNode getChild(int i) {
        if (this.orderedClasses == null) {
            this.buildOrderedClassList();
        }
        return (HasMetricsNode)this.orderedClasses.get(i);
    }

    public int getIndexOfChild(HasMetricsNode child) {
        if (this.orderedClasses == null) {
            this.buildOrderedClassList();
        }
        return this.orderedClasses.indexOf(child);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.orderedClasses = null;
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            classInfo.setComparator(cmp);
        }
    }

    private void buildOrderedClassList() {
        ArrayList tmpOrderedClasses = new ArrayList(this.classes.values());
        if (this.orderby != null) {
            Collections.sort(tmpOrderedClasses, this.orderby);
        } else {
            Collections.sort(tmpOrderedClasses, SourceRegion.SOURCE_ORDER_COMP);
        }
        this.orderedClasses = tmpOrderedClasses;
    }

    private FileMetrics calcMetrics(boolean filtered) {
        FileMetrics fileMetrics = new FileMetrics(this);
        fileMetrics.setLineCount(this.lineCount);
        fileMetrics.setNcLineCount(this.ncLinecount);
        int numClasses = 0;
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            if (!filtered) {
                fileMetrics.add((ClassMetrics)classInfo.getRawMetrics());
            } else {
                fileMetrics.add((ClassMetrics)classInfo.getMetrics());
            }
            ++numClasses;
        }
        fileMetrics.setNumClasses(numClasses);
        return fileMetrics;
    }

    public FileInfo copy(PackageInfo pkg, HasMetricsFilter filter) {
        FileInfo file = new FileInfo(pkg, this.actualFile, this.encoding, this.dataIndex, this.lineCount, this.ncLinecount, this.timestamp, this.filesize, this.checksum, this.minVersion);
        file.addVersion(this.maxVersion);
        file.setDataProvider(this.getDataProvider());
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            if (!filter.accept(classInfo)) continue;
            file.addClass(classInfo.copy(file, filter));
        }
        file.setDataLength(this.getDataLength());
        if (this.failStackInfos != null) {
            file.setFailStackEntries(this.failStackInfos);
        }
        return file;
    }

    public Set getUniqueFailingTests() {
        HashSet<TestCaseInfo> tests = null;
        if (this.failStackInfos != null) {
            tests = new HashSet<TestCaseInfo>();
            Iterator it = this.failStackInfos.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                List entries = (List)entry.getValue();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    StackTraceInfo.TraceEntry traceEntry = (StackTraceInfo.TraceEntry)iterator.next();
                    tests.add(traceEntry.getParentTrace().getOriginatingTest());
                }
            }
        }
        return tests;
    }

    public Map getFailStackEntries() {
        return this.failStackInfos;
    }

    public void setFailStackEntries(Map entries) {
        this.failStackInfos = new TreeMap(entries);
    }

    public void addFailStackEntry(int lineNum, StackTraceInfo.TraceEntry traceEntry) {
        Integer lineKey;
        ArrayList<StackTraceInfo.TraceEntry> tracesForLine;
        if (this.failStackInfos == null) {
            this.failStackInfos = new TreeMap();
        }
        if ((tracesForLine = (ArrayList<StackTraceInfo.TraceEntry>)this.failStackInfos.get(lineKey = new Integer(lineNum))) == null) {
            tracesForLine = new ArrayList<StackTraceInfo.TraceEntry>();
            this.failStackInfos.put(lineKey, tracesForLine);
        }
        tracesForLine.add(traceEntry);
    }
}

