/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PackageFragment
implements HasMetricsNode {
    private ProjectInfo containingProject;
    private PackageFragment parent;
    private List orderedKids;
    private Map children;
    private BlockMetrics rawMetrics;
    private BlockMetrics metrics;
    private PackageInfo concretePackage;
    private String qualifiedName;
    private String name;
    private Comparator orderby;

    public PackageFragment(PackageFragment parent, ProjectInfo containingProject, String fqn, String name) {
        this.parent = parent;
        this.containingProject = containingProject;
        this.qualifiedName = fqn;
        this.name = name;
    }

    void addChild(PackageFragment pkg) {
        if (this.children == null) {
            this.children = new TreeMap();
        }
        this.children.put(pkg.getName(), pkg);
    }

    public PackageFragment[] getChildren() {
        if (this.children != null) {
            return this.children.values().toArray(new PackageFragment[this.children.size()]);
        }
        return new PackageFragment[0];
    }

    public PackageInfo getConcretePackage() {
        return this.concretePackage;
    }

    public void setConcretePackage(PackageInfo concretePackage) {
        this.concretePackage = concretePackage;
    }

    public boolean isConcrete() {
        return this.concretePackage != null;
    }

    public PackageFragment getParent() {
        return this.parent;
    }

    public ProjectInfo getContainingProject() {
        return this.containingProject;
    }

    public String getQualifiedName() {
        return this.isConcrete() ? this.concretePackage.getName() : this.qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return !(this.children != null && this.children.size() != 0 || this.concretePackage != null && !this.concretePackage.isEmpty());
    }

    public BlockMetrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public PackageFragment getChild(String name) {
        if (this.children != null) {
            return (PackageFragment)this.children.get(name);
        }
        return null;
    }

    public String getChildType() {
        return this.isConcrete() ? this.concretePackage.getChildType() : "package";
    }

    public int getNumChildren() {
        int kids = 0;
        if (this.children != null) {
            if (this.orderedKids == null) {
                this.buildOrderedChildList();
            }
            kids += this.orderedKids.size();
        }
        if (this.isConcrete()) {
            kids += this.concretePackage.getNumChildren();
        }
        return kids;
    }

    public HasMetricsNode getChild(int i) {
        int offset = 0;
        if (this.children != null) {
            if (this.orderedKids == null) {
                this.buildOrderedChildList();
            }
            if (i < this.orderedKids.size()) {
                return (HasMetricsNode)this.orderedKids.get(i);
            }
            offset = this.orderedKids.size();
        }
        if (this.isConcrete()) {
            return this.concretePackage.getChild(i - offset);
        }
        return null;
    }

    public int getIndexOfChild(HasMetricsNode child) {
        if (child instanceof PackageFragment && this.children != null) {
            if (this.orderedKids == null) {
                this.buildOrderedChildList();
            }
            return this.orderedKids.indexOf(child);
        }
        if (child instanceof ClassInfo && this.isConcrete()) {
            return this.concretePackage.getIndexOfChild(child);
        }
        return -1;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.orderedKids = null;
    }

    private void buildOrderedChildList() {
        this.orderedKids = new ArrayList(this.children.values());
        if (this.orderby != null) {
            Collections.sort(this.orderedKids, this.orderby);
        }
    }

    private ProjectMetrics calcMetrics(boolean filter) {
        ProjectMetrics metrics = new ProjectMetrics(this);
        if (this.isConcrete()) {
            if (!filter) {
                metrics.add((PackageMetrics)this.concretePackage.getRawMetrics());
            } else {
                metrics.add((PackageMetrics)this.concretePackage.getMetrics());
            }
            metrics.setNumPackages(1);
        }
        if (this.children != null) {
            Iterator kids = this.children.values().iterator();
            while (kids.hasNext()) {
                PackageFragment pkgFrag = (PackageFragment)kids.next();
                if (!filter) {
                    metrics.add((ProjectMetrics)pkgFrag.getRawMetrics());
                    continue;
                }
                metrics.add((ProjectMetrics)pkgFrag.getMetrics());
            }
        }
        return metrics;
    }
}

