/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import clover.gnu.cajo.invoke.Remote;
import clover.gnu.cajo.utils.ItemServer;
import clover.gnu.cajo.utils.extra.ClientProxy;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import com.cenqua.clover.Logger;
import com.cenqua.clover.remote.Config;
import com.cenqua.clover.remote.DistributedConfig;
import com.cenqua.clover.remote.RecorderService;
import com.cenqua.clover.remote.RpcMessage;
import com.cenqua.clover.util.Formatting;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import java.util.List;

public class CajoTcpRecorderService
implements RecorderService {
    private final List<ClientProxy> clientProxies = new CopyOnWriteArrayList();
    private DistributedConfig config;
    private static final int INIT_SLEEP_MILLIS = 500;
    private Remote server;
    static final String REGISTER_CALLBACK = "registerListener";

    public void init(Config config) {
        this.config = (DistributedConfig)config;
    }

    public void start() {
        try {
            Logger.getInstance().debug("About to start service with config: " + this.config);
            Remote.config(this.config.getHost(), this.config.getPort(), null, 0);
            this.server = ItemServer.bind(this, this.config.getName());
            Logger.getInstance().debug("Started coverage service: " + this.config.getName());
            if (this.config.getNumClients() > 0) {
                Logger.getInstance().info("Clover waiting for " + this.config.getNumClients() + " remote clients to attach to this remote testing session. ");
            }
            while (this.clientProxies.size() < this.config.getNumClients()) {
                try {
                    Thread.sleep(500L);
                    Logger.getInstance().debug("Waiting for " + this.config.getNumClients() + " remote VMs " + this.clientProxies.size());
                }
                catch (InterruptedException e) {}
            }
            Logger.getInstance().debug("Recording proceeding now that " + Formatting.pluralizedVal(this.clientProxies.size(), "client") + " are connected.");
        }
        catch (RemoteException e) {
            Logger.getInstance().error("Error starting recorder service: " + this.config, e);
        }
        catch (UnknownHostException e) {
            Logger.getInstance().error("Error starting recorder service: " + this.config, e);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.unexport(true);
            }
            catch (NoSuchObjectException e) {
                Logger.getInstance().info("Error stopping service: " + e.getMessage());
            }
        }
    }

    public Remote registerListener() {
        Logger.getInstance().verbose("registerListener(). proxies: " + this.clientProxies);
        try {
            ClientProxy proxy = new ClientProxy();
            this.clientProxies.add(proxy);
            Logger.getInstance().debug("Accepting connection from client: " + UnicastRemoteObject.getClientHost());
            return new Remote(proxy);
        }
        catch (RemoteException e) {
            Logger.getInstance().error("Error registering listener.", e);
        }
        catch (ServerNotActiveException e) {
            Logger.getInstance().error("Error registering listener.", e);
        }
        return null;
    }

    public Object sendMessage(RpcMessage message) {
        int numClients = this.invokeAllClients(message.getName(), message.getMethodArgs());
        Logger.getInstance().debug("Invoked method " + message.getName() + " on " + numClients + " remote clients.");
        return new Integer(numClients);
    }

    private int invokeAllClients(String methodName, Object parameters) {
        int numSuccess = 0;
        Iterator<ClientProxy> iterator = this.clientProxies.iterator();
        while (iterator.hasNext()) {
            ClientProxy rec = iterator.next();
            rec.timeout = this.config.getTimeout();
            try {
                rec.remoteThis.invoke(methodName, parameters);
                ++numSuccess;
            }
            catch (Exception e) {
                Logger.getInstance().warn(" Error occured during a remote flush to: " + methodName + " on " + rec.remoteThis + ". message: " + e.getMessage() + " - " + e, e);
                this.clientProxies.remove(rec);
            }
        }
        return numSuccess;
    }

    public int getNumRegisteredListeners() {
        return this.clientProxies.size();
    }
}

