/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.instr.TestDetector;
import com.cenqua.clover.instr.TestSourceMatcher;
import com.cenqua.clover.spec.instr.test.AndSpec;
import com.cenqua.clover.spec.instr.test.BooleanSpec;
import com.cenqua.clover.spec.instr.test.OrSpec;
import com.cenqua.clover.spec.instr.test.TestClassSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class TestSourceSet
extends FileSet
implements TestSourceMatcher {
    private TestDetector testDetector;
    private Set includedFiles = null;
    private Set excludedFiles = null;
    private BooleanSpec defaultBoolSpec = new OrSpec();
    private List boolSpecs = null;

    public void addConfiguredTestClass(TestClassSpec testClassSpec) {
        this.initBoolSpecs();
        if (!this.boolSpecs.contains(this.defaultBoolSpec)) {
            this.boolSpecs.add(this.defaultBoolSpec);
        }
        this.defaultBoolSpec.addConfiguredTestClass(testClassSpec);
    }

    public void addConfiguredOr(OrSpec or) {
        this.initBoolSpecs();
        this.boolSpecs.add(or);
    }

    public void addConfiguredAnd(AndSpec and) {
        this.initBoolSpecs();
        this.boolSpecs.add(and);
    }

    private void initBoolSpecs() {
        if (this.boolSpecs == null) {
            this.boolSpecs = new ArrayList();
        }
    }

    public void validate() throws BuildException {
        this.buildTestDetector();
    }

    public Set getIncludedFiles() {
        this.maybeBuildFileSets();
        return new HashSet(this.includedFiles);
    }

    public Set getExcludedFiles() {
        this.maybeBuildFileSets();
        return new HashSet(this.excludedFiles);
    }

    public boolean matchesFile(File f) {
        this.maybeBuildFileSets();
        return this.includedFiles.contains(f);
    }

    public TestDetector getDetector() {
        return this.testDetector;
    }

    private void buildTestDetector() {
        try {
            this.testDetector = BooleanSpec.buildTestDetectorFor(this.boolSpecs);
        }
        catch (CloverException e) {
            throw new BuildException(e.getMessage());
        }
    }

    private void maybeBuildFileSets() {
        if (this.includedFiles == null) {
            HashSet<File> is = new HashSet<File>();
            HashSet<File> es = new HashSet<File>();
            DirectoryScanner ds = this.getDirectoryScanner(this.getProject());
            File baseDir = this.getDir(this.getProject());
            String[] included = ds.getIncludedFiles();
            for (int j = 0; j < included.length; ++j) {
                File testFile = new File(baseDir, included[j]);
                is.add(testFile);
            }
            String[] excluded = ds.getExcludedFiles();
            for (int j = 0; j < excluded.length; ++j) {
                File testFile = new File(baseDir, excluded[j]);
                es.add(testFile);
            }
            this.includedFiles = is;
            this.excludedFiles = es;
        }
    }
}

