/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.MethodInfo;
import java.io.File;
import java.text.DateFormat;
import java.util.Iterator;

public class RegistryDumper {
    private static int indent;
    static /* synthetic */ Class class$com$cenqua$clover$util$RegistryDumper;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            RegistryDumper.printUsage();
        } else {
            Clover2Registry reg = Clover2Registry.fromFile(new File(args[1]));
            if (args[0].equals("pretty")) {
                RegistryDumper.printPretty(reg);
            } else if (args[0].equals("csv")) {
                RegistryDumper.printCSV(reg);
            } else {
                System.err.println("Unknown format");
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage:");
        StringBuffer stringBuffer = new StringBuffer().append("java ");
        Class<?> clazz = class$com$cenqua$clover$util$RegistryDumper;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$util$RegistryDumper = new RegistryDumper[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" pretty|csv database").toString());
    }

    private static void printPretty(Clover2Registry reg) {
        Logger.getInstance().info("Loaded registry at " + reg.getRegistryFile());
        Logger.getInstance().info("Init String: " + reg.getInitString());
        Logger.getInstance().info("Version: " + reg.getVersion());
        Logger.getInstance().info("Current index: " + reg.getCurrentIndex());
        reg.getModel().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Logger.getInstance().info("File " + file.getPackagePath());
                indent++;
                Logger.getInstance().info(RegistryDumper.indent("Encoding: " + file.getEncoding()));
                Logger.getInstance().info(RegistryDumper.indent("Checksum: " + file.getChecksum()));
                Logger.getInstance().info(RegistryDumper.indent("File Size: " + file.getFilesize()));
                Logger.getInstance().info(RegistryDumper.indent("Line Count: " + file.getLineCount()));
                Logger.getInstance().info(RegistryDumper.indent("NC Line Count: " + file.getNcLinecount()));
                Logger.getInstance().info(RegistryDumper.indent("Timestamp: " + DateFormat.getDateTimeInstance().format(new Long(file.getTimestamp()))));
                Logger.getInstance().info(RegistryDumper.indent("Slot Index: " + ((FileInfo)file).getDataIndex()));
                Logger.getInstance().info(RegistryDumper.indent("Slot Length: " + ((FileInfo)file).getDataLength()));
                Logger.getInstance().info(RegistryDumper.indent("Statement count: " + RegistryDumper.statementCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Branch count: " + RegistryDumper.branchCount((FileInfo)file)));
                indent--;
            }
        });
    }

    private static int statementCount(FileInfo fileInfo) {
        int statementCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            MethodInfo[] methods = classInfo.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                statementCount += methods[i].getStatements().length;
            }
        }
        return statementCount;
    }

    private static int branchCount(FileInfo fileInfo) {
        int branchCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            MethodInfo[] methods = classInfo.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                branchCount += methods[i].getBranches().length;
            }
        }
        return branchCount;
    }

    private static String indent(String line) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        return line;
    }

    public static void printCSV(Clover2Registry reg) {
        Logger.getInstance().info("Init String,Version,Current Index");
        Logger.getInstance().info(reg.getInitString() + "," + reg.getVersion() + "," + Integer.toString(reg.getCurrentIndex()) + "\n");
        Logger.getInstance().info("File,Encoding,Checksum,File Size,Line Count,NC Line Count,Timestamp,Slot Index,Slot Length,Statement Count,Branch Count");
        reg.getModel().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Logger.getInstance().info(file.getPackagePath() + "," + file.getEncoding() + "," + file.getChecksum() + "," + file.getFilesize() + "," + file.getLineCount() + "," + file.getNcLinecount() + "," + DateFormat.getDateTimeInstance().format(new Long(file.getTimestamp())) + "," + ((FileInfo)file).getDataIndex() + "," + Integer.toString(((FileInfo)file).getDataLength()) + "," + Integer.toString(RegistryDumper.statementCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.branchCount((FileInfo)file)) + ",");
            }
        });
    }
}

