/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Long;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.RecorderLogging;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.ReadOnlyRegistryException;
import com.cenqua.clover.remote.DistributedClover;
import com.cenqua.clover.remote.RpcMessage;
import com.cenqua.clover.util.CloverUtils;
import com_cenqua_clover.CoverageRecorder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Clover {
    public static final int NO_SLICE = -1;
    private static int currentSlice = -1;
    private static long currentSliceStart = 0L;
    private static String currentType;
    private static int typeID;
    private static int testRunID;
    private static Map typeIDs;
    private static final HashMap RECORDERS;
    private static final Set DB_NAMES;
    private static final CoverageRecorder DUMMY_RECORDER;
    private static DistributedClover DISTRIBUTED_CLOVER;
    static /* synthetic */ Class class$com_cenqua_clover$Clover;

    private Clover() {
    }

    public static void globalFlush() {
        Clover.allRecordersFlush();
    }

    public static int getCurrentSlice() {
        return currentSlice;
    }

    public static String getCurrentType() {
        return currentType;
    }

    public static long getCurrentSliceStart() {
        return currentSliceStart;
    }

    public static int getCurrentTestRunID() {
        return testRunID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoverageRecorder getRecorder(char[] initChars, char[] serverChars, long dbVersion, long cfgbits, int maxDataIndex) {
        String initStr = new String(initChars);
        String recorderKey = initStr + "_" + dbVersion + "_" + cfgbits;
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            DB_NAMES.add(initStr);
            CoverageRecorder recorder = (CoverageRecorder)RECORDERS.get(recorderKey);
            if (recorder != null) {
                Logger.getInstance().debug("[found existing recorder for " + recorderKey + "]");
            } else {
                Logger.getInstance().debug("[creating new recorder for " + recorderKey + "]");
                recorder = Clover.createRecorder(initStr, dbVersion, cfgbits);
                RECORDERS.put(recorderKey, recorder);
                recorder.startRun();
            }
            if (recorder.getNumElements() < maxDataIndex) {
                Logger.getInstance().warn("CLOVER: Clover database: '" + initStr + "' is no longer valid. Required size: " + maxDataIndex + ", actual size: " + recorder.getNumElements());
                Logger.getInstance().warn("CLOVER: No coverage data will be gathered.");
                DUMMY_RECORDER.growToSize(maxDataIndex);
                return DUMMY_RECORDER;
            }
            if (DISTRIBUTED_CLOVER == null) {
                DISTRIBUTED_CLOVER = new DistributedClover();
                DISTRIBUTED_CLOVER.initClientServer(serverChars);
            }
            return recorder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDatabaseNames() {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            return DB_NAMES.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disable() {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.disable();
            }
        }
    }

    public static int getTypeID(String runtimeType) {
        int result;
        Integer val = (Integer)typeIDs.get(runtimeType);
        if (val == null) {
            result = typeID++;
            typeIDs.put(runtimeType, new Integer(result));
        } else {
            result = val;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersFlush() {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.forceFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersSliceStart(String type, int slice, long startTime) {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            currentSlice = slice;
            currentSliceStart = startTime > 0L ? startTime : System.currentTimeMillis();
            currentType = type;
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.sliceStart(type, currentSliceStart, slice, testRunID);
            }
            if (DISTRIBUTED_CLOVER.hasService()) {
                DISTRIBUTED_CLOVER.remoteFlush(new RpcMessage(_Integer.valueOf(1), new Object[]{type, _Integer.valueOf(slice), _Long.valueOf(currentSliceStart)}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersSliceEnd(String type, String method, int slice, int p, ErrorInfo ei) {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            currentSlice = -1;
            long ts = System.currentTimeMillis();
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.sliceEnd(type, method, ts, slice, testRunID, p, ei);
            }
            if (DISTRIBUTED_CLOVER.hasService()) {
                DISTRIBUTED_CLOVER.remoteFlush(new RpcMessage(_Integer.valueOf(2), new Object[]{type, method, _Integer.valueOf(slice), _Integer.valueOf(p), ei}));
            }
            ++testRunID;
        }
    }

    public static CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits) {
        try {
            File infile = Clover.resolveRegistryFile(dbName);
            int numElements = Clover2Registry.readRegistryHeaderAndModeOnly(infile);
            return new CoverageRecorder(infile.getAbsolutePath(), dbVersion, numElements, cfgbits);
        }
        catch (IOException e) {
            Clover.logRecorderCreationFailure(e);
        }
        catch (ReadOnlyRegistryException e) {
            Clover.logRecorderCreationFailure(e);
        }
        return new CoverageRecorder(null, 0L, 500000, cfgbits);
    }

    private static void logRecorderCreationFailure(Exception e) {
        Logger.getInstance().error("CLOVER: Unable to load coverage database.");
        Logger.getInstance().error("CLOVER: No coverage data will be gathered.");
        Logger.getInstance().error("CLOVER: " + e.getClass().getName());
        Logger.getInstance().error("CLOVER: " + e.getMessage());
    }

    private static File resolveRegistryFile(String dbName) {
        try {
            String initStringProp = System.getProperty("clover.initstring");
            if (initStringProp != null && initStringProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring: " + initStringProp);
                return new File(initStringProp);
            }
            String initStringBaseProp = System.getProperty("clover.initstring.basedir");
            if (initStringBaseProp != null && initStringBaseProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring basedir: " + initStringBaseProp);
                File dbFile = new File(dbName);
                return new File(initStringBaseProp, dbFile.getName());
            }
            String initStringPrefixProp = System.getProperty("clover.initstring.prefix");
            if (initStringPrefixProp != null && initStringPrefixProp.length() > 0) {
                Logger.getInstance().verbose("prepending initstring prefix: " + initStringPrefixProp);
                String newInit = initStringPrefixProp + dbName;
                if ((initStringPrefixProp.endsWith("/") || initStringPrefixProp.endsWith("\\")) && (dbName.startsWith("\\") || dbName.startsWith("/"))) {
                    newInit = initStringPrefixProp + dbName.substring(1);
                }
                return new File(newInit);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return new File(dbName);
    }

    public static String getRecordingName(int hash, String dbname, long ts) {
        return dbname + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36);
    }

    public static String getSliceRecordingName(int typeid, int methodID, int runID, int hash, String dbname, long ts) {
        long globalSliceID = (long)typeid << 32 | (long)methodID;
        return dbname + Long.toString(globalSliceID, 36) + "_" + Integer.toString(runID, 36) + "_" + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36) + ".s";
    }

    public static void l(String m) {
        Logger.getInstance().error(m);
    }

    public static void l(String m, Throwable t) {
        Logger.getInstance().error(m, t);
    }

    public static ErrorInfo getErrorInfo(Throwable t) {
        return t == null ? null : new ErrorInfo(t.getMessage(), CloverUtils.stackTraceFor(t));
    }

    static {
        long l = System.currentTimeMillis();
        Class<?> clazz = class$com_cenqua_clover$Clover;
        if (clazz == null) {
            clazz = class$com_cenqua_clover$Clover = new Clover[0].getClass().getComponentType();
        }
        typeID = Math.abs((int)(l + (long)clazz.hashCode()));
        testRunID = 0;
        RecorderLogging.init();
        typeIDs = Collections.synchronizedMap(new HashMap());
        RECORDERS = new HashMap();
        DB_NAMES = new HashSet();
        DUMMY_RECORDER = new CoverageRecorder(null, 0L, 50000, 0L);
        DISTRIBUTED_CLOVER = null;
    }
}

