/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.DLLCallback;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CallbacksTest
extends TestCase {
    private static final double DOUBLE_MAGIC = -118.625;
    private static final float FLOAT_MAGIC = -118.625f;
    TestLibrary lib;

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testLookupNullCallback() {
        CallbacksTest.assertNull((String)"NULL pointer should result in null callback", (Object)CallbackReference.getCallback(null, null));
        try {
            CallbackReference.getCallback(TestLibrary.VoidCallback.class, (Pointer)new Pointer(0L));
            CallbacksTest.fail((String)"Null pointer lookup should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLookupNonCallbackClass() {
        try {
            CallbackReference.getCallback(String.class, (Pointer)new Pointer(0L));
            CallbacksTest.fail((String)"Request for non-Callback class should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoMethodCallback() {
        try {
            CallbackReference.getCallback(TestLibrary.NoMethodCallback.class, (Pointer)new Pointer(1L));
            CallbacksTest.fail((String)"Callback with no callback method should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCustomMethodCallback() {
        CallbackReference.getCallback(TestLibrary.CustomMethodCallback.class, (Pointer)new Pointer(1L));
    }

    public void testTooManyMethodsCallback() {
        try {
            CallbackReference.getCallback(TestLibrary.TooManyMethodsCallback.class, (Pointer)new Pointer(1L));
            CallbacksTest.fail((String)"Callback lookup with too many methods should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMultipleMethodsCallback() {
        CallbackReference.getCallback(TestLibrary.MultipleMethodsCallback.class, (Pointer)new Pointer(1L));
    }

    public void testNativeFunctionPointerStringValue() {
        Callback cb = CallbackReference.getCallback(TestLibrary.VoidCallback.class, (Pointer)new Pointer(1L));
        Class cls = CallbackReference.findCallbackClass(cb.getClass());
        CallbacksTest.assertTrue((String)("toString should include Java Callback type: " + cb + " (" + cls + ")"), (cb.toString().indexOf(cls.getName()) != -1 ? 1 : 0) != 0);
    }

    public void testLookupSameCallback() {
        Callback cb = CallbackReference.getCallback(TestLibrary.VoidCallback.class, (Pointer)new Pointer(1L));
        Callback cb2 = CallbackReference.getCallback(TestLibrary.VoidCallback.class, (Pointer)new Pointer(1L));
        CallbacksTest.assertEquals((String)"Callback lookups for same pointer should return same Callback object", (Object)cb, (Object)cb2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGCCallbackOnFinalize() throws Exception {
        int i;
        final boolean[] called = new boolean[]{false};
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                called[0] = true;
            }
        };
        this.lib.callVoidCallback(cb);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        Map refs = new WeakHashMap(CallbackReference.callbackMap);
        CallbacksTest.assertTrue((String)"Callback not cached", (boolean)refs.containsKey(cb));
        CallbackReference ref = (CallbackReference)refs.get(cb);
        refs = CallbackReference.callbackMap;
        Pointer cbstruct = ref.cbstruct;
        cb = null;
        System.gc();
        for (i = 0; i < 100 && (ref.get() != null || refs.containsValue(ref)); ++i) {
            Thread.sleep(10L);
            System.gc();
            continue;
        }
        CallbacksTest.assertNull((String)"Callback not GC'd", (Object)ref.get());
        CallbacksTest.assertFalse((String)"Callback still in map", (boolean)refs.containsValue(ref));
        ref = null;
        System.gc();
        for (i = 0; i < 100 && (cbstruct.peer != 0L || refs.size() > 0); ++i) {
            refs.size();
            Thread.sleep(10L);
            System.gc();
            continue;
        }
        CallbacksTest.assertEquals((String)"Callback trampoline not freed", (long)0L, (long)cbstruct.peer);
    }

    public void testFindCallbackInterface() {
        TestLibrary.Int32Callback cb = new TestLibrary.Int32Callback(){

            public int callback(int arg, int arg2) {
                return arg + arg2;
            }
        };
        CallbacksTest.assertEquals((String)"Wrong callback interface", TestLibrary.Int32Callback.class, (Object)CallbackReference.findCallbackClass(cb.getClass()));
    }

    public void testCallVoidCallback() {
        final boolean[] called = new boolean[]{false};
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                called[0] = true;
            }
        };
        this.lib.callVoidCallback(cb);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
    }

    public void testCallInt32Callback() {
        int MAGIC = 0x11111111;
        final boolean[] called = new boolean[]{false};
        TestLibrary.Int32Callback cb = new TestLibrary.Int32Callback(){

            public int callback(int arg, int arg2) {
                called[0] = true;
                return arg + arg2;
            }
        };
        int EXPECTED = 0x33333333;
        int value = this.lib.callInt32Callback(cb, 0x11111111, 0x22222222);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback value", (String)Integer.toHexString(0x33333333), (String)Integer.toHexString(value));
        value = this.lib.callInt32Callback(cb, -1, -2);
        CallbacksTest.assertEquals((String)"Wrong callback return", (int)-3, (int)value);
    }

    public void testCallInt64Callback() {
        long MAGIC = 0x1111111111111111L;
        final boolean[] called = new boolean[]{false};
        TestLibrary.Int64Callback cb = new TestLibrary.Int64Callback(){

            public long callback(long arg, long arg2) {
                called[0] = true;
                return arg + arg2;
            }
        };
        long EXPECTED = 0x3333333333333333L;
        long value = this.lib.callInt64Callback(cb, 0x1111111111111111L, 0x2222222222222222L);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback value", (String)Long.toHexString(0x3333333333333333L), (String)Long.toHexString(value));
        value = this.lib.callInt64Callback(cb, -1L, -2L);
        CallbacksTest.assertEquals((String)"Wrong callback return", (long)-3L, (long)value);
    }

    public void testCallFloatCallback() {
        final boolean[] called = new boolean[]{false};
        final float[] args = new float[]{0.0f, 0.0f};
        TestLibrary.FloatCallback cb = new TestLibrary.FloatCallback(){

            public float callback(float arg, float arg2) {
                called[0] = true;
                args[0] = arg;
                args[1] = arg2;
                return arg + arg2;
            }
        };
        float EXPECTED = -355.875f;
        float value = this.lib.callFloatCallback(cb, -118.625f, -237.25f);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong first argument", (float)-118.625f, (float)args[0], (float)0.0f);
        CallbacksTest.assertEquals((String)"Wrong second argument", (float)-237.25f, (float)args[1], (float)0.0f);
        CallbacksTest.assertEquals((String)"Wrong callback value", (float)-355.875f, (float)value, (float)0.0f);
        value = this.lib.callFloatCallback(cb, -1.0f, -2.0f);
        CallbacksTest.assertEquals((String)"Wrong callback return", (float)-3.0f, (float)value, (float)0.0f);
    }

    public void testCallDoubleCallback() {
        final boolean[] called = new boolean[]{false};
        final double[] args = new double[]{0.0, 0.0};
        TestLibrary.DoubleCallback cb = new TestLibrary.DoubleCallback(){

            public double callback(double arg, double arg2) {
                called[0] = true;
                args[0] = arg;
                args[1] = arg2;
                return arg + arg2;
            }
        };
        double EXPECTED = -355.875;
        double value = this.lib.callDoubleCallback(cb, -118.625, -237.25);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong first argument", (double)-118.625, (double)args[0], (double)0.0);
        CallbacksTest.assertEquals((String)"Wrong second argument", (double)-237.25, (double)args[1], (double)0.0);
        CallbacksTest.assertEquals((String)"Wrong callback value", (double)-355.875, (double)value, (double)0.0);
        value = this.lib.callDoubleCallback(cb, -1.0, -2.0);
        CallbacksTest.assertEquals((String)"Wrong callback return", (double)-3.0, (double)value, (double)0.0);
    }

    public void testCallStructureCallback() {
        final boolean[] called = new boolean[]{false};
        final Pointer[] cbarg = new Pointer[]{null};
        SmallTestStructure s = new SmallTestStructure();
        double MAGIC = 118.625;
        TestLibrary.StructureCallback cb = new TestLibrary.StructureCallback(){

            public SmallTestStructure callback(SmallTestStructure arg) {
                called[0] = true;
                cbarg[0] = arg.getPointer();
                arg.value = 118.625;
                return arg;
            }
        };
        SmallTestStructure.allocations = 0;
        SmallTestStructure value = this.lib.callStructureCallback(cb, s);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong argument passed to callback", (Object)s.getPointer(), (Object)cbarg[0]);
        CallbacksTest.assertEquals((String)"Structure argument not synched on callback return", (double)118.625, (double)s.value, (double)0.0);
        CallbacksTest.assertEquals((String)"Wrong structure return", (Object)s.getPointer(), (Object)value.getPointer());
        CallbacksTest.assertEquals((String)"Structure return not synched", (double)118.625, (double)value.value, (double)0.0);
        if (((Object)((Object)this)).getClass() == CallbacksTest.class) {
            CallbacksTest.assertEquals((String)"No structure memory should be allocated", (int)0, (int)SmallTestStructure.allocations);
        }
    }

    public void testCallStructureArrayCallback() {
        SmallTestStructure s = new SmallTestStructure();
        SmallTestStructure[] array = (SmallTestStructure[])s.toArray(2);
        double MAGIC = 118.625;
        TestLibrary.StructureCallback cb = new TestLibrary.StructureCallback(){

            public SmallTestStructure callback(SmallTestStructure arg) {
                SmallTestStructure[] array = (SmallTestStructure[])arg.toArray(2);
                array[0].value = 118.625;
                array[1].value = 237.25;
                return arg;
            }
        };
        SmallTestStructure value = this.lib.callStructureCallback(cb, s);
        CallbacksTest.assertEquals((String)"Structure array element 0 not synched on callback return", (double)118.625, (double)array[0].value, (double)0.0);
        CallbacksTest.assertEquals((String)"Structure array element 1 not synched on callback return", (double)237.25, (double)array[1].value, (double)0.0);
    }

    public void testCallBooleanCallback() {
        final boolean[] called = new boolean[]{false};
        final boolean[] cbargs = new boolean[]{false, false};
        TestLibrary.BooleanCallback cb = new TestLibrary.BooleanCallback(){

            public boolean callback(boolean arg, boolean arg2) {
                called[0] = true;
                cbargs[0] = arg;
                cbargs[1] = arg2;
                return arg && arg2;
            }
        };
        boolean value = this.lib.callBooleanCallback(cb, true, false);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (boolean)true, (boolean)cbargs[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (boolean)false, (boolean)cbargs[1]);
        CallbacksTest.assertFalse((String)"Wrong boolean return", (boolean)value);
    }

    public void testCallInt8Callback() {
        final boolean[] called = new boolean[]{false};
        final byte[] cbargs = new byte[]{0, 0};
        TestLibrary.ByteCallback cb = new TestLibrary.ByteCallback(){

            public byte callback(byte arg, byte arg2) {
                called[0] = true;
                cbargs[0] = arg;
                cbargs[1] = arg2;
                return (byte)(arg + arg2);
            }
        };
        int MAGIC = 17;
        byte value = this.lib.callInt8Callback(cb, (byte)17, (byte)34);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (String)Integer.toHexString(17), (String)Integer.toHexString(cbargs[0]));
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (String)Integer.toHexString(34), (String)Integer.toHexString(cbargs[1]));
        CallbacksTest.assertEquals((String)"Wrong byte return", (String)Integer.toHexString(51), (String)Integer.toHexString(value));
        value = this.lib.callInt8Callback(cb, (byte)-1, (byte)-2);
        CallbacksTest.assertEquals((String)"Wrong byte return (hi bit)", (byte)-3, (byte)value);
    }

    public void testCallInt16Callback() {
        final boolean[] called = new boolean[]{false};
        final short[] cbargs = new short[]{0, 0};
        TestLibrary.ShortCallback cb = new TestLibrary.ShortCallback(){

            public short callback(short arg, short arg2) {
                called[0] = true;
                cbargs[0] = arg;
                cbargs[1] = arg2;
                return (short)(arg + arg2);
            }
        };
        int MAGIC = 4369;
        short value = this.lib.callInt16Callback(cb, (short)4369, (short)8738);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (String)Integer.toHexString(4369), (String)Integer.toHexString(cbargs[0]));
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (String)Integer.toHexString(8738), (String)Integer.toHexString(cbargs[1]));
        CallbacksTest.assertEquals((String)"Wrong short return", (String)Integer.toHexString(13107), (String)Integer.toHexString(value));
        value = this.lib.callInt16Callback(cb, (short)-1, (short)-2);
        CallbacksTest.assertEquals((String)"Wrong short return (hi bit)", (short)-3, (short)value);
    }

    public void testCallNativeLongCallback() {
        final boolean[] called = new boolean[]{false};
        final NativeLong[] cbargs = new NativeLong[]{null, null};
        TestLibrary.NativeLongCallback cb = new TestLibrary.NativeLongCallback(){

            public NativeLong callback(NativeLong arg, NativeLong arg2) {
                called[0] = true;
                cbargs[0] = arg;
                cbargs[1] = arg2;
                return new NativeLong((long)(arg.intValue() + arg2.intValue()));
            }
        };
        NativeLong value = this.lib.callNativeLongCallback(cb, new NativeLong(1L), new NativeLong(2L));
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (Object)new NativeLong(1L), (Object)cbargs[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (Object)new NativeLong(2L), (Object)cbargs[1]);
        CallbacksTest.assertEquals((String)"Wrong boolean return", (Object)new NativeLong(3L), (Object)value);
    }

    public void testCallNativeMappedCallback() {
        final boolean[] called = new boolean[]{false};
        final Custom[] cbargs = new Custom[]{null, null};
        TestLibrary.CustomCallback cb = new TestLibrary.CustomCallback(){

            public Custom callback(Custom arg, Custom arg2) {
                called[0] = true;
                cbargs[0] = arg;
                cbargs[1] = arg2;
                return new Custom(arg.value + arg2.value);
            }
        };
        int value = this.lib.callInt32Callback(cb, 1, 2);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (Object)new Custom(1), (Object)cbargs[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (Object)new Custom(2), (Object)cbargs[1]);
        CallbacksTest.assertEquals((String)"Wrong NativeMapped return", (int)3, (int)value);
    }

    public void testCallStringCallback() {
        final boolean[] called = new boolean[]{false};
        final String[] cbargs = new String[]{null};
        TestLibrary.StringCallback cb = new TestLibrary.StringCallback(){

            public String callback(String arg) {
                called[0] = true;
                cbargs[0] = arg;
                return arg;
            }
        };
        String VALUE = "value";
        String value = this.lib.callStringCallback(cb, "value");
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (String)"value", (String)cbargs[0]);
        CallbacksTest.assertEquals((String)"Wrong String return", (String)"value", (String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringCallbackMemoryReclamation() throws InterruptedException {
        TestLibrary.StringCallback cb = new TestLibrary.StringCallback(){

            public String callback(String arg) {
                return arg;
            }
        };
        Map m = CallbackReference.allocations;
        m.clear();
        String arg = this.getName() + "1";
        String value = this.lib.callStringCallback(cb, arg);
        WeakReference<String> ref = new WeakReference<String>(value);
        arg = null;
        value = null;
        System.gc();
        for (int i = 0; i < 100 && (ref.get() != null || m.size() > 0); ++i) {
            Thread.sleep(10L);
            System.gc();
            continue;
        }
        CallbacksTest.assertNull((String)"NativeString reference not GC'd", ref.get());
        CallbacksTest.assertEquals((String)("NativeString reference still held: " + m.values()), (int)0, (int)m.size());
    }

    public void testCallWideStringCallback() {
        final boolean[] called = new boolean[]{false};
        final WString[] cbargs = new WString[]{null};
        TestLibrary.WideStringCallback cb = new TestLibrary.WideStringCallback(){

            public WString callback(WString arg) {
                called[0] = true;
                cbargs[0] = arg;
                return arg;
            }
        };
        WString VALUE = new WString("value");
        WString value = this.lib.callWideStringCallback(cb, VALUE);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (Object)VALUE, (Object)cbargs[0]);
        CallbacksTest.assertEquals((String)"Wrong wide string return", (Object)VALUE, (Object)value);
    }

    public void testCallStringArrayCallback() {
        final boolean[] called = new boolean[]{false};
        final String[][] cbargs = new String[][]{null};
        TestLibrary.StringArrayCallback cb = new TestLibrary.StringArrayCallback(){

            public String[] callback(String[] arg) {
                called[0] = true;
                cbargs[0] = arg;
                return arg;
            }
        };
        String[] VALUE = new String[]{"value", null};
        Pointer value = this.lib.callStringArrayCallback(cb, VALUE);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (String)VALUE[0], (String)cbargs[0][0]);
        String[] result = value.getStringArray(0L);
        CallbacksTest.assertEquals((String)"Wrong String return", (String)VALUE[0], (String)result[0]);
    }

    public void testCallCallbackWithByReferenceArgument() {
        final boolean[] called = new boolean[]{false};
        TestLibrary.CopyArgToByReference cb = new TestLibrary.CopyArgToByReference(){

            public int callback(int arg, IntByReference result) {
                called[0] = true;
                result.setValue(arg);
                return result.getValue();
            }
        };
        boolean VALUE = false;
        IntByReference ref = new IntByReference(-1);
        int value = this.lib.callCallbackWithByReferenceArgument(cb, 0, ref);
        CallbacksTest.assertEquals((String)"Wrong value returned", (int)0, (int)value);
        CallbacksTest.assertEquals((String)"Wrong value in by reference memory", (int)0, (int)ref.getValue());
    }

    public void testCallCallbackWithStructByValue() {
        TestStructure.ByValue s = new TestStructure.ByValue();
        final TestStructure innerResult = new TestStructure();
        TestStructure.TestCallback cb = new TestStructure.TestCallback(){

            public TestStructure.ByValue callback(TestStructure.ByValue s) {
                Pointer old = innerResult.getPointer();
                innerResult.useMemory(s.getPointer());
                innerResult.read();
                innerResult.useMemory(old);
                innerResult.write();
                return s;
            }
        };
        s.c = (byte)17;
        s.s = (short)8738;
        s.i = 0x33333333;
        s.j = 0x4444444444444444L;
        s.inner.value = 5.0;
        TestStructure.ByValue result = this.lib.callCallbackWithStructByValue(cb, s);
        CallbacksTest.assertEquals((String)"Wrong value passed to callback", (Object)((Object)s), (Object)((Object)innerResult));
        CallbacksTest.assertEquals((String)"Wrong value for result", (Object)((Object)s), (Object)((Object)result));
    }

    public void testCallCallbackWithCallbackArgumentAndResult() {
        TestLibrary.CbCallback cb = new TestLibrary.CbCallback(){

            public TestLibrary.CbCallback callback(TestLibrary.CbCallback arg) {
                return arg;
            }
        };
        TestLibrary.CbCallback cb2 = this.lib.callCallbackWithCallback(cb);
        CallbacksTest.assertEquals((String)"Callback reference should be reused", (Object)cb, (Object)cb2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultCallbackExceptionHandler() {
        final RuntimeException ERROR = new RuntimeException(this.getName());
        PrintStream ps = System.err;
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        System.setErr(new PrintStream(s));
        try {
            TestLibrary.CbCallback cb = new TestLibrary.CbCallback(){

                public TestLibrary.CbCallback callback(TestLibrary.CbCallback arg) {
                    throw ERROR;
                }
            };
            TestLibrary.CbCallback cb2 = this.lib.callCallbackWithCallback(cb);
            String output = s.toString();
            CallbacksTest.assertTrue((String)"Default handler not called", (output.length() > 0 ? 1 : 0) != 0);
        }
        finally {
            System.setErr(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbackExceptionHandler() {
        final RuntimeException ERROR = new RuntimeException(this.getName());
        final Throwable[] CAUGHT = new Throwable[]{null};
        final Callback[] CALLBACK = new Callback[]{null};
        Callback.UncaughtExceptionHandler old = Native.getCallbackExceptionHandler();
        Callback.UncaughtExceptionHandler handler = new Callback.UncaughtExceptionHandler(){

            public void uncaughtException(Callback cb, Throwable e) {
                CALLBACK[0] = cb;
                CAUGHT[0] = e;
            }
        };
        Native.setCallbackExceptionHandler((Callback.UncaughtExceptionHandler)handler);
        try {
            TestLibrary.CbCallback cb = new TestLibrary.CbCallback(){

                public TestLibrary.CbCallback callback(TestLibrary.CbCallback arg) {
                    throw ERROR;
                }
            };
            TestLibrary.CbCallback cb2 = this.lib.callCallbackWithCallback(cb);
            CallbacksTest.assertNotNull((String)"Exception handler not called", (Object)CALLBACK[0]);
            CallbacksTest.assertEquals((String)"Wrong callback argument to handler", (Object)cb, (Object)CALLBACK[0]);
            CallbacksTest.assertEquals((String)"Wrong exception passed to handler", (Object)ERROR, (Object)CAUGHT[0]);
        }
        finally {
            Native.setCallbackExceptionHandler((Callback.UncaughtExceptionHandler)old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbackExceptionHandlerWithCallbackProxy() throws Throwable {
        final RuntimeException ERROR = new RuntimeException(this.getName());
        final Throwable[] CAUGHT = new Throwable[]{null};
        final Callback[] CALLBACK = new Callback[]{null};
        Callback.UncaughtExceptionHandler old = Native.getCallbackExceptionHandler();
        Callback.UncaughtExceptionHandler handler = new Callback.UncaughtExceptionHandler(){

            public void uncaughtException(Callback cb, Throwable e) {
                CALLBACK[0] = cb;
                CAUGHT[0] = e;
            }
        };
        Native.setCallbackExceptionHandler((Callback.UncaughtExceptionHandler)handler);
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class TestProxy
            implements CallbackProxy,
            TestLibrary.CbCallback {
                TestProxy() {
                }

                @Override
                public TestLibrary.CbCallback callback(TestLibrary.CbCallback arg) {
                    throw new Error("Should never be called");
                }

                public Object callback(Object[] args) {
                    throw ERROR;
                }

                public Class[] getParameterTypes() {
                    return new Class[]{TestLibrary.CbCallback.class};
                }

                public Class getReturnType() {
                    return TestLibrary.CbCallback.class;
                }
            }
            TestProxy cb = new TestProxy();
            TestLibrary.CbCallback cb2 = this.lib.callCallbackWithCallback(cb);
            CallbacksTest.assertNotNull((String)"Exception handler not called", (Object)CALLBACK[0]);
            CallbacksTest.assertEquals((String)"Wrong callback argument to handler", (Object)cb, (Object)CALLBACK[0]);
            CallbacksTest.assertEquals((String)"Wrong exception passed to handler", (Object)ERROR, (Object)CAUGHT[0]);
        }
        finally {
            Native.setCallbackExceptionHandler((Callback.UncaughtExceptionHandler)old);
        }
    }

    public void testResetCallbackExceptionHandler() {
        Native.setCallbackExceptionHandler(null);
        CallbacksTest.assertNotNull((String)"Should not be able to set callback EH null", (Object)Native.getCallbackExceptionHandler());
    }

    public void testInvokeCallback() {
        TestLibrary.Int32CallbackX cb = this.lib.returnCallback();
        CallbacksTest.assertNotNull((String)"Callback should not be null", (Object)cb);
        CallbacksTest.assertEquals((String)"Callback should be callable", (int)1, (int)cb.callback(1));
        TestLibrary.Int32CallbackX cb2 = new TestLibrary.Int32CallbackX(){

            public int callback(int arg) {
                return 0;
            }
        };
        CallbacksTest.assertSame((String)"Java callback should be looked up", (Object)cb2, (Object)this.lib.returnCallbackArgument(cb2));
        CallbacksTest.assertSame((String)"Existing native function wrapper should be reused", (Object)cb, (Object)this.lib.returnCallbackArgument(cb));
    }

    public void testCallCallbackInStructure() {
        final boolean[] flag = new boolean[]{false};
        TestLibrary.CbStruct s = new TestLibrary.CbStruct();
        s.cb = new Callback(){

            public void callback() {
                flag[0] = true;
            }
        };
        this.lib.callCallbackInStruct(s);
        CallbacksTest.assertTrue((String)"Callback not invoked", (boolean)flag[0]);
    }

    public void testCustomCallbackMethodName() {
        final boolean[] called = new boolean[]{false};
        TestLibrary.VoidCallbackCustom cb = new TestLibrary.VoidCallbackCustom(){

            public void customMethodName() {
                called[0] = true;
            }

            public String toString() {
                return "Some debug output";
            }
        };
        this.lib.callVoidCallback(cb);
        CallbacksTest.assertTrue((String)"Callback with custom method name not called", (boolean)called[0]);
    }

    public void testCustomCallbackVariedInheritance() {
        boolean[] called = new boolean[]{false};
        TestLibrary.VoidCallbackCustomDerived cb = new TestLibrary.VoidCallbackCustomDerived();
        this.lib.callVoidCallback(cb);
    }

    protected CallbackTestLibrary loadCallbackTestLibrary() {
        return (CallbackTestLibrary)Native.loadLibrary((String)"testlib", CallbackTestLibrary.class, (Map)CallbackTestLibrary._OPTIONS);
    }

    public void testCallbackUsesTypeMapper() throws Exception {
        CallbackTestLibrary lib = this.loadCallbackTestLibrary();
        final double[] ARGS = new double[2];
        CallbackTestLibrary.DoubleCallback cb = new CallbackTestLibrary.DoubleCallback(){

            public double callback(double arg, double arg2) {
                ARGS[0] = arg;
                ARGS[1] = arg2;
                return arg + arg2;
            }
        };
        CallbacksTest.assertEquals((String)"Wrong type mapper for callback class", (Object)CallbackTestLibrary._MAPPER, (Object)Native.getTypeMapper(CallbackTestLibrary.DoubleCallback.class));
        CallbacksTest.assertEquals((String)"Wrong type mapper for callback object", (Object)CallbackTestLibrary._MAPPER, (Object)Native.getTypeMapper(cb.getClass()));
        double result = lib.callInt32Callback(cb, -1.0, -1.0);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (double)-1.0, (double)ARGS[0], (double)0.0);
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (double)-1.0, (double)ARGS[1], (double)0.0);
        CallbacksTest.assertEquals((String)"Incorrect result of callback invocation", (double)-2.0, (double)result, (double)0.0);
    }

    public void testCallbackUsesTypeMapperWithDifferentReturnTypeSize() throws Exception {
        CallbackTestLibrary lib = this.loadCallbackTestLibrary();
        final float[] ARGS = new float[2];
        CallbackTestLibrary.FloatCallback cb = new CallbackTestLibrary.FloatCallback(){

            public float callback(float arg, float arg2) {
                ARGS[0] = arg;
                ARGS[1] = arg2;
                return arg + arg2;
            }
        };
        CallbacksTest.assertEquals((String)"Wrong type mapper for callback class", (Object)CallbackTestLibrary._MAPPER, (Object)Native.getTypeMapper(CallbackTestLibrary.FloatCallback.class));
        CallbacksTest.assertEquals((String)"Wrong type mapper for callback object", (Object)CallbackTestLibrary._MAPPER, (Object)Native.getTypeMapper(cb.getClass()));
        float result = lib.callInt64Callback(cb, -1.0f, -1.0f);
        CallbacksTest.assertEquals((String)"Wrong callback argument 1", (float)-1.0f, (float)ARGS[0], (float)0.0f);
        CallbacksTest.assertEquals((String)"Wrong callback argument 2", (float)-1.0f, (float)ARGS[1], (float)0.0f);
        CallbacksTest.assertEquals((String)"Incorrect result of callback invocation", (float)-2.0f, (float)result, (float)0.0f);
    }

    protected void callThreadedCallback(TestLibrary.VoidCallback cb, CallbackThreadInitializer cti, int repeat, int sleepms, int[] called) throws Exception {
        if (cti != null) {
            Native.setCallbackThreadInitializer((Callback)cb, (CallbackThreadInitializer)cti);
        }
        this.lib.callVoidCallbackThreaded(cb, repeat, sleepms);
        long start = System.currentTimeMillis();
        while (called[0] < repeat) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 5000L) continue;
            CallbacksTest.fail((String)("Timed out waiting for callback, invoked " + called[0] + " times so far"));
        }
    }

    public void testCallbackThreadDefaults() throws Exception {
        final int[] called = new int[]{0};
        final boolean[] daemon = new boolean[]{false};
        final String[] name = new String[]{null};
        final ThreadGroup[] group = new ThreadGroup[]{null};
        final Thread[] t = new Thread[]{null};
        ThreadGroup testGroup = new ThreadGroup(this.getName());
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                Thread thread = Thread.currentThread();
                daemon[0] = thread.isDaemon();
                name[0] = thread.getName();
                group[0] = thread.getThreadGroup();
                t[0] = thread;
                called[0] = called[0] + 1;
            }
        };
        this.callThreadedCallback(cb, null, 1, 100, called);
        CallbacksTest.assertFalse((String)"Callback thread default should not be attached as daemon", (boolean)daemon[0]);
    }

    public void testCustomizeCallbackThread() throws Exception {
        final int[] called = new int[]{0};
        final boolean[] daemon = new boolean[]{false};
        final String[] name = new String[]{null};
        final ThreadGroup[] group = new ThreadGroup[]{null};
        final Thread[] t = new Thread[]{null};
        String tname = this.getName() + " thread";
        final boolean[] alive = new boolean[]{false};
        ThreadGroup testGroup = new ThreadGroup(this.getName() + " thread group");
        CallbackThreadInitializer init = new CallbackThreadInitializer(true, false, tname, testGroup);
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                Thread thread = Thread.currentThread();
                daemon[0] = thread.isDaemon();
                name[0] = thread.getName();
                group[0] = thread.getThreadGroup();
                t[0] = thread;
                if (thread.isAlive()) {
                    alive[0] = true;
                }
                if ((called[0] = called[0] + 1) == 2) {
                    Native.detach((boolean)true);
                }
            }
        };
        this.callThreadedCallback(cb, init, 1, 5000, called);
        CallbacksTest.assertTrue((String)"Callback thread not attached as daemon", (boolean)daemon[0]);
        CallbacksTest.assertEquals((String)"Wrong thread name", (String)tname, (String)name[0]);
        CallbacksTest.assertEquals((String)"Wrong thread group", (Object)testGroup, (Object)group[0]);
        if (!alive[0]) {
            throw new Error("VM incorrectly reports Thread.isAlive() == false within callback");
        }
        CallbacksTest.assertTrue((String)"Thread should still be alive", (boolean)t[0].isAlive());
    }

    public void testCallbackThreadPersistence() throws Exception {
        final int[] called = new int[]{0};
        final HashSet threads = new HashSet();
        int COUNT = 5;
        CallbackThreadInitializer init = new CallbackThreadInitializer(true, false){

            public String getName(Callback cb) {
                return CallbacksTest.this.getName() + " thread " + called[0];
            }
        };
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                threads.add(Thread.currentThread());
                called[0] = called[0] + 1;
            }
        };
        this.callThreadedCallback(cb, init, 5, 100, called);
        CallbacksTest.assertEquals((String)("Multiple callbacks on a given native thread should use the same Thread mapping: " + threads), (int)1, (int)threads.size());
    }

    public void testAttachedThreadCleanupOnExit() throws Exception {
        final HashSet threads = new HashSet();
        final int[] called = new int[]{0};
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                threads.add(new WeakReference<Thread>(Thread.currentThread()));
                called[0] = called[0] + 1;
                if (called[0] == 1) {
                    Thread.currentThread().setName("Thread to be cleaned up");
                }
                Native.detach((boolean)false);
            }
        };
        CallbackThreadInitializer asDaemon = new CallbackThreadInitializer(true);
        this.callThreadedCallback(cb, asDaemon, 1, 0, called);
        while (threads.size() == 0) {
            Thread.sleep(10L);
        }
        long start = System.currentTimeMillis();
        WeakReference ref = (WeakReference)threads.iterator().next();
        while (ref.get() != null) {
            System.gc();
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 10000L) continue;
            Thread t = (Thread)ref.get();
            CallbacksTest.fail((String)("Timed out waiting for attached thread to be detached on exit and disposed: " + t + " alive: " + t.isAlive() + " daemon " + t.isDaemon()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbackIndicatedThreadDetach() throws Exception {
        final int[] called = new int[]{0};
        final HashSet threads = new HashSet();
        int COUNT = 5;
        TestLibrary.VoidCallback cb = new TestLibrary.VoidCallback(){

            public void callback() {
                threads.add(Thread.currentThread());
                int count = called[0] + 1;
                if (count == 1) {
                    Native.detach((boolean)false);
                } else if (count == 5) {
                    Native.detach((boolean)true);
                }
                called[0] = count;
            }
        };
        this.callThreadedCallback(cb, null, 5, 100, called);
        CallbacksTest.assertEquals((String)("Multiple callbacks in the same native thread should use the same Thread mapping: " + threads), (int)1, (int)threads.size());
        Thread thread = (Thread)threads.iterator().next();
        long start = System.currentTimeMillis();
        while (thread.isAlive()) {
            System.gc();
            Thread.sleep(10L);
            if (System.currentTimeMillis() - start <= 5000L) continue;
            PrintStream ps = System.err;
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            System.setErr(new PrintStream(s));
            try {
                thread.dumpStack();
            }
            finally {
                System.setErr(ps);
            }
            CallbacksTest.fail((String)("Timed out waiting for callback thread " + thread + " to die: " + s));
        }
    }

    public void testDLLCallback() throws Exception {
        int i;
        if (!Platform.HAS_DLL_CALLBACKS) {
            return;
        }
        final boolean[] called = new boolean[]{false};
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestCallback
        implements TestLibrary.VoidCallback,
        DLLCallback {
            TestCallback() {
            }

            @Override
            public void callback() {
                called[0] = true;
            }
        }
        TestCallback cb = new TestCallback();
        this.lib.callVoidCallback(cb);
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        Map refs = new WeakHashMap(CallbackReference.callbackMap);
        CallbacksTest.assertTrue((String)"Callback not cached", (boolean)refs.containsKey(cb));
        CallbackReference ref = (CallbackReference)refs.get(cb);
        refs = CallbackReference.callbackMap;
        Pointer cbstruct = ref.cbstruct;
        Pointer first_fptr = cbstruct.getPointer(0L);
        cb = null;
        System.gc();
        for (i = 0; i < 100 && (ref.get() != null || refs.containsValue(ref)); ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        CallbacksTest.assertNull((String)"Callback not GC'd", (Object)ref.get());
        CallbacksTest.assertFalse((String)"Callback still in map", (boolean)refs.containsValue(ref));
        ref = null;
        System.gc();
        for (i = 0; i < 100 && (cbstruct.peer != 0L || refs.size() > 0); ++i) {
            refs.size();
            Thread.sleep(10L);
            System.gc();
        }
        CallbacksTest.assertEquals((String)"Callback trampoline not freed", (long)0L, (long)cbstruct.peer);
        called[0] = false;
        cb = new TestCallback();
        this.lib.callVoidCallback(cb);
        ref = (CallbackReference)refs.get(cb);
        cbstruct = ref.cbstruct;
        CallbacksTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        CallbacksTest.assertEquals((String)"Same (in-DLL) address should be re-used for DLL callbacks", (Object)first_fptr, (Object)cbstruct.getPointer(0L));
    }

    public void testThrowOutOfMemoryWhenDLLCallbacksExhausted() throws Exception {
        if (!Platform.HAS_DLL_CALLBACKS) {
            return;
        }
        final boolean[] called = new boolean[]{false};
        try {
            for (int i = 0; i <= 16; ++i) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class TestCallback
                implements TestLibrary.VoidCallback,
                DLLCallback {
                    TestCallback() {
                    }

                    @Override
                    public void callback() {
                        called[0] = true;
                    }
                }
                this.lib.callVoidCallback(new TestCallback());
            }
            CallbacksTest.fail((String)"Expected out of memory error when all DLL callbacks used");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public static void main(String[] argList) {
        TestRunner.run(CallbacksTest.class);
    }

    public static interface CallbackTestLibrary
    extends Library {
        public static final TypeMapper _MAPPER = new DefaultTypeMapper(){
            {
                Object converter = new TypeConverter(){

                    public Object fromNative(Object value, FromNativeContext context) {
                        return new Double(((Integer)value).intValue());
                    }

                    public Class nativeType() {
                        return Integer.class;
                    }

                    public Object toNative(Object value, ToNativeContext ctx) {
                        return new Integer(((Double)value).intValue());
                    }
                };
                this.addTypeConverter(Double.TYPE, (TypeConverter)converter);
                converter = new TypeConverter(){

                    public Object fromNative(Object value, FromNativeContext context) {
                        return new Float(((Long)value).intValue());
                    }

                    public Class nativeType() {
                        return Long.class;
                    }

                    public Object toNative(Object value, ToNativeContext ctx) {
                        return new Long(((Float)value).longValue());
                    }
                };
                this.addTypeConverter(Float.TYPE, (TypeConverter)converter);
            }
        };
        public static final Map _OPTIONS = new HashMap(){
            {
                this.put("type-mapper", _MAPPER);
            }
        };

        public double callInt32Callback(DoubleCallback var1, double var2, double var4);

        public float callInt64Callback(FloatCallback var1, float var2, float var3);

        public static interface FloatCallback
        extends Callback {
            public float callback(float var1, float var2);
        }

        public static interface DoubleCallback
        extends Callback {
            public double callback(double var1, double var3);
        }
    }

    public static class Custom
    implements NativeMapped {
        private int value;

        public Custom() {
        }

        public Custom(int value) {
            this.value = value;
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return new Custom((Integer)nativeValue);
        }

        public Class nativeType() {
            return Integer.class;
        }

        public Object toNative() {
            return new Integer(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof Custom && ((Custom)o).value == this.value;
        }
    }

    public static interface TestLibrary
    extends Library {
        public void callVoidCallback(VoidCallback var1);

        public void callVoidCallbackThreaded(VoidCallback var1, int var2, int var3);

        public void callVoidCallback(VoidCallbackCustom var1);

        public boolean callBooleanCallback(BooleanCallback var1, boolean var2, boolean var3);

        public byte callInt8Callback(ByteCallback var1, byte var2, byte var3);

        public short callInt16Callback(ShortCallback var1, short var2, short var3);

        public int callInt32Callback(Int32Callback var1, int var2, int var3);

        public NativeLong callNativeLongCallback(NativeLongCallback var1, NativeLong var2, NativeLong var3);

        public long callInt64Callback(Int64Callback var1, long var2, long var4);

        public float callFloatCallback(FloatCallback var1, float var2, float var3);

        public double callDoubleCallback(DoubleCallback var1, double var2, double var4);

        public SmallTestStructure callStructureCallback(StructureCallback var1, SmallTestStructure var2);

        public String callStringCallback(StringCallback var1, String var2);

        public WString callWideStringCallback(WideStringCallback var1, WString var2);

        public Pointer callStringArrayCallback(StringArrayCallback var1, String[] var2);

        public int callCallbackWithByReferenceArgument(CopyArgToByReference var1, int var2, IntByReference var3);

        public TestStructure.ByValue callCallbackWithStructByValue(TestStructure.TestCallback var1, TestStructure.ByValue var2);

        public CbCallback callCallbackWithCallback(CbCallback var1);

        public Int32CallbackX returnCallback();

        public Int32CallbackX returnCallbackArgument(Int32CallbackX var1);

        public int callInt32Callback(CustomCallback var1, int var2, int var3);

        public void callCallbackInStruct(CbStruct var1);

        public static class CbStruct
        extends Structure {
            public Callback cb;

            protected List getFieldOrder() {
                return Arrays.asList("cb");
            }
        }

        public static interface CustomCallback
        extends Callback {
            public Custom callback(Custom var1, Custom var2);
        }

        public static interface Int32CallbackX
        extends Callback {
            public int callback(int var1);
        }

        public static interface CbCallback
        extends Callback {
            public CbCallback callback(CbCallback var1);
        }

        public static interface StringArrayCallback
        extends Callback {
            public String[] callback(String[] var1);
        }

        public static interface CopyArgToByReference
        extends Callback {
            public int callback(int var1, IntByReference var2);
        }

        public static interface WideStringCallback
        extends Callback {
            public WString callback(WString var1);
        }

        public static interface StringCallback
        extends Callback {
            public String callback(String var1);
        }

        public static interface StructureCallback
        extends Callback {
            public SmallTestStructure callback(SmallTestStructure var1);
        }

        public static interface DoubleCallback
        extends Callback {
            public double callback(double var1, double var3);
        }

        public static interface FloatCallback
        extends Callback {
            public float callback(float var1, float var2);
        }

        public static interface Int64Callback
        extends Callback {
            public long callback(long var1, long var3);
        }

        public static interface NativeLongCallback
        extends Callback {
            public NativeLong callback(NativeLong var1, NativeLong var2);
        }

        public static interface Int32Callback
        extends Callback {
            public int callback(int var1, int var2);
        }

        public static interface ShortCallback
        extends Callback {
            public short callback(short var1, short var2);
        }

        public static interface ByteCallback
        extends Callback {
            public byte callback(byte var1, byte var2);
        }

        public static interface BooleanCallback
        extends Callback {
            public boolean callback(boolean var1, boolean var2);
        }

        public static class VoidCallbackCustomDerived
        extends VoidCallbackCustomAbstract {
        }

        public static abstract class VoidCallbackCustomAbstract
        implements VoidCallbackCustom {
            public void customMethodName() {
            }
        }

        public static interface VoidCallbackCustom
        extends Callback {
            public void customMethodName();
        }

        public static interface VoidCallback
        extends Callback {
            public void callback();
        }

        public static interface MultipleMethodsCallback
        extends Callback {
            public void invoke();

            public void callback();
        }

        public static interface TooManyMethodsCallback
        extends Callback {
            public void invoke();

            public void invoke2();
        }

        public static interface CustomMethodCallback
        extends Callback {
            public void invoke();
        }

        public static interface NoMethodCallback
        extends Callback {
        }
    }

    public static class TestStructure
    extends Structure {
        public byte c;
        public short s;
        public int i;
        public long j;
        public SmallTestStructure inner;

        protected List getFieldOrder() {
            return Arrays.asList("c", "s", "i", "j", "inner");
        }

        public static interface TestCallback
        extends Callback {
            public ByValue callback(ByValue var1);
        }

        public static class ByValue
        extends TestStructure
        implements Structure.ByValue {
        }
    }

    public static class SmallTestStructure
    extends Structure {
        public double value;
        public static int allocations = 0;

        protected void allocateMemory(int size) {
            super.allocateMemory(size);
            ++allocations;
        }

        public SmallTestStructure() {
        }

        public SmallTestStructure(Pointer p) {
            super(p);
            this.read();
        }

        protected List getFieldOrder() {
            return Arrays.asList("value");
        }
    }
}

