/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DirectTest
extends TestCase {
    private static final String BUILDDIR = System.getProperty("jna.builddir", "build" + (Platform.is64Bit() ? "-d64" : ""));

    public static void main(String[] argList) {
        TestRunner.run(DirectTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterMethods() throws Exception {
        String name = "com.sun.jna.DirectTest$MathLibrary";
        TestLoader loader = new TestLoader();
        Class<?> cls = Class.forName(name, true, loader);
        DirectTest.assertNotNull((String)"Failed loading class", cls);
        WeakReference ref = new WeakReference(cls);
        loader = null;
        cls = null;
        System.gc();
        for (int i = 0; i < 100 && ref.get() != null; ++i) {
            Thread.sleep(10L);
            System.gc();
            continue;
        }
        DirectTest.assertNull((String)("Registered methods not GC'd: " + ref.get()), ref.get());
    }

    private Class returnCallingClass() {
        return Native.getCallingClass();
    }

    public void testFindCallingClass() {
        DirectTest.assertEquals((String)"Wrong calling class detected", ((Object)((Object)this)).getClass(), (Object)this.returnCallingClass());
    }

    public void testFindNativeClass() {
        class UnregisterLibrary {
            UnregisterLibrary() {
            }

            public native double cos(double var1);

            public Class getNativeClass() {
                return new 1UnregisterLibrary.Inner().getNativeClass();
            }

            class 1UnregisterLibrary.Inner {
                1UnregisterLibrary.Inner() {
                }

                public Class getNativeClass() {
                    return this.getNativeClassInner();
                }

                public Class getNativeClassInner() {
                    return Native.getNativeClass((Class)Native.getCallingClass());
                }
            }
        }
        DirectTest.assertEquals((String)"Wrong native class found", UnregisterLibrary.class, (Object)new UnregisterLibrary().getNativeClass());
    }

    private static class TestLoader
    extends URLClassLoader {
        public TestLoader() throws MalformedURLException {
            URL[] uRLArray;
            if (Platform.isWindowsCE()) {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = new File("/Storage Card/test.jar").toURI().toURL();
            } else {
                URL[] uRLArray3 = new URL[2];
                uRLArray3[0] = new File(BUILDDIR + "/classes").toURI().toURL();
                uRLArray = uRLArray3;
                uRLArray3[1] = new File(BUILDDIR + "/test-classes").toURI().toURL();
            }
            super(uRLArray, (ClassLoader)null);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            String boot = System.getProperty("jna.boot.library.path");
            if (boot != null) {
                System.setProperty("jna.boot.library.path", "");
            }
            Class<?> cls = super.findClass(name);
            if (boot != null) {
                System.setProperty("jna.boot.library.path", boot);
            }
            return cls;
        }
    }

    static class TestLibrary
    implements TestInterface {
        TestLibrary() {
        }

        public native int callInt32CallbackRepeatedly(TestInterface.Int32Callback var1, int var2, int var3, int var4);

        public native NativeLong callLongCallbackRepeatedly(TestInterface.NativeLongCallback var1, NativeLong var2, NativeLong var3, int var4);

        static {
            Native.register((String)"testlib");
        }
    }

    static interface TestInterface
    extends Library {
        public int callInt32CallbackRepeatedly(Int32Callback var1, int var2, int var3, int var4);

        public NativeLong callLongCallbackRepeatedly(NativeLongCallback var1, NativeLong var2, NativeLong var3, int var4);

        public static interface NativeLongCallback
        extends Callback {
            public NativeLong invoke(NativeLong var1, NativeLong var2);
        }

        public static interface Int32Callback
        extends Callback {
            public int invoke(int var1, int var2);
        }
    }

    static interface CInterface
    extends Library {
        public Pointer memset(Pointer var1, int var2, int var3);

        public int strlen(String var1);
    }

    static class CLibrary {
        CLibrary() {
        }

        public static native Pointer memset(Pointer var0, int var1, size_t var2);

        public static native Pointer memset(Pointer var0, int var1, int var2);

        public static native Pointer memset(Pointer var0, int var1, long var2);

        public static native long memset(long var0, int var2, long var3);

        public static native int memset(int var0, int var1, int var2);

        public static native int strlen(String var0);

        public static native int strlen(Pointer var0);

        public static native int strlen(byte[] var0);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }

        public static class size_t
        extends IntegerType {
            public size_t() {
                super(Native.POINTER_SIZE);
            }

            public size_t(long value) {
                super(Native.POINTER_SIZE, value);
            }
        }
    }

    static interface MathInterface
    extends Library {
        public double cos(double var1);
    }

    static class MathLibrary {
        MathLibrary() {
        }

        public static native double cos(double var0);

        static {
            Native.register((String)Platform.MATH_LIBRARY_NAME);
        }
    }

    private static class JNI {
        private JNI() {
        }

        private static native double cos(double var0);

        static {
            String path = BUILDDIR + "/native/" + System.mapLibraryName("testlib");
            if (!new File(path).isAbsolute()) {
                path = System.getProperty("user.dir") + "/" + path;
            }
            if (path.endsWith(".jnilib")) {
                path = path.replace(".jnilib", ".dylib");
            }
            System.load(path);
        }
    }
}

