/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DirectTypeMapperTest
extends TestCase {
    public void testBooleanToIntArgumentConversion() {
        DirectTestLibraryBoolean lib = new DirectTestLibraryBoolean();
        DirectTypeMapperTest.assertEquals((String)"Failed to convert Boolean argument to Int", (int)-1410478301, (int)lib.returnInt32Argument(true));
    }

    public void testStringToIntArgumentConversion() {
        int MAGIC = 2079182627;
        DirectTestLibraryString lib = new DirectTestLibraryString();
        DirectTypeMapperTest.assertEquals((String)"Failed to convert String argument to Int", (int)2079182627, (int)lib.returnInt32Argument(Integer.toHexString(2079182627)));
    }

    public void testCharSequenceToIntArgumentConversion() {
        int MAGIC = 2079182627;
        DirectTestLibraryCharSequence lib = new DirectTestLibraryCharSequence();
        DirectTypeMapperTest.assertEquals((String)"Failed to convert String argument to Int", (int)2079182627, (int)lib.returnInt32Argument(Integer.toHexString(2079182627)));
    }

    public void testNumberToIntArgumentConversion() {
        int MAGIC = 2079182627;
        DirectTestLibraryNumber lib = new DirectTestLibraryNumber();
        DirectTypeMapperTest.assertEquals((String)"Failed to convert Double argument to Int", (int)2079182627, (int)lib.returnInt32Argument(new Double(2.079182627E9)));
    }

    public void testIntegerToBooleanResultConversion() throws Exception {
        DirectBooleanTestLibrary lib = new DirectBooleanTestLibrary();
        DirectTypeMapperTest.assertTrue((String)"Failed to convert integer return to boolean TRUE", (boolean)lib.returnInt32Argument(true));
        DirectTypeMapperTest.assertFalse((String)"Failed to convert integer return to boolean FALSE", (boolean)lib.returnInt32Argument(false));
    }

    public static void main(String[] args) {
        TestRunner.run(DirectTypeMapperTest.class);
    }

    public static class DirectBooleanTestLibrary {
        public native boolean returnInt32Argument(boolean var1);

        static {
            int MAGIC = -1410478301;
            HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
            DefaultTypeMapper mapper = new DefaultTypeMapper();
            mapper.addToNativeConverter(Boolean.class, new ToNativeConverter(){

                public Object toNative(Object value, ToNativeContext ctx) {
                    return new Integer(Boolean.TRUE.equals(value) ? 0 : -1410478301);
                }

                public Class nativeType() {
                    return Integer.class;
                }
            });
            mapper.addFromNativeConverter(Boolean.class, new FromNativeConverter(){

                public Object fromNative(Object value, FromNativeContext context) {
                    return (Integer)value != -1410478301;
                }

                public Class nativeType() {
                    return Integer.class;
                }
            });
            options.put("type-mapper", mapper);
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"testlib", options));
        }
    }

    public static class DirectTestLibraryNumber {
        public native int returnInt32Argument(Number var1);

        static {
            DefaultTypeMapper mapper = new DefaultTypeMapper();
            mapper.addToNativeConverter(Number.class, new ToNativeConverter(){

                public Object toNative(Object arg, ToNativeContext ctx) {
                    return new Integer(((Number)arg).intValue());
                }

                public Class nativeType() {
                    return Integer.class;
                }
            });
            HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
            options.put("type-mapper", mapper);
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"testlib", options));
        }
    }

    public static class DirectTestLibraryCharSequence {
        public native int returnInt32Argument(String var1);

        static {
            DefaultTypeMapper mapper = new DefaultTypeMapper();
            mapper.addToNativeConverter(CharSequence.class, new ToNativeConverter(){

                public Object toNative(Object arg, ToNativeContext ctx) {
                    return Integer.valueOf(((Object)((CharSequence)arg)).toString(), 16);
                }

                public Class nativeType() {
                    return Integer.class;
                }
            });
            HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
            options.put("type-mapper", mapper);
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"testlib", options));
        }
    }

    public static class DirectTestLibraryString {
        public native int returnInt32Argument(String var1);

        static {
            DefaultTypeMapper mapper = new DefaultTypeMapper();
            mapper.addToNativeConverter(String.class, new ToNativeConverter(){

                public Object toNative(Object arg, ToNativeContext ctx) {
                    return Integer.valueOf((String)arg, 16);
                }

                public Class nativeType() {
                    return Integer.class;
                }
            });
            HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
            options.put("type-mapper", mapper);
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"testlib", options));
        }
    }

    public static class DirectTestLibraryBoolean {
        static final int MAGIC = -1410478301;

        public native int returnInt32Argument(boolean var1);

        static {
            HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
            DefaultTypeMapper mapper = new DefaultTypeMapper();
            mapper.addToNativeConverter(Boolean.class, new ToNativeConverter(){

                public Object toNative(Object arg, ToNativeContext ctx) {
                    return new Integer(Boolean.TRUE.equals(arg) ? -1410478301 : 0);
                }

                public Class nativeType() {
                    return Integer.class;
                }
            });
            options.put("type-mapper", mapper);
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"testlib", options));
        }
    }
}

