/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Platform;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class JNAUnloadTest
extends TestCase {
    private static final String BUILDDIR = System.getProperty("jna.builddir", "build" + (Platform.is64Bit() ? "-d64" : ""));

    public void testLoadFromJar() throws Exception {
        Class.forName("com.sun.jna.Native", true, new TestLoader(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAvoidJarUnpacking() throws Exception {
        System.setProperty("jna.nounpack", "true");
        TestLoader loader = new TestLoader(true);
        try {
            Class<?> cls = Class.forName("com.sun.jna.Native", true, loader);
            JNAUnloadTest.fail((String)("Class com.sun.jna.Native should not be loadable if jna.nounpack=true: " + cls.getClassLoader()));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        finally {
            System.setProperty("jna.nounpack", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnloadFromJar() throws Exception {
        File jar = new File((Platform.isWindowsCE() ? "/Storage Card" : BUILDDIR) + "/jna.jar");
        if (!jar.exists()) {
            throw new Error("Expected JNA jar file at " + jar + " is missing");
        }
        TestLoader loader = new TestLoader(true);
        Class<?> cls = Class.forName("com.sun.jna.Native", true, loader);
        JNAUnloadTest.assertEquals((String)"Wrong class loader", (Object)loader, (Object)cls.getClassLoader());
        Field field = cls.getDeclaredField("nativeLibraryPath");
        field.setAccessible(true);
        String path = (String)field.get(null);
        JNAUnloadTest.assertNotNull((String)"Native library path unavailable", (Object)path);
        JNAUnloadTest.assertTrue((String)("Native library not unpacked from jar: " + path), (boolean)path.startsWith(System.getProperty("java.io.tmpdir")));
        WeakReference ref = new WeakReference(cls);
        WeakReference<TestLoader> clref = new WeakReference<TestLoader>(loader);
        loader = null;
        cls = null;
        field = null;
        System.gc();
        for (int i = 0; i < 100 && (ref.get() != null || clref.get() != null); ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        JNAUnloadTest.assertNull((String)("Class not GC'd: " + ref.get()), ref.get());
        JNAUnloadTest.assertNull((String)("ClassLoader not GC'd: " + clref.get()), clref.get());
        File f = new File(path);
        for (int i = 0; i < 100 && f.exists(); ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        if (f.exists()) {
            JNAUnloadTest.assertTrue((String)("Temporary jnidispatch not marked for later deletion: " + f), (boolean)new File(f.getAbsolutePath() + ".x").exists());
        }
        try {
            loader = new TestLoader(true);
            cls = Class.forName("com.sun.jna.Native", true, loader);
        }
        catch (Throwable t) {
            JNAUnloadTest.fail((String)("Couldn't load class again after discarding first load: " + t.getMessage()));
        }
        finally {
            loader = null;
            cls = null;
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnload() throws Exception {
        TestLoader loader = new TestLoader(false);
        Class<?> cls = Class.forName("com.sun.jna.Native", true, loader);
        JNAUnloadTest.assertEquals((String)"Wrong class loader", (Object)loader, (Object)cls.getClassLoader());
        Field field = cls.getDeclaredField("nativeLibraryPath");
        field.setAccessible(true);
        String path = (String)field.get(null);
        JNAUnloadTest.assertNotNull((String)"Native library not found", (Object)path);
        WeakReference ref = new WeakReference(cls);
        WeakReference<TestLoader> clref = new WeakReference<TestLoader>(loader);
        loader = null;
        cls = null;
        field = null;
        System.gc();
        for (int i = 0; i < 100 && (ref.get() != null || clref.get() != null); ++i) {
            Thread.sleep(10L);
            System.gc();
        }
        JNAUnloadTest.assertNull((String)("Class not GC'd: " + ref.get()), ref.get());
        JNAUnloadTest.assertNull((String)("ClassLoader not GC'd: " + clref.get()), clref.get());
        Throwable throwable = null;
        for (int i = 0; i < 100; ++i) {
            System.gc();
            Thread.sleep(10L);
            try {
                loader = new TestLoader(false);
                cls = Class.forName("com.sun.jna.Native", true, loader);
                break;
            }
            catch (Throwable t) {
                loader = null;
                throwable = t;
                continue;
            }
        }
        try {
            if (loader == null) {
                JNAUnloadTest.fail((String)("Native library not unloaded: " + throwable.getMessage()));
            }
        }
        finally {
            loader = null;
            cls = null;
            System.gc();
        }
    }

    public static void main(String[] args) {
        TestRunner.run(JNAUnloadTest.class);
    }

    private static class TestLoader
    extends URLClassLoader {
        public TestLoader(boolean fromJar) throws MalformedURLException {
            super(new URL[]{Platform.isWindowsCE() ? new File("/Storage Card/" + (fromJar ? "jna.jar" : "test.jar")).toURI().toURL() : new File(BUILDDIR + (fromJar ? "/jna.jar" : "/classes")).toURI().toURL()}, (ClassLoader)null);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            String boot = System.getProperty("jna.boot.library.path");
            if (boot != null) {
                System.setProperty("jna.boot.library.path", "");
            }
            Class<?> cls = super.findClass(name);
            if (boot != null) {
                System.setProperty("jna.boot.library.path", boot);
            }
            return cls;
        }
    }
}

