/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class MemoryTest
extends TestCase {
    public void testAutoFreeMemory() throws Exception {
        final boolean[] flag = new boolean[]{false};
        Memory core = new Memory(10L){

            protected void finalize() {
                super.finalize();
                flag[0] = true;
            }
        };
        Pointer shared = core.share(0L, 5L);
        WeakReference<1> ref = new WeakReference<1>(core);
        core = null;
        System.gc();
        long start = System.currentTimeMillis();
        MemoryTest.assertFalse((String)"Memory prematurely GC'd", (boolean)flag[0]);
        MemoryTest.assertNotNull((String)"Base memory GC'd while shared memory extant", ref.get());
        shared.setInt(0L, 0);
        shared = null;
        System.gc();
        while (ref.get() != null && System.currentTimeMillis() - start <= 5000L) {
            Thread.sleep(10L);
        }
        MemoryTest.assertNull((String)"Memory not GC'd", ref.get());
    }

    public void testShareMemory() {
        Memory base = new Memory(8L);
        Pointer shared = base.share(0L);
        MemoryTest.assertNotSame((String)"Memory share should return a different object", (Object)base, (Object)shared);
    }

    public void testSharedMemoryBounds() {
        Memory base = new Memory(16L);
        Pointer shared = base.share(4L, 4L);
        shared.getInt(-4L);
        try {
            shared.getInt(-8L);
            MemoryTest.fail((String)"Bounds check should fail");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        shared.getInt(8L);
        try {
            shared.getInt(12L);
            MemoryTest.fail((String)"Bounds check should fail");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAlignment() {
        int SIZE = 65536;
        Memory base = new Memory(65536L);
        for (int align = 1; align < 65536; align *= 2) {
            Memory unaligned = base;
            long mask = (long)align - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if ((base.peer & mask) == base.peer) {
                unaligned = (Memory)base.share(1L, 65535L);
            }
            Memory aligned = unaligned.align(align);
            MemoryTest.assertEquals((String)("Memory not aligned (" + align + ")"), (long)(aligned.peer & mask), (long)aligned.peer);
            MemoryTest.assertSame((String)"Alignment request on aligned memory should no-op", (Object)aligned, (Object)aligned.align(align));
        }
    }

    public void testNegativeAlignment() {
        int SIZE = 128;
        Memory base = new Memory(128L);
        try {
            base.align(-1);
            MemoryTest.fail((String)"Negative alignments not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidAlignment() {
        int SIZE = 128;
        Memory base = new Memory(128L);
        int[] alignments = new int[]{0, 3, 5, 9, 13};
        for (int i = 0; i < alignments.length; ++i) {
            try {
                base.align(alignments[i]);
                MemoryTest.fail((String)"Power-of-two alignments required");
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public void testAvoidGCWithExtantBuffer() throws Exception {
        int i;
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        Memory m = new Memory(1024L);
        m.clear();
        ByteBuffer b = m.getByteBuffer(0L, m.size());
        WeakReference<Memory> ref = new WeakReference<Memory>(m);
        WeakReference<ByteBuffer> bref = new WeakReference<ByteBuffer>(b);
        m = new Memory(1024L);
        m.clear();
        m.getByteBuffer(0L, m.size());
        m = null;
        System.gc();
        Memory.purge();
        for (i = 0; i < 100 && ref.get() != null; ++i) {
            Thread.sleep(10L);
            System.gc();
            Memory.purge();
        }
        MemoryTest.assertNotNull((String)"Memory GC'd while NIO Buffer still extant", ref.get());
        b.put((byte)0);
        b = null;
        System.gc();
        Memory.purge();
        for (i = 0; i < 100 && (bref.get() != null || ref.get() != null); ++i) {
            Thread.sleep(10L);
            System.gc();
            Memory.purge();
        }
        MemoryTest.assertNull((String)"Buffer not GC'd\n", bref.get());
        MemoryTest.assertNull((String)"Memory not GC'd after buffer GC'd\n", ref.get());
    }

    public static void main(String[] args) {
        TestRunner.run(MemoryTest.class);
    }
}

