/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Structure;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructureFieldOrderInspector {
    private StructureFieldOrderInspector() {
    }

    public static void batchCheckStructureGetFieldOrder(Class classDeclaredInSourceTreeToSearch, List<String> ignoreConstructorError) {
        Set<Class<? extends Structure>> classes = StructureFieldOrderInspector.findSubTypesOfStructure(classDeclaredInSourceTreeToSearch);
        ArrayList<Throwable> problems = new ArrayList<Throwable>();
        for (Class<? extends Structure> structureSubType : classes) {
            try {
                StructureFieldOrderInspector.checkMethodGetFieldOrder(structureSubType, ignoreConstructorError);
            }
            catch (Throwable t) {
                problems.add(t);
            }
        }
        if (problems.size() > 0) {
            String msg = "";
            for (Throwable t : problems) {
                msg = msg + t.getMessage() + "; \n";
            }
            throw new RuntimeException("Some Structure sub types (" + problems.size() + ") have problems with getFieldOrder(): \n" + msg);
        }
    }

    public static void checkStructureGetFieldOrder(Class classDeclaredInSourceTreeToSearch, List<String> ignoreConstructorError) {
        Set<Class<? extends Structure>> classes = StructureFieldOrderInspector.findSubTypesOfStructure(classDeclaredInSourceTreeToSearch);
        for (Class<? extends Structure> structureSubType : classes) {
            StructureFieldOrderInspector.checkMethodGetFieldOrder(structureSubType, ignoreConstructorError);
        }
    }

    public static Set<Class<? extends Structure>> findSubTypesOfStructure(Class classDeclaredInSourceTreeToSearch) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false), new ResourcesScanner()}).setUrls(new URL[]{ClasspathHelper.forClass((Class)classDeclaredInSourceTreeToSearch, (ClassLoader[])new ClassLoader[0])}));
        return reflections.getSubTypesOf(Structure.class);
    }

    public static void checkMethodGetFieldOrder(Class<? extends Structure> structureSubType, List<String> ignoreConstructorError) {
        List methodCallFieldList;
        Structure structure;
        Constructor<? extends Structure> structConstructor;
        if (Structure.ByValue.class.isAssignableFrom(structureSubType) || Structure.ByReference.class.isAssignableFrom(structureSubType)) {
            return;
        }
        Method methodGetFieldOrder = StructureFieldOrderInspector.getMethodGetFieldOrder(structureSubType);
        if (Modifier.isAbstract(structureSubType.getModifiers())) {
            return;
        }
        try {
            structConstructor = structureSubType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (structureSubType == Structure.FFIType.class) {
                return;
            }
            throw new RuntimeException("Parameterless constructor failed on Structure sub type: " + structureSubType.getName());
        }
        if (!structConstructor.isAccessible()) {
            structConstructor.setAccessible(true);
        }
        try {
            structure = structConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate Structure sub type: " + structureSubType.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not instantiate Structure sub type: " + structureSubType.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (ignoreConstructorError != null) {
                String structSubtypeName = structureSubType.getName();
                for (String classPrefix : ignoreConstructorError) {
                    if (!structSubtypeName.startsWith(classPrefix)) continue;
                    return;
                }
            }
            throw new RuntimeException("Could not instantiate Structure sub type: " + structureSubType.getName(), e);
        }
        if (!methodGetFieldOrder.isAccessible()) {
            methodGetFieldOrder.setAccessible(true);
        }
        try {
            methodCallFieldList = (List)methodGetFieldOrder.invoke((Object)structure, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke getFieldOrder() on Structure sub type: " + structureSubType.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not invoke getFieldOrder() on Structure sub type: " + structureSubType.getName(), e);
        }
        Field[] actualFields = structureSubType.getFields();
        ArrayList<String> actualFieldNames = new ArrayList<String>(actualFields.length);
        for (Field field : actualFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String actualFieldName = field.getName();
            if (!methodCallFieldList.contains(actualFieldName)) {
                throw new IllegalArgumentException(structureSubType.getName() + ".getFieldOrder() [" + methodCallFieldList + "] does not include declared field: " + actualFieldName);
            }
            actualFieldNames.add(actualFieldName);
        }
        for (Object methodCallField : methodCallFieldList) {
            if (actualFieldNames.contains(methodCallField)) continue;
            throw new IllegalArgumentException(structureSubType.getName() + ".getFieldOrder() [" + methodCallFieldList + "] includes undeclared field: " + methodCallField);
        }
    }

    private static Method getMethodGetFieldOrder(Class<? extends Structure> structureSubType) {
        Method methodGetFieldOrder;
        try {
            methodGetFieldOrder = structureSubType.getDeclaredMethod("getFieldOrder", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (structureSubType.getSuperclass() != null) {
                return StructureFieldOrderInspector.getMethodGetFieldOrder(structureSubType.getSuperclass());
            }
            throw new IllegalArgumentException("The Structure sub type: " + structureSubType.getName() + " must define the method: getFieldOrder()." + " See the javadoc for Structure.getFieldOrder() for details.", e);
        }
        return methodGetFieldOrder;
    }
}

